package com.digiwin.athena.dtdapp.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.athena.dtdapp.pojo.esp.EspBody;
import com.digiwin.athena.dtdapp.pojo.esp.EspResponse;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Slf4j
public class ESPInvokeUtil {

    private static final Set<String> SUCCESS_CODES = new HashSet<>();

    static {
        SUCCESS_CODES.add("0");
        SUCCESS_CODES.add("000");
    }

    private ESPInvokeUtil() {}

    public static EspResponse invokeRestSync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String, String> eocMap, String pinpointId) throws DWException {
        // 建立RequestModel物件並設定內容
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("dtdapp");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("dtdapp");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        Map<String,Object> eocMap2 = new HashMap<>();
        eocMap2.putAll(eocMap);
        requestModel.setEocMap(eocMap2);
        String body = null;
        if(StringUtils.isNotEmpty(jsonMsg)){
            body = "{\"std_data\":{\"parameter\":" + jsonMsg + "}}";
        }else{
            body = "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString(new JSONObject()) + "}}";
        }
        requestModel.setBodyJsonString(body);
        //header
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);

//        if(StringUtils.isNotEmpty(pinpointId)){
//            headerMap.put("pinpoint-traceid", pinpointId);
//            headerMap.put("tx-xid", pinpointId);
//        }


        if(headerParamMap != null){
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for(Map.Entry<String, Object> entry : entries){
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);

        ResponseModel responseModel;
        try {
//            DWServiceChainUtils.beforeInvokeOutterAPI(headerMap::put);
            responseModel = Invoker.invokeRestSync(requestModel);
            String response = responseModel.getBodyJsonString();
//            String response = "{\"std_data\":{\"execution\":{\"sql_code\":\"\",\"code\":\"0\",\"description\":\"\"},\"parameter\":{\"inquiry_is_download\":true,\"purchase_is_download\":true,\"drawing_default_format\":\"1\",\"online_drawing_format\":\"1\",\"advance_notice_days\":\"2\",\"only_download_once\":true}}}";
            log.info("invoke Result:{}", response);
            EspBody espBody = JSONObject.parseObject(response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            } else {
                espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
                espResponse.setStatus(EspResponse.Status.FAILED);
                return espResponse;
            }
        } catch (Exception e) {
            log.error("call esp error:{}", e);
            throw new DWException(e.getMessage());
//            EspResponse espResponse = new EspResponse();
//            espResponse.setMsg(e.getMessage());
//            espResponse.setStatus(EspResponse.Status.FAILED);
//            if(e instanceof InvocationException){
//                espResponse.setErrorCode(((InvocationException) e).getErrorCode());
//                espResponse.setChainInfo(((InvocationException) e).getChainInfo());
//            }
//            return espResponse;
        }
    }

    public static EspResponse invokeRestFasync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String, String> eocMap, String callBackId) throws DWException {
        // 建立RequestModel物件並設定內容
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("dtdapp");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("dtdapp");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        Map<String,Object> eocMap2 = new HashMap<>();
        eocMap2.putAll(eocMap);
        requestModel.setEocMap(eocMap2);
        String body = null;
        if(StringUtils.isNotEmpty(jsonMsg)){
            body = "{\"std_data\":{\"parameter\":" + jsonMsg + "}}";
        }else{
            body = "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString(new JSONObject()) + "}}";
        }
        requestModel.setBodyJsonString(body);
        //header
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);

//        if(StringUtils.isNotEmpty(pinpointId)){
//            headerMap.put("pinpoint-traceid", pinpointId);
//            headerMap.put("tx-xid", pinpointId);
//        }


        if(headerParamMap != null){
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for(Map.Entry<String, Object> entry : entries){
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);

        ResponseModel responseModel;
        try {
//            DWServiceChainUtils.beforeInvokeOutterAPI(headerMap::put);
            responseModel = Invoker.invokeRestFasync(requestModel, callBackId);
            String response = responseModel.getBodyJsonString();
//            String response = "{\"std_data\":{\"execution\":{\"sql_code\":\"\",\"code\":\"0\",\"description\":\"\"},\"parameter\":{\"inquiry_is_download\":true,\"purchase_is_download\":true,\"drawing_default_format\":\"1\",\"online_drawing_format\":\"1\",\"advance_notice_days\":\"2\",\"only_download_once\":true}}}";
            log.info("invoke Result:{}", response);
            EspBody espBody = JSONObject.parseObject(response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            } else {
                espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
                espResponse.setStatus(EspResponse.Status.FAILED);
                return espResponse;
            }
        } catch (Exception e) {
            log.error("call esp error:{}", e);
            throw new DWException(e.getMessage());
//            EspResponse espResponse = new EspResponse();
//            espResponse.setMsg(e.getMessage());
//            espResponse.setStatus(EspResponse.Status.FAILED);
//            if(e instanceof InvocationException){
//                espResponse.setErrorCode(((InvocationException) e).getErrorCode());
//                espResponse.setChainInfo(((InvocationException) e).getChainInfo());
//            }
//            return espResponse;
        }
    }
}
