package com.digiwin.athena.dtdapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.dap.middleware.lmc.http.client.ServiceException;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.*;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Slf4j
public class HttpUtil {

    public static String sendGet(String url, String reqJson, Map<String, String> header) throws URISyntaxException, IOException {
        String responseContent = "";
        HttpClient httpClient = HttpClientBuilder.create().build();
        // Get请求
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (StringUtils.isNotEmpty(reqJson)) {
                List<NameValuePair> nameValuePairList = json2NameValuePairList(JSON.parseObject(reqJson));
                uriBuilder.setParameters(nameValuePairList);
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            // 设置Header
            httpGet.setHeader("Content-Type", "application/json");
            if (null != header && !header.isEmpty()) {
                for (Map.Entry<String, String> i : header.entrySet()) {
                    httpGet.setHeader(i.getKey(), i.getValue());
                }
            }
            HttpResponse httpResponse = httpClient.execute(httpGet);
            HttpEntity entity = httpResponse.getEntity();            //获取响应实体
            if (null != entity) {
                responseContent = EntityUtils.toString(entity);
                EntityUtils.consume(entity);

            }
            return responseContent;
        } catch (URISyntaxException e) {
            log.error(e.toString());
            throw e;
        } catch (IOException e) {
            log.error(e.toString());
            throw e;
        }
    }

    private static List<NameValuePair> json2NameValuePairList(JSONObject params) {
        if (params != null && !params.isEmpty()) {
            List<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() != null) {
                    String value = String.valueOf(entry.getValue());
                    list.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            return list;
        }
        return null;
    }


//    public static void main(String[] args) {
//        String url = "https://ddp-dataserver.digiwincloud.com.cn/restful/standard/gateway/cloud/report/data";
//        StConfig config = new StConfig();
//        config.setDatabaseIp("192.168.1.245");
//        config.setDatabaseName("default");
//        config.setDatabasePort("21050");
//        config.setDatabaseType("impala");
//        config.setUsername("");
//        config.setPassword("");
//        config.setSeparator(",");
//        config.setSql("SELECT productCode AS productCode, productName AS productName, STDDEV(CAST(salesAmount AS DOUBLE)) AS stdDevSalesAmount, STDDEV(CAST(salesCount AS DOUBLE)) AS stdDevSalesCount, avg(CAST(salesAmount AS DOUBLE)) AS avgSalesAmount, sum(CAST(salesAmount AS DOUBLE)) AS sumSalesAmount, sum(CAST(salesCount AS DOUBLE)) AS sumSalesCount, sum(CAST(salesCount AS DOUBLE)) / (count(*) * 30) AS avgDaySalseCount, if(sum(CAST(salesCount AS DOUBLE)) = 0 , 0, sum(CAST(salesAmount AS DOUBLE)) / sum(CAST(salesCount AS DOUBLE)))  AS singleSalesAmount,GROUP_CONCAT(salesAmount) AS salesAmountGroup, minProductBatch AS minProductBatch, productLeadTime AS productLeadTime FROM ods.to_erp_coptd_mf WHERE month >= '20200101' and month <= '20210101' GROUP BY productCode, productName, minProductBatch, productLeadTime ORDER BY sumSalesAmount DESC");
//        config.setTargetDir("");
//        Request request = new Request();
//        request.setConfig(config);
//        String s = JSON.toJSONString(request);
//        HttpUtil.sendGet(url, s, null);
//    }

    public static String postByFormData(String url, Map<String, String> header, Map<String, String> requestParams) {
        String result = "";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(550000).setConnectTimeout(550000)
                    .setConnectionRequestTimeout(550000).build();
            client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            // client = HttpClients.createDefault();
            URIBuilder uriBuilder = new URIBuilder(url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
//        httpPost.setHeader("Connection", "Keep-Alive");
//        httpPost.setHeader("Charset", "UTF-8");
//        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            Iterator<Map.Entry<String, String>> headerIterator = header.entrySet().iterator();
            while (headerIterator.hasNext()) {
                Map.Entry<String, String> next = headerIterator.next();
                httpPost.setHeader(next.getKey(), next.getValue());
            }
            Iterator<Map.Entry<String, String>> it = requestParams.entrySet().iterator();
            List params = new ArrayList();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                params.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
//            log.info("postByFormData url:{}, params:{}", url , params);
            response = client.execute(httpPost);
            StatusLine statusLine = response.getStatusLine();
            String reasonPhrase = statusLine.getReasonPhrase();
            int statusCode = statusLine.getStatusCode();
            if(statusCode < 200 || statusCode >= 300){
                throw new RuntimeException("HTTP request failed with status code: " + statusCode);
            }
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, "UTF-8");
                    EntityUtils.consume(resEntity);
                }
            }
        } catch (ClientProtocolException e) {
            throw null;
        } catch (Exception e) {
            throw null;
        }

        return result;
    }

    public static String postByJsonBody(String url, Map<String, String> headers, String requestBody) {
        String result = "";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(550000).setConnectTimeout(550000)
                    .setConnectionRequestTimeout(550000).build();
            client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpPost.setHeader(header.getKey(), header.getValue());
            }
            httpPost.setEntity(new StringEntity(requestBody, "UTF-8"));

            response = client.execute(httpPost);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new RuntimeException("HTTP request failed with status code: " + statusCode);
            }
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result = EntityUtils.toString(resEntity, "UTF-8");
                EntityUtils.consume(resEntity);
            }
        } catch (URISyntaxException | IOException e) {
            e.printStackTrace(); // Handle exception properly
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            } catch (IOException e) {
                e.printStackTrace(); // Handle exception properly
            }
        }
        return result;
    }

}
