/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.athena.dtdapp.util.DateUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class EmployeeEntryInfoDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmployeeEntryInfoDAO.class);
    public static final String TABLE_NAME = "employee_entry_info";
    @Autowired
    @Qualifier(value="dtdappDwdao")
    private DWDao dao;

    private DWDataSetOperationOption getOption() {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return option;
    }

    private boolean checkAllEmpNoIsNotNull(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (!StringUtils.isEmpty((CharSequence)empNo)) continue;
            return false;
        }
        return true;
    }

    public List<Map<String, Object>> updateEmployeeEntryInfo(Map<String, String> parameter) throws Exception {
        LOGGER.info("updateEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("update emp_entry_info is empty");
        }
        if (!this.checkAllEmpNoIsNotNull(jsonArray)) {
            throw new DWException("update emp_entry_info has object emp_no is null");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (StringUtils.isEmpty((CharSequence)empNo)) {
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");
            String managerName = jsonObjParam.getString("manager_name");
            String reportSubmitDateString = jsonObjParam.getString("report_submit_date");
            String workReportApprovalDateString = jsonObjParam.getString("work_report_approval_date");
            String probationDateString = jsonObjParam.getString("probation_date");
            String task_status = jsonObjParam.getString("task_status");
            StringBuilder sql = new StringBuilder();
            sql.append("update employee_entry_info set update_date = ?");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(DateUtils.getDateTimeNow());
            if (StringUtil.isNotBlank((CharSequence)entryDateString)) {
                Date entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
                sql.append(",entry_date = ? ");
                params.add(entryDate);
            }
            if (StringUtil.isNotBlank((CharSequence)reportSubmitDateString)) {
                Date reportSubmitDate = DateUtils.parseStringToDate(reportSubmitDateString, "yyyy-MM-dd");
                sql.append(",report_submit_date = ? ");
                params.add(reportSubmitDate);
            }
            if (StringUtil.isNotBlank((CharSequence)workReportApprovalDateString)) {
                Date workReportApprovalDate = DateUtils.parseStringToDate(workReportApprovalDateString, "yyyy-MM-dd");
                sql.append(",work_report_approval_date = ? ");
                params.add(workReportApprovalDate);
            }
            if (StringUtil.isNotBlank((CharSequence)probationDateString)) {
                Date probationDate = DateUtils.parseStringToDate(probationDateString, "yyyy-MM-dd");
                sql.append(",probation_date = ? ");
                params.add(probationDate);
            }
            if (StringUtil.isNotBlank((CharSequence)task_status)) {
                sql.append(",task_status = ? ");
                params.add(task_status);
            }
            sql.append(" where emp_no = ?");
            params.add(empNo);
            this.dao.update((IDWSQLOptions)this.getOption(), sql.toString(), params.toArray());
        }
        return this.getEmployeeEntryInfo(parameter);
    }

    public List<Map<String, Object>> insertEmployeeEntryInfo(Map<String, String> parameter) throws Exception {
        LOGGER.info("insertEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("update emp_entry_info is empty");
        }
        if (!this.checkAllEmpNoIsNotNull(jsonArray)) {
            throw new DWException("update emp_entry_info has object emp_no is null");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (StringUtils.isEmpty((CharSequence)empNo)) {
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");
            Date entryDate = null;
            if (StringUtils.isNotEmpty((CharSequence)entryDateString)) {
                entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
            }
            String managerName = jsonObjParam.getString("manager_name");
            String managerNo = jsonObjParam.getString("manager_no");
            String emp_email = jsonObjParam.getString("emp_email");
            String manager_email = jsonObjParam.getString("manager_email");
            String task_status = jsonObjParam.getString("task_status");
            String sql = "insert into employee_entry_info(emp_no, emp_name, login_name, entry_date, manager_no, manager_name,create_date,emp_email,manager_email,task_status) values(?,?,?,?,?,?,?,?,?,?)";
            this.dao.update((IDWSQLOptions)this.getOption(), sql, new Object[]{empNo, empName, loginName, entryDate, managerNo, managerName, DateUtils.getDateTimeNow(), emp_email, manager_email, task_status});
        }
        return this.getEmployeeEntryInfo(parameter);
    }

    public List<Map<String, Object>> getEmployeeEntryInfo(Map<String, String> parameter) throws DWException {
        LOGGER.info("getEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("empNo is empty");
        }
        ArrayList<String> empNoList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String emp_no = jsonObject.getString("emp_no");
            empNoList.add(emp_no);
        }
        String task_status = jsonArray.getJSONObject(0).getString("task_status");
        String empNoQueryCondition = "('" + StringUtils.join(empNoList, (String)"','") + "')";
        StringBuilder sb = new StringBuilder();
        sb.append(DWTenantUtils.getTenantIgnoreTagByColumnName()).append("select emp_no, emp_name, login_name, entry_date, manager_no, manager_name, report_submit_date, work_report_approval_date, probation_date, emp_email, manager_email, task_status").append(" FROM employee_entry_info").append(" WHERE emp_no  in " + empNoQueryCondition);
        if (StringUtils.isNotEmpty((CharSequence)task_status)) {
            sb.append(" and task_status = '" + task_status + "'");
        }
        List datas = this.dao.select((IDWSQLOptions)this.getOption(), sb.toString(), new Object[0]);
        return datas;
    }
}

