/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.provider.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.dao.AnonymousOpinionsDAO;
import com.digiwin.athena.dtdapp.mapper.RecipientMapper;
import com.digiwin.athena.dtdapp.pojo.dto.BugEmailInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.OpinionsInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.DeptEmail;
import com.digiwin.athena.dtdapp.pojo.entity.RecipientInfo;
import com.digiwin.athena.dtdapp.pojo.vo.OpinionsInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.RecipientInfoVO;
import com.digiwin.athena.dtdapp.provider.IAnonymousOpinionsService;
import com.digiwin.athena.dtdapp.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class IAnonymousOpinionsImpl
implements IAnonymousOpinionsService {
    private static final Logger log = LoggerFactory.getLogger(IAnonymousOpinionsImpl.class);
    @Autowired
    private AnonymousOpinionsDAO anonymousOpinionsDAO;
    @Autowired
    private RecipientMapper recipientMapper;

    @Override
    public void addAnonymousOpinions(OpinionsInfoDTO opinionsInfoDTO) throws Exception {
        this.insertOpinionsInfo(opinionsInfoDTO);
    }

    @Override
    public void addRealNameOpinions(OpinionsInfoDTO opinionsInfoDTO) throws Exception {
        this.insertOpinionsInfo(opinionsInfoDTO);
    }

    @Override
    public List<OpinionsInfoVO> getOpinions() throws Exception {
        return this.anonymousOpinionsDAO.getOpinions();
    }

    @Override
    public List<RecipientInfoVO> getRecipient() throws Exception {
        return this.anonymousOpinionsDAO.getRecipient();
    }

    private void insertOpinionsInfo(OpinionsInfoDTO opinionsInfoDTO) throws DWException {
        if (ObjectUtils.isEmpty((Object)opinionsInfoDTO.getProblem_description())) {
            throw new DWException(" problem_description is empty");
        }
        if (ObjectUtils.isEmpty(opinionsInfoDTO.getRecipientInfo())) {
            throw new DWException(" recipientInfo is empty");
        }
        Map<Long, String> recipientInfo = opinionsInfoDTO.getRecipientInfo();
        for (Long recipient_id : recipientInfo.keySet()) {
            QueryWrapper recipientInfoQueryWrapper = new QueryWrapper();
            recipientInfoQueryWrapper.eq((Object)"email_address", (Object)recipientInfo.get(recipient_id));
            RecipientInfo recipientInfo1 = (RecipientInfo)this.recipientMapper.selectOne((Wrapper)recipientInfoQueryWrapper);
            if (recipientInfo1 != null && recipient_id == recipientInfo1.getRecipient_id()) continue;
            throw new RuntimeException("\u6536\u4fe1\u4eba\u4e0d\u5b58\u5728\u6216\u4fe1\u606f\u4e0d\u7b26\u5408!");
        }
        this.anonymousOpinionsDAO.insertOpinionsInfo(opinionsInfoDTO);
        IAnonymousOpinionsImpl.sendEmail(opinionsInfoDTO);
    }

    private static void sendEmail(OpinionsInfoDTO opinionsInfoDTO) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        HashMap<String, Object> tRequest = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(opinionsInfoDTO.getRecipientInfo().values());
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "\u60a8\u6709\u4e00\u4efd\u65b0\u7684\u53cd\u9988\u4fe1\u606f");
        String feedbackFrontUrl = DWApplicationConfigUtils.getProperty((String)"feedbackFrontUrl");
        log.info("\u57df\u540d:{}", (Object)feedbackFrontUrl);
        tRequest.put("content", "\u60a8\u6709\u65b0\u7684\u53cd\u9988\u4fe1\u606f\uff0c\u8bf7\u81f3\uff1a<a href=\"" + feedbackFrontUrl + "\">\u53cd\u9988\u7cfb\u7edf</a>\u67e5\u770b\uff01");
        HttpEntity httpEntity = new HttpEntity(tRequest, (MultiValueMap)headers);
        String tFinalUrl = DWApplicationConfigUtils.getProperty((String)"emcUrl") + tApi;
        log.info("sendemcUrl:" + tFinalUrl);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.info(String.valueOf((Object)e));
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = (String)responseEntity.getBody();
            log.error("send mail error:{}-{}", (Object)statusCodeValue, (Object)body);
        }
    }

    @Override
    @Scheduled(cron="0 0 8 * * ?")
    public void sendEmailToSm() {
        OpinionsInfoDTO opinionsInfoDTO = new OpinionsInfoDTO();
        List<ZtBugWarningDTO> allNormalBugs = this.anonymousOpinionsDAO.findAllNormalBugs();
        List<ZtBugWarningDTO> allExternalBugs = this.anonymousOpinionsDAO.findAllExternalBugs();
        List<ZtBugWarningDTO> allSeriousBugs = this.anonymousOpinionsDAO.findAllSeriousBugs();
        ArrayList<Object> allBugs = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(allNormalBugs)) {
            List ztBugWarningDTOS = allNormalBugs.stream().filter(x -> {
                String createTime = x.getCreateTime();
                LocalDate openTime = DateUtils.convertStringToLocalDate(createTime);
                long days = DateUtils.calculateWorkingDays(openTime, LocalDate.now());
                return days > 2L;
            }).collect(Collectors.toList());
            allBugs.addAll(ztBugWarningDTOS);
        }
        if (!CollectionUtils.isEmpty(allExternalBugs)) {
            allBugs.addAll(allExternalBugs);
        }
        if (!CollectionUtils.isEmpty(allSeriousBugs)) {
            allBugs.addAll(allSeriousBugs);
        }
        List<DeptEmail> emailInfo = this.anonymousOpinionsDAO.getEmailInfo();
        Map<String, List<ZtBugWarningDTO>> bugByDept = allBugs.stream().filter(x -> !StringUtils.isEmpty((Object)x.getAssignedDepartment())).collect(Collectors.groupingBy(ZtBugWarningDTO::getAssignedDepartment));
        Map<String, List<DeptEmail>> email = emailInfo.stream().collect(Collectors.groupingBy(DeptEmail::getDept));
        for (Map.Entry<String, List<DeptEmail>> emailInfoMap : email.entrySet()) {
            String key = emailInfoMap.getKey();
            List<ZtBugWarningDTO> ztBugWarningDTOS = bugByDept.get(key);
            if (CollectionUtils.isEmpty(ztBugWarningDTOS)) continue;
            List<DeptEmail> deptEmails = email.get(key);
            BugEmailInfoDTO bugEmailInfoDTO = new BugEmailInfoDTO();
            bugEmailInfoDTO.setEmail(deptEmails.get(0).getEmail());
            int size = ztBugWarningDTOS.size();
            String bugNum = ztBugWarningDTOS.stream().map(x -> "<li><h2 style=\"color:#faad14\">" + x.getBugNum() + " - " + x.getReceiver() + "</h2></li>").collect(Collectors.joining());
            String content = "<h2>\u5c0a\u656c\u7684%sSM\uff1a</h2><h2>\u76ee\u524d\u5171\u6709<span style=\"color:#ff4d4f\">%s</span>\u5f20\u5355\u636e\u5373\u5c06\u8d85\u671f\uff0c\u8bf7\u53ca\u65f6\u901a\u77e5\u76f8\u5173\u540c\u4e8b\u8fdb\u884c\u5904\u7406\u3002</h2><h2>\u5177\u4f53\u5355\u636e\u4fe1\u606f\u5982\u4e0b\uff1a</h2><ul>%s</ul><h2>\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u968f\u65f6\u8054\u7cfb\u7ef4\u62a4\u7ec4SM\u5c1a\u4e39\u4e39\u3002</h2>";
            String msg = String.format(content, key, size, bugNum);
            bugEmailInfoDTO.setMsg(msg);
            IAnonymousOpinionsImpl.sendEmailForBug(bugEmailInfoDTO);
        }
    }

    private static void sendEmailForBug(BugEmailInfoDTO bugEmailInfoDTO) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        HashMap<String, Object> tRequest = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(bugEmailInfoDTO.getEmail()));
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "\u3010\u6765\u81ea\u8fd0\u8425\u7ba1\u7406\u7cfb\u7edf\u7684\u4e34\u671f\u5355\u636e\u63d0\u9192\u3011");
        tRequest.put("content", bugEmailInfoDTO.getMsg());
        HttpEntity httpEntity = new HttpEntity(tRequest, (MultiValueMap)headers);
        String tFinalUrl = DWApplicationConfigUtils.getProperty((String)"emcUrl") + tApi;
        log.info("sendemcUrl:" + tFinalUrl);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.info(String.valueOf((Object)e));
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = (String)responseEntity.getBody();
            log.error("send mail error:{}-{}", (Object)statusCodeValue, (Object)body);
        }
    }
}

