/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.dtdapp.dao.zentao.ZtUserDAO;
import com.digiwin.athena.dtdapp.mapperzentao.ZtDJHolidayDateMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtPlusProjectMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtUserMapper;
import com.digiwin.athena.dtdapp.pojo.constants.Constant;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.ProjectEstimateDto;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.ProjectTeamDetailDto;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.ProjectWithTeamInfoDto;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.UserEffortDto;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.UserProjectConsumedDetailDto;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.UserTaskEstimatedAndConsumedDto;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtProjectDTO;
import com.digiwin.athena.dtdapp.pojo.dto.ztkanban.queryTaskReq;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtDJHolidayDate;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtEffort;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.enums.KanBanStatus;
import com.digiwin.athena.dtdapp.pojo.enums.Status;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.DateToProjectConsumedVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.ProjectTeamConsumedInfoVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.ProjectTeamDetailVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.ProjectWithTeamInfoVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.UserEstimateAndConsumedVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.UserProjectConsumedVo;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.ZtUserScoreVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskProjectVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskRespVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskSummaryVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskTotalVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskVO;
import com.digiwin.athena.dtdapp.util.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DtdappProjectService {
    private static final Logger log = LoggerFactory.getLogger(DtdappProjectService.class);
    private static final String INVALID_TIME = "0000-00-00";
    private static final HashSet<String> WEEKENDS = new HashSet<String>(Arrays.asList("2024-05-01", "2024-05-02", "2024-05-03", "2024-06-10", "2024-09-16", "2024-09-17", "2024-10-01", "2024-10-02", "2024-10-03", "2024-10-04", "2024-10-07", "2024-10-08"));
    @Autowired
    private ZtPlusProjectMapper projectMapper;
    @Autowired
    private ZtDJHolidayDateMapper holidayDateMapper;
    @Autowired
    private ZtUserDAO ztUserDAO;

    public Collection<ProjectWithTeamInfoVo> getProjectWithTeamInfoList(String parentProjectName, String projectName, String status) {
        List<ProjectWithTeamInfoDto> infoDto = this.projectMapper.getProjectWithTeamInfoList(parentProjectName, projectName, status);
        HashMap<Integer, ProjectWithTeamInfoVo> projectIdToTeamInfoVoMap = new HashMap<Integer, ProjectWithTeamInfoVo>();
        HashSet<String> userNames = new HashSet<String>();
        for (ProjectWithTeamInfoDto dto : infoDto) {
            userNames.add(dto.getUserName());
            projectIdToTeamInfoVoMap.computeIfAbsent(dto.getId(), ignore -> new ProjectWithTeamInfoVo(dto.getId(), dto.getName(), dto.getStatus(), dto.getEstimate(), dto.getConsumed(), dto.getBegin(), dto.getEnd())).getConsumedInfoVos().add(new ProjectTeamConsumedInfoVo(dto.getUserName(), dto.getRole(), dto.getUserEstimate(), dto.getUserConsumed()));
        }
        for (ProjectWithTeamInfoVo vo : projectIdToTeamInfoVoMap.values()) {
            Set users = vo.getConsumedInfoVos().stream().map(ProjectTeamConsumedInfoVo::getUserName).collect(Collectors.toSet());
            for (String each : userNames) {
                if (users.contains(each)) continue;
                vo.getConsumedInfoVos().add(new ProjectTeamConsumedInfoVo(each, "", 0.0, 0.0));
            }
            vo.getConsumedInfoVos().sort(Comparator.comparing(ProjectTeamConsumedInfoVo::getUserName));
        }
        return projectIdToTeamInfoVoMap.values();
    }

    public Collection<ProjectTeamDetailVo> getProjectTeamDetailList(int projectId, String userName, String beginDate, String endDate) {
        List<ProjectTeamDetailDto> detailDto = this.projectMapper.getProjectTeamDetailList(projectId, userName, beginDate, endDate);
        HashMap<Integer, ProjectTeamDetailVo> userIdToTeamDetailVoMap = new HashMap<Integer, ProjectTeamDetailVo>();
        for (ProjectTeamDetailDto dto : detailDto) {
            ProjectTeamDetailVo projectTeamDetailVo = userIdToTeamDetailVoMap.computeIfAbsent(dto.getUserId(), ignore -> {
                ProjectTeamDetailVo detailVo = new ProjectTeamDetailVo(dto.getUserName(), dto.getRole());
                this.initDateEstimateAndConsumed(detailVo, beginDate, endDate);
                return detailVo;
            });
            this.appendEstimate(projectTeamDetailVo, dto);
        }
        List<UserEffortDto> userEffortsDto = this.projectMapper.getProjectUserEffort(projectId, userName, beginDate, endDate);
        for (UserEffortDto dto : userEffortsDto) {
            ProjectTeamDetailVo projectTeamDetailVo = userIdToTeamDetailVoMap.computeIfAbsent(dto.getUserId(), ignore -> {
                ProjectTeamDetailVo detailVo = new ProjectTeamDetailVo(dto.getUserName(), dto.getRole());
                this.initDateEstimateAndConsumed(detailVo, beginDate, endDate);
                return detailVo;
            });
            projectTeamDetailVo.getDateConsumed().computeIfPresent(dto.getDate(), (ignored, v) -> BigDecimal.valueOf(v + dto.getConsumed()).setScale(2, RoundingMode.CEILING).doubleValue());
        }
        this.handleEstimateMoreThanTwelveForProject(userIdToTeamDetailVoMap);
        userIdToTeamDetailVoMap.values().forEach(v -> {
            v.setEstimate(BigDecimal.valueOf(v.getDateEstimate().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
            v.setConsumed(BigDecimal.valueOf(v.getDateConsumed().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
        });
        return userIdToTeamDetailVoMap.values();
    }

    private void initDateEstimateAndConsumed(ProjectTeamDetailVo detailVo, String beginDate, String endDate) {
        List<String> workingDays = this.getWorkingDays(beginDate, endDate);
        for (String each : workingDays) {
            detailVo.getDateEstimate().put(each, 0.0);
            detailVo.getDateConsumed().put(each, 0.0);
        }
    }

    private void initDateEstimateAndConsumed(UserEstimateAndConsumedVo estimateAndConsumedVo, String beginDate, String endDate) {
        List<String> workingDays = this.getWorkingDays(beginDate, endDate);
        for (String each : workingDays) {
            estimateAndConsumedVo.getDateEstimate().put(each, 0.0);
            estimateAndConsumedVo.getDateConsumed().put(each, 0.0);
        }
    }

    private void initDateEstimateAndConsumed(UserProjectConsumedVo estimateAndConsumedVo, String beginDate, String endDate) {
        List<String> workingDays = this.getWorkingDays(beginDate, endDate);
        for (String each : workingDays) {
            estimateAndConsumedVo.getDateEstimate().put(each, 0.0);
            estimateAndConsumedVo.getDateConsumed().put(each, 0.0);
        }
    }

    private void appendEstimate(ProjectTeamDetailVo target, ProjectTeamDetailDto source) {
        if (source.getEstimate() != 0.0 && null != source.getStarted() && !INVALID_TIME.equals(source.getStarted())) {
            List<String> workingDays = this.getWorkingDays(source.getStarted(), source.getEnded());
            double avgConsumed = BigDecimal.valueOf(source.getEstimate()).divide(new BigDecimal(workingDays.size()), RoundingMode.CEILING).setScale(1, RoundingMode.CEILING).doubleValue();
            for (String each : workingDays) {
                target.getDateEstimate().computeIfPresent(each, (ignored, v) -> BigDecimal.valueOf(v + avgConsumed).setScale(2, RoundingMode.CEILING).doubleValue());
            }
        }
    }

    private void appendEstimate(UserEstimateAndConsumedVo target, UserTaskEstimatedAndConsumedDto source) {
        if (source.getEstimate() != 0.0 && null != source.getStarted() && !INVALID_TIME.equals(source.getStarted())) {
            List<String> workingDays = this.getWorkingDays(source.getStarted(), source.getEnded());
            double avgConsumed = BigDecimal.valueOf(source.getEstimate()).divide(new BigDecimal(workingDays.size()), RoundingMode.CEILING).setScale(2, RoundingMode.CEILING).doubleValue();
            for (String each : workingDays) {
                target.getDateEstimate().computeIfPresent(each, (ignored, v) -> BigDecimal.valueOf(v + avgConsumed).setScale(2, RoundingMode.CEILING).doubleValue());
            }
        }
    }

    private void appendEstimate(UserProjectConsumedVo target, UserProjectConsumedDetailDto source) {
        if (source.getEstimate() != 0.0 && null != source.getStarted() && !INVALID_TIME.equals(source.getStarted())) {
            List<String> workingDays = this.getWorkingDays(source.getStarted(), source.getEnded());
            double avgConsumed = BigDecimal.valueOf(source.getEstimate()).divide(new BigDecimal(workingDays.size()), RoundingMode.CEILING).setScale(1, RoundingMode.CEILING).doubleValue();
            for (String each : workingDays) {
                target.getDateEstimate().computeIfPresent(each, (ignored, v) -> v + avgConsumed);
            }
        }
    }

    private List<String> getWorkingDays(String startDate, String endDate) {
        if (null == endDate || INVALID_TIME.equals(endDate)) {
            return Collections.singletonList(startDate);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = dateFormat.parse(startDate);
        Date end = dateFormat.parse(endDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(begin);
        LinkedList<String> result = new LinkedList<String>();
        while (calendar.getTime().before(end) || calendar.getTime().equals(end)) {
            if (1 == calendar.get(7) || 7 == calendar.get(7)) {
                calendar.add(5, 1);
                continue;
            }
            String date = dateFormat.format(calendar.getTime().getTime());
            if (!WEEKENDS.contains(date)) {
                result.add(date);
            }
            calendar.add(5, 1);
        }
        if (result.isEmpty()) {
            result.add(startDate);
        }
        return result;
    }

    public Collection<UserEstimateAndConsumedVo> getUserEstimateAndConsumedList(int deptId, String userName, String beginDate, String endDate) {
        Collection<Integer> deptIds = this.getDeptAndSubDeptIds(deptId);
        if (deptIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<UserTaskEstimatedAndConsumedDto> userTasks = this.projectMapper.getUserTask(deptIds, userName, beginDate, endDate);
        HashMap<Integer, UserEstimateAndConsumedVo> userIdToVoMap = new HashMap<Integer, UserEstimateAndConsumedVo>();
        for (UserTaskEstimatedAndConsumedDto dto : userTasks) {
            UserEstimateAndConsumedVo vo = userIdToVoMap.computeIfAbsent(dto.getUserId(), ignore -> {
                UserEstimateAndConsumedVo estimateAndConsumedVo = new UserEstimateAndConsumedVo(dto.getUserId(), dto.getUserName(), dto.getRole());
                this.initDateEstimateAndConsumed(estimateAndConsumedVo, beginDate, endDate);
                return estimateAndConsumedVo;
            });
            this.appendEstimate(vo, dto);
        }
        List<UserEffortDto> userEffortsDto = this.projectMapper.getUserEffortDetail(deptIds, userName, beginDate, endDate);
        for (UserEffortDto dto : userEffortsDto) {
            UserEstimateAndConsumedVo vo = userIdToVoMap.computeIfAbsent(dto.getUserId(), ignore -> {
                UserEstimateAndConsumedVo estimateAndConsumedVo = new UserEstimateAndConsumedVo(dto.getUserId(), dto.getUserName(), dto.getRole());
                this.initDateEstimateAndConsumed(estimateAndConsumedVo, beginDate, endDate);
                return estimateAndConsumedVo;
            });
            vo.getDateConsumed().computeIfPresent(dto.getDate(), (ignored, v) -> v + dto.getConsumed());
        }
        this.handleEstimateLessThanEight(userIdToVoMap);
        userIdToVoMap.values().forEach(v -> {
            v.setEstimate(BigDecimal.valueOf(v.getDateEstimate().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
            v.setConsumed(BigDecimal.valueOf(v.getDateConsumed().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
        });
        return userIdToVoMap.values();
    }

    private Collection<Integer> getDeptAndSubDeptIds(int deptId) {
        HashSet<Integer> result = new HashSet<Integer>();
        result.add(deptId);
        this.addSubDeptIds(deptId, result);
        return result;
    }

    private void addSubDeptIds(Integer deptId, Set<Integer> result) {
        List<Integer> subDeptIds = this.projectMapper.getSubDeptIds(deptId);
        result.addAll(subDeptIds);
    }

    private void handleEstimateLessThanEight(Map<Integer, UserEstimateAndConsumedVo> userIdToVoMap) {
        Date current = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        userIdToVoMap.values().forEach(v -> v.getDateEstimate().forEach((key, value) -> {
            try {
                if (dateFormat.parse((String)key).before(current)) {
                    if (value < 8.0) {
                        v.getDateEstimate().put((String)key, 8.0);
                    } else if (value > 12.0) {
                        v.getDateEstimate().put((String)key, 12.0);
                    }
                }
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public Collection<UserProjectConsumedVo> getUserProjectConsumedList(int userId, String beginDate, String endDate) {
        List<UserProjectConsumedDetailDto> consumedDetailDto = this.projectMapper.getUserProjectConsumedList(userId, beginDate, endDate);
        HashMap<Integer, UserProjectConsumedVo> projectIdToVoMap = new HashMap<Integer, UserProjectConsumedVo>();
        for (UserProjectConsumedDetailDto dto : consumedDetailDto) {
            UserProjectConsumedVo vo = projectIdToVoMap.computeIfAbsent(dto.getProjectId(), ignore -> {
                UserProjectConsumedVo estimateAndConsumedVo = new UserProjectConsumedVo(dto.getProjectName(), dto.getProjectId(), dto.getBegin(), dto.getEnd());
                this.initDateEstimateAndConsumed(estimateAndConsumedVo, beginDate, endDate);
                return estimateAndConsumedVo;
            });
            this.appendEstimate(vo, dto);
        }
        this.handleEstimateMoreThanTwelve(projectIdToVoMap);
        List<UserEffortDto> userEffortsDto = this.projectMapper.getUserProjectEffort(userId, beginDate, endDate);
        for (UserEffortDto dto : userEffortsDto) {
            UserProjectConsumedVo vo = projectIdToVoMap.computeIfAbsent(dto.getProjectId(), ignore -> {
                UserProjectConsumedVo userProjectConsumedVo = new UserProjectConsumedVo(dto.getProjectName(), dto.getProjectId(), dto.getProjectBegin(), dto.getProjectEnd());
                this.initDateEstimateAndConsumed(userProjectConsumedVo, beginDate, endDate);
                return userProjectConsumedVo;
            });
            vo.getDateConsumed().computeIfPresent(dto.getDate(), (ignored, v) -> BigDecimal.valueOf(v + dto.getConsumed()).setScale(2, RoundingMode.CEILING).doubleValue());
        }
        projectIdToVoMap.values().forEach(v -> {
            v.setEstimate(BigDecimal.valueOf(v.getDateEstimate().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
            v.setConsumed(BigDecimal.valueOf(v.getDateConsumed().values().stream().mapToDouble(Double::doubleValue).sum()).setScale(2, RoundingMode.CEILING).doubleValue());
        });
        return projectIdToVoMap.values();
    }

    private void handleEstimateMoreThanTwelve(Map<Integer, UserProjectConsumedVo> projectIdToVoMap) {
        for (UserProjectConsumedVo vo : projectIdToVoMap.values()) {
            vo.getDateEstimate().forEach((key, value) -> {
                if (value > 12.0) {
                    vo.getDateEstimate().put((String)key, 12.0);
                }
            });
        }
    }

    private void handleEstimateMoreThanTwelveForProject(Map<Integer, ProjectTeamDetailVo> userIdToTeamDetailVoMap) {
        for (ProjectTeamDetailVo vo : userIdToTeamDetailVoMap.values()) {
            vo.getDateEstimate().forEach((key, value) -> {
                if (value > 12.0) {
                    vo.getDateEstimate().put((String)key, 12.0);
                }
            });
        }
    }

    public List<DateToProjectConsumedVo> getDateToProjectConsumedVoList(String parentProjectName, String beginDate, String endDate) {
        List<ProjectEstimateDto> dto = this.projectMapper.getProjectTaskConsumed(parentProjectName, beginDate, endDate);
        List<String> workingDays = this.getWorkingDays(beginDate, endDate);
        LinkedHashMap dateToProjectIdToConsumedVoMap = new LinkedHashMap();
        for (String string : workingDays) {
            dateToProjectIdToConsumedVoMap.put(string, new LinkedHashMap());
        }
        for (ProjectEstimateDto projectEstimateDto : dto) {
            if (projectEstimateDto.getEstimate() == 0.0 || null == projectEstimateDto.getStarted() || INVALID_TIME.equals(projectEstimateDto.getStarted())) continue;
            List<String> days = this.getWorkingDays(projectEstimateDto.getStarted(), projectEstimateDto.getEnded());
            double avgConsumed = BigDecimal.valueOf(projectEstimateDto.getEstimate()).divide(new BigDecimal(days.size()), RoundingMode.CEILING).setScale(1, RoundingMode.CEILING).doubleValue();
            for (String string : days) {
            }
        }
        return null;
    }

    public List<ZtProjectDTO> getMilestoneByName(String projectName, Integer programId) {
        List<ZtProjectDTO> ztProjects = this.projectMapper.getProjectByName(projectName, programId);
        if (CollectionUtils.isEmpty(ztProjects)) {
            return Lists.newArrayList();
        }
        List<Integer> parentIds = ztProjects.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<ZtProjectDTO> stages = this.projectMapper.getProjectChildrenByParent(parentIds, "stage");
        stages.stream().filter(v -> "doing".equals(v.getStatus()) || "wait".equals(v.getStatus())).forEach(v -> {
            String[] dateNumbers = v.getEnd().split("-");
            long daysBetween = ChronoUnit.DAYS.between(LocalDate.of(Integer.parseInt(dateNumbers[0]), Integer.parseInt(dateNumbers[1]), Integer.parseInt(dateNumbers[2])), LocalDate.now());
            if (daysBetween > 0L) {
                v.setIsDelay(Boolean.TRUE);
                v.setDelayDayCount(daysBetween);
            }
        });
        ztProjects.addAll(stages);
        ztProjects.stream().forEach(v -> ztProjects.stream().forEach(t -> {
            if (v.getId().equals(t.getParent())) {
                if (v.getChildren() == null) {
                    v.setChildren(Lists.newArrayList());
                }
                v.getChildren().add((ZtProjectDTO)t);
            }
        }));
        return ztProjects.stream().filter(v -> v.getParent() == null).collect(Collectors.toList());
    }

    public List<ZtProjectDTO> getProgramByParentId(Integer parentId) {
        ArrayList<Integer> parentIds = new ArrayList<Integer>();
        if (parentId != null) {
            parentIds.add(parentId);
        }
        List<ZtProjectDTO> ztProjects = this.projectMapper.getProjectChildrenByParent(parentIds, "program");
        Integer parentGrade = ztProjects.stream().map(v -> v.getGrade()).min(Integer::compareTo).get();
        ztProjects.stream().forEach(v -> ztProjects.stream().forEach(t -> {
            if (v.getId().equals(t.getParent())) {
                if (v.getChildren() == null) {
                    v.setChildren(Lists.newArrayList());
                }
                v.getChildren().add((ZtProjectDTO)t);
            }
        }));
        return ztProjects.stream().filter(v -> v.getGrade() == parentGrade).collect(Collectors.toList());
    }

    public List<ZtUser> getUserByDept(Integer deptId, String name) {
        return this.getUserByDeptList(deptId == null ? null : Lists.newArrayList((Object[])new Integer[]{deptId}), name);
    }

    public List<ZtUser> getUserByDeptList(List<Integer> deptIdList, String name) {
        return this.projectMapper.getUserByDeptList(deptIdList, name);
    }

    public List<ZtTask> getTaskByFinishUser(List<String> userAccountList, String date) {
        return this.projectMapper.getTaskByFinishUser(userAccountList, date);
    }

    public List<ZtTask> getTaskByUser(String userAccount, String date) {
        return this.projectMapper.getTaskByUser(userAccount, date);
    }

    public List<ZtUserScoreVO> getUserScore(Integer userId, Integer deptId, String date) {
        Integer n;
        String[] split = date.split("[^\\d]");
        Integer month = Integer.valueOf(split[1]);
        ArrayList userIdList = Lists.newArrayList();
        ArrayList userAccountList = Lists.newArrayList();
        if (userId == null) {
            List<ZtUser> userList = this.getUserByDept(deptId, null);
            userIdList.addAll(userList.stream().map(v -> v.getId()).collect(Collectors.toList()));
            userAccountList.addAll(userList.stream().map(v -> v.getAccount()).collect(Collectors.toList()));
        } else {
            userIdList.add(userId);
            ZtUser ztUser = (ZtUser)((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectById(userId);
            userAccountList.add(ztUser.getAccount());
        }
        List<ZtTask> taskList = this.getTaskByFinishUser(userAccountList, date.split("-")[0]);
        if (CollectionUtils.isEmpty(taskList)) {
            return null;
        }
        List ztUsers = ((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectBatchIds(userIdList);
        Map<Integer, ZtUser> userMap = ztUsers.stream().collect(Collectors.toMap(v -> v.getId(), v -> v, (k1, k2) -> k1));
        List currentMonthTaskList = taskList.stream().filter(v -> this.isCurrentMonth(v.getFinishedDate().toString().split(" ")[0], month)).collect(Collectors.toList());
        Map<String, List<ZtTask>> monthTaskMap = currentMonthTaskList.stream().collect(Collectors.groupingBy(v -> v.getFinishedBy()));
        Map<String, List<ZtTask>> yearTaskMap = taskList.stream().collect(Collectors.groupingBy(v -> v.getFinishedBy()));
        List userScoreVOS = userIdList.stream().map(v -> {
            ZtUserScoreVO userScoreVO = new ZtUserScoreVO();
            ZtUser ztUser = (ZtUser)userMap.get(v);
            List yearTaskList = (List)yearTaskMap.get(ztUser.getAccount());
            List monthTaskList = (List)monthTaskMap.get(ztUser.getAccount());
            Integer yearScore = this.countScoreTotal(yearTaskList);
            Integer monthScore = this.countScoreTotal(monthTaskList);
            userScoreVO.setId((Integer)v);
            userScoreVO.setAccount(ztUser.getAccount());
            userScoreVO.setDept(ztUser.getDept());
            userScoreVO.setRealname(ztUser.getRealname());
            userScoreVO.setRole(ztUser.getRole().toUpperCase(Locale.ROOT));
            userScoreVO.setMonthScore(monthScore);
            userScoreVO.setMonthScoreTotal(monthScore + 80);
            userScoreVO.setYearScoreTotal(yearScore + 80 * month);
            return userScoreVO;
        }).collect(Collectors.toList());
        Integer monthScoreMax = 999999;
        Integer yearScoreMax = 999999;
        Integer monthRankMax = 0;
        Integer yearRankMax = 0;
        LinkedList monthUserScoreList = userScoreVOS.stream().sorted(Comparator.comparing(ZtUserScoreVO::getMonthScoreTotal).reversed()).collect(Collectors.toCollection(LinkedList::new));
        for (int i = 0; i < monthUserScoreList.size(); ++i) {
            ZtUserScoreVO userScoreVO = (ZtUserScoreVO)monthUserScoreList.get(i);
            if (monthScoreMax > userScoreVO.getMonthScoreTotal()) {
                monthScoreMax = userScoreVO.getMonthScoreTotal();
                Integer n2 = monthRankMax;
                n = monthRankMax = Integer.valueOf(monthRankMax + 1);
            }
            userScoreVO.setMonthRank(monthRankMax);
        }
        LinkedList yearUserScoreList = userScoreVOS.stream().sorted(Comparator.comparing(ZtUserScoreVO::getYearScoreTotal).thenComparing(ZtUserScoreVO::getMonthScore).reversed()).collect(Collectors.toCollection(LinkedList::new));
        for (int i = 0; i < yearUserScoreList.size(); ++i) {
            ZtUserScoreVO userScoreVO = (ZtUserScoreVO)yearUserScoreList.get(i);
            if (yearScoreMax > userScoreVO.getYearScoreTotal()) {
                yearScoreMax = userScoreVO.getYearScoreTotal();
                n = yearRankMax;
                Integer n3 = yearRankMax = Integer.valueOf(yearRankMax + 1);
            }
            userScoreVO.setYearRank(yearRankMax);
        }
        return yearUserScoreList;
    }

    public List<ZtTask> getUserScoreTask(String account, String date) {
        if (ObjectUtils.isEmpty((Object)account)) {
            return null;
        }
        List<ZtTask> taskList = this.getTaskByUser(account, date.split("-")[0]);
        List<ZtTask> taskResult = taskList.stream().filter(v -> {
            if (Status.Done_State.getValue().equalsIgnoreCase(v.getStatus().getValue())) {
                return v.getFinishedDate().toString().startsWith(date.substring(0, 7));
            }
            return true;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(taskList)) {
            return null;
        }
        Set userAccountList = taskResult.stream().flatMap(v -> Stream.of(v.getFinishedBy(), v.getAssignedTO())).collect(Collectors.toSet());
        List<ZtUser> userList = this.projectMapper.getUserByAccount(userAccountList.stream().collect(Collectors.toList()));
        Map<String, ZtUser> userMap = userList.stream().collect(Collectors.toMap(v -> v.getAccount(), v -> v, (k1, k2) -> k1));
        taskResult.stream().forEach(v -> {
            if (!ObjectUtils.isEmpty((Object)v.getFinishedBy())) {
                v.setFinishedBy(((ZtUser)userMap.get(v.getFinishedBy())).getRealname());
            }
            v.setAssignedTO(((ZtUser)userMap.get(v.getAssignedTO())).getRealname());
        });
        return taskResult;
    }

    private Boolean isCurrentMonth(String date, Integer month) {
        String[] split = date.split("[^\\d]");
        Integer targetMonth = Integer.valueOf(split[1]);
        return month == targetMonth;
    }

    private Integer countScoreTotal(List<ZtTask> taskList) {
        if (CollectionUtils.isEmpty(taskList)) {
            return 0;
        }
        Integer scoreTotal = taskList.stream().map(v -> {
            String taskName = v.getName();
            String scoreTask = taskName.split("\u79ef\u5206\u3011")[0];
            if (ObjectUtils.isEmpty((Object)scoreTask)) {
                return null;
            }
            return Integer.valueOf(scoreTask.substring(1));
        }).filter(v -> v != null).reduce(Integer::sum).orElse(0);
        return scoreTotal;
    }

    public ZtTaskRespVO queryTaskListByCondition(queryTaskReq queryTaskReq2, Integer scene) {
        List<ZtTaskProjectVO> bugList;
        ZtTaskRespVO ztTaskRespVO = new ZtTaskRespVO();
        long availableDuration = 0L;
        List<ZtUser> userList = this.ztUserDAO.queryUserList(queryTaskReq2.getDeptId());
        Map<String, ZtUser> accountMap = userList.stream().collect(Collectors.toMap(ZtUser::getAccount, Function.identity(), (a, b) -> a));
        List<ZtTaskProjectVO> taskList = this.projectMapper.queryTaskListByCondition(queryTaskReq2, accountMap.keySet());
        if (CollectionUtils.isNotEmpty(taskList)) {
            taskList.forEach(x -> {
                if (StringUtils.isBlank((CharSequence)x.getFinishedBy())) {
                    x.setFinishedBy(x.getAssignedTO());
                }
            });
            Map<Object, Object> taskIdMap = Maps.newHashMap();
            if (Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT.equals(scene) && StringUtils.isNotBlank((CharSequence)queryTaskReq2.getStartTime()) && StringUtils.isNotBlank((CharSequence)queryTaskReq2.getEndTime())) {
                List<Integer> taskIdList = taskList.stream().map(ZtTaskProjectVO::getId).collect(Collectors.toList());
                List<ZtEffort> taskEffortList = this.projectMapper.queryTaskConsumed(taskIdList, queryTaskReq2.getStartTime(), queryTaskReq2.getEndTime());
                taskIdMap = taskEffortList.stream().collect(Collectors.groupingBy(ZtEffort::getObjectID, Collectors.groupingBy(ZtEffort::getAccount, Collectors.mapping(ZtEffort::getConsumed, Collectors.reducing(Float::sum)))));
            }
            MathContext mathContext = new MathContext(3, RoundingMode.HALF_UP);
            for (ZtTaskProjectVO x2 : taskList) {
                if (Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT.equals(scene) && StringUtils.isNotBlank((CharSequence)queryTaskReq2.getStartTime()) && StringUtils.isNotBlank((CharSequence)queryTaskReq2.getEndTime())) {
                    DtdappProjectService.calculateEstimate(x2, queryTaskReq2, taskIdMap);
                }
                BigDecimal estimate = ObjectUtils.isEmpty((Object)x2.getEstimate()) || x2.getEstimate().equals(new BigDecimal(0)) ? new BigDecimal(0) : x2.getEstimate().setScale(1, RoundingMode.HALF_UP);
                x2.setEstimate(estimate);
                BigDecimal consumed = ObjectUtils.isEmpty((Object)x2.getConsumed()) || x2.getConsumed().equals(new BigDecimal(0)) ? new BigDecimal(0) : x2.getConsumed().setScale(1, RoundingMode.HALF_UP);
                x2.setConsumed(consumed);
                x2.setTypeName(KanBanStatus.fromValue(x2.getType()));
                String process = this.calculateProcess(x2.getId(), x2.getConsumed(), x2.getLeft(), mathContext);
                x2.setTaskProgress(process);
                String workHourDeviation = this.calculateWorkHourDeviation(x2.getEstimate(), x2.getConsumed(), mathContext);
                x2.setWorkHourDeviationRate(workHourDeviation);
            }
            if (Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT.equals(scene)) {
                availableDuration = this.calculateAvailablePeriod(queryTaskReq2);
            }
        }
        if (CollectionUtils.isNotEmpty(bugList = this.projectMapper.queryBugListByCondition(queryTaskReq2))) {
            taskList.addAll(bugList);
        }
        if (CollectionUtils.isEmpty(taskList)) {
            return ztTaskRespVO;
        }
        List<ZtTaskVO> userTaskList = this.buildUserTaskList(taskList, scene, availableDuration, accountMap);
        ztTaskRespVO.setTaskList(userTaskList);
        ZtTaskSummaryVO taskSummaryVO = this.buildTaskSummary(userTaskList, scene, availableDuration);
        ztTaskRespVO.setTaskSummary(taskSummaryVO);
        return ztTaskRespVO;
    }

    private List<ZtTaskVO> buildUserTaskList(List<ZtTaskProjectVO> taskList, Integer scene, long availableDuration, Map<String, ZtUser> accountMap) {
        ArrayList userTaskList = Lists.newArrayList();
        Map<String, List<ZtTaskProjectVO>> accountTaskList = taskList.stream().collect(Collectors.groupingBy(ZtTaskProjectVO::getFinishedBy));
        for (Map.Entry<String, List<ZtTaskProjectVO>> accountEntry : accountTaskList.entrySet()) {
            String key = accountEntry.getKey();
            List<ZtTaskProjectVO> value = accountEntry.getValue();
            ZtTaskVO taskVO = new ZtTaskVO();
            taskVO.setAccount(key);
            taskVO.setRealname(ObjectUtils.isEmpty((Object)accountMap.get(key)) ? "\u5176\u4ed6" : accountMap.get(key).getRealname());
            taskVO.setRole(ObjectUtils.isEmpty((Object)accountMap.get(key)) ? "\u5176\u4ed6" : accountMap.get(key).getRole());
            taskVO.setUserTaskList(value);
            value.forEach(x -> {
                x.setEstStartedStr(ObjectUtils.isEmpty((Object)x.getEstStarted()) ? "" : DateUtils.parseLocalDateToString(x.getEstStarted(), "yyyy/MM/dd"));
                x.setDeadlineStr(ObjectUtils.isEmpty((Object)x.getDeadline()) ? "" : DateUtils.parseLocalDateToString(x.getDeadline(), "yyyy/MM/dd"));
            });
            ZtTaskTotalVO taskTotalVO = new ZtTaskTotalVO();
            List<String> projectIdList = value.stream().map(ZtTaskProjectVO::getProjectId).distinct().collect(Collectors.toList());
            taskTotalVO.setProjectIdList(projectIdList);
            List<String> projectNameList = value.stream().map(ZtTaskProjectVO::getProjectName).distinct().collect(Collectors.toList());
            taskTotalVO.setProjectNameList(projectNameList);
            BigDecimal totalConsumed = value.stream().map(ZtTaskProjectVO::getConsumed).filter(consumed -> !ObjectUtils.isEmpty((Object)consumed)).reduce(BigDecimal.ZERO, BigDecimal::add);
            taskTotalVO.setConsumed(totalConsumed.equals(new BigDecimal(0)) ? new BigDecimal(0) : totalConsumed.setScale(1, RoundingMode.HALF_UP));
            boolean flag = value.stream().anyMatch(x -> !KanBanStatus.bug.getValue().equals(x.getType()));
            if (flag) {
                LocalDate earliestEstStarted = value.stream().map(ZtTaskProjectVO::getEstStarted).filter(estStarted -> !ObjectUtils.isEmpty((Object)estStarted)).min(LocalDate::compareTo).orElse(null);
                taskTotalVO.setEarliestEstStarted(earliestEstStarted);
                taskTotalVO.setEarliestEstStartedStr(ObjectUtils.isEmpty((Object)earliestEstStarted) ? "" : DateUtils.parseLocalDateToString(earliestEstStarted, "yyyy/MM/dd"));
                LocalDate latestDeadline = value.stream().map(ZtTaskProjectVO::getDeadline).filter(deadline -> !ObjectUtils.isEmpty((Object)deadline)).max(LocalDate::compareTo).orElse(null);
                taskTotalVO.setLatestDeadline(latestDeadline);
                taskTotalVO.setLatestDeadlineStr(ObjectUtils.isEmpty((Object)latestDeadline) ? "" : DateUtils.parseLocalDateToString(latestDeadline, "yyyy/MM/dd"));
                LocalDateTime earliestRealStarted = value.stream().map(ZtTaskProjectVO::getRealStarted).filter(x -> !ObjectUtils.isEmpty((Object)x)).min(LocalDateTime::compareTo).orElse(null);
                taskTotalVO.setEarliestRealStarted(earliestRealStarted);
                LocalDateTime latestFinishedDate = value.stream().map(ZtTaskProjectVO::getFinishedDate).filter(x -> !ObjectUtils.isEmpty((Object)x)).max(LocalDateTime::compareTo).orElse(null);
                taskTotalVO.setLatestFinishedDate(latestFinishedDate);
                BigDecimal totalEstimate = value.stream().map(ZtTaskProjectVO::getEstimate).filter(estimate -> !ObjectUtils.isEmpty((Object)estimate)).reduce(BigDecimal.ZERO, BigDecimal::add);
                taskTotalVO.setEstimate(totalEstimate.equals(new BigDecimal(0)) ? new BigDecimal(0) : totalEstimate.setScale(1, RoundingMode.HALF_UP));
                MathContext mathContext = new MathContext(3, RoundingMode.HALF_UP);
                double totalLeft = value.stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getLeft())).mapToDouble(ZtTaskProjectVO::getLeft).sum();
                String process = this.calculateProcess(null, totalConsumed, Float.valueOf((float)totalLeft), mathContext);
                taskTotalVO.setTaskProgress(process);
                String workHourDeviation = this.calculateWorkHourDeviation(totalEstimate, totalConsumed, mathContext);
                taskTotalVO.setWorkHourDeviationRate(workHourDeviation);
                if (Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT.equals(scene)) {
                    String expectedUtilizationRate = this.calculateExpectedUtilizationRate(totalEstimate, availableDuration, mathContext);
                    taskTotalVO.setExpectedUtilizationRate(expectedUtilizationRate);
                    String actualUtilizationRate = this.calculateActualUtilizationRate(totalConsumed, availableDuration, mathContext);
                    taskTotalVO.setActualUtilizationRate(actualUtilizationRate);
                }
            }
            taskVO.setTaskTotal(taskTotalVO);
            userTaskList.add(taskVO);
        }
        return userTaskList;
    }

    private ZtTaskSummaryVO buildTaskSummary(List<ZtTaskVO> userTaskList, Integer scene, long availableDuration) {
        ZtTaskSummaryVO taskSummary = new ZtTaskSummaryVO();
        taskSummary.setPersonNum(userTaskList.size());
        long devNum = userTaskList.stream().filter(x -> KanBanStatus.DEV.getValue().equals(x.getRole())).count();
        taskSummary.setDevNum(devNum);
        long qaNum = userTaskList.stream().filter(x -> KanBanStatus.QC.getValue().equals(x.getRole())).count();
        taskSummary.setQaNum(qaNum);
        BigDecimal totalEstimate = userTaskList.stream().map(x -> x.getTaskTotal().getEstimate()).filter(estimate -> !ObjectUtils.isEmpty((Object)estimate)).reduce(BigDecimal.ZERO, BigDecimal::add);
        taskSummary.setTotalEstimate(totalEstimate.equals(new BigDecimal(0)) ? new BigDecimal(0) : totalEstimate.setScale(1, RoundingMode.HALF_UP));
        BigDecimal totalConsumed = userTaskList.stream().map(x -> x.getTaskTotal().getConsumed()).filter(consumed -> !ObjectUtils.isEmpty((Object)consumed)).reduce(BigDecimal.ZERO, BigDecimal::add);
        taskSummary.setTotalConsumed(totalConsumed.equals(new BigDecimal(0)) ? new BigDecimal(0) : totalConsumed.setScale(1, RoundingMode.HALF_UP));
        MathContext mathContext = new MathContext(3, RoundingMode.HALF_UP);
        String workHourDeviation = this.calculateWorkHourDeviation(totalEstimate, totalConsumed, mathContext);
        taskSummary.setTotalWorkHourDeviationRate(workHourDeviation);
        if (Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT.equals(scene)) {
            taskSummary.setAvailableDuration(availableDuration *= (long)userTaskList.size());
            String expectedUtilizationRate = this.calculateExpectedUtilizationRate(totalEstimate, availableDuration, mathContext);
            taskSummary.setTotalExpectedUtilizationRate(expectedUtilizationRate);
            String actualUtilizationRate = this.calculateActualUtilizationRate(totalConsumed, availableDuration, mathContext);
            taskSummary.setTotalActualUtilizationRate(actualUtilizationRate);
        }
        return taskSummary;
    }

    private long calculateAvailablePeriod(queryTaskReq queryTaskReq2) {
        long availableDuration = this.calculateAvailableDuration(LocalDate.parse(queryTaskReq2.getStartTime()), LocalDate.parse(queryTaskReq2.getEndTime()));
        return availableDuration * 8L;
    }

    private long calculateAvailableDuration(LocalDate startDate, LocalDate endDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.between((Object)"date", (Object)startDate, (Object)endDate);
        List holidayDateList = this.holidayDateMapper.selectList((Wrapper)queryWrapper);
        List<String> holidayList = holidayDateList.stream().filter(x -> Constant.DATE_TYPE_HOLIDAY.equals(x.getDateType())).map(ZtDJHolidayDate::getDate).collect(Collectors.toList());
        List<String> workingList = holidayDateList.stream().filter(x -> Constant.DATE_TYPE_WORKING.equals(x.getDateType())).map(ZtDJHolidayDate::getDate).collect(Collectors.toList());
        return DateUtils.calculateLegalWorkingDays(startDate, endDate, holidayList, workingList);
    }

    private static void calculateEstimate(ZtTaskProjectVO x, queryTaskReq queryTaskReq2, Map<Integer, Map<String, Optional<Float>>> taskIdMap) {
        if (MapUtils.isNotEmpty(taskIdMap) && MapUtils.isNotEmpty(taskIdMap.get(x.getId()))) {
            Optional<Float> optional = taskIdMap.get(x.getId()).get(x.getFinishedBy());
            float temp = ObjectUtils.isEmpty(optional) ? 0.0f : optional.orElse(Float.valueOf(0.0f)).floatValue();
            x.setConsumed(temp == 0.0f ? new BigDecimal(0) : new BigDecimal(String.valueOf(temp)));
        } else {
            x.setConsumed(new BigDecimal(0));
        }
        BigDecimal estimate = x.getEstimate();
        if (ObjectUtils.isEmpty((Object)estimate) || estimate.equals(new BigDecimal(0)) || ObjectUtils.isEmpty((Object)x.getEstStarted()) || ObjectUtils.isEmpty((Object)x.getDeadline())) {
            x.setEstimate(new BigDecimal(0));
            return;
        }
        long totalPeriod = DateUtils.calculateDateDifference(x.getEstStarted(), x.getDeadline());
        if (totalPeriod == 0L) {
            x.setEstimate(new BigDecimal(0));
            return;
        }
        MathContext mc = new MathContext(3, RoundingMode.HALF_UP);
        if (x.getDeadline().isBefore(LocalDate.parse(queryTaskReq2.getStartTime())) || x.getEstStarted().isAfter(LocalDate.parse(queryTaskReq2.getEndTime()))) {
            estimate = new BigDecimal(0);
        }
        if (x.getEstStarted().isBefore(LocalDate.parse(queryTaskReq2.getStartTime())) && !x.getDeadline().isAfter(LocalDate.parse(queryTaskReq2.getEndTime()))) {
            long coveragePeriod = DateUtils.calculateDateDifference(LocalDate.parse(queryTaskReq2.getStartTime()), x.getDeadline());
            estimate = new BigDecimal(coveragePeriod).divide(new BigDecimal(totalPeriod), mc).multiply(estimate);
        } else if (!x.getEstStarted().isBefore(LocalDate.parse(queryTaskReq2.getStartTime())) && !x.getDeadline().isAfter(LocalDate.parse(queryTaskReq2.getEndTime()))) {
            estimate = x.getEstimate();
        } else if (!x.getEstStarted().isBefore(LocalDate.parse(queryTaskReq2.getStartTime())) && !x.getEstStarted().isAfter(LocalDate.parse(queryTaskReq2.getEndTime())) && x.getDeadline().isAfter(LocalDate.parse(queryTaskReq2.getEndTime()))) {
            long coveragePeriod = DateUtils.calculateDateDifference(x.getEstStarted(), LocalDate.parse(queryTaskReq2.getEndTime()));
            estimate = new BigDecimal(coveragePeriod).divide(new BigDecimal(totalPeriod), mc).multiply(estimate);
        } else if (x.getEstStarted().isBefore(LocalDate.parse(queryTaskReq2.getStartTime())) && x.getDeadline().isAfter(LocalDate.parse(queryTaskReq2.getEndTime()))) {
            long coveragePeriod = DateUtils.calculateDateDifference(LocalDate.parse(queryTaskReq2.getStartTime()), LocalDate.parse(queryTaskReq2.getEndTime()));
            estimate = new BigDecimal(coveragePeriod).divide(new BigDecimal(totalPeriod), mc).multiply(estimate);
        }
        x.setEstimate(estimate);
    }

    private String calculateProcess(Integer taskId, BigDecimal consumed, Float left, MathContext mathContext) {
        try {
            if (consumed.equals(new BigDecimal("0")) || consumed.equals(new BigDecimal("0.0"))) {
                return "0%";
            }
            if (consumed.add(new BigDecimal(left.floatValue())).equals(new BigDecimal("0")) || consumed.add(new BigDecimal(left.floatValue())).equals(new BigDecimal("0.0"))) {
                return "";
            }
            BigDecimal process = consumed.divide(consumed.add(new BigDecimal(left.floatValue())), mathContext);
            DecimalFormat df = new DecimalFormat("#%");
            return df.format(process);
        }
        catch (Exception e) {
            log.info("taskId:{}, new BigDecimal(left):{}, consumed.add(new BigDecimal(left)):{}", new Object[]{taskId, new BigDecimal(left.floatValue()), consumed.add(new BigDecimal(left.floatValue())), e});
            return "";
        }
    }

    private String calculateWorkHourDeviation(BigDecimal estimate, BigDecimal consumed, MathContext mathContext) {
        if (estimate.equals(new BigDecimal("0")) || estimate.equals(new BigDecimal("0.0"))) {
            return "0%";
        }
        if (consumed.equals(new BigDecimal("0")) || consumed.equals(new BigDecimal("0.0"))) {
            return "";
        }
        BigDecimal workHourDeviation = estimate.divide(consumed, mathContext);
        DecimalFormat df = new DecimalFormat("#%");
        return df.format(workHourDeviation);
    }

    private String calculateExpectedUtilizationRate(BigDecimal estimate, Long availableDuration, MathContext mathContext) {
        if (estimate.equals(new BigDecimal(0))) {
            return "0%";
        }
        if (availableDuration == 0L) {
            return "";
        }
        BigDecimal expectedUtilizationRate = estimate.divide(new BigDecimal(availableDuration), mathContext);
        DecimalFormat df = new DecimalFormat("#%");
        return df.format(expectedUtilizationRate);
    }

    private String calculateActualUtilizationRate(BigDecimal consumed, Long availableDuration, MathContext mathContext) {
        if (consumed.equals(new BigDecimal(0))) {
            return "0%";
        }
        if (availableDuration == 0L) {
            return "";
        }
        BigDecimal actualUtilizationRate = consumed.divide(new BigDecimal(availableDuration), mathContext);
        DecimalFormat df = new DecimalFormat("#%");
        return df.format(actualUtilizationRate);
    }
}

