/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.util;

import com.digiwin.athena.esp.sdk.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

public class DateUtils {
    public static final String DATE_FORMAT_ONE = "yyyy-MM-dd";
    public static final String DATE_FORMAT_TWO = "yyyy/MM/dd";

    public static Date getDateTimeNow() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date parseStringToDate(String dateString, String format) throws ParseException {
        if (StringUtil.isEmpty((Object)dateString)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(dateString);
    }

    public static long calculateWorkingDays(LocalDate start, LocalDate end) {
        long daysBetween = ChronoUnit.DAYS.between(start, end) + 1L;
        long weekendDays = 0L;
        for (long i = 0L; i < daysBetween; ++i) {
            LocalDate date = start.plusDays(i);
            if (date.getDayOfWeek().getValue() != 6 && date.getDayOfWeek().getValue() != 7) continue;
            ++weekendDays;
        }
        return daysBetween - weekendDays;
    }

    public static long calculateLegalWorkingDays(LocalDate start, LocalDate end, List<String> holidayList, List<String> workingList) {
        long daysBetween = ChronoUnit.DAYS.between(start, end) + 1L;
        long holidayDays = 0L;
        for (long i = 0L; i < daysBetween; ++i) {
            LocalDate date = start.plusDays(i);
            String dateStr = DateUtils.parseLocalDateToString(date, DATE_FORMAT_ONE);
            if ((date.getDayOfWeek().getValue() != 6 && date.getDayOfWeek().getValue() != 7 || workingList.contains(dateStr)) && !holidayList.contains(dateStr)) continue;
            ++holidayDays;
        }
        return daysBetween - holidayDays;
    }

    public static LocalDate convertStringToLocalDate(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_ONE);
        try {
            return LocalDate.parse(dateString, formatter);
        }
        catch (DateTimeParseException e) {
            System.out.println("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e: " + e.getMessage());
            return null;
        }
    }

    public static String parseLocalDateToString(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return formatter.format(localDate);
    }

    public static long calculateDateDifference(LocalDate startDate, LocalDate endDate) {
        return ChronoUnit.DAYS.between(startDate, endDate);
    }
}

