package com.digiwin.athena;


import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(exclude = {MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, DataSourceAutoConfiguration.class})
@ComponentScan(basePackages = {"com.digiwin.gateway", "com.digiwin.athena.dtdapp"})
@EntityScan({"com.digiwin.athena.dtdapp.dao", "com.digiwin.athena.dtdapp.pojo.neo4j"})
@EnableTransactionManagement
@EnableScheduling
@EnableNeo4jRepositories(basePackages = "com.digiwin.athena.dtdapp.repoNeo4j")
public class DtdAppBoot {

    public static void main(String[] args) {

        try {
            SpringApplication springApplication = new SpringApplication(DtdAppBoot.class);
            springApplication.addListeners(new ApplicationPidFileWriter("DWApiGatewayApplication.pid"));
            springApplication.run(args);
        } catch (Throwable e) {
            print(e);
            throw e;
        }

    }

    private static void print(Throwable e){
        e.printStackTrace();
        if(e.getCause()!=null){
            print(e.getCause());
        }
    }

}
