package com.digiwin.athena.dtdapp.config;

import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-07 15:47
 **/
//@Configuration
//@ConditionalOnProperty(value = "spring.data.neo4j.domain1.enable",havingValue = "true")
//@Import({Neo4jProperties.class})
//@EnableNeo4jRepositories(basePackages = "com.digiwin.athena.dtdapp.repoNeo4j",sessionFactoryRef="dtdappSessionFactory")
public class DtdappNeo4jConfiguration {

    @Autowired
    Neo4jProperties neo4jProperties;


//    @Primary
    @Bean("dtdappNeo4jDriver")
    public org.neo4j.driver.v1.Driver dtdAppNeo4jDriver() {
        Config config = Config.build()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime( 4, TimeUnit.MINUTES )
                .withMaxConnectionPoolSize( 50 )
                .withConnectionAcquisitionTimeout( 1, TimeUnit.MINUTES )
                .toConfig();
        return GraphDatabase.driver(neo4jProperties.getUri(), AuthTokens.basic( neo4jProperties.getUsername(), neo4jProperties.getPassword() ), config );
    }

  //  @Primary
    @Bean("dtdappOgmDriver")
    public Driver dtdappOgmDriver() {
        Driver ogmDriver = new BoltDriver(dtdAppNeo4jDriver());
        return ogmDriver;
    }

 //   @Primary
    @Bean("dtdappSessionFactory")
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(dtdappOgmDriver(),packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
//        List<String> packages = EntityScanPackages.get(applicationContext)
//                .getPackageNames();
//        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
//            packages = AutoConfigurationPackages.get(applicationContext);
//        }
//        return org.springframework.util.StringUtils.toStringArray(packages);
        return new String[]{ "com.digiwin.athena.dtdapp.pojo.neo4j"};
    }

}
