package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.dtdapp.mapper.DorDodCheckItemMapper;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckItem;
import com.digiwin.athena.dtdapp.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class DorDoDCheckItemDAO extends ServiceImpl<DorDodCheckItemMapper, DorDodCheckItem> {


    public List getDorDodCheckItems(Map parameter) {
        log.info("getDorDodCheckItems:{}", parameter);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("check_item_info");

        if(jsonArray == null || jsonArray.size() == 0){
            List<DorDodCheckItem> dorDodCheckItems = this.baseMapper.selectList(new QueryWrapper<>());
            return dorDodCheckItems;
        }

        JSONObject jsonObject = jsonArray.getJSONObject(0);
        String check_type = jsonObject.getString("check_type");

        QueryWrapper<DorDodCheckItem> queryWrapper = new QueryWrapper<>();
        LambdaQueryWrapper<DorDodCheckItem> lambda = queryWrapper.lambda();
        lambda.eq(DorDodCheckItem::getCheck_type, check_type);

        List<DorDodCheckItem> dorDodCheckItems = this.baseMapper.selectList(queryWrapper);
        return dorDodCheckItems;
    }

    public List saveDorDodCheckItems(Map parameter) {
        log.info("saveDorDodCheckItems:{}", parameter);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("check_item_info");

        if(jsonArray == null || jsonArray.size() == 0){
            throw new DWRuntimeException("has no data to save");
        }

        List<DorDodCheckItem> dorDodCheckItems = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCheckItem.class);

        this.saveOrUpdateBatch(dorDodCheckItems);

        return dorDodCheckItems;
    }
}
