package com.digiwin.athena.dtdapp.dao.zentao;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.dtdapp.mapperzentao.ZtStoryMapper;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProductplan;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtStory;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtStoryVO;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.Year;
import java.util.List;

@Service
@Slf4j
public class ZtStoryDAO extends ServiceImpl<ZtStoryMapper, ZtStory> {
    @Autowired
    private ZtStoryMapper ztStoryMapper;
    public List<ZtStory> getProjectDemandByProjectId(Integer id) {
        return ztStoryMapper.getProjectDemandByProjectId(id);
    }

    public List<ZtStory> getStoryByModuleId(List<String> moduleIds){
        return ztStoryMapper.getStoryByModuleId(moduleIds);
    }

    public List<ZtStory> getStoryByProductId(List<Integer> productIds) {
        return ztStoryMapper.getStoryByProductId(productIds);
    }

    public Integer getStoryByPlanId(List<String> ztProductPlans,String stage) {
        return ztStoryMapper.getStoryByPlanId(ztProductPlans,stage);
    }

    public List<ZtStoryVO> getStoryByProductIdOrModuleId(List<String> storyIds,String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort,
                                                         String associated_tasks_sort, String associated_bugs_sort,Integer page,Integer size,String status){
        return ztStoryMapper.getStoryByProductIdOrModuleId(storyIds,id_sort,plan_end_sort,pri_sort,estimate_sort,consumed_sort,associated_tasks_sort,associated_bugs_sort,page,size,status);
    }

    public Long getStoryByProductIdOrModuleIdSum(List<String> storyIds,String status){
        return ztStoryMapper.getStoryByProductIdOrModuleIdSum(storyIds,status);
    }

    public List<String> getStoryIdByProductIds(List<Integer> productIds){
        return ztStoryMapper.getStoryIdByProductIds(productIds);
    }

    public List<String> getStoryIdByModuleIds(List<String> moduleIds){
        return ztStoryMapper.getStoryIdByModuleIds(moduleIds);
    }
}
