package com.digiwin.athena.dtdapp.mapperzentao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtDept;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @author
 * @version 1.0
 */
public interface ZtDeptMapper extends BaseMapper<ZtDept> {

    @Select("SELECT A.title                                   AS bugName\n" +
            "     , A.id                                         bugNum\n" +
            "     , l.name                                    AS assignedDepartment\n" +
            "     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n" +
            "     , D.code                                    AS productCode\n" +
            "     , D.name                                       productName\n" +
            "     , CASE\n" +
            "           WHEN A.severity = 1 THEN '1.A类严重BUG'\n" +
            "           WHEN A.severity = 2 THEN '2.较严重BUG'\n" +
            "           WHEN A.severity = 3 THEN '3.一般BUG'\n" +
            "           WHEN A.severity = 4 THEN '4.轻微BUG'\n" +
            "    END                                             severity\n" +
            "     , A.pri                                     AS priorityOrder\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "           ELSE\n" +
            "               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "    END                                             processingDays\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n" +
            "           ELSE\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n" +
            "    END                                             processingHours\n" +
            "     , B.realname                                AS questioner\n" +
            "     , G.realname                                AS receiver\n" +
            "     , CASE\n" +
            "           WHEN E.parent = 0 THEN E.name\n" +
            "           WHEN E.parent <> 0 THEN E2.name\n" +
            "    END                                             receiverDept\n" +
            "     , H.realname                                AS externalBugTracker\n" +
            "     , CASE\n" +
            "           WHEN A.type = 'security' THEN '安全相关'\n" +
            "           WHEN A.type IN ('codeerror') THEN '代码错误'\n" +
            "           WHEN A.type = 'otherserror' THEN '他人Bug'\n" +
            "           WHEN A.type = 'ERPbug' THEN '稳态erpBUG'\n" +
            "           WHEN A.type IN ('config', 'application') THEN '配置相关'\n" +
            "           WHEN A.type = 'BMbug' THEN '业务中台BUG'\n" +
            "           WHEN A.type = 'application' THEN '应用问题'\n" +
            "           WHEN A.type = 'designdefect' THEN '设计缺陷'\n" +
            "           WHEN A.type = 'install' THEN '安装部署'\n" +
            "           WHEN A.type = 'performance' THEN '性能问题'\n" +
            "           WHEN A.type = 'automation' THEN '测试脚本'\n" +
            "           WHEN A.type = 'codeimprovement' THEN '代码改进'\n" +
            "           WHEN A.type = 'others' THEN '其他'\n" +
            "           WHEN A.type = 'platform' THEN '平台原因'\n" +
            "           WHEN A.type = 'customization' THEN '定制问题'\n" +
            "           WHEN A.type = 'TBB' THEN 'TBB报表问题'\n" +
            "           WHEN A.type = 'ksc' THEN '知识中心问题'\n" +
            "           WHEN A.type = 'Yixin' THEN '亿信报表问题'\n" +
            "           WHEN A.type = 'nobug' THEN ' 非BUG '\n" +
            "           WHEN A.type = 'standard' THEN '标准规范'\n" +
            "           WHEN A.type = 'designdefect_ux' THEN '设计缺陷(UX问题)'\n" +
            "           WHEN A.type = 'designdefect_req' THEN '设计缺陷(需求问题)'\n" +
            "           WHEN A.type = 'experience' THEN '使用體驗不佳'\n" +
            "           WHEN A.type = 'code_compatibility' THEN '代码兼容性'\n" +
            "           WHEN A.type = 'browser_compatibility' THEN '浏览器兼容性'\n" +
            "           WHEN A.type = 'user_experience' THEN '用户体验'\n" +
            "           WHEN A.type = 'multilingual' THEN '多语系问题'\n" +
            "           WHEN A.type = 'data_issue' THEN '数据问题'\n" +
            "           WHEN A.type = 'DAP' THEN 'DAP问题'\n" +
            "           WHEN A.type = 'external' THEN '环境问题'\n" +
            "           WHEN A.type = 'Episodic' THEN '待观察'\n" +
            "           WHEN A.type = 'gnwj' THEN '功能误解'\n" +
            "           ELSE A.type\n" +
            "    END                                             bugType\n" +
            "     , CASE\n" +
            "           WHEN A.BugDepartment = 'platform' THEN 'Athena平台'\n" +
            "           WHEN A.BugDepartment = 'customization' THEN '定制前端'\n" +
            "           WHEN A.BugDepartment = 'application' THEN '标准前端'\n" +
            "           WHEN A.BugDepartment = 'TBB' THEN 'TBB报表'\n" +
            "           WHEN A.BugDepartment = 'ksc' THEN '知识中心'\n" +
            "           WHEN A.BugDepartment = 'Yixin' THEN '亿信报表'\n" +
            "           WHEN A.BugDepartment = 'BM' THEN '业务中台'\n" +
            "           WHEN A.BugDepartment = 'ERP' THEN '稳态ERP'\n" +
            "           WHEN A.BugDepartment = 'DAP' THEN 'DAP平台'\n" +
            "           WHEN A.BugDepartment = 'ADD' THEN '应用研发中心'\n" +
            "           WHEN A.BugDepartment = 'EMD' THEN '装备制造事业部'\n" +
            "           WHEN A.BugDepartment = 'DC' THEN '数据中台'\n" +
            "           WHEN A.BugDepartment = 'Other' THEN '其他'\n" +
            "           WHEN A.BugDepartment = 'YiFei' THEN '稳态-易飞'\n" +
            "           WHEN A.BugDepartment = 'Mobile' THEN '移动端'\n" +
            "           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n" +
            "           WHEN A.BugDepartment = 'Service' THEN '服务云'\n" +
            "           WHEN A.BugDepartment = 'T' THEN '稳态-T产品'\n" +
            "           WHEN A.BugDepartment = 'E10' THEN '稳态-E10'\n" +
            "           WHEN A.BugDepartment = 'WF' THEN '稳态-WF'\n" +
            "           WHEN A.BugDepartment = 'BM01' THEN '业务中台-应用开发'\n" +
            "           ELSE A.BugDepartment\n" +
            "    END                                             bugBelongToDept\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.status = 'active' THEN '激活'\n" +
            "           WHEN A.status = 'resolved' THEN '已解决'\n" +
            "           WHEN A.status = 'closed' THEN '已关闭'\n" +
            "    END                                             bugState\n" +
            "     , C.realname                                AS solver\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN '内部BUG'\n" +
            "           WHEN A.bugType = '' THEN ''\n" +
            "           WHEN A.bugType = 'external' THEN '外部BUG'\n" +
            "    END                                             bugClassification\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN 0\n" +
            "           WHEN A.bugType = '' THEN 0\n" +
            "           WHEN A.bugType = 'external' THEN 1\n" +
            "    END                                             customerRequestsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name = 'Athena' or D.name = 'ATHENA平台需求' or D.name = 'Athena-PaaS平台' or\n" +
            "                 D.name = 'Athena平台運維事務' or D.name = 'athena低代码开发设计器' or D.name = '表格内测' or\n" +
            "                 D.name = '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             platformPresentsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name <> 'Athena' and D.name <> 'ATHENA平台需求' and D.name <> 'Athena-PaaS平台' and\n" +
            "                 D.name <> 'Athena平台運維事務' and D.name <> 'athena低代码开发设计器' AND D.name <> '表格内测' AND\n" +
            "                 D.name <> '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             applicationRaisesBugCount\n" +
            "     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n" +
            "     , CASE\n" +
            "           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n" +
            "           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n" +
            "           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n" +
            "           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n" +
            "           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n" +
            "           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n" +
            "           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n" +
            "           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n" +
            "           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n" +
            "           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n" +
            "           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n" +
            "    END                                             owningSprint\n" +
            "     , CASE\n" +
            "           WHEN A.resolution = 'modicode' THEN '修改代码'\n" +
            "           WHEN A.resolution = 'modiconfig' THEN '修改配置'\n" +
            "           WHEN A.resolution = 'bydesign' THEN '设计如此'\n" +
            "           WHEN A.resolution = 'duplicate' THEN '重复提单'\n" +
            "           WHEN A.resolution = 'external' THEN '外部原因'\n" +
            "           WHEN A.resolution = 'fixed' THEN '已处理'\n" +
            "           WHEN A.resolution = 'notrepro' THEN '没有重现'\n" +
            "           WHEN A.resolution = 'postponed' THEN '延期处理'\n" +
            "           WHEN A.resolution = 'tostory' THEN '转为研发需求'\n" +
            "           WHEN A.resolution = 'willnotfix' THEN '不处理'\n" +
            "           WHEN A.resolution = 'nobug' THEN '非BUG'\n" +
            "           WHEN A.resolution = 'spec' THEN '规格问题'\n" +
            "           WHEN A.resolution = 'restart' THEN '重启服务'\n" +
            "           WHEN A.resolution = 'fixpublisherror' THEN '发版错误重新部署'\n" +
            "           WHEN A.resolution = 'patchfix' THEN '平台异动跟修'\n" +
            "           WHEN A.resolution = 'improve_perform' THEN '性能优化'\n" +
            "           WHEN A.resolution = 'dirtydataclean' THEN '脏数据清理'\n" +
            "           WHEN A.resolution = 'Episodic' THEN '待观察'\n" +
            "           ELSE A.resolution\n" +
            "    END                                             solution\n" +
            "     , smPredictTtime                            AS estimatedTimeOfResolution\n" +
            "     , A.replyToCustomer                         AS processingResponse\n" +
            "     , M.realname                                AS shutter\n" +
            "     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n" +
            "\n" +
            "     , customerNameT                             AS customerInformationInTaiwan\n" +
            "     , customerNameC                             AS customerInformationInMainland\n" +
            "\n" +
            "     , isFillData                                AS isFilldata\n" +
            "     , filldataPath                              AS FilldataPath\n" +
            "     , influenceOthers                           AS affectOtherTenants\n" +
            "     , InternalClosingIdentification             AS internalClosingIdentification\n" +
            "     , reasonsofproblem                          as reasonsofproblem\n" +
            "     , Processingprocess                         as processingHistory\n" +
            "     , improvementmeasure                        as improvementmeasure\n" +
            "     , DemandOrder                               as DemandOrder\n" +
            "     , relation                                  as relation\n" +
            "     , A.probreason                              AS probreason\n" +
            "     , A.approach                                AS approach\n" +
            "     , A.influence                               AS influence\n" +
            "     , CASE\n" +
            "           WHEN A.serviceSource = 'C' THEN '大陆区服务云'\n" +
            "           WHEN A.serviceSource = 'T' THEN '台湾区服务云'\n" +
            "    END                                             serviceCloudSource\n" +
            "     , CASE\n" +
            "           WHEN A.AREA = 'hw-test' THEN '华为测试区'\n" +
            "           WHEN A.AREA = 'pass' THEN 'paas区'\n" +
            "           WHEN A.AREA = 'other' THEN '其他区'\n" +
            "           WHEN A.AREA = 'hw-pre-test' THEN '华为预测试区'\n" +
            "           WHEN A.AREA = 'ms-test' THEN '微软测试区'\n" +
            "           WHEN A.AREA = 'ms-pre-prod' THEN '微软预测试区'\n" +
            "           WHEN A.AREA = 'hw-prod' THEN '华为正式区'\n" +
            "           WHEN A.AREA = 'hw-pre-prod' THEN '华为预生产区'\n" +
            "    END                                             owningRegion\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '流程机制'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素'\n" +
            "           WHEN A.returningtype IN ('6', '7') THEN '技术方案'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案'\n" +
            "           WHEN A.returningtype IN ('9', '10') THEN '人员能力'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏'\n" +
            "    END                                             rootCauseClassification\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype = '1' THEN '流程机制——沟通机制'\n" +
            "           WHEN A.returningtype = '2' THEN '流程机制——缺少规范或标准'\n" +
            "           WHEN A.returningtype = '3' THEN '流程机制——时间分配不足'\n" +
            "           WHEN A.returningtype = '4' THEN '流程机制——其它'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素——未按规范或标准执行'\n" +
            "           WHEN A.returningtype = '6' THEN '技术方案——历史设计缺陷'\n" +
            "           WHEN A.returningtype = '7' THEN '技术方案——新需求方案缺陷'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案——需求规格缺陷'\n" +
            "           WHEN A.returningtype = '9' THEN '人员能力——新员工经验不足'\n" +
            "           WHEN A.returningtype = '10' THEN '人员能力——组织缺少赋能'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意——笔误等低级错误'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏——业务场景考虑不全'\n" +
            "    END                                             rootCauseType\n" +
            "     , CASE\n" +
            "           WHEN A.bugsourcetype = '1' THEN '历史BUG'\n" +
            "           WHEN A.bugsourcetype = '2' THEN '新需求引发'\n" +
            "           WHEN A.bugsourcetype = '3' THEN '修改BUG引发'\n" +
            "    END                                             bugsourcetype\n" +
            "     , BUGbelonger                                  BUGbelonger\n" +
            "     , createBy                                     createBy\n" +
            "     , debugtimes                                   debugtimes\n" +
            "     , A.checktime                                  checktime\n" +
            "     , A.activatedCount                             activatedCount\n" +
            "FROM zt_bug AS A\n" +
            "         LEFT JOIN zt_user B ON A.openedBy = B.account\n" +
            "         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n" +
            "         LEFT JOIN zt_user G ON A.assignedTo = G.account\n" +
            "         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n" +
            "         LEFT JOIN zt_product D ON A.product = D.id\n" +
            "         LEFT JOIN zt_dept E ON G.dept = E.id\n" +
            "         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n" +
            "         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n" +
            "         LEFT JOIN zt_user M ON A.closedBy = M.account\n" +
            "         LEFT JOIN zt_dept l ON l.id = G.dept\n" +
            "         LEFT JOIN zt_dept l2 ON B.dept = l2.id\n" +
            "WHERE A.deleted NOT IN ('1') and A.bugType = 'external' " +
            "and A.status in ('active','resolved') " +
//            "and  A.BugDepartment ='platform'      -- \n" +
            "  and A.openedDate >= #{startTime}\n" +
            "  and A.openedDate <= #{endTime} -- 创建日期\n" +
            "  and l2.path not like ',1,%'\n" +
            "ORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc")
    List<ZtBugWarningDTO> findAllExternalBugs(String startTime, String endTime);


    @Select("SELECT A.title                                   AS bugName\n" +
            "     , A.id                                         bugNum\n" +
            "     , l.name                                    AS assignedDepartment\n" +
            "     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n" +
            "     , D.code                                    AS productCode\n" +
            "     , D.name                                       productName\n" +
            "     , CASE\n" +
            "           WHEN A.severity = 1 THEN '1.A类严重BUG'\n" +
            "           WHEN A.severity = 2 THEN '2.较严重BUG'\n" +
            "           WHEN A.severity = 3 THEN '3.一般BUG'\n" +
            "           WHEN A.severity = 4 THEN '4.轻微BUG'\n" +
            "    END                                             severity\n" +
            "     , A.pri                                     AS priorityOrder\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "           ELSE\n" +
            "               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "    END                                             processingDays\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n" +
            "           ELSE\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n" +
            "    END                                             processingHours\n" +
            "     , B.realname                                AS questioner\n" +
            "     , G.realname                                AS receiver\n" +
            "     , CASE\n" +
            "           WHEN E.parent = 0 THEN E.name\n" +
            "           WHEN E.parent <> 0 THEN E2.name\n" +
            "    END                                             receiverDept\n" +
            "     , H.realname                                AS externalBugTracker\n" +
            "     , CASE\n" +
            "           WHEN A.type = 'security' THEN '安全相关'\n" +
            "           WHEN A.type IN ('codeerror') THEN '代码错误'\n" +
            "           WHEN A.type = 'otherserror' THEN '他人Bug'\n" +
            "           WHEN A.type = 'ERPbug' THEN '稳态erpBUG'\n" +
            "           WHEN A.type IN ('config', 'application') THEN '配置相关'\n" +
            "           WHEN A.type = 'BMbug' THEN '业务中台BUG'\n" +
            "           WHEN A.type = 'application' THEN '应用问题'\n" +
            "           WHEN A.type = 'designdefect' THEN '设计缺陷'\n" +
            "           WHEN A.type = 'install' THEN '安装部署'\n" +
            "           WHEN A.type = 'performance' THEN '性能问题'\n" +
            "           WHEN A.type = 'automation' THEN '测试脚本'\n" +
            "           WHEN A.type = 'codeimprovement' THEN '代码改进'\n" +
            "           WHEN A.type = 'others' THEN '其他'\n" +
            "           WHEN A.type = 'platform' THEN '平台原因'\n" +
            "           WHEN A.type = 'customization' THEN '定制问题'\n" +
            "           WHEN A.type = 'TBB' THEN 'TBB报表问题'\n" +
            "           WHEN A.type = 'ksc' THEN '知识中心问题'\n" +
            "           WHEN A.type = 'Yixin' THEN '亿信报表问题'\n" +
            "           WHEN A.type = 'nobug' THEN ' 非BUG '\n" +
            "           WHEN A.type = 'standard' THEN '标准规范'\n" +
            "           WHEN A.type = 'designdefect_ux' THEN '设计缺陷(UX问题)'\n" +
            "           WHEN A.type = 'designdefect_req' THEN '设计缺陷(需求问题)'\n" +
            "           WHEN A.type = 'experience' THEN '使用體驗不佳'\n" +
            "           WHEN A.type = 'code_compatibility' THEN '代码兼容性'\n" +
            "           WHEN A.type = 'browser_compatibility' THEN '浏览器兼容性'\n" +
            "           WHEN A.type = 'user_experience' THEN '用户体验'\n" +
            "           WHEN A.type = 'multilingual' THEN '多语系问题'\n" +
            "           WHEN A.type = 'data_issue' THEN '数据问题'\n" +
            "           WHEN A.type = 'DAP' THEN 'DAP问题'\n" +
            "           WHEN A.type = 'external' THEN '环境问题'\n" +
            "           WHEN A.type = 'Episodic' THEN '待观察'\n" +
            "           WHEN A.type = 'gnwj' THEN '功能误解'\n" +
            "           ELSE A.type\n" +
            "    END                                             bugType\n" +
            "     , CASE\n" +
            "           WHEN A.BugDepartment = 'platform' THEN 'Athena平台'\n" +
            "           WHEN A.BugDepartment = 'customization' THEN '定制前端'\n" +
            "           WHEN A.BugDepartment = 'application' THEN '标准前端'\n" +
            "           WHEN A.BugDepartment = 'TBB' THEN 'TBB报表'\n" +
            "           WHEN A.BugDepartment = 'ksc' THEN '知识中心'\n" +
            "           WHEN A.BugDepartment = 'Yixin' THEN '亿信报表'\n" +
            "           WHEN A.BugDepartment = 'BM' THEN '业务中台'\n" +
            "           WHEN A.BugDepartment = 'ERP' THEN '稳态ERP'\n" +
            "           WHEN A.BugDepartment = 'DAP' THEN 'DAP平台'\n" +
            "           WHEN A.BugDepartment = 'ADD' THEN '应用研发中心'\n" +
            "           WHEN A.BugDepartment = 'EMD' THEN '装备制造事业部'\n" +
            "           WHEN A.BugDepartment = 'DC' THEN '数据中台'\n" +
            "           WHEN A.BugDepartment = 'Other' THEN '其他'\n" +
            "           WHEN A.BugDepartment = 'YiFei' THEN '稳态-易飞'\n" +
            "           WHEN A.BugDepartment = 'Mobile' THEN '移动端'\n" +
            "           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n" +
            "           WHEN A.BugDepartment = 'Service' THEN '服务云'\n" +
            "           WHEN A.BugDepartment = 'T' THEN '稳态-T产品'\n" +
            "           WHEN A.BugDepartment = 'E10' THEN '稳态-E10'\n" +
            "           WHEN A.BugDepartment = 'WF' THEN '稳态-WF'\n" +
            "           WHEN A.BugDepartment = 'BM01' THEN '业务中台-应用开发'\n" +
            "           ELSE A.BugDepartment\n" +
            "    END                                             bugBelongToDept\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.status = 'active' THEN '激活'\n" +
            "           WHEN A.status = 'resolved' THEN '已解决'\n" +
            "           WHEN A.status = 'closed' THEN '已关闭'\n" +
            "    END                                             bugState\n" +
            "     , C.realname                                AS solver\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN '内部BUG'\n" +
            "           WHEN A.bugType = '' THEN ''\n" +
            "           WHEN A.bugType = 'external' THEN '外部BUG'\n" +
            "    END                                             bugClassification\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN 0\n" +
            "           WHEN A.bugType = '' THEN 0\n" +
            "           WHEN A.bugType = 'external' THEN 1\n" +
            "    END                                             customerRequestsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name = 'Athena' or D.name = 'ATHENA平台需求' or D.name = 'Athena-PaaS平台' or\n" +
            "                 D.name = 'Athena平台運維事務' or D.name = 'athena低代码开发设计器' or D.name = '表格内测' or\n" +
            "                 D.name = '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             platformPresentsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name <> 'Athena' and D.name <> 'ATHENA平台需求' and D.name <> 'Athena-PaaS平台' and\n" +
            "                 D.name <> 'Athena平台運維事務' and D.name <> 'athena低代码开发设计器' AND D.name <> '表格内测' AND\n" +
            "                 D.name <> '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             applicationRaisesBugCount\n" +
            "     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n" +
            "     , CASE\n" +
            "           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n" +
            "           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n" +
            "           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n" +
            "           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n" +
            "           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n" +
            "           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n" +
            "           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n" +
            "           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n" +
            "           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n" +
            "           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n" +
            "           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n" +
            "    END                                             owningSprint\n" +
            "     , CASE\n" +
            "           WHEN A.resolution = 'modicode' THEN '修改代码'\n" +
            "           WHEN A.resolution = 'modiconfig' THEN '修改配置'\n" +
            "           WHEN A.resolution = 'bydesign' THEN '设计如此'\n" +
            "           WHEN A.resolution = 'duplicate' THEN '重复提单'\n" +
            "           WHEN A.resolution = 'external' THEN '外部原因'\n" +
            "           WHEN A.resolution = 'fixed' THEN '已处理'\n" +
            "           WHEN A.resolution = 'notrepro' THEN '没有重现'\n" +
            "           WHEN A.resolution = 'postponed' THEN '延期处理'\n" +
            "           WHEN A.resolution = 'tostory' THEN '转为研发需求'\n" +
            "           WHEN A.resolution = 'willnotfix' THEN '不处理'\n" +
            "           WHEN A.resolution = 'nobug' THEN '非BUG'\n" +
            "           WHEN A.resolution = 'spec' THEN '规格问题'\n" +
            "           WHEN A.resolution = 'restart' THEN '重启服务'\n" +
            "           WHEN A.resolution = 'fixpublisherror' THEN '发版错误重新部署'\n" +
            "           WHEN A.resolution = 'patchfix' THEN '平台异动跟修'\n" +
            "           WHEN A.resolution = 'improve_perform' THEN '性能优化'\n" +
            "           WHEN A.resolution = 'dirtydataclean' THEN '脏数据清理'\n" +
            "           WHEN A.resolution = 'Episodic' THEN '待观察'\n" +
            "           ELSE A.resolution\n" +
            "    END                                             solution\n" +
            "     , smPredictTtime                            AS estimatedTimeOfResolution\n" +
            "     , A.replyToCustomer                         AS processingResponse\n" +
            "     , M.realname                                AS shutter\n" +
            "     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n" +
            "\n" +
            "     , customerNameT                             AS customerInformationInTaiwan\n" +
            "     , customerNameC                             AS customerInformationInMainland\n" +
            "\n" +
            "     , isFillData                                AS isFilldata\n" +
            "     , filldataPath                              AS FilldataPath\n" +
            "     , influenceOthers                           AS affectOtherTenants\n" +
            "     , InternalClosingIdentification             AS internalClosingIdentification\n" +
            "     , reasonsofproblem                          as reasonsofproblem\n" +
            "     , Processingprocess                         as processingHistory\n" +
            "     , improvementmeasure                        as improvementmeasure\n" +
            "     , DemandOrder                               as DemandOrder\n" +
            "     , relation                                  as relation\n" +
            "     , A.probreason                              AS probreason\n" +
            "     , A.approach                                AS approach\n" +
            "     , A.influence                               AS influence\n" +
            "     , CASE\n" +
            "           WHEN A.serviceSource = 'C' THEN '大陆区服务云'\n" +
            "           WHEN A.serviceSource = 'T' THEN '台湾区服务云'\n" +
            "    END                                             serviceCloudSource\n" +
            "     , CASE\n" +
            "           WHEN A.AREA = 'hw-test' THEN '华为测试区'\n" +
            "           WHEN A.AREA = 'pass' THEN 'paas区'\n" +
            "           WHEN A.AREA = 'other' THEN '其他区'\n" +
            "           WHEN A.AREA = 'hw-pre-test' THEN '华为预测试区'\n" +
            "           WHEN A.AREA = 'ms-test' THEN '微软测试区'\n" +
            "           WHEN A.AREA = 'ms-pre-prod' THEN '微软预测试区'\n" +
            "           WHEN A.AREA = 'hw-prod' THEN '华为正式区'\n" +
            "           WHEN A.AREA = 'hw-pre-prod' THEN '华为预生产区'\n" +
            "    END                                             owningRegion\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '流程机制'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素'\n" +
            "           WHEN A.returningtype IN ('6', '7') THEN '技术方案'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案'\n" +
            "           WHEN A.returningtype IN ('9', '10') THEN '人员能力'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏'\n" +
            "    END                                             rootCauseClassification\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype = '1' THEN '流程机制——沟通机制'\n" +
            "           WHEN A.returningtype = '2' THEN '流程机制——缺少规范或标准'\n" +
            "           WHEN A.returningtype = '3' THEN '流程机制——时间分配不足'\n" +
            "           WHEN A.returningtype = '4' THEN '流程机制——其它'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素——未按规范或标准执行'\n" +
            "           WHEN A.returningtype = '6' THEN '技术方案——历史设计缺陷'\n" +
            "           WHEN A.returningtype = '7' THEN '技术方案——新需求方案缺陷'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案——需求规格缺陷'\n" +
            "           WHEN A.returningtype = '9' THEN '人员能力——新员工经验不足'\n" +
            "           WHEN A.returningtype = '10' THEN '人员能力——组织缺少赋能'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意——笔误等低级错误'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏——业务场景考虑不全'\n" +
            "    END                                             rootCauseType\n" +
            "     , CASE\n" +
            "           WHEN A.bugsourcetype = '1' THEN '历史BUG'\n" +
            "           WHEN A.bugsourcetype = '2' THEN '新需求引发'\n" +
            "           WHEN A.bugsourcetype = '3' THEN '修改BUG引发'\n" +
            "    END                                             bugsourcetype\n" +
            "     , BUGbelonger                                  BUGbelonger\n" +
            "     , createBy                                     createBy\n" +
            "     , debugtimes                                   debugtimes\n" +
            "     , A.checktime                                  checktime\n" +
            "     , A.activatedCount                             activatedCount\n" +
            "FROM zt_bug AS A\n" +
            "         LEFT JOIN zt_user B ON A.openedBy = B.account\n" +
            "         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n" +
            "         LEFT JOIN zt_user G ON A.assignedTo = G.account\n" +
            "         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n" +
            "         LEFT JOIN zt_product D ON A.product = D.id\n" +
            "         LEFT JOIN zt_dept E ON G.dept = E.id\n" +
            "         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n" +
            "         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n" +
            "         LEFT JOIN zt_user M ON A.closedBy = M.account\n" +
            "         LEFT JOIN zt_dept l ON l.id = G.dept\n" +
            "         LEFT JOIN zt_dept l2 ON B.dept = l2.id\n" +
            "WHERE A.deleted NOT IN ('1')\n" +
            "  and A.bugType = 'internal'\n" +
            "  and A.status in ('active')\n" +
            "  and A.severity in (1,2)\n" +
            "  and A.openedDate >= #{startTime}\n" +
            "  and A.openedDate <= #{endTime}  -- 创建日期\n" +
            "  and l2.path not like ',1,%'\n" +
            "ORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc")
    List<ZtBugWarningDTO> findAllSeriousBugs(String startTime, String endTime);


    @Select("SELECT A.title                                   AS bugName\n" +
            "     , A.id                                         bugNum\n" +
            "     , l.name                                    AS assignedDepartment\n" +
            "     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n" +
            "     , D.code                                    AS productCode\n" +
            "     , D.name                                       productName\n" +
            "     , CASE\n" +
            "           WHEN A.severity = 1 THEN '1.A类严重BUG'\n" +
            "           WHEN A.severity = 2 THEN '2.较严重BUG'\n" +
            "           WHEN A.severity = 3 THEN '3.一般BUG'\n" +
            "           WHEN A.severity = 4 THEN '4.轻微BUG'\n" +
            "    END                                             severity\n" +
            "     , A.pri                                     AS priorityOrder\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "           ELSE\n" +
            "               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "    END                                             processingDays\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n" +
            "           ELSE\n" +
            "               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n" +
            "    END                                             processingHours\n" +
            "     , B.realname                                AS questioner\n" +
            "     , G.realname                                AS receiver\n" +
            "     , CASE\n" +
            "           WHEN E.parent = 0 THEN E.name\n" +
            "           WHEN E.parent <> 0 THEN E2.name\n" +
            "    END                                             receiverDept\n" +
            "     , H.realname                                AS externalBugTracker\n" +
            "     , CASE\n" +
            "           WHEN A.type = 'security' THEN '安全相关'\n" +
            "           WHEN A.type IN ('codeerror') THEN '代码错误'\n" +
            "           WHEN A.type = 'otherserror' THEN '他人Bug'\n" +
            "           WHEN A.type = 'ERPbug' THEN '稳态erpBUG'\n" +
            "           WHEN A.type IN ('config', 'application') THEN '配置相关'\n" +
            "           WHEN A.type = 'BMbug' THEN '业务中台BUG'\n" +
            "           WHEN A.type = 'application' THEN '应用问题'\n" +
            "           WHEN A.type = 'designdefect' THEN '设计缺陷'\n" +
            "           WHEN A.type = 'install' THEN '安装部署'\n" +
            "           WHEN A.type = 'performance' THEN '性能问题'\n" +
            "           WHEN A.type = 'automation' THEN '测试脚本'\n" +
            "           WHEN A.type = 'codeimprovement' THEN '代码改进'\n" +
            "           WHEN A.type = 'others' THEN '其他'\n" +
            "           WHEN A.type = 'platform' THEN '平台原因'\n" +
            "           WHEN A.type = 'customization' THEN '定制问题'\n" +
            "           WHEN A.type = 'TBB' THEN 'TBB报表问题'\n" +
            "           WHEN A.type = 'ksc' THEN '知识中心问题'\n" +
            "           WHEN A.type = 'Yixin' THEN '亿信报表问题'\n" +
            "           WHEN A.type = 'nobug' THEN ' 非BUG '\n" +
            "           WHEN A.type = 'standard' THEN '标准规范'\n" +
            "           WHEN A.type = 'designdefect_ux' THEN '设计缺陷(UX问题)'\n" +
            "           WHEN A.type = 'designdefect_req' THEN '设计缺陷(需求问题)'\n" +
            "           WHEN A.type = 'experience' THEN '使用體驗不佳'\n" +
            "           WHEN A.type = 'code_compatibility' THEN '代码兼容性'\n" +
            "           WHEN A.type = 'browser_compatibility' THEN '浏览器兼容性'\n" +
            "           WHEN A.type = 'user_experience' THEN '用户体验'\n" +
            "           WHEN A.type = 'multilingual' THEN '多语系问题'\n" +
            "           WHEN A.type = 'data_issue' THEN '数据问题'\n" +
            "           WHEN A.type = 'DAP' THEN 'DAP问题'\n" +
            "           WHEN A.type = 'external' THEN '环境问题'\n" +
            "           WHEN A.type = 'Episodic' THEN '待观察'\n" +
            "           WHEN A.type = 'gnwj' THEN '功能误解'\n" +
            "           ELSE A.type\n" +
            "    END                                             bugType\n" +
            "     , CASE\n" +
            "           WHEN A.BugDepartment = 'platform' THEN 'Athena平台'\n" +
            "           WHEN A.BugDepartment = 'customization' THEN '定制前端'\n" +
            "           WHEN A.BugDepartment = 'application' THEN '标准前端'\n" +
            "           WHEN A.BugDepartment = 'TBB' THEN 'TBB报表'\n" +
            "           WHEN A.BugDepartment = 'ksc' THEN '知识中心'\n" +
            "           WHEN A.BugDepartment = 'Yixin' THEN '亿信报表'\n" +
            "           WHEN A.BugDepartment = 'BM' THEN '业务中台'\n" +
            "           WHEN A.BugDepartment = 'ERP' THEN '稳态ERP'\n" +
            "           WHEN A.BugDepartment = 'DAP' THEN 'DAP平台'\n" +
            "           WHEN A.BugDepartment = 'ADD' THEN '应用研发中心'\n" +
            "           WHEN A.BugDepartment = 'EMD' THEN '装备制造事业部'\n" +
            "           WHEN A.BugDepartment = 'DC' THEN '数据中台'\n" +
            "           WHEN A.BugDepartment = 'Other' THEN '其他'\n" +
            "           WHEN A.BugDepartment = 'YiFei' THEN '稳态-易飞'\n" +
            "           WHEN A.BugDepartment = 'Mobile' THEN '移动端'\n" +
            "           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n" +
            "           WHEN A.BugDepartment = 'Service' THEN '服务云'\n" +
            "           WHEN A.BugDepartment = 'T' THEN '稳态-T产品'\n" +
            "           WHEN A.BugDepartment = 'E10' THEN '稳态-E10'\n" +
            "           WHEN A.BugDepartment = 'WF' THEN '稳态-WF'\n" +
            "           WHEN A.BugDepartment = 'BM01' THEN '业务中台-应用开发'\n" +
            "           ELSE A.BugDepartment\n" +
            "    END                                             bugBelongToDept\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.status = 'active' THEN '激活'\n" +
            "           WHEN A.status = 'resolved' THEN '已解决'\n" +
            "           WHEN A.status = 'closed' THEN '已关闭'\n" +
            "    END                                             bugState\n" +
            "     , C.realname                                AS solver\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN '内部BUG'\n" +
            "           WHEN A.bugType = '' THEN ''\n" +
            "           WHEN A.bugType = 'external' THEN '外部BUG'\n" +
            "    END                                             bugClassification\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' THEN 0\n" +
            "           WHEN A.bugType = '' THEN 0\n" +
            "           WHEN A.bugType = 'external' THEN 1\n" +
            "    END                                             customerRequestsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name = 'Athena' or D.name = 'ATHENA平台需求' or D.name = 'Athena-PaaS平台' or\n" +
            "                 D.name = 'Athena平台運維事務' or D.name = 'athena低代码开发设计器' or D.name = '表格内测' or\n" +
            "                 D.name = '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             platformPresentsBugCount\n" +
            "     , CASE\n" +
            "           WHEN A.bugType = 'internal' and\n" +
            "                (D.name <> 'Athena' and D.name <> 'ATHENA平台需求' and D.name <> 'Athena-PaaS平台' and\n" +
            "                 D.name <> 'Athena平台運維事務' and D.name <> 'athena低代码开发设计器' AND D.name <> '表格内测' AND\n" +
            "                 D.name <> '采购自动分派(铁科)') THEN 1\n" +
            "    END                                             applicationRaisesBugCount\n" +
            "     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n" +
            "     , CASE\n" +
            "           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n" +
            "           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n" +
            "           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n" +
            "           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n" +
            "           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n" +
            "           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n" +
            "           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n" +
            "           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n" +
            "           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n" +
            "           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n" +
            "           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n" +
            "    END                                             owningSprint\n" +
            "     , CASE\n" +
            "           WHEN A.resolution = 'modicode' THEN '修改代码'\n" +
            "           WHEN A.resolution = 'modiconfig' THEN '修改配置'\n" +
            "           WHEN A.resolution = 'bydesign' THEN '设计如此'\n" +
            "           WHEN A.resolution = 'duplicate' THEN '重复提单'\n" +
            "           WHEN A.resolution = 'external' THEN '外部原因'\n" +
            "           WHEN A.resolution = 'fixed' THEN '已处理'\n" +
            "           WHEN A.resolution = 'notrepro' THEN '没有重现'\n" +
            "           WHEN A.resolution = 'postponed' THEN '延期处理'\n" +
            "           WHEN A.resolution = 'tostory' THEN '转为研发需求'\n" +
            "           WHEN A.resolution = 'willnotfix' THEN '不处理'\n" +
            "           WHEN A.resolution = 'nobug' THEN '非BUG'\n" +
            "           WHEN A.resolution = 'spec' THEN '规格问题'\n" +
            "           WHEN A.resolution = 'restart' THEN '重启服务'\n" +
            "           WHEN A.resolution = 'fixpublisherror' THEN '发版错误重新部署'\n" +
            "           WHEN A.resolution = 'patchfix' THEN '平台异动跟修'\n" +
            "           WHEN A.resolution = 'improve_perform' THEN '性能优化'\n" +
            "           WHEN A.resolution = 'dirtydataclean' THEN '脏数据清理'\n" +
            "           WHEN A.resolution = 'Episodic' THEN '待观察'\n" +
            "           ELSE A.resolution\n" +
            "    END                                             solution\n" +
            "     , smPredictTtime                            AS estimatedTimeOfResolution\n" +
            "     , A.replyToCustomer                         AS processingResponse\n" +
            "     , M.realname                                AS shutter\n" +
            "     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n" +
            "\n" +
            "     , customerNameT                             AS customerInformationInTaiwan\n" +
            "     , customerNameC                             AS customerInformationInMainland\n" +
            "\n" +
            "     , isFillData                                AS isFilldata\n" +
            "     , filldataPath                              AS FilldataPath\n" +
            "     , influenceOthers                           AS affectOtherTenants\n" +
            "     , InternalClosingIdentification             AS internalClosingIdentification\n" +
            "     , reasonsofproblem                          as reasonsofproblem\n" +
            "     , Processingprocess                         as processingHistory\n" +
            "     , improvementmeasure                        as improvementmeasure\n" +
            "     , DemandOrder                               as DemandOrder\n" +
            "     , relation                                  as relation\n" +
            "     , A.probreason                              AS probreason\n" +
            "     , A.approach                                AS approach\n" +
            "     , A.influence                               AS influence\n" +
            "     , CASE\n" +
            "           WHEN A.serviceSource = 'C' THEN '大陆区服务云'\n" +
            "           WHEN A.serviceSource = 'T' THEN '台湾区服务云'\n" +
            "    END                                             serviceCloudSource\n" +
            "     , CASE\n" +
            "           WHEN A.AREA = 'hw-test' THEN '华为测试区'\n" +
            "           WHEN A.AREA = 'pass' THEN 'paas区'\n" +
            "           WHEN A.AREA = 'other' THEN '其他区'\n" +
            "           WHEN A.AREA = 'hw-pre-test' THEN '华为预测试区'\n" +
            "           WHEN A.AREA = 'ms-test' THEN '微软测试区'\n" +
            "           WHEN A.AREA = 'ms-pre-prod' THEN '微软预测试区'\n" +
            "           WHEN A.AREA = 'hw-prod' THEN '华为正式区'\n" +
            "           WHEN A.AREA = 'hw-pre-prod' THEN '华为预生产区'\n" +
            "    END                                             owningRegion\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '流程机制'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素'\n" +
            "           WHEN A.returningtype IN ('6', '7') THEN '技术方案'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案'\n" +
            "           WHEN A.returningtype IN ('9', '10') THEN '人员能力'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏'\n" +
            "    END                                             rootCauseClassification\n" +
            "\n" +
            "     , CASE\n" +
            "           WHEN A.returningtype = '1' THEN '流程机制——沟通机制'\n" +
            "           WHEN A.returningtype = '2' THEN '流程机制——缺少规范或标准'\n" +
            "           WHEN A.returningtype = '3' THEN '流程机制——时间分配不足'\n" +
            "           WHEN A.returningtype = '4' THEN '流程机制——其它'\n" +
            "           WHEN A.returningtype = '5' THEN '执行因素——未按规范或标准执行'\n" +
            "           WHEN A.returningtype = '6' THEN '技术方案——历史设计缺陷'\n" +
            "           WHEN A.returningtype = '7' THEN '技术方案——新需求方案缺陷'\n" +
            "           WHEN A.returningtype = '8' THEN '业务方案——需求规格缺陷'\n" +
            "           WHEN A.returningtype = '9' THEN '人员能力——新员工经验不足'\n" +
            "           WHEN A.returningtype = '10' THEN '人员能力——组织缺少赋能'\n" +
            "           WHEN A.returningtype = '11' THEN '粗心大意——笔误等低级错误'\n" +
            "           WHEN A.returningtype = '12' THEN '场景遗漏——业务场景考虑不全'\n" +
            "    END                                             rootCauseType\n" +
            "     , CASE\n" +
            "           WHEN A.bugsourcetype = '1' THEN '历史BUG'\n" +
            "           WHEN A.bugsourcetype = '2' THEN '新需求引发'\n" +
            "           WHEN A.bugsourcetype = '3' THEN '修改BUG引发'\n" +
            "    END                                             bugsourcetype\n" +
            "     , BUGbelonger                                  BUGbelonger\n" +
            "     , createBy                                     createBy\n" +
            "     , debugtimes                                   debugtimes\n" +
            "     , A.checktime                                  checktime\n" +
            "     , A.activatedCount                             activatedCount\n" +
            "FROM zt_bug AS A\n" +
            "         LEFT JOIN zt_user B ON A.openedBy = B.account\n" +
            "         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n" +
            "         LEFT JOIN zt_user G ON A.assignedTo = G.account\n" +
            "         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n" +
            "         LEFT JOIN zt_product D ON A.product = D.id\n" +
            "         LEFT JOIN zt_dept E ON G.dept = E.id\n" +
            "         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n" +
            "         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n" +
            "         LEFT JOIN zt_user M ON A.closedBy = M.account\n" +
            "         LEFT JOIN zt_dept l ON l.id = G.dept\n" +
            "         LEFT JOIN zt_dept l2 ON B.dept = l2.id\n" +
            "WHERE A.deleted NOT IN ('1')\n" +
            "  and A.bugType = 'internal'\n" +
            "  and A.status in ('active')\n" +
            "  and A.severity in (3,4)\n" +
            "  and (\n" +
            "        CASE\n" +
            "           WHEN A.resolution <> '' THEN\n" +
            "              0 " +
            "           ELSE\n" +
            "               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n" +
            "        END\n" +
            "      ) > 2\n" +
            "  and A.openedDate >= #{startTime}\n" +
            "  and A.openedDate <= #{endTime}  -- 创建日期\n" +
            "  and l2.path not like ',1,%'\n" +
            "ORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc")
    List<ZtBugWarningDTO> findAllNormalBugs(String startTime, String endTime);

    /**
     * 根据部门id获取当前部门及子部门列表
     *
     * @param deptId 部门id
     * @return 返回
     */
    List<ZtDept> queryDeptList(Integer deptId);
}
