package com.digiwin.athena.dtdapp.pojo.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@Accessors(chain = true)
public class OpinionsInfoDTO implements Serializable {
    /**
     * 匿名状态
     */
    @NotNull(message = "匿名状态不能为空")
    private String status;
    /**
     * 应用名称
     */

    private String apply_name;
    /**
     * 问题描述
     */
    @NotNull(message = "应用描述不能为空")
    private String problem_description;
    /**
     * 回访电话
     */
    private String follow_up_call;
    /**
     * 收信人id及邮箱
     */
    @NotNull(message = "收信人id或邮箱不能为空")
    private Map<Long,String> recipientInfo;
    /**
     * 创建人
     */
    private String create_by;


}
