package com.digiwin.athena.dtdapp.pojo.entity.st;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
@Data
@TableName("st_work_report_detail")
@Accessors(chain = true)
public class WorkReportDetail {
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 报工人员
     */
    private String employee_no;
    /**
     * 报工日期
     */
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date report_date;
    /**
     * 序号
     */
    private Integer seq;
    /**
     * 实际工时
     */
    private BigDecimal actual_hour;
    /**
     *  剩余工时
     */
    private BigDecimal unfinished_hour;
    /**
     * 计划工时
     */
    private BigDecimal plan_hour;
    /**
     * 工作内容
     */
    private String work_content;
    /**
     * 报工类型(1.开发; 2.测试; 3.事务; 4.设计; 5.需求; 6.研究
     *        7.讨论; 8.界面; 9.其他; 10.技术支持;* 11.运维
     *        12.软件工程; 13.DAP专用请假)
     */
    private String report_type;
    /**
     * 报工来源(PROJECT:项目; OTHER:其他)
     */
    private String report_source;
    /**
     * 所属项目(项目id)
     */
    private String belong_project;
    /**
     * 所属产品(产品id)
     */
    private String belong_product;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否来源于禅道
     */
    private Boolean from_zentao;
    /**
     * 审核意见
     */
    private String audit_opinion;
    /**
     * 状态(0:待审核; 1:审核通过; 2:审核拒绝;3:待提交)
     */
    private String status;
    /**
     * 创建人
     */
    private String  create_by;
    /**
     * 创建时间
     */
    private Date create_time;
    /**
     * 更新人
     */
    private String update_by;
    /**
     * 更新时间
     */
    private Date update_time;
    /**
     * 租户
     */
    private Long tenantsid;
    /**
     * 报工所在任务卡
     */
    private String task_id;
    /**
     * 禅道报工数据id
     */
    private String zentao_effort_id;
    /**
     * 是否为补充工时
     */
    private Boolean from_supplement;
}
