package com.digiwin.athena.dtdapp.pojo.entity.zentao;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

/**
 * @author
 * @version 1.0
 */
@Data
@TableName("zt_dept")
public class ZtDept {
    /**
     * id
     * */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 部门名称
     * */
    private String name;

    /**
     * 部门的父级（上一级），最上层值为0
     *  其他为id
     * */
    private Integer parent;

    /**
     * 路径
     * 以,开始,结束
     * 记录根节点到当前节点的id
     * */
    private String path;

    /**
     * 此部门节点是多少级
     * 与path的节点数量一致
     * */
    private Integer grade;

    /**
     * 排序字段，值越大排在越后
     * */
    @TableField("`order`")
    private Integer order;

    /**
     * position
     * */
    private String position;

    /**
     * function
     * */
    private String function;

    /**
     * 部门所属人（同user表里的account）
     * */
    private String manager;

    public ZtDept(String name, Integer parent,String path,Integer grade,Integer order,String manager){
        this.name = name;
        this.parent = parent;
        this.path = path;
        this.grade = grade;
        this.order = order;
        this.manager = manager;
    }

    public ZtDept(){

    }
}
