package com.digiwin.athena.dtdapp.pojo.neo4j;

import lombok.Data;
import org.neo4j.ogm.annotation.*;

import java.util.List;
import java.util.Map;

@NodeEntity
@Data
public class DomainEntity {

    @Id
    @GeneratedValue
    private Long neo4jId;
    private String id;
    private String version;
    private Integer d;
    private Integer trait;
    @Relationship(
            type = "IMPL"
    )
    private List<DomainEntity> impl;
    @Properties
    private Map<String, Object> properties;
    @Properties
    private Map<String, Map<String, String>> lang;
    @Properties
    private Map<String, Map<String, String>> language;

    public DomainEntity() {
    }
}
