package com.digiwin.athena.dtdapp.pojo.vo;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Accessors(chain = true)
public class CommodityInfoVO  {
    /**
     * 采购单号
     */
    private String purchase_no;
    /**
     * 商品编号
     */
    private String commodity_cod;
    /**
     * 商品名称
     */
    private String commodity_name;
    /**
     * 厂商编号
     */
    private String supplier_no;
    /**
     * 供应商名称
     */
    private String supplier_name;
    /**
     * 注册地址
     */
    private String supplier_address;
    /**
     * 联系人
     */
    private String supplier_contacts;
    /**
     * 电话
     */
    private String supplier_phone;
    /**
     * 邮箱
     */
    private String supplier_email;
    /**
     * 职位
     */
    private String supplier_position;
    /**
     * 供应商状态码(1：可交易;2：停用;3：不可交易)
     */
    private String supplier_status;
    /**
     * 采购数量
     */
    private Long purchase_qty;
    /**
     * 数量单位
     */
    private String unit;
    /**
     * 供应商可供数量
     */
    private Long supplier_qty;
    /**
     * 采购期望单价
     */
    private BigDecimal purchase_price;
    /**
     * 供应商回复单价
     */
    private BigDecimal supplier_price;
    /**
     * 采购要求交期
     */
    private Date purchase_delivery_date;
    /**
     * 供应商回复交期
     */
    private Date supplier_delivery_date;
    /**
     * 异常状态(1：正常状态;2：异常状态;3：未处理)
     */
    private String abnormal_status;
    /**
     * 异常方案
     */
    private String abnormal_scheme;

    /**
     * 异常原因
     */
    private String abnormal_reason;
    /**
     * 商品预存状态(1：预存状态; 2：提交状态)
     */
    private String commodity_temp_status;
    /**
     * 采购商品总价
     */
    private BigDecimal purchase_price_total;
    /**
     * 交易币种
     */
    private String currency_name;
    /**
     * 交易币种编号
     */
    private String currency_no;
    /**
     * 是否含税(true：含稅; false：不含稅)
     */
    private Boolean is_tax_included;
    /**
     * 税种
     */
    private String tax_name;
    /**
     * 税种编号
     */
    private String tax_no;
    /**
     * 发票类型
     */
    private String invoice_type_name;
    /**
     * 发票类型编号
     */
    private String invoice_type_no;
    /**
     * 产地
     */
    private String producer;
    /**
     * 库存
     */
    private Long iventory;
    /**
     * 商品备注
     */
    private String commodity_remark;
    /**
     * 附件信息
     */
    private JSONObject attachment;

}
