package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 部门表返回对象
 *
 * @author sungqz
 * @since 2025-06-11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ZtDeptVO implements Serializable {

    private static final long serialVersionUID = 8667724148055862469L;

    /**
     * 部门id
     */
    private Integer id;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 部门节点是多少级
     * 与path的节点数量一致
     */
    private Integer grade;

    /**
     * 上级部门id
     */
    private Integer parent;

    /**
     * 子部门
     */
    private List<ZtDeptVO> children;
}
