package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@NoArgsConstructor
@AllArgsConstructor
@ContentRowHeight(15)
@HeadRowHeight(20)
public class ZtStoryExcelVO {

    @ExcelProperty(value = {"需求ID"}, index = 0)
    private String id;

    @ExcelProperty(value = {"需求名称"}, index = 1)
    private String title;

    @ExcelProperty(value = {"所属产品"}, index = 2)
    private String product_name;

    @ExcelProperty(value = {"所属模块"}, index = 3)
    private String module_name;

    @ExcelProperty(value = {"计划结束日期"}, index = 4)
    private String plan_end;

    @ExcelProperty(value = {"冲刺状态"}, index = 5)
    private String status;

    @ExcelProperty(value = {"阶段"}, index = 6)
    private String stage;

    @ExcelProperty(value = {"负责人"}, index = 7)
    private String assignedTo;

    @ExcelProperty(value = {"优先级"}, index = 8)
    private String pri;

    @ExcelProperty(value = {"预计事故点数"}, index = 9)
    private Integer estimate;

    @ExcelProperty(value = {"已消耗工时/h"}, index = 10)
    private Float consumed;

    @ExcelProperty(value = {"剩余工时/h"}, index = 11)
    private Float left;

    @ExcelProperty(value = {"关联任务数"}, index = 12)
    private Integer associated_tasks_number;

    @ExcelProperty(value = {"已完成任务数"}, index = 13)
    private Integer completed_tasks_number;

    @ExcelProperty(value = {"关联bug数"}, index = 14)
    private Integer associated_bugs_number;

    @ExcelProperty(value = {"已解决bug数"}, index = 15)
    private Integer completed_bugs_number;

}
