package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * 人力看板-任务汇总模块 对象实体
 *
 * @author sungqz
 * @since 2025-06-12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ZtTaskSummaryVO implements Serializable {

    private static final long serialVersionUID = 3381965626655858599L;

    /**
     * 总人数
     */
    private long personNum;

    /**
     * PR人数
     */
    private long devNum;

    /**
     * QC人数
     */
    private long qaNum;

    /**
     * 可用工期
     */
    private long availableDuration;

    /**
     * 计划工期
     */
    private BigDecimal totalEstimate;

    /**
     * 实际工期
     */
    private BigDecimal totalConsumed;

    /**
     * 工时偏差率
     */
    private String totalWorkHourDeviationRate;

    /**
     * 预计利用率
     */
    private String totalExpectedUtilizationRate;

    /**
     * 实际利用率
     */
    private String totalActualUtilizationRate;
}
