package com.digiwin.athena.dtdapp.provider.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.dtdapp.dao.zentao.ZtUserDAO;
import com.digiwin.athena.dtdapp.pojo.dto.InitEmployeeInfoReqDTO;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Employee;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_EmployeeDepts;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtUserDTO;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.provider.IInitEmployeeInfoService;
import com.digiwin.athena.dtdapp.service.DtdappEocService;
import com.digiwin.athena.dtdapp.service.ZentaoRestfulService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class InitEmployeeInfoServiceImpl implements IInitEmployeeInfoService {
    private  static Map<String,Integer> DEPT_MAP ;
    private static DeptTreeNode ROOT;

    static {
        DEPT_MAP = new HashMap<>();
//        DEPT_MAP.put("CG0000",74);
        DEPT_MAP.put("CG0100",1);
        DEPT_MAP.put("CG01C0",76);
        DEPT_MAP.put("CG01D0",77);
        DEPT_MAP.put("CG01E0",78);
        DEPT_MAP.put("CG01F0",79);
        DEPT_MAP.put("CG01G0",80);
        DEPT_MAP.put("CG01D1",81);
        DEPT_MAP.put("CG01D2",82);
        DEPT_MAP.put("CG01D3",83);
        DEPT_MAP.put("CG01D4",84);
        DEPT_MAP.put("CG01D5",85);
        DEPT_MAP.put("CG01D6",86);
        DEPT_MAP.put("CG01E1",87);
        DEPT_MAP.put("CG01E2",88);
        DEPT_MAP.put("CG01E3",89);
        DEPT_MAP.put("CG01E4",90);
        DEPT_MAP.put("CG01E5",91);
        DEPT_MAP.put("CG01E6",92);
        DEPT_MAP.put("CG01F1",93);
        DEPT_MAP.put("CG01F2",94);
        DEPT_MAP.put("CG01F3",95);
        DEPT_MAP.put("CG01F4",96);
        DEPT_MAP.put("CG01DA",97);
        DEPT_MAP.put("CG01DB",98);
        DEPT_MAP.put("CG01DC",99);
        DEPT_MAP.put("CG01DD",100);
        DEPT_MAP.put("CG01DE",101);
        DEPT_MAP.put("CG01DF",102);
        DEPT_MAP.put("CG01DG",103);
        DEPT_MAP.put("CG01DH",104);
        DEPT_MAP.put("CG01DI",105);
        DEPT_MAP.put("CG01DJ",106);
        DEPT_MAP.put("CG01DK",107);
        DEPT_MAP.put("CG01DL",108);
        DEPT_MAP.put("CG01DM",109);
        DEPT_MAP.put("CG01DN",110);
        DEPT_MAP.put("CG01DO",111);
        DEPT_MAP.put("CG01DP",112);
        DEPT_MAP.put("CG01DQ",113);
        DEPT_MAP.put("CG01DR",114);
        DEPT_MAP.put("CG01DS",115);
        DEPT_MAP.put("CG01DT",116);
        DEPT_MAP.put("CG01DU",117);
        DEPT_MAP.put("CG01DV",118);
        DEPT_MAP.put("CG01DW",119);
        DEPT_MAP.put("CG01DX",120);
        DEPT_MAP.put("CG01DY",121);
        DEPT_MAP.put("CG01DZ",122);
        DEPT_MAP.put("CG01HA",123);
        DEPT_MAP.put("CG01HB",124);
        DEPT_MAP.put("CG01FA",125);
        DEPT_MAP.put("CG01FB",126);
        DEPT_MAP.put("CG01FC",127);
        DEPT_MAP.put("CG01FD",128);
        DEPT_MAP.put("CG01FE",129);


    }

    static {

        ROOT = new DeptTreeNode("CG0100");

        DeptTreeNode  CG01C0 = new DeptTreeNode("CG01C0");
        DeptTreeNode  CG01D0 = new DeptTreeNode("CG01D0");
        DeptTreeNode  CG01E0 = new DeptTreeNode("CG01E0");
        DeptTreeNode  CG01F0 = new DeptTreeNode("CG01F0");
        DeptTreeNode  CG01G0 = new DeptTreeNode("CG01G0");
        ROOT.getSubNodes().add(CG01C0);
        ROOT.getSubNodes().add(CG01D0);
        ROOT.getSubNodes().add(CG01E0);
        ROOT.getSubNodes().add(CG01F0);
        ROOT.getSubNodes().add(CG01G0);

        DeptTreeNode  CG01D1 = new DeptTreeNode("CG01D1");
        DeptTreeNode  CG01D2 = new DeptTreeNode("CG01D2");
        DeptTreeNode  CG01D3 = new DeptTreeNode("CG01D3");
        DeptTreeNode  CG01D4 = new DeptTreeNode("CG01D4");
        DeptTreeNode  CG01D5 = new DeptTreeNode("CG01D5");
        DeptTreeNode  CG01D6 = new DeptTreeNode("CG01D6");
        CG01D0.getSubNodes().add(CG01D1);
        CG01D0.getSubNodes().add(CG01D2);
        CG01D0.getSubNodes().add(CG01D3);
        CG01D0.getSubNodes().add(CG01D4);
        CG01D0.getSubNodes().add(CG01D5);
        CG01D0.getSubNodes().add(CG01D6);


        DeptTreeNode  CG01DA = new DeptTreeNode("CG01DA");
        DeptTreeNode  CG01DB= new DeptTreeNode("CG01DB");
        DeptTreeNode  CG01DC = new DeptTreeNode("CG01DC");
        DeptTreeNode  CG01DD = new DeptTreeNode("CG01DD");
        DeptTreeNode  CG01DE = new DeptTreeNode("CG01DE");
        DeptTreeNode  CG01DF = new DeptTreeNode("CG01DF");
        DeptTreeNode  CG01DG = new DeptTreeNode("CG01DG");
        CG01D1.getSubNodes().add(CG01DA);
        CG01D1.getSubNodes().add(CG01DB);
        CG01D1.getSubNodes().add(CG01DC);
        CG01D1.getSubNodes().add(CG01DD);
        CG01D1.getSubNodes().add(CG01DE);
        CG01D1.getSubNodes().add(CG01DF);
        CG01D1.getSubNodes().add(CG01DG);



        DeptTreeNode  CG01DH = new DeptTreeNode("CG01DH");
        DeptTreeNode  CG01DI= new DeptTreeNode("CG01DI");
        DeptTreeNode  CG01DJ = new DeptTreeNode("CG01DJ");
        DeptTreeNode  CG01DK = new DeptTreeNode("CG01DK");
        DeptTreeNode  CG01DL = new DeptTreeNode("CG01DL");
        DeptTreeNode  CG01DM = new DeptTreeNode("CG01DM");
        DeptTreeNode  CG01DN = new DeptTreeNode("CG01DN");
        CG01D2.getSubNodes().add(CG01DH);
        CG01D2.getSubNodes().add(CG01DI);
        CG01D2.getSubNodes().add(CG01DJ);
        CG01D2.getSubNodes().add(CG01DK);
        CG01D2.getSubNodes().add(CG01DL);
        CG01D2.getSubNodes().add(CG01DM);
        CG01D2.getSubNodes().add(CG01DN);


        DeptTreeNode  CG01DO = new DeptTreeNode("CG01DO");
        DeptTreeNode  CG01DP= new DeptTreeNode("CG01DP");
        DeptTreeNode  CG01DQ = new DeptTreeNode("CG01DQ");
        DeptTreeNode  CG01DR = new DeptTreeNode("CG01DR");
        DeptTreeNode  CG01DS = new DeptTreeNode("CG01DS");
        CG01D3.getSubNodes().add(CG01DO);
        CG01D3.getSubNodes().add(CG01DP);
        CG01D3.getSubNodes().add(CG01DQ);
        CG01D3.getSubNodes().add(CG01DR);
        CG01D3.getSubNodes().add(CG01DS);


        DeptTreeNode  CG01DT = new DeptTreeNode("CG01DT");
        DeptTreeNode  CG01DU= new DeptTreeNode("CG01DU");
        DeptTreeNode  CG01DV = new DeptTreeNode("CG01DV");
        DeptTreeNode  CG01DW = new DeptTreeNode("CG01DW");
        DeptTreeNode  CG01DX = new DeptTreeNode("CG01DX");
        DeptTreeNode  CG01DY = new DeptTreeNode("CG01DY");
        CG01D4.getSubNodes().add(CG01DT);
        CG01D4.getSubNodes().add(CG01DU);
        CG01D4.getSubNodes().add(CG01DV);
        CG01D4.getSubNodes().add(CG01DW);
        CG01D4.getSubNodes().add(CG01DX);
        CG01D4.getSubNodes().add(CG01DY);



        DeptTreeNode  CG01DZ = new DeptTreeNode("CG01DZ");
        CG01D5.getSubNodes().add(CG01DZ);



        DeptTreeNode  CG01HA = new DeptTreeNode("CG01HA");
        DeptTreeNode  CG01HB = new DeptTreeNode("CG01HB");
        CG01D6.getSubNodes().add(CG01HA);
        CG01D6.getSubNodes().add(CG01HB);



        DeptTreeNode  CG01E1 = new DeptTreeNode("CG01E1");
        DeptTreeNode  CG01E2= new DeptTreeNode("CG01E2");
        DeptTreeNode  CG01E3 = new DeptTreeNode("CG01E3");
        DeptTreeNode  CG01E4 = new DeptTreeNode("CG01E4");
        DeptTreeNode  CG01E5 = new DeptTreeNode("CG01E5");
        DeptTreeNode  CG01E6 = new DeptTreeNode("CG01E6");
        CG01E0.getSubNodes().add(CG01E1);
        CG01E0.getSubNodes().add(CG01E2);
        CG01E0.getSubNodes().add(CG01E3);
        CG01E0.getSubNodes().add(CG01E4);
        CG01E0.getSubNodes().add(CG01E5);
        CG01E0.getSubNodes().add(CG01E6);



        DeptTreeNode  CG01F1 = new DeptTreeNode("CG01F1");
        DeptTreeNode  CG01F2= new DeptTreeNode("CG01F2");
        DeptTreeNode  CG01F3 = new DeptTreeNode("CG01F3");
        CG01F0.getSubNodes().add(CG01F1);
        CG01F0.getSubNodes().add(CG01F2);
        CG01F0.getSubNodes().add(CG01F3);


        DeptTreeNode  CG01FA = new DeptTreeNode("CG01FA");
        DeptTreeNode  CG01FB= new DeptTreeNode("CG01FB");
        DeptTreeNode  CG01FC = new DeptTreeNode("CG01FC");
        CG01F2.getSubNodes().add(CG01FA);
        CG01F2.getSubNodes().add(CG01FB);
        CG01F2.getSubNodes().add(CG01FC);


        DeptTreeNode  CG01FD = new DeptTreeNode("CG01FD");
        DeptTreeNode  CG01FE= new DeptTreeNode("CG01FE");
        CG01F3.getSubNodes().add(CG01FD);
        CG01F3.getSubNodes().add(CG01FE);
    }

    @Autowired
    private DtdappEocService eocService;

    @Autowired
    private ZtUserDAO ztUserDAO;

    @Autowired
    private ZentaoRestfulService zentaoRestfulService;

    @Override
    public Object employeeInit(InitEmployeeInfoReqDTO req) throws Exception {
        log.info("=======employeeInit start==========");
        Map<String,List<Api_Employee>> map = eocService.getApiEmployee(50);
        String token = zentaoRestfulService.getZentaoToken();

            List<Api_Employee> v= map.get("CG0100");
            if(Objects.isNull(v) || v.size()==0){
                return null;
            }
            for (Api_Employee api_employee : v) {
                if(Objects.isNull(api_employee.getEmail()) || Objects.equals("",api_employee.getEmail())){
                    log.info("create user error , email is null:{}",api_employee.getId());
                    continue;
                }
                List<ZtUser> ztUserList = ztUserDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getEmail, api_employee.getEmail()).or().eq(ZtUser::getRealname, api_employee.getName()));
                ztUserList = ztUserList.stream().filter(d-> Objects.equals( d.getDeleted(),0 )).collect(Collectors.toList());
                //表里无记录就创建用户
                if(ztUserList.size()==0){
                    log.info("create user:{}",api_employee.getId());
                    ZtUserDTO userDTO = new ZtUserDTO();
                    userDTO.setAccount(getAccount(api_employee.getEmail()));
                    userDTO.setPassword("123456");
                    userDTO.setRealname(api_employee.getName());
                    try {
                        //创建用户有account唯一键约束
                        zentaoRestfulService.zenTaoUserCreate(token, userDTO);
                    }catch (Exception e){
                        continue;
                    }
                    //更新信息
                    try {
                        Thread.sleep(1000L);
                        List<ZtUser> xxx = ztUserDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getEmail, api_employee.getEmail()).or().eq(ZtUser::getRealname, api_employee.getName()));
                        if(xxx.size()>0){
                            ZtUser ztUser = xxx.get(0);
                            List<Api_EmployeeDepts> depts = api_employee.getDepts();
                            updateAccountInfo(ztUser,depts,api_employee,token);
                        }
                    } catch (InterruptedException e) {
                        //
                    }
                }else {
                    ZtUser ztUser = ztUserList.get(0);
                    List<Api_EmployeeDepts> depts = api_employee.getDepts();
                    updateAccountInfo(ztUser,depts,api_employee,token);
                }
            }


        return null;
    }

    private void updateAccountInfo(ZtUser ztUser,List<Api_EmployeeDepts> depts,Api_Employee api_employee,String token){
        if(Objects.nonNull(depts) && depts.size()>0){
            Map<String,Integer> depthMap = new HashMap<>();
            Map<Integer,Integer> valueMap = new HashMap<>();
            for (Api_EmployeeDepts dept : depts) {
                int depth = findDepth(ROOT,dept.getId(),0);
                if(depth!=-1) {
                    depthMap.put(dept.getId(), depth);
                    if(valueMap.containsKey(depth)){
                        valueMap.put(depth,valueMap.get(depth)+1);
                    }else {
                        valueMap.put(depth,1);
                    }
                }
            }
            Integer result = -1;
            for (Map.Entry<Integer,Integer> entry:valueMap.entrySet()) {
                if(entry.getValue()==1 && entry.getKey()>result){
                    result = entry.getKey();
                }
            }
            if(!Objects.equals(-1,result)){
                for (Map.Entry<String,Integer> entry:depthMap.entrySet()) {
                    if(entry.getValue()==result ){
                        log.info("获取到部门，{}，{}",api_employee.getEmail(),DEPT_MAP.get(entry.getKey()));
                        if(!Objects.equals(ztUser.getDept(),DEPT_MAP.get(entry.getKey()) )) {
                            log.info("改变部门，{},{}", api_employee.getEmail(), DEPT_MAP.get(entry.getKey()));
                            ZtUserDTO ztUserDTO = new ZtUserDTO();
                            ztUserDTO.setId(ztUser.getId());
                            ztUserDTO.setDept(DEPT_MAP.get(entry.getKey()));
                            try {
                                zentaoRestfulService.zenTaoUserOperat(HttpMethod.PUT, token, ztUserDTO);
                            } catch (Exception e) {
                                log.info("改变部门异常，{},{}", api_employee.getEmail(), DEPT_MAP.get(entry.getKey()));
                            }
                        }
                        break;
                    }
                }
            }else {
                log.info("获取不到部门，{}",api_employee.getEmail());
            }
        }
    }


    private String getAccount(String email){
        return email.split("@")[0];
    }


    /**
     *
    取部门树深，哪个深放在哪个部门
     深度优先搜索
     */
    public static int findDepth(DeptTreeNode department, String deptCode, int depth) {
        if (department.getDeptCode().equals(deptCode)) {
            return depth;
        }

        for (DeptTreeNode subDepartment : department.getSubNodes()) {
            int subDepth = findDepth(subDepartment, deptCode, depth + 1);
            if (subDepth != -1) {
                return subDepth;
            }
        }
        return -1;
    }


    public static class DeptTreeNode{

        private String deptCode;

        private List<DeptTreeNode> subNodes;

        public DeptTreeNode(String deptCode){
            this.deptCode = deptCode;
            this.subNodes = new ArrayList<>();
        }

        public String getDeptCode() {
            return deptCode;
        }

        public void setDeptCode(String deptCode) {
            this.deptCode = deptCode;
        }

        public List<DeptTreeNode> getSubNodes() {
            return subNodes;
        }

        public void setSubNodes(List<DeptTreeNode> subNodes) {
            this.subNodes = subNodes;
        }
    }



}
