package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.dtdapp.dao.ProcureDAO;
import com.digiwin.athena.dtdapp.pojo.enums.Status;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.PurchaseInfoVO;
import com.digiwin.athena.dtdapp.provider.IProcureSercive;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcureServiceImpl implements IProcureSercive {
    @Autowired
    private ProcureDAO procureDAO;

    @Override
    public DWEAIResult createPurchaseOrder(Map<String, String> headers, String messageBody) throws Exception {
        Map map = com.alibaba.fastjson.JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("purchase_temp");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("has no data purchase_temp");
        }
        List<PurchaseInfoVO> purchaseInfoVOS = JSON.parseArray(JSON.toJSONString(jsonArray), PurchaseInfoVO.class);
        List list = procureDAO.createPurchaseInfo(purchaseInfoVOS);
        Map<String, Object> purchase_temp = new HashMap<>();
        purchase_temp.put("purchase_temp", list);
        return new DWEAIResult("0", "0", "OK", purchase_temp);
    }

    @Override
    public DWEAIResult updatePurchaseOrder(Map<String, String> headers, String messageBody) throws Exception {
        Map map = com.alibaba.fastjson.JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("purchase_temp");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("has no data purchase_temp");
        }
        List<PurchaseInfoVO> purchaseInfoVOS = JSON.parseArray(JSON.toJSONString(jsonArray), PurchaseInfoVO.class);
        List list = procureDAO.updatePurchaseInfo(purchaseInfoVOS);
        Map<String, Object> purchase_temp = new HashMap<>();
        purchase_temp.put("purchase_temp", list);
        return new DWEAIResult("0", "0", "OK", purchase_temp);
    }

    @Override
    public DWEAIResult getPurchaseOrder(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        String purchaser_code = obj.getJSONObject("std_data").getJSONObject("parameter").getString("purchaser_code");
        if (StringUtils.isEmpty(purchaser_code)) {
            throw new DWRuntimeException("has no purchaser_code ");
        }
        List list = procureDAO.getPurchaseInfo(purchaser_code);
        Map<String, Object> purchase_temp = new HashMap<>();
        purchase_temp.put("purchase_temp", list);
        return new DWEAIResult("0", "0", "OK", purchase_temp);
    }

    @Override
    public DWEAIResult getCommodityInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("purchase_temp");

        List list = procureDAO.getCommodityInfo(jsonArray);
        Map<String, Object> purchase_temp = new HashMap<>();
        purchase_temp.put("purchase_temp", list);
        return new DWEAIResult("0", "0", "OK", purchase_temp);

    }

    @Override
    public DWEAIResult updateCommodityInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = com.alibaba.fastjson.JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("purchase_temp");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("has no data purchase_temp");
        }
        List<PurchaseInfoVO> purchaseInfoVOS = JSON.parseArray(JSON.toJSONString(jsonArray), PurchaseInfoVO.class);
        List list = procureDAO.updateCommodityInfo(purchaseInfoVOS);
        Map<String, Object> purchase_temp = new HashMap<>();
        purchase_temp.put("purchase_temp", list);
        return new DWEAIResult("0", "0", "OK", purchase_temp);
    }
}
