package com.digiwin.athena.dtdapp.provider.impl;

import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtProjectDTO;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.*;
import com.digiwin.athena.dtdapp.provider.IZtPlusProjectService;
import com.digiwin.athena.dtdapp.service.DtdappProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.*;

@Service
public class ZtPlusProjectServiceImpl implements IZtPlusProjectService {

    @Autowired
    private DtdappProjectService projectService;


    /**
     * 项目维度查询页面
     *
     * @param parentProjectName 项目名称
     * @param status            项目状态
     */
    public Collection<ProjectWithTeamInfoVo> getProjectWithTeamInfoList(@RequestParam String parentProjectName,
                                                                        @RequestParam(required = false) String projectName,
                                                                        @RequestParam(required = false) String status) {
        return projectService.getProjectWithTeamInfoList(parentProjectName, projectName, status);
    }

    /**
     * 每个项目工时明细
     * @param projectId 上个接口返回的 id
     * @param userName 人员名称
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    public Collection<ProjectTeamDetailVo> getProjectTeamDetailList(@RequestParam int projectId,
                                                                    @RequestParam(required = false) String userName,
                                                                    @RequestParam String beginDate,
                                                                    @RequestParam String endDate) {
        return projectService.getProjectTeamDetailList(projectId, userName, beginDate, endDate);
    }

    /**
     * 人员预估和消耗工时
     * @param deptId 部门名称
     * @param userName 人员名称
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    public Collection<UserEstimateAndConsumedVo> getUserEstimateAndConsumedList(@RequestParam int deptId,
                                                                                @RequestParam(required = false) String userName,
                                                                                @RequestParam String beginDate,
                                                                                @RequestParam String endDate) {
        return projectService.getUserEstimateAndConsumedList(deptId, userName, beginDate, endDate);
    }

    /**
     * 人员项目消耗工时
     * @param userId 人员 ID
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    public Collection<UserProjectConsumedVo> getUserProjectConsumedList(@RequestParam int userId,
                                                                        @RequestParam String beginDate,
                                                                        @RequestParam String endDate) {
        return projectService.getUserProjectConsumedList(userId, beginDate, endDate);
    }

    public List<DateToProjectConsumedVo> getDateToProjectConsumedVoList(@RequestParam String parentProjectName,
                                                                        @RequestParam String beginDate,
                                                                        @RequestParam String endDate) {
        return projectService.getDateToProjectConsumedVoList(parentProjectName, beginDate, endDate);

    }

    public List<ZtProjectDTO> getMilestoneByName(String projectName, Integer programId) {
        return projectService.getMilestoneByName(projectName, programId);

    }

    public List<ZtProjectDTO> getProgramByParentId(Integer parentId) {
        return projectService.getProgramByParentId(parentId);

    }

    public List<ZtUser> getUserByDept(Integer deptId, String name) {
        return projectService.getUserByDept(deptId, name);
    }

    public List<ZtUserScoreVO> getUserScore(Integer userId, Integer deptId, String date) {
       return projectService.getUserScore(userId, deptId, date);
    }

    public List<ZtTask> getUserScoreTask(String account, String date) {
        return projectService.getUserScoreTask(account, date);
    }


}
