package com.digiwin.athena.dtdapp.service;

import com.digiwin.app.service.DWFile;
import com.digiwin.athena.dtdapp.config.DtdappNeo4j1Config;
//import com.digiwin.athena.dtdapp.mappermdc.*;
import com.digiwin.athena.dtdapp.pojo.neo4j.Action;
import com.digiwin.athena.dtdapp.pojo.vo.publish.*;
import com.digiwin.athena.dtdapp.repoNeo4j.DtdappActionRepository;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Service
@Slf4j
public class DtdappPublishService {

//    @Autowired
//    ProductMapper productMapper;
//
//    @Autowired
//    ServiceMapper serviceMapper;
//    @Autowired
//    ApiMetadataMapper apiMetadataMapper;
//
//    @Autowired
//    ApiMapper apiMapper;
//
//    @Autowired
//    ApiVersionMapper apiVersionMapper;


    @Autowired(required=false)
    @Qualifier(DtdappNeo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired
    DtdappActionRepository actionRepository;



    public Object publishEspActionByProduct(PublishRequest publishRequest) {

//        List<ProductDTO> productDTOList = productMapper.selectList(new LambdaQueryWrapper<ProductDTO>().in(ProductDTO::getName, publishRequest.getProductList()));
//        List<Long> productIdList = productDTOList.stream().map(ProductDTO::getId).collect(Collectors.toList());
//
//        List<ServiceDTO> serviceDTOS = serviceMapper.selectList(new LambdaQueryWrapper<ServiceDTO>().in(ServiceDTO::getProduct_id, productIdList));
//        List<String> serviceNameList = serviceDTOS.stream().map(ServiceDTO::getName).collect(Collectors.toList());
//
//        Object o = this.publishEspActionByServiceNameList(serviceNameList);
//
//        return o;
        return null;

    }



    public Object publishEspActionByServiceNameList(List<String> serviceNameList ){
//        log.info("=================start==================");
//
//        initVirtualTenantForNeo4j();
//
//        List<String> distinctServiceNameList = serviceNameList.stream().distinct().collect(Collectors.toList());
//
//        List<List<String>> partitionServiceNameList = Lists.partition(distinctServiceNameList, 100);
//        log.info("分组查询：{}", partitionServiceNameList.size());
//        // 每次100条查
//        for(List<String> partition : partitionServiceNameList){
//            List<Map> apiVersionIdList = apiMetadataMapper.getApiVersionId(partition);
//
//            List<Integer> avIdList = apiVersionIdList.stream().map(e -> Integer.valueOf(String.valueOf(e.get("avId")))).collect(Collectors.toList());
//
//            List<Integer> apiIdList = apiVersionIdList.stream().map(e -> Integer.valueOf(String.valueOf(e.get("apiId")))).collect(Collectors.toList());
//
//            List<ApiMetadataDTO> serviceDTOS = apiMetadataMapper.selectList(new LambdaQueryWrapper<ApiMetadataDTO>().in(ApiMetadataDTO::getApi_version_id, avIdList));
//
//
//            List<ApiDTO> apiDTOS = apiMapper.selectList(new LambdaQueryWrapper<ApiDTO>().in(ApiDTO::getId, apiIdList));
//
//            List<ApiVersionDTO> apiVersionDTOS = apiVersionMapper.selectList(new LambdaQueryWrapper<ApiVersionDTO>().in(ApiVersionDTO::getId, avIdList));
//
//            Map<Long, ApiDTO> apiMap = apiDTOS.stream()
//                    .collect(Collectors.toMap(ApiDTO::getId, item -> item, (a,b)-> a));
//
//            Map<Long, ApiVersionDTO> apiVersionMap = apiVersionDTOS.stream()
//                    .collect(Collectors.toMap(ApiVersionDTO::getId, item -> item, (a,b)-> a));
//
//
//            List<String> executeNeo4jScripts = new ArrayList<>();
//
//            for(ApiMetadataDTO apiMetadataDTO : serviceDTOS){
//                String metadata = apiMetadataDTO.getMetadata();
//                if(StringUtils.isEmpty(metadata)){
//                    continue;
//                }
//                Long api_version_id = apiMetadataDTO.getApi_version_id();
//                ApiVersionDTO apiVersionDTO = apiVersionMap.get(api_version_id);
//                if(apiVersionDTO == null){
//                    continue;
//                }
//                ApiDTO apiDTO = apiMap.get(apiVersionDTO.getApi_id());
//                if(apiDTO == null){
//                    continue;
//                }
//
//
//                ApiDataMetadataDTO dataMetadata = JSONObject.parseObject(metadata, ApiDataMetadataDTO.class);
//                List<ApiDataFieldMetadataDTO> fieldsOfParameter = new ArrayList<>();
//                if (dataMetadata.getRequest().getBody().getField() != null && dataMetadata.getRequest().getBody().getField().get(0).getField() != null) {
//                    fieldsOfParameter = dataMetadata.getRequest().getBody().getField().get(0).getField();
//                }
//                List<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<>();
//                for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
//                    if (!fieldOfParameter.getData_name().equals("enterprise_no")
//                            && !fieldOfParameter.getData_name().equals("site_no")
//                            && !fieldOfParameter.getData_name().equals("call_id")) {
//                        fieldRequestObjects.add(fieldOfParameter);
//                    }
//                }
//
//
//                String request_str = JSON.toJSONString(fieldRequestObjects, SerializerFeature.NotWriteDefaultValue);
//                List<ApiDataFieldMetadataDTO> fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
//                ApiDataFieldMetadataDTO fieldReponseObject = null;
//                for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
//                    if (fieldOfResponse.getData_name().equals("parameter")) {
//                        fieldReponseObject = fieldOfResponse;
//                        break;
//                    }
//                }
//                String response_str = "";
//                if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
//                    Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
//                    if (findObject.isPresent()) {
//                        ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
//
//                        response_str = JSON.toJSONString(apiDataFieldMetadataDTO, SerializerFeature.NotWriteDefaultValue);
//                    } else
//                        response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), SerializerFeature.NotWriteDefaultValue);
//                }
//
//                String actionId = "esp_" + apiDTO.getName();
//                log.info("===>" + actionId);
//
//
//
//                StringBuffer stringBuffer = new StringBuffer();
//                stringBuffer.append("Create (action:Action:EspAction {");
//                stringBuffer.append("actionId:'");
//                stringBuffer.append(actionId);
//                stringBuffer.append("', url:'");
//                stringBuffer.append(apiDTO.getUrl());
//                stringBuffer.append("', serviceName:'");
//                stringBuffer.append(apiDTO.getName());
//                stringBuffer.append("', serviceVersion:'");
//                stringBuffer.append(apiVersionDTO.getVersion());
//                stringBuffer.append("', actionName:'");
//                stringBuffer.append(apiDTO.getDescription_zh_cn());
//                stringBuffer.append("', actionName_tw:'");
//                stringBuffer.append(apiDTO.getDescription_zh_tw());
//                stringBuffer.append("', desc:'");
//                stringBuffer.append(apiDTO.getRemark_zh_cn());
//                stringBuffer.append("', desc_tw:'");
//                stringBuffer.append(apiDTO.getRemark_zh_tw());
//                stringBuffer.append("', request_parameters:'");
//                stringBuffer.append(request_str.replaceAll("'", ""));
//                stringBuffer.append("', response_object:'");
//                stringBuffer.append(response_str.replaceAll("'", ""));
//                stringBuffer.append("', invokeType:'");
//                stringBuffer.append(apiDTO.getInvoked_type());
//                stringBuffer.append("', lastUpdateTime:'");
//                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
//                stringBuffer.append("', updateTime:'");
//                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
//                stringBuffer.append("', idempotency:");
//                stringBuffer.append(1 == apiVersionDTO.getIdempotency());
//                stringBuffer.append(", version:'");
//                stringBuffer.append("1.0");
//                stringBuffer.append("', createFrom:'");
//                stringBuffer.append("batchInit");
//                stringBuffer.append("', tenantId:'");
//                stringBuffer.append("SYSTEM");
//                stringBuffer.append("', nameSpace:'");
//                stringBuffer.append("espCommon");
//                stringBuffer.append("'})");
//
//                StringBuffer relationSb = new StringBuffer();
//                relationSb.append("match (te:TenantEntity{ifCommon:true,version:'1.0'})")
//                        .append(" match (espAction:Action{")
//                        .append("actionId:'")
//                        .append(actionId)
//                        .append("', version:'1.0'}) ")
//                        .append(" merge (te)-[:ACTION]->(espAction)");
//
//                executeNeo4jScripts.add(StringEscapeUtils.escapeJava(stringBuffer.toString()));
//                executeNeo4jScripts.add(relationSb.toString());
//
//
//                StringBuffer stringBuffer2 = new StringBuffer();
//                stringBuffer2.append("Create (action:Action:EspAction {");
//                stringBuffer2.append("actionId:'");
//                stringBuffer2.append(actionId);
//                stringBuffer2.append("', url:'");
//                stringBuffer2.append(apiDTO.getUrl());
//                stringBuffer2.append("', serviceName:'");
//                stringBuffer2.append(apiDTO.getName());
//                stringBuffer2.append("', serviceVersion:'");
//                stringBuffer2.append(apiVersionDTO.getVersion());
//                stringBuffer2.append("', actionName:'");
//                stringBuffer2.append(apiDTO.getDescription_zh_cn());
//                stringBuffer2.append("', actionName_tw:'");
//                stringBuffer2.append(apiDTO.getDescription_zh_tw());
//                stringBuffer2.append("', desc:'");
//                stringBuffer2.append(apiDTO.getRemark_zh_cn());
//                stringBuffer2.append("', desc_tw:'");
//                stringBuffer2.append(apiDTO.getRemark_zh_tw());
//                stringBuffer2.append("', request_parameters:'");
//                stringBuffer2.append(request_str.replaceAll("'", ""));
//                stringBuffer2.append("', response_object:'");
//                stringBuffer2.append(response_str.replaceAll("'", ""));
//                stringBuffer2.append("', invokeType:'");
//                stringBuffer2.append(apiDTO.getInvoked_type());
//                stringBuffer2.append("', lastUpdateTime:'");
//                stringBuffer2.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
//                stringBuffer2.append("', updateTime:'");
//                stringBuffer2.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
//                stringBuffer2.append("', idempotency:");
//                stringBuffer2.append(1 == apiVersionDTO.getIdempotency());
//                stringBuffer2.append(", version:'");
//                stringBuffer2.append("2.0");
//                stringBuffer2.append("', createFrom:'");
//                stringBuffer2.append("batchInit");
//                stringBuffer2.append("', tenantId:'");
//                stringBuffer2.append("SYSTEM");
//                stringBuffer2.append("', nameSpace:'");
//                stringBuffer2.append("espCommon");
//                stringBuffer2.append("'})");
//
//                StringBuffer relationSb2 = new StringBuffer();
//                relationSb2.append("match (te:TenantEntity{ifCommon:true,version:'2.0'})")
//                        .append(" match (espAction:Action{")
//                        .append("actionId:'")
//                        .append(actionId)
//                        .append("', version:'2.0'}) ")
//                        .append(" merge (te)-[:ACTION]->(espAction)");
//
//                executeNeo4jScripts.add(StringEscapeUtils.escapeJava(stringBuffer2.toString()));
//                executeNeo4jScripts.add(relationSb2.toString());
//            }
//
//
//            executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain1);
//
//        }
//
//
//
//        log.info("=================finish==================");
        return "success";
    }


    private void initVirtualTenantForNeo4j(){
        log.info("=================start initVirtualTenantForNeo4j==================");

        List<String> tenantList = new ArrayList<>();
        String t1 ="merge (te:TenantEntity{tenantId:'VIRTUAL_V1'}) set te.ifCommon = true, te.version='1.0'";
        String t2 ="merge (te:TenantEntity{tenantId:'VIRTUAL_V2'}) set te.ifCommon = true, te.version='2.0'";
        tenantList.add(t1);
        tenantList.add(t2);
        executeNeo4jScript(tenantList, sessionFactoryDomain1);
        log.info("=================finish initVirtualTenantForNeo4j==================");
    }

    private List<Object> executeNeo4jScript(List<String> executeNeo4jScripts,SessionFactory sessionFactory){

        if(org.springframework.util.CollectionUtils.isEmpty(executeNeo4jScripts)){
            return null;
        }

        if(sessionFactory == null){
            return null;
        }
        List<Object> errorResult = new ArrayList<>();
        Session session = sessionFactory.openSession();

//        try (Transaction transaction = session.beginTransaction()){
            for(String str : executeNeo4jScripts){
                try {
                    session.query(str, new HashMap<>());
                } catch (Exception e) {
                    errorResult.add(str);
                    log.error("=====executeNeo4jScriptError:{}",str);
                }
            }
//            transaction.commit();
//        }catch (Exception e) {
//            log.error("executeNeo4jScript error:{}",e);
//        }

        session.clear();

            return errorResult;
    }

    public Object generateActionScriptByProduct(PublishRequest publishRequest) {

//        List<ProductDTO> productDTOList = productMapper.selectList(new LambdaQueryWrapper<ProductDTO>().in(ProductDTO::getName, publishRequest.getProductList()));
//        List<Long> productIdList = productDTOList.stream().map(ProductDTO::getId).collect(Collectors.toList());
//
//        List<ServiceDTO> serviceDTOS = serviceMapper.selectList(new LambdaQueryWrapper<ServiceDTO>().in(ServiceDTO::getProduct_id, productIdList));
//        List<String> serviceNameList = serviceDTOS.stream().map(ServiceDTO::getName).collect(Collectors.toList());
//
//
//        Object o = this.generateActionScriptByServiceNameList(serviceNameList, publishRequest.getCreateFrom(), publishRequest.getVersion());
//
//        return o;
        return null;

    }

    public void deleteFolders(String filePath) {

        Path path = Paths.get(filePath);
        try {
            Files.walkFileTree(path, new SimpleFileVisitor<Path>() {
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Files.delete(file);
                    log.info("删除文件: {}", file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir,
                                                          IOException exc) throws IOException {
                    Files.delete(dir);
                    log.info("文件夹被删除: {}", dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object generateActionScriptByServiceNameList(List<String> serviceNameList, String createFrom, String version) {
        log.info("=====start clear file directory=========");
        this.deleteFolders("neo4jExport/");

        log.info("serviceNameList:{}", serviceNameList);
//        File file = new File("espActionScript.txt");
        if(StringUtils.isEmpty(createFrom)){
            createFrom = "batchInitScript" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        Set<String> set = new HashSet();

//        try {
//            //先清空下文件
//            FileUtils.write(file, "", "UTF-8", false);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
        List<String> exportActionCountErrorList = new ArrayList<>();
        File file = null;
        int fileIndex = 1;
        int line = 1;
        for(String serviceName : serviceNameList){
            String actionId = "esp_" + serviceName.trim();


            List<Action> byActionId = this.actionRepository.findByActionId(actionId);
//            List<Action> byActionId = new ArrayList<>();
            if(byActionId.size() != 2){
                log.info("===>action:{}, size:{}", actionId, byActionId.size());
                exportActionCountErrorList.add("action:" + actionId + ",size:" + byActionId.size() + ",version:" + (CollectionUtils.isNotEmpty(byActionId)? byActionId.get(0).getVersion() : ""));
            }else{
                Action action = byActionId.get(0);
                Action action1 = byActionId.get(1);
                if(!StringUtils.equals(action.getServiceVersion(), action1.getServiceVersion())){
                    exportActionCountErrorList.add("action:" + actionId + ", serviceVersion:" + action.getServiceVersion() + ", " + action1.getServiceVersion());
                }
            }
            for(Action action : byActionId){

                if(StringUtils.isNotEmpty(version) && version.equals(action.getVersion())){
                    continue;
                }
                set.add(action.getActionId());

                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Create (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("', url:'");
                stringBuffer.append(action.getUrl());
                stringBuffer.append("', serviceName:'");
                stringBuffer.append(action.getServiceName());
                stringBuffer.append("', serviceVersion:'");
                stringBuffer.append(action.getServiceVersion());
                stringBuffer.append("', actionName:'");
                stringBuffer.append(action.getActionName());
                stringBuffer.append("', actionName_tw:'");
                stringBuffer.append(action.getActionName_tw());
                stringBuffer.append("', desc:'");
                stringBuffer.append(action.getDesc());
                stringBuffer.append("', desc_tw:'");
                stringBuffer.append(action.getDesc_tw());
                stringBuffer.append("', request_parameters:'");
                stringBuffer.append(action.getRequest_parameters());
//                stringBuffer.append(action.getRequest_parameters().replaceAll("\\\\", ""));
                stringBuffer.append("', response_object:'");
                stringBuffer.append(action.getResponse_object());
//                stringBuffer.append(action.getResponse_object().replaceAll("\\\\", ""));
                stringBuffer.append("', invokeType:'");
                stringBuffer.append(action.getInvokeType());
                stringBuffer.append("', lastUpdateTime:'");
                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                stringBuffer.append("', updateTime:'");
                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                stringBuffer.append("', idempotency:");
                stringBuffer.append(action.getIdempotency());
                stringBuffer.append(", version:'");
                stringBuffer.append(action.getVersion());

                if(StringUtils.isNotEmpty(action.getTenantId())){
                    stringBuffer.append("', tenantId:'");
                    stringBuffer.append(action.getTenantId());
                }

                stringBuffer.append("', createFrom:'");
                stringBuffer.append(createFrom);
                stringBuffer.append("', nameSpace:'");
                stringBuffer.append("espCommon");
                stringBuffer.append("'});");



//                StringBuffer relationSb2 = new StringBuffer();
//                relationSb2.append("match (te:TenantEntity{ifCommon:true,version:'"+ action.getVersion() +"'})")
//                        .append(" match (espAction:Action{")
//                        .append("actionId:'")
//                        .append(actionId)
//                        .append("', version:'"+ action.getVersion()+"'}) ")
//                        .append(" merge (te)-[:ACTION]->(espAction);");

                try {


                    if(line == 1){
                        file = new File("neo4jExport/espActionScript" + fileIndex + ".txt");

                        //先清空下文件
                        FileUtils.write(file, "", "UTF-8", false);
                    }else if(line == 2800){
                        line = 0;
                        fileIndex++;
                    }

                    line = line + 1;
//                    System.out.println("===>" + StringEscapeUtils.escapeJava(stringBuffer.toString()));
                    System.out.println("===>" + line);
//                    FileUtils.writeLines(file, "UTF-8", Arrays.asList(stringBuffer.toString(), relationSb2.toString()), true);
                    FileUtils.writeLines(file, "UTF-8", Arrays.asList(StringEscapeUtils.escapeJava(stringBuffer.toString())), true);

                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }
        log.info("====total generate script action:{}", set);

        this.generateFlagAndDeleteScriptFile(set, createFrom, version);

        this.generateErrorSizeActionFile(exportActionCountErrorList);
        log.info("============finish==============");
        return null;
    }


    private void generateErrorSizeActionFile(List<String> exportActionCountErrorList){
        if(CollectionUtils.isEmpty(exportActionCountErrorList)){
            return;
        }

        try {
            File file = new File("neo4jExport/exportActionCountError.txt");
            FileUtils.write(file, "", "UTF-8", false);
            FileUtils.writeLines(file, "UTF-8", exportActionCountErrorList, true);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    private void generateFlagAndDeleteScriptFile( Set<String> set, String createFrom, String version){

        String leftCodesStr = "['" + StringUtils.join(set, "','") + "']";

        String  beforeScript = null;
        String  toDeleteScript= null;
        String  mergeScript = null;
        String  mergeScript2 = null;
        if(StringUtils.isEmpty(version)){
            beforeScript = "match (a:Action) where a.actionId in " + leftCodesStr + " set a.flagtag = 'old' return count(a);";

            toDeleteScript = "match (a:Action) where a.flagtag = 'old' detach delete a;";
            mergeScript = "match (te:TenantEntity{ifCommon:true,version:'1.0'}) match (espAction:EspAction{createFrom:'" + createFrom +"', version:'1.0'}) merge (te)-[:ACTION]->(espAction);";
            mergeScript2 = "match (te:TenantEntity{ifCommon:true,version:'2.0'}) match (espAction:EspAction{createFrom:'" + createFrom +"', version:'2.0'}) merge (te)-[:ACTION]->(espAction);";
        }else{
            beforeScript = "match (a:Action) where a.actionId in " + leftCodesStr + " and a.version = '"+ version +"' set a.flagtag = 'old' return count(a);";

            toDeleteScript = "match (a:Action) where a.flagtag = 'old' detach delete a;";
            if(version.equals("1.0")){
                mergeScript = "match (te:TenantEntity{ifCommon:true,version:'1.0'}) match (espAction:EspAction{createFrom:'" + createFrom +"', version:'1.0'}) merge (te)-[:ACTION]->(espAction);";
            }
            if(version.equals("2.0")) {
                mergeScript2 = "match (te:TenantEntity{ifCommon:true,version:'2.0'}) match (espAction:EspAction{createFrom:'" + createFrom + "', version:'2.0'}) merge (te)-[:ACTION]->(espAction);";
            }
        }

        String toDeleteScript2 = "match (a:Action) where a.actionId in " + leftCodesStr + " and a.flagtag = 'old' detach delete a;";

        try {
            File file = new File("neo4jExport/beforeInsert.txt");
            FileUtils.write(file, "", "UTF-8", false);
            FileUtils.writeLines(file, "UTF-8", Arrays.asList(beforeScript), true);

            File file2 = new File("neo4jExport/afterInsert.txt");
            FileUtils.write(file2, "", "UTF-8", false);
            FileUtils.writeLines(file2, "UTF-8", Arrays.asList(toDeleteScript, mergeScript, mergeScript2), true);

            File file3 = new File("neo4jExport/afterInsert2.txt");
            FileUtils.write(file3, "", "UTF-8", false);
            FileUtils.writeLines(file3, "UTF-8", Arrays.asList(toDeleteScript2), true);
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public PublishResult executeScript(DWFile dwFile) {
        InputStream inputStream = dwFile.getInputStream();
        File tempFile = new File("tempFile.txt");
        log.info("============start==============");
        List<Object> result = new ArrayList<>();
        try {
            FileUtils.copyInputStreamToFile(inputStream, tempFile);
            List<String> list = FileUtils.readLines(tempFile, "UTF-8");
            List<List<String>> partitions = Lists.partition(list, 200);
            int i = 0;
            for(List<String> par : partitions){
                log.info("execute partitions：{}", ++i);
                List<Object> objectList = executeNeo4jScript(par, sessionFactoryDomain1);
                result.addAll(objectList);
            }


        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            log.info("===delete temp file=====");
            tempFile.delete();
        }

        log.info("============finish==============");

        PublishResult publishResult = new PublishResult();
        publishResult.setErrorScripts(result);
        return publishResult;

    }

}
