package com.digiwin.athena.dtdapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dtdapp.pojo.entity.FileInfo;
import com.digiwin.athena.dtdapp.pojo.vo.FileInfoData;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class AttachmentUtils {
    /**
     * 将String类型转为附件类型返回
     * @param StringAttachment
     * @return
     */
    public static FileInfoData getAttachment(String StringAttachment){
        log.info("attachment{}",StringAttachment);
        if(StringUtils.isEmpty(StringAttachment) || ("null").equals(StringAttachment) || ("NULL").equals(StringAttachment)){
            return null;
        }

        JSONObject obj = JSON.parseObject(StringAttachment);
        JSONArray jsonArray = obj.getJSONArray("data");
        if(jsonArray == null || jsonArray.size() ==0){
            return null;
        }

        List<FileInfo> fileInfos = JSON.parseArray(jsonArray.toJSONString(), FileInfo.class);
        log.info("attachment{}",fileInfos);
        FileInfoData attachment = new FileInfoData();
        attachment.setData(fileInfos);
        return attachment;
    }
}
