package com.digiwin.athena.dtdapp.util;

import com.digiwin.athena.dtdapp.pojo.dto.st.SearchDTO;
import org.springframework.beans.BeanUtils;

import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StringUtils {
    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    /**
     * 把对象中的 String 类型的null字段，转换为空字符串
     *
     * @param <T> 待转化对象类型
     * @param cls 待转化对象
     * @return 转化好的对象
     */
    public static <T> T noNullStringAttr(T cls) {
        Field[] fields = cls.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return cls;
        }
        for (Field field : fields) {
            if ("String".equals(field.getType().getSimpleName())) {
                field.setAccessible(true);
                try {
                    Object value = field.get(cls);
                    if (value == null) {
                        field.set(cls, "");
                    }
                } catch (IllegalArgumentException | IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return cls;
    }

    public static <T> T noNullFieldAttr(T cls) {
        Field[] declaredFields = cls.getClass().getDeclaredFields();
        if (declaredFields == null || declaredFields.length == 0) {
            return cls;
        }
        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            try {
                Object value = declaredField.get(cls);
                if (value != null) {
                    declaredField.set(cls, null);
                }
                Object a = value;
            } catch (IllegalArgumentException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return cls;
    }

    public static String builderSQL(SearchDTO searchDTO, String sql1) {
        if (searchDTO == null || searchDTO.equals("")) {
            return "";
        }

        StringBuilder sql = new StringBuilder();
        // sql.append(sql1);


        String searchField = searchDTO.getSearch_field();
        String searchOperator = searchDTO.getSearch_operator();
        String searchBracket = searchDTO.getBracket();
        String searchLogic = searchDTO.getLogic();
        List<String> searchValues = searchDTO.getSearch_value();

        if ("like".equals(searchOperator)) {
            if (searchBracket != null && searchBracket.equals("(")) {
                sql.append("(");
            }
            sql.append(searchField).append(" like '%" + searchValues.get(0) + "%'");

            if (searchBracket != null && searchBracket.equals(")")) {
                sql.append(")");
            }
            if (searchLogic != null) {
                sql.append(" " + searchLogic + " ");
            }
        } else if ("between".equals(searchOperator)) {

            sql.append(searchField).append(" ").append(searchOperator).append(" " + "'" + searchValues.get(0) + "'"
                    + " and " + "'" + searchValues.get(1) + "'");
            if (searchLogic != null) {
                sql.append(" " + searchLogic + " ");
            }
        } else if ("in".equals(searchOperator)) {
            if (searchBracket != null && searchBracket.equals("(")) {
                sql.append("(");
            }
            String value = "";
            for (int i = 0; i < searchValues.size(); i++) {
                if (i == 0) {
                    value = "'" + searchValues.get(i) + "'";
                } else {
                    value = value + "," + "'" + searchValues.get(i) + "'";
                }
            }
            sql.append(searchField).append(" ").append(searchOperator).append(" (" + value + ")");
            if (searchBracket != null && searchBracket.equals(")")) {
                sql.append(")");
            }
            if (searchLogic != null) {
                sql.append(" " + searchLogic + " ");
            }
        } else if ("exist".equals(searchOperator)) {
            if ("status".equals(searchField)) {
                if (searchBracket != null && searchBracket.equals("(")) {
                    sql.append("(");
                }
                sql.append(searchField).append(" = '" + searchValues.get(0) + "'");
                if (searchLogic != null) {
                    sql.append(" " + searchLogic + " ");
                }
                if (searchBracket != null && searchBracket.equals(")")) {
                    sql.append(")");
                }
                if (searchLogic != null) {
                    sql.append(" " + searchLogic + " ");
                }
            }
        } else if ("equal".equals(searchOperator)) {

            sql.append("(");

            sql.append(searchField).append(" = '" + searchValues.get(0) + "'");


            sql.append(")");

            if (searchLogic != null) {
                sql.append(" " + searchLogic + " ");
            }
        }

        return sql.toString();

    }

    public static Date localDateToDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String splice(String a, String b) {
        if (!"".equals(a)) {
            a = a + ",";
        }
        a += b;
        return a;
    }

    //将
    public static <P, T> T copyObjectIsBoolean(P source, T target) {
        Field[] sourceFields = source.getClass().getDeclaredFields();

        if (sourceFields == null || sourceFields.length == 0) {
            return target;
        }
        Class<?> targetClass = target.getClass();
        for (Field sourceField : sourceFields) {
            if ("Boolean".equals(sourceField.getType().getSimpleName())) {
                sourceField.setAccessible(true);
                try {
                    Boolean value = (Boolean) sourceField.get(source);
                    if (value != null){
                        String stringValue = value ? "是" : "否";
                    Field targetField = targetClass.getDeclaredField(sourceField.getName());
                    targetField.setAccessible(true);
                    targetField.set(target, stringValue);
                }
                } catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return target;
    }
}
