/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.digiwin.athena.dtdapp.mapperzentao"}, sqlSessionTemplateRef="ztSqlSessionTemplate")
public class ZentaoDataSourceConfig {
    @Bean(name={"ztDataSource"})
    @ConfigurationProperties(prefix="ztdata.spring.datasource")
    public DataSource setDataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        return druidDataSource;
    }

    @Bean(name={"ztTransactionManager"})
    public DataSourceTransactionManager setTransactionManager(@Qualifier(value="ztDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"ztSqlSessionFactory"})
    public SqlSessionFactory setSqlSessionFactory(@Qualifier(value="ztDataSource") DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mappers/zentao/*.xml"));
        MybatisConfiguration mybatisConfiguration = new MybatisConfiguration();
        mybatisConfiguration.setMapUnderscoreToCamelCase(false);
        mybatisConfiguration.setCallSettersOnNulls(true);
        mybatisConfiguration.setLogImpl(StdOutImpl.class);
        bean.setConfiguration(mybatisConfiguration);
        return bean.getObject();
    }

    @Bean(name={"ztSqlSessionTemplate"})
    public SqlSessionTemplate setSqlSessionTemplate(@Qualifier(value="ztSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

