/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.dtdapp.mapper.CommodityAttachmentMapper;
import com.digiwin.athena.dtdapp.mapper.CommodityInfoMapper;
import com.digiwin.athena.dtdapp.mapper.PurchaseInfoMapper;
import com.digiwin.athena.dtdapp.pojo.entity.CommodityAttachment;
import com.digiwin.athena.dtdapp.pojo.entity.CommodityInfo;
import com.digiwin.athena.dtdapp.pojo.entity.PurchaseInfo;
import com.digiwin.athena.dtdapp.pojo.vo.CommodityInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.PurchaseInfoVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProcureDAO {
    private static final Logger log = LoggerFactory.getLogger(ProcureDAO.class);
    @Autowired
    private PurchaseInfoMapper purchaseInfoMapper;
    @Autowired
    private CommodityInfoMapper commodityInfoMapper;
    @Autowired
    private CommodityAttachmentMapper commodityAttachmentMapper;

    public List createPurchaseInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("\u91c7\u8d2d\u4fe1\u606f:{}", purchaseInfoVOS);
        ArrayList purchase_temp = new ArrayList();
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {
            PurchaseInfo purchaseInfo = new PurchaseInfo();
            BeanUtils.copyProperties((Object)purchaseInfoVO, (Object)purchaseInfo);
            String uuid = UUID.randomUUID().toString();
            purchaseInfo.setPurchase_no(uuid);
            this.purchaseInfoMapper.insert(purchaseInfo);
            ProcureDAO.result(purchase_temp, purchaseInfo);
            List<CommodityInfoVO> commodityInfos = purchaseInfoVO.getCommodity_info();
            for (CommodityInfoVO commodityInfoVO : commodityInfos) {
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties((Object)commodityInfoVO, (Object)commodityInfo);
                commodityInfo.setCommodity_cod(commodityInfoVO.getCommodity_cod()).setPurchase_no(uuid);
                this.commodityInfoMapper.insert(commodityInfo);
                JSONObject attachments = commodityInfoVO.getAttachment();
                JSONArray data = attachments.getJSONArray("data");
                List commodityAttachments = JSON.parseArray((String)JSON.toJSONString((Object)data), CommodityAttachment.class);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {
                    commodityAttachment.setPurchase_no(uuid).setCommodity_cod(commodityInfoVO.getCommodity_cod());
                    this.commodityAttachmentMapper.insert(commodityAttachment);
                }
            }
        }
        return purchase_temp;
    }

    public List updatePurchaseInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("\u9009\u62e9\u4f9b\u5e94\u5546\u66f4\u65b0\u91c7\u8d2d\u4fe1\u606f:{}", purchaseInfoVOS);
        ArrayList purchase_temp = new ArrayList();
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {
            PurchaseInfo purchaseInfo = new PurchaseInfo();
            BeanUtils.copyProperties((Object)purchaseInfoVO, (Object)purchaseInfo);
            QueryWrapper purchaseInfoQueryWrapper = new QueryWrapper();
            purchaseInfoQueryWrapper.eq((Object)"purchase_no", (Object)purchaseInfoVO.getPurchase_no());
            PurchaseInfo purchaseIf = (PurchaseInfo)this.purchaseInfoMapper.selectOne((Wrapper)purchaseInfoQueryWrapper);
            purchaseInfo.setId(purchaseIf.getId());
            this.purchaseInfoMapper.updateById(purchaseInfo);
            ProcureDAO.result(purchase_temp, purchaseInfo);
            List<CommodityInfoVO> commodityInfoVOS = purchaseInfoVO.getCommodity_info();
            for (CommodityInfoVO commodityInfoVO : commodityInfoVOS) {
                commodityInfoVO.setPurchase_no(purchaseInfoVO.getPurchase_no());
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties((Object)commodityInfoVO, (Object)commodityInfo);
                QueryWrapper commodityInfoQueryWrapper = new QueryWrapper();
                ((QueryWrapper)commodityInfoQueryWrapper.eq((Object)"purchase_no", (Object)commodityInfoVO.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfoVO.getCommodity_cod());
                CommodityInfo commodityIf = (CommodityInfo)this.commodityInfoMapper.selectOne((Wrapper)commodityInfoQueryWrapper);
                commodityInfo.setId(commodityIf.getId());
                this.commodityInfoMapper.updateById(commodityInfo);
                JSONArray data = commodityInfoVO.getAttachment().getJSONArray("data");
                List commodityAttachments = JSON.parseArray((String)JSON.toJSONString((Object)data), CommodityAttachment.class);
                QueryWrapper commodityAttachmentQueryWrapper = new QueryWrapper();
                ((QueryWrapper)commodityAttachmentQueryWrapper.eq((Object)"purchase_no", (Object)commodityInfoVO.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfoVO.getCommodity_cod());
                this.commodityAttachmentMapper.delete((Wrapper)commodityAttachmentQueryWrapper);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {
                    commodityAttachment.setPurchase_no(purchaseInfoVO.getPurchase_no()).setCommodity_cod(commodityInfoVO.getCommodity_cod());
                    this.commodityAttachmentMapper.insert(commodityAttachment);
                }
            }
        }
        return purchase_temp;
    }

    public List getPurchaseInfo(String purchaserCode) {
        log.info("\u91c7\u8d2d\u4eba:{}", (Object)purchaserCode);
        ArrayList<PurchaseInfoVO> purchaseInfoVOS = new ArrayList<PurchaseInfoVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchaser_code", (Object)purchaserCode);
        List purchaseInfos = this.purchaseInfoMapper.selectList((Wrapper)queryWrapper);
        for (PurchaseInfo purchaseInfo : purchaseInfos) {
            PurchaseInfoVO purchaseInfoVO = new PurchaseInfoVO();
            BeanUtils.copyProperties((Object)purchaseInfo, (Object)purchaseInfoVO);
            QueryWrapper commodityInfoQueryWrapper = new QueryWrapper();
            commodityInfoQueryWrapper.eq((Object)"purchase_no", (Object)purchaseInfo.getPurchase_no());
            List commodityInfos = this.commodityInfoMapper.selectList((Wrapper)commodityInfoQueryWrapper);
            ArrayList<CommodityInfoVO> commodityInfoVOS = new ArrayList<CommodityInfoVO>();
            for (CommodityInfo commodityInfo : commodityInfos) {
                CommodityInfoVO commodityInfoVO = new CommodityInfoVO();
                QueryWrapper commodityAttachmentQueryWrapper = new QueryWrapper();
                ((QueryWrapper)commodityAttachmentQueryWrapper.eq((Object)"purchase_no", (Object)commodityInfo.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfo.getCommodity_cod());
                List commodityAttachments = this.commodityAttachmentMapper.selectList((Wrapper)commodityAttachmentQueryWrapper);
                JSONArray jsonArray = ProcureDAO.getJsonArray(commodityAttachments);
                HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
                map.put("data", jsonArray);
                BeanUtils.copyProperties((Object)commodityInfo, (Object)commodityInfoVO);
                commodityInfoVO.setAttachment(new JSONObject(map));
                commodityInfoVOS.add(commodityInfoVO);
            }
            purchaseInfoVO.setCommodity_info(commodityInfoVOS);
            purchaseInfoVOS.add(purchaseInfoVO);
        }
        return purchaseInfoVOS;
    }

    public List getCommodityInfo(JSONArray jsonArray) {
        log.info("\u4f9b\u5e94\u5546\u56de\u590d\u83b7\u53d6\u4efb\u52a1\u5361:{}", (Object)jsonArray);
        ArrayList<PurchaseInfoVO> purchaseInfoVOS = new ArrayList<PurchaseInfoVO>();
        if (jsonArray == null || jsonArray.size() == 0) {
            List purchaseInfos = this.purchaseInfoMapper.selectList((Wrapper)new QueryWrapper());
            for (PurchaseInfo purchaseInfo : purchaseInfos) {
                String purchase_no = purchaseInfo.getPurchase_no();
                this.processPurchaseInfo(purchaseInfo, purchaseInfoVOS, purchase_no, null);
            }
        } else {
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                String purchase_no = jsonObject.getString("purchase_no");
                String supplier_no = jsonObject.getString("supplier_no");
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq(purchase_no != null, (Object)"purchase_no", (Object)purchase_no);
                PurchaseInfo purchaseInfo = (PurchaseInfo)this.purchaseInfoMapper.selectOne((Wrapper)queryWrapper);
                this.processPurchaseInfo(purchaseInfo, purchaseInfoVOS, purchase_no, supplier_no);
            }
        }
        return purchaseInfoVOS;
    }

    private void processPurchaseInfo(PurchaseInfo purchaseInfo, ArrayList<PurchaseInfoVO> purchaseInfoVOS, String purchase_no, String supplier_no) {
        PurchaseInfoVO purchaseInfoVO = new PurchaseInfoVO();
        BeanUtils.copyProperties((Object)purchaseInfo, (Object)purchaseInfoVO);
        QueryWrapper commodityInfoQueryWrapper = new QueryWrapper();
        ((QueryWrapper)commodityInfoQueryWrapper.eq(supplier_no != null, (Object)"supplier_no", (Object)supplier_no)).eq(purchase_no != null, (Object)"purchase_no", (Object)purchase_no);
        List commodityInfos = this.commodityInfoMapper.selectList((Wrapper)commodityInfoQueryWrapper);
        ArrayList<CommodityInfoVO> commodityInfoVOS = new ArrayList<CommodityInfoVO>();
        for (CommodityInfo commodityInfo : commodityInfos) {
            CommodityInfoVO commodityInfoVO = new CommodityInfoVO();
            BeanUtils.copyProperties((Object)commodityInfo, (Object)commodityInfoVO);
            QueryWrapper commodityAttachmentQueryWrapper = new QueryWrapper();
            ((QueryWrapper)commodityAttachmentQueryWrapper.eq((Object)"purchase_no", (Object)purchaseInfo.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfo.getCommodity_cod());
            List commodityAttachments = this.commodityAttachmentMapper.selectList((Wrapper)commodityAttachmentQueryWrapper);
            JSONArray jsonArr = ProcureDAO.getJsonArray(commodityAttachments);
            HashMap<String, JSONArray> map = new HashMap<String, JSONArray>();
            map.put("data", jsonArr);
            commodityInfoVO.setAttachment(new JSONObject(map));
            commodityInfoVOS.add(commodityInfoVO);
        }
        purchaseInfoVO.setCommodity_info(commodityInfoVOS);
        purchaseInfoVOS.add(purchaseInfoVO);
    }

    public List updateCommodityInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("\u4f9b\u5e94\u5546\u56de\u590d:{}", purchaseInfoVOS);
        ArrayList purchase_temp = new ArrayList();
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {
            PurchaseInfo purchaseInfo = new PurchaseInfo();
            BeanUtils.copyProperties((Object)purchaseInfoVO, (Object)purchaseInfo);
            QueryWrapper purchaseInfoQueryWrapper = new QueryWrapper();
            purchaseInfoQueryWrapper.eq((Object)"purchase_no", (Object)purchaseInfoVO.getPurchase_no());
            PurchaseInfo purchaseIf = (PurchaseInfo)this.purchaseInfoMapper.selectOne((Wrapper)purchaseInfoQueryWrapper);
            purchaseInfo.setId(purchaseIf.getId());
            this.purchaseInfoMapper.updateById(purchaseInfo);
            ProcureDAO.result(purchase_temp, purchaseInfo);
            List<CommodityInfoVO> commodityInfoVOS = purchaseInfoVO.getCommodity_info();
            for (CommodityInfoVO commodityInfoVO : commodityInfoVOS) {
                commodityInfoVO.setPurchase_no(purchaseInfoVO.getPurchase_no());
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties((Object)commodityInfoVO, (Object)commodityInfo);
                QueryWrapper commodityInfoQueryWrapper = new QueryWrapper();
                ((QueryWrapper)commodityInfoQueryWrapper.eq((Object)"purchase_no", (Object)commodityInfoVO.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfoVO.getCommodity_cod());
                CommodityInfo commodityIf = (CommodityInfo)this.commodityInfoMapper.selectOne((Wrapper)commodityInfoQueryWrapper);
                commodityInfo.setId(commodityIf.getId());
                this.commodityInfoMapper.updateById(commodityInfo);
                JSONArray data = commodityInfoVO.getAttachment().getJSONArray("data");
                List commodityAttachments = JSON.parseArray((String)JSON.toJSONString((Object)data), CommodityAttachment.class);
                QueryWrapper commodityAttachmentQueryWrapper = new QueryWrapper();
                ((QueryWrapper)commodityAttachmentQueryWrapper.eq((Object)"purchase_no", (Object)commodityInfoVO.getPurchase_no())).eq((Object)"commodity_cod", (Object)commodityInfoVO.getCommodity_cod());
                this.commodityAttachmentMapper.delete((Wrapper)commodityAttachmentQueryWrapper);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {
                    commodityAttachment.setPurchase_no(purchaseInfoVO.getPurchase_no()).setCommodity_cod(commodityInfoVO.getCommodity_cod());
                    this.commodityAttachmentMapper.insert(commodityAttachment);
                }
            }
        }
        return purchase_temp;
    }

    private static JSONArray getJsonArray(List<CommodityAttachment> commodityAttachments) {
        JSONArray jsonArr = new JSONArray(commodityAttachments.stream().map(commodityAttachment -> {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", commodityAttachment.getId());
            map1.put("name", commodityAttachment.getName());
            map1.put("category", commodityAttachment.getCategory());
            map1.put("category_id", commodityAttachment.getCategory_id());
            map1.put("size", commodityAttachment.getSize());
            map1.put("upload_user_id", commodityAttachment.getUpload_user_id());
            map1.put("upload_user_name", commodityAttachment.getUpload_user_name());
            map1.put("create_date", commodityAttachment.getCreate_date());
            map1.put("row_data", commodityAttachment.getRow_data());
            return new JSONObject(map1);
        }).collect(Collectors.toList()));
        return jsonArr;
    }

    private static void result(List purchase_temp, PurchaseInfo purchaseInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("purchase_no", purchaseInfo.getPurchase_no());
        map.put("eoc_company_id", purchaseInfo.getEoc_company_id());
        map.put("eoc_site_id", purchaseInfo.getEoc_site_id());
        map.put("eoc_region_id", purchaseInfo.getEoc_region_id());
        map.put("om_company_id", purchaseInfo.getOm_company_id());
        map.put("om_site_id", purchaseInfo.getOm_site_id());
        map.put("om_region_id", purchaseInfo.getOm_region_id());
        map.put("operation_results", purchaseInfo.toString());
        purchase_temp.add(map);
    }

    private static void sendEmail(CommodityInfoVO commodityInfoVO) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        HashMap<String, Object> tRequest = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(commodityInfoVO.getSupplier_email());
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "\u60a8\u6709\u4e00\u4efd\u65b0\u7684\u53cd\u9988\u4fe1\u606f");
        String athenaTestUrl = DWApplicationConfigUtils.getProperty((String)"athenaTestUrl");
        log.info("\u57df\u540d:{}", (Object)athenaTestUrl);
        tRequest.put("content", "\u60a8\u6709\u65b0\u7684\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u81f3\uff1a<a href=\"" + athenaTestUrl + "\">\u96c5\u5178\u5a1c\u8fd0\u884c\u5e73\u53f0</a>\u67e5\u770b\uff01");
        HttpEntity httpEntity = new HttpEntity(tRequest, (MultiValueMap)headers);
        String tFinalUrl = DWApplicationConfigUtils.getProperty((String)"emcUrl") + tApi;
        log.info("sendEmailUrl:" + tFinalUrl);
        restTemplate.setErrorHandler(new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse clientHttpResponse) {
                return false;
            }

            public void handleError(ClientHttpResponse clientHttpResponse) {
            }
        });
        ResponseEntity responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = (String)responseEntity.getBody();
            log.error("send mail error:{}-{}", (Object)statusCodeValue, (Object)body);
        }
    }
}

