/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.dao.st;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.mapper.stmapper.WorkCalendarMapper;
import com.digiwin.athena.dtdapp.pojo.dto.st.WorkCalendarDTO;
import com.digiwin.athena.dtdapp.pojo.entity.st.WorkCalendar;
import com.digiwin.athena.dtdapp.pojo.vo.WorkCalendarInfos;
import com.digiwin.athena.dtdapp.pojo.vo.st.WorkCalendarVO;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import com.digiwin.athena.dtdapp.util.StringUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkCalendarDAO {
    private static final Logger log = LoggerFactory.getLogger(WorkCalendarDAO.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkCalendarDAO.class);
    @Autowired
    private WorkCalendarMapper workCalendarMapper;

    public List getWorkCalendarInfo(JSONObject jsonObject) throws DWException {
        LOGGER.info("getWorkCalendarInfo:{}", (Object)jsonObject);
        WorkCalendar getWorkCalendar = null;
        List<WorkCalendar> workCalendars = new ArrayList();
        ArrayList workCalendarVOS = new ArrayList();
        ArrayList<WorkCalendarInfos> workCalendarInfos = new ArrayList<WorkCalendarInfos>();
        if (jsonObject == null || jsonObject.isEmpty()) {
            WorkCalendarInfos cn = this.getWorkCalendarInfos("CN");
            WorkCalendarInfos tw = this.getWorkCalendarInfos("TW");
            workCalendarInfos.add(cn);
            workCalendarInfos.add(tw);
            return workCalendarInfos;
        }
        WorkCalendarDTO workCalendar = (WorkCalendarDTO)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), WorkCalendarDTO.class);
        if (workCalendar.getAdjust_date() != null) {
            for (String date : workCalendar.getAdjust_date()) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(workCalendar.getArea() != null, WorkCalendar::getArea, (Object)workCalendar.getArea());
                queryWrapper.eq(WorkCalendar::getAdjust_date, (Object)date);
                queryWrapper.eq(workCalendar.getAdjust_type() != null, WorkCalendar::getAdjust_type, (Object)workCalendar.getAdjust_type());
                queryWrapper.eq(workCalendar.getTenantsid() != null, WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                queryWrapper.orderByAsc(WorkCalendar::getAdjust_date);
                queryWrapper.eq(WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                getWorkCalendar = (WorkCalendar)this.workCalendarMapper.selectOne((Wrapper)queryWrapper);
                if (getWorkCalendar != null) {
                    workCalendars.add(getWorkCalendar);
                    continue;
                }
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate localDate = LocalDate.parse(date, df);
                WorkCalendar workCalendar1 = new WorkCalendar();
                workCalendar1.setArea(workCalendar.getArea());
                workCalendar1.setYear(localDate.getYear() + "");
                workCalendar1.setAdjust_date(date);
                workCalendar1.setAdjust_type(this.isWorkday(localDate) ? "2" : "1");
                workCalendars.add(workCalendar1);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(workCalendar.getArea() != null, WorkCalendar::getArea, (Object)workCalendar.getArea());
            queryWrapper.eq(workCalendar.getAdjust_type() != null, WorkCalendar::getAdjust_type, (Object)workCalendar.getAdjust_type());
            queryWrapper.eq(WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            workCalendars = this.workCalendarMapper.selectList((Wrapper)queryWrapper);
        }
        workCalendars.stream().forEach(s -> {
            WorkCalendarVO workCalendarVO = new WorkCalendarVO();
            BeanUtils.copyProperties((Object)s, (Object)workCalendarVO);
            workCalendarVO.setUibot_checked(false);
            workCalendarVOS.add(workCalendarVO);
        });
        WorkCalendarInfos workCalendarInfo = new WorkCalendarInfos();
        workCalendarInfo.setArea(workCalendar.getArea());
        workCalendarInfo.setWork_calendar_info(workCalendarVOS);
        workCalendarInfos.add(workCalendarInfo);
        return workCalendarInfos;
    }

    private WorkCalendarInfos getWorkCalendarInfos(String area) {
        List workCalendars = new ArrayList();
        ArrayList workCalendarVOS = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WorkCalendar::getArea, (Object)area);
        queryWrapper.eq(WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        queryWrapper.orderByAsc(WorkCalendar::getAdjust_date);
        workCalendars = this.workCalendarMapper.selectList((Wrapper)queryWrapper);
        workCalendars.stream().forEach(s -> {
            WorkCalendarVO workCalendarVO = new WorkCalendarVO();
            BeanUtils.copyProperties((Object)s, (Object)workCalendarVO);
            workCalendarVO.setUibot_checked(false);
            workCalendarVOS.add(workCalendarVO);
        });
        WorkCalendarInfos workCalendarInfo = new WorkCalendarInfos();
        workCalendarInfo.setArea(area);
        workCalendarInfo.setWork_calendar_info(workCalendars);
        return workCalendarInfo;
    }

    private boolean isWorkday(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return !dayOfWeek.equals(DayOfWeek.SATURDAY) && !dayOfWeek.equals(DayOfWeek.SUNDAY);
    }

    @Transactional
    public List createOrUpdateWorkCalendar(Map<String, String> parameter) throws DWException {
        LOGGER.info("getWorkCalendarInfo:{}", parameter);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_calendar_info");
        if (jsonArray == null && jsonArray.size() == 0) {
            throw new DWException("workCalendar is empty");
        }
        List workCalendars = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkCalendar.class);
        ArrayList<WorkCalendar> getWorkCalendars = new ArrayList<WorkCalendar>();
        for (WorkCalendar workCalendar : workCalendars) {
            if (!StringUtils.isNotEmpty(workCalendar.getAdjust_date())) {
                throw new DWException("adjust_date is empty");
            }
            workCalendar.setYear(workCalendar.getAdjust_date().split("-")[0]);
            LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(WorkCalendar::getAdjust_date, (Object)workCalendar.getAdjust_date())).eq(WorkCalendar::getArea, (Object)workCalendar.getArea())).eq(WorkCalendar::getYear, (Object)workCalendar.getYear())).eq(WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            WorkCalendar getWorkCalendar = (WorkCalendar)this.workCalendarMapper.selectOne((Wrapper)eq);
            if (getWorkCalendar != null) {
                this.workCalendarMapper.delete((Wrapper)eq);
            }
            this.workCalendarMapper.insert(workCalendar);
            eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(WorkCalendar::getAdjust_date, (Object)workCalendar.getAdjust_date())).eq(WorkCalendar::getArea, (Object)workCalendar.getArea())).eq(WorkCalendar::getYear, (Object)workCalendar.getYear())).eq(WorkCalendar::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            WorkCalendar getWorkCalendarOne = (WorkCalendar)this.workCalendarMapper.selectOne((Wrapper)eq);
            getWorkCalendars.add(getWorkCalendarOne);
        }
        return getWorkCalendars;
    }
}

