/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckItemDAO;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckResult;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCallBackVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckResultVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodInfoVO;
import com.digiwin.athena.dtdapp.provider.IDorDodProvider;
import com.digiwin.athena.dtdapp.service.DorDodService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DorDodProviderImpl
implements IDorDodProvider {
    private static final Logger log = LoggerFactory.getLogger(DorDodProviderImpl.class);
    @Autowired
    private DorDoDCheckItemDAO dorDoDCheckItemDAO;
    @Autowired
    private DorDodService dorDodService;

    @Override
    public DWEAIResult getDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        List list = this.dorDoDCheckItemDAO.getDorDodCheckItems(map);
        HashMap<String, List> info = new HashMap<String, List>();
        info.put("check_item_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult saveDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        List list = this.dorDoDCheckItemDAO.saveDorDodCheckItems(map);
        HashMap<String, List> info = new HashMap<String, List>();
        info.put("check_item_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult createDorDodInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("has no data to save");
        }
        List dorDodCheckItems = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodInfoVO.class);
        this.dorDodService.initDorDodInfo(dorDodCheckItems);
        HashMap<String, List> info = new HashMap<String, List>();
        info.put("dor_dod_info", dorDodCheckItems);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List dorDodCheckResults = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodCheckResult.class);
        List<Object> result = null;
        result = CollectionUtils.isEmpty((Collection)dorDodCheckResults) ? new ArrayList() : this.dorDodService.getDorDodCheckResult(dorDodCheckResults);
        HashMap info = new HashMap();
        info.put("dor_dod_info", result);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult updateDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List dorDodCheckResults = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodCheckResultVO.class);
        this.dorDodService.updateDorDodCheckResult(dorDodCheckResults);
        HashMap<String, JSONArray> info = new HashMap<String, JSONArray>();
        info.put("dor_dod_info", jsonArray);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult auditDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List dorDodCheckResults = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodCheckResultVO.class);
        this.dorDodService.auditDorDodCheckResult(dorDodCheckResults);
        HashMap<String, JSONArray> info = new HashMap<String, JSONArray>();
        info.put("dor_dod_info", jsonArray);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getDorDodCheckResultDetail(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List dorDodCheckResults = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodCheckResult.class);
        List<DorDodCheckResult> result = this.dorDodService.getDorDodCheckResultDetail(jsonArray.getJSONObject(0));
        HashMap<String, List<DorDodCheckResult>> info = new HashMap<String, List<DorDodCheckResult>>();
        info.put("dor_dod_info", result);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult callbackDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = (Map)JSONObject.parseObject((String)messageBody, Map.class);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List dorDodCallBackVOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), DorDodCallBackVO.class);
        this.dorDodService.callbackDorDodCheckResult(dorDodCallBackVOS);
        HashMap info = new HashMap();
        return new DWEAIResult("0", "0", "OK", info);
    }
}

