/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DtdappIamService {
    private static final Logger log = LoggerFactory.getLogger(DtdappIamService.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${iamUrl}")
    private String iamUrl;
    @Value(value="${iamApToken}")
    private String iamApToken;
    private final String LOGIN = "/api/iam/v2/identity/login/internal";
    private static final String integrationInternalPasswordHash = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    public String getTenantToken(String tenantId) throws Exception {
        Object login = this.login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    public Object login(String tenantId) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", null);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.iamUrl + "/api/iam/v2/identity/login/internal", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        return body;
    }
}

