/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.dtdapp.dao.st.EmployeeDAO;
import com.digiwin.athena.dtdapp.dao.st.OrganizationDAO;
import com.digiwin.athena.dtdapp.dao.st.ProjectDAO;
import com.digiwin.athena.dtdapp.dao.st.ProjectEmployeeRelationDAO;
import com.digiwin.athena.dtdapp.dao.st.ProjectProductRelationDAO;
import com.digiwin.athena.dtdapp.dao.st.WorkReportDetailDAO;
import com.digiwin.athena.dtdapp.dao.st.ZtTypeAssociationsDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtEffortDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProductDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProductplanDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProjectDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtStoryDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtTaskDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtUserDAO;
import com.digiwin.athena.dtdapp.mapper.stmapper.EmployeeMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.OrganizationMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.ProjectEmployeeRelationMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.ProjectMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.ProjectProductRelationMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.WorkReportDetailMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.ZtTypeAssociationsMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtEffortMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProductMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProductplanMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProjectMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtStoryMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtTaskMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtUserMapper;
import com.digiwin.athena.dtdapp.pojo.dto.st.ProjectDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.ProjectEmployeeRelationDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.SearchDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.WorkReportDetailDTO;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.entity.st.Organization;
import com.digiwin.athena.dtdapp.pojo.entity.st.Project;
import com.digiwin.athena.dtdapp.pojo.entity.st.ProjectEmployeeRelation;
import com.digiwin.athena.dtdapp.pojo.entity.st.ProjectProductRelation;
import com.digiwin.athena.dtdapp.pojo.entity.st.WorkReportDetail;
import com.digiwin.athena.dtdapp.pojo.entity.st.ZtTypeAssociations;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtEffort;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProduct;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProductplan;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtStory;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.vo.st.AuditWorkReportVO;
import com.digiwin.athena.dtdapp.pojo.vo.st.EmployeeVO;
import com.digiwin.athena.dtdapp.pojo.vo.st.OrgVO;
import com.digiwin.athena.dtdapp.pojo.vo.st.ProductVO;
import com.digiwin.athena.dtdapp.pojo.vo.st.ProjectVO;
import com.digiwin.athena.dtdapp.pojo.vo.st.WorkReportDetailVO;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import com.digiwin.athena.dtdapp.util.StringUtils;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkReportService {
    private static final Logger log = LoggerFactory.getLogger(WorkReportService.class);
    @Autowired
    private EmployeeDAO employeeDAO;
    @Autowired
    private OrganizationDAO organizationDAO;
    @Autowired
    private ProjectDAO projectDAO;
    @Autowired
    private ProjectProductRelationDAO projectProductRelationDAO;
    @Autowired
    private WorkReportDetailDAO workReportDetailDAO;
    @Autowired
    private ProjectEmployeeRelationDAO projectEmployeeRelationDAO;
    @Autowired
    private ZtTaskDAO ztTaskDAO;
    @Autowired
    private ZtTypeAssociationsDAO ztTypeAssociationsDAO;
    @Autowired
    private WorkReportService workReportService;
    @Autowired
    private ZtProductDAO ztProductDAO;
    @Autowired
    private ZtProjectDAO ztProjectDAO;
    @Autowired
    private ZtEffortDAO ztEffortDAO;
    @Autowired
    private ZtUserDAO ztUserDAO;
    @Autowired
    private ZtProductplanDAO ztProductplanDAO;
    @Autowired
    private ZtStoryDAO ztStoryDAO;

    public Map queryEmployeeInfo(Map map) {
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        Integer page = (Integer)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = (Integer)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = (Boolean)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        ArrayList result = new ArrayList();
        LambdaQueryWrapper employeeLambdaQueryWrapper = new LambdaQueryWrapper();
        List employees = new ArrayList();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        List employees1 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, String> empMap = employees1.stream().collect(Collectors.toMap(s -> s.getEmployee_no(), s -> s.getEmployee_name()));
        if (jsonArray == null || jsonArray.size() == 0) {
            employees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        } else {
            List searchDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), SearchDTO.class);
            employeeLambdaQueryWrapper.eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            String sql = "";
            sql = sql + "(";
            block6: for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {
                    case "org_name": {
                        LambdaQueryWrapper organizationLambdaQueryWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)organizationLambdaQueryWrapper.like(Organization::getOrg_name, (Object)searchDTO.getSearch_value().get(0))).eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)organizationLambdaQueryWrapper);
                        if (organizations == null) continue block6;
                        if (organizations.size() == 0) break;
                        ArrayList<String> objects = new ArrayList<String>();
                        for (Organization organization : organizations) {
                            objects.add(organization.getOrg_no());
                        }
                        searchDTO.setSearch_operator("in");
                        searchDTO.setSearch_field("org_no");
                        searchDTO.setSearch_value(objects);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        break;
                    }
                    default: {
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                    }
                }
            }
            sql = sql + ")";
            employeeLambdaQueryWrapper.apply(sql, new Object[0]);
            Page pages = new Page((long)page.intValue(), (long)size.intValue());
            if (use_has_next != null && use_has_next.booleanValue()) {
                Page employeePage = (Page)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)employeeLambdaQueryWrapper);
                employees = employeePage.getRecords();
                stringObjectMap.put("total_results", employeePage.getTotal());
                stringObjectMap.put("has_next", employeePage.hasNext());
            } else {
                employees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)employeeLambdaQueryWrapper);
            }
        }
        List allEmp = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map employeeMap = allEmp.stream().collect(Collectors.toMap(Employee::getEmployee_no, Function.identity(), (a, b) -> a));
        if (CollectionUtils.isNotEmpty(employees)) {
            List organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            Map orgMap = organizations.stream().collect(Collectors.toMap(Organization::getOrg_no, Function.identity(), (a, b) -> a));
            employees.forEach(e -> {
                EmployeeVO employeeVO = new EmployeeVO();
                BeanUtils.copyProperties((Object)e, (Object)employeeVO);
                if (StringUtil.isEmpty((Object)employeeVO.getApproval_no())) {
                    employeeVO.setApproval_name("");
                    employeeVO.setApproval_no("");
                } else {
                    employeeVO.setApproval_no(e.getApproval_no());
                    employeeVO.setApproval_name((String)empMap.get(e.getApproval_no()));
                }
                Organization organization = (Organization)orgMap.get(e.getOrg_no());
                if (organization != null) {
                    employeeVO.setOrg_name(organization.getOrg_name());
                    employeeVO.setOrg_supervisor_name(organization.getOrg_supervisor());
                    if (employeeMap.containsKey(organization.getOrg_supervisor_id())) {
                        employeeVO.setManage_no(organization.getOrg_supervisor_id());
                        employeeVO.setManage_name(organization.getOrg_supervisor());
                        employeeVO.setManage_email(((Employee)employeeMap.get(organization.getOrg_supervisor_id())).getEmail());
                    }
                }
                result.add(employeeVO);
            });
        }
        stringObjectMap.put("employee_info", result);
        return stringObjectMap;
    }

    @Transactional
    public List updateEmployeeInfo(Map map) {
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("employee_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("no data to update");
        }
        List updateEmployees = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Employee.class);
        updateEmployees.forEach(e -> this.employeeDAO.update(e, (Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(Employee::getEmployee_no, (Object)e.getEmployee_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid())));
        return updateEmployees;
    }

    public List queryOrgInfo(Map map) {
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("org_info");
        List organizations = null;
        if (jsonArray == null || jsonArray.size() == 0) {
            organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(Organization::getStatus, (Object)Character.valueOf('Y')));
        } else {
            List query = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Organization.class);
            List orgNos = query.stream().map(Organization::getOrg_no).collect(Collectors.toList());
            organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Organization::getOrg_no, orgNos)).eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(Organization::getStatus, (Object)Character.valueOf('Y')));
        }
        Map orgMap = organizations.stream().collect(Collectors.toMap(Organization::getOrg_no, Function.identity(), (a, b) -> a));
        ArrayList result = new ArrayList();
        organizations.forEach(e -> {
            OrgVO orgVO = new OrgVO();
            BeanUtils.copyProperties((Object)e, (Object)orgVO);
            LinkedList<String> orgHierarchyList = new LinkedList<String>();
            orgHierarchyList.push(e.getOrg_no());
            this.getOrgHierarchy(e.getSuper_org_no(), orgMap, orgHierarchyList);
            orgVO.setOrg_hierarchy(orgHierarchyList);
            result.add(orgVO);
        });
        return result;
    }

    private void getOrgHierarchy1(String superOrgNo, Map<String, Organization> orgMap, LinkedList<String> orgHierarchyList) {
        if (StringUtil.isEmpty((Object)superOrgNo)) {
            return;
        }
        Organization organization = orgMap.get(superOrgNo);
        if (organization == null) {
            return;
        }
        orgHierarchyList.push(superOrgNo);
        this.getOrgHierarchy(organization.getSuper_org_no(), orgMap, orgHierarchyList);
    }

    private void getOrgHierarchy(String superOrgNo, Map<String, Organization> orgMap, LinkedList<String> orgHierarchyList) {
        if (StringUtil.isEmpty((Object)superOrgNo)) {
            return;
        }
        Stack<String> orgStack = new Stack<String>();
        orgStack.push(superOrgNo);
        while (!orgStack.isEmpty()) {
            String currentOrgNo = (String)orgStack.pop();
            Organization organization = orgMap.get(currentOrgNo);
            if (organization == null) continue;
            orgHierarchyList.push(currentOrgNo);
            String parentOrgNo = organization.getSuper_org_no();
            if (!StringUtil.isNotEmpty((Object)superOrgNo) || orgHierarchyList.contains(parentOrgNo)) continue;
            orgStack.push(parentOrgNo);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> queryProject(Map map) throws DWException {
        log.info("queryProjectInfo:{}", (Object)map);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        JSONArray projectJsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        List searchDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), SearchDTO.class);
        Integer page = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = (Boolean)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page pages = new Page();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        List projectList = new ArrayList();
        ArrayList<Object> projectVOS = new ArrayList<Object>();
        if (jsonArray == null || jsonArray.size() == 0) {
            if (use_has_next != null && use_has_next.booleanValue()) {
                pages = new Page((long)page.intValue(), (long)size.intValue());
                Page projectPage = null;
                if (projectJsonArray != null && projectJsonArray.size() != 0) {
                    List list = JSON.parseArray((String)JSON.toJSONString((Object)projectJsonArray), Project.class);
                    for (Project project : list) {
                        projectPage = (Page)((ProjectMapper)this.projectDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StringUtil.isNotEmpty((Object)project.getProject_type()), Project::getProject_type, (Object)project.getProject_type())).eq(StringUtil.isNotEmpty((Object)project.getManage_status()), Project::getManage_status, (Object)project.getManage_status())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                    }
                } else {
                    projectPage = (Page)((ProjectMapper)this.projectDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                }
                projectList = projectPage.getRecords();
                stringObjectMap.put("total_results", pages.getTotal());
                stringObjectMap.put("has_next", projectPage.hasNext());
            } else {
                projectList = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            }
            if (projectList == null) {
                throw new DWException("table is not data");
            }
            for (Project project : projectList) {
                ProjectVO projectVO = new ProjectVO();
                BeanUtils.copyProperties((Object)project, (Object)projectVO);
                if ("2".equals(project.getProject_type())) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ProjectProductRelation::getProject_id, (Object)project.getProject_code());
                    ((LambdaQueryWrapper)wrapper.orderByDesc(ProjectProductRelation::getUpdate_time)).eq(ProjectProductRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                    Object projectProductRelationList = ((ProjectProductRelationMapper)this.projectProductRelationDAO.getBaseMapper()).selectList((Wrapper)wrapper);
                    Iterator<ProductVO> productList = new ArrayList();
                    Iterator iterator = projectProductRelationList.iterator();
                    while (iterator.hasNext()) {
                        ProjectProductRelation projectProductRelation = (ProjectProductRelation)iterator.next();
                        Project product = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)projectProductRelation.getProduct_id())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                        if (!Objects.nonNull(product)) continue;
                        ProductVO productVO = new ProductVO();
                        BeanUtils.copyProperties((Object)product, (Object)productVO);
                        productList.add(productVO);
                    }
                    projectVO.setProduct((List<ProductVO>)((Object)productList));
                }
                projectVOS.add(projectVO);
            }
        } else {
            void var14_19;
            LambdaQueryWrapper projectLambdaQueryWrapper = new LambdaQueryWrapper();
            projectLambdaQueryWrapper.eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            String string2 = "";
            string2 = string2 + "(";
            for (SearchDTO searchDTO : searchDTOs) {
                switch (searchDTO.getSearch_field()) {
                    case "project_leader": {
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.like(Employee::getEmployee_name, (Object)searchDTO.getSearch_value().get(0));
                        wrapper.eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)wrapper);
                        ArrayList<String> list = new ArrayList<String>();
                        if (employees != null && employees.size() != 0) {
                            ArrayList projectEmployeeRelationS = new ArrayList();
                            for (Employee employee : employees) {
                                LambdaQueryWrapper relationLambdaQueryWrapper = new LambdaQueryWrapper();
                                ((LambdaQueryWrapper)((LambdaQueryWrapper)relationLambdaQueryWrapper.eq(ProjectEmployeeRelation::getEmployee_no, (Object)employee.getEmployee_no())).eq(ProjectEmployeeRelation::getEmployee_role, (Object)"1")).eq(ProjectEmployeeRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                                List projectEmployeeRelations = ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).selectList((Wrapper)relationLambdaQueryWrapper);
                                projectEmployeeRelationS.addAll(projectEmployeeRelations);
                            }
                            if (projectEmployeeRelationS != null && projectEmployeeRelationS.size() != 0) {
                                for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelationS) {
                                    list.add(projectEmployeeRelation.getProject_id());
                                }
                                searchDTO.setSearch_field("project_code");
                                searchDTO.setSearch_operator("in");
                                searchDTO.setSearch_value(list);
                                String string3 = (String)var14_19 + StringUtils.builderSQL(searchDTO, (String)var14_19);
                                break;
                            }
                            searchDTO.setSearch_field("project_code");
                            list.add("000000");
                            searchDTO.setSearch_value(list);
                            String string4 = (String)var14_19 + StringUtils.builderSQL(searchDTO, (String)var14_19);
                            break;
                        }
                        searchDTO.setSearch_field("project_code");
                        list.add("000000");
                        searchDTO.setSearch_value(list);
                        String string5 = (String)var14_19 + StringUtils.builderSQL(searchDTO, (String)var14_19);
                        break;
                    }
                    default: {
                        String string6 = (String)var14_19 + StringUtils.builderSQL(searchDTO, (String)var14_19);
                    }
                }
            }
            String string7 = (String)var14_19 + ")";
            projectLambdaQueryWrapper.apply(string7, new Object[0]);
            if (use_has_next != null && use_has_next.booleanValue()) {
                pages = new Page((long)page.intValue(), (long)size.intValue());
                Page projectPage = (Page)((ProjectMapper)this.projectDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)projectLambdaQueryWrapper);
                projectList = projectPage.getRecords();
                stringObjectMap.put("total_results", projectPage.getTotal());
                stringObjectMap.put("has_next", projectPage.hasNext());
            }
            for (Project project : projectList) {
                ProjectVO projectVO = new ProjectVO();
                BeanUtils.copyProperties((Object)project, (Object)projectVO);
                projectVOS.add(projectVO);
            }
        }
        for (ProjectVO projectVO : projectVOS) {
            if ("2".equals(projectVO.getProject_type())) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(ProjectProductRelation::getProject_id, (Object)projectVO.getProject_code());
                ((LambdaQueryWrapper)wrapper.orderByDesc(ProjectProductRelation::getUpdate_time)).eq(ProjectProductRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                List projectProductRelationList = ((ProjectProductRelationMapper)this.projectProductRelationDAO.getBaseMapper()).selectList((Wrapper)wrapper);
                ArrayList<ProductVO> productList = new ArrayList<ProductVO>();
                for (ProjectProductRelation projectProductRelation : projectProductRelationList) {
                    Project product = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)projectProductRelation.getProduct_id())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                    if (!Objects.nonNull(product)) continue;
                    ProductVO productVO = new ProductVO();
                    productVO.setProduct_name(product.getProject_name());
                    productVO.setProject_code(product.getProject_code());
                    productList.add(productVO);
                }
                projectVO.setProduct(productList);
            }
            projectVO.setProject_leader_id("");
            projectVO.setProject_leader("");
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(ProjectEmployeeRelation::getProject_id, (Object)projectVO.getProject_code())).eq(ProjectEmployeeRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            List projectEmployeeRelationList = ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
            ArrayList<ProjectEmployeeRelationDTO> projectEmployeeRelationDTOList = new ArrayList<ProjectEmployeeRelationDTO>();
            for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelationList) {
                ProjectEmployeeRelationDTO projectEmployeeRelationDTO = new ProjectEmployeeRelationDTO();
                BeanUtils.copyProperties((Object)projectEmployeeRelation, (Object)projectEmployeeRelationDTO);
                projectEmployeeRelationDTOList.add(projectEmployeeRelationDTO);
            }
            LambdaQueryWrapper employeeLambdaQueryWrapper = null;
            ArrayList<ProjectEmployeeRelationDTO> projectEmployeeRelationDTOS = new ArrayList<ProjectEmployeeRelationDTO>();
            for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectEmployeeRelationDTOList) {
                employeeLambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)employeeLambdaQueryWrapper.eq(Employee::getEmployee_no, (Object)projectEmployeeRelationDTO.getEmployee_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                Employee employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)employeeLambdaQueryWrapper);
                if (employee == null) continue;
                if ("1".equals(projectEmployeeRelationDTO.getEmployee_role())) {
                    projectVO.setProject_leader(employee.getEmployee_name());
                    projectVO.setProject_leader_id(employee.getEmployee_no());
                    continue;
                }
                projectEmployeeRelationDTO.setEmployee_name(employee.getEmployee_name());
                projectEmployeeRelationDTOS.add(projectEmployeeRelationDTO);
            }
            projectVO.setProject_participants(projectEmployeeRelationDTOS);
        }
        stringObjectMap.put("work_report_info", projectVOS);
        return stringObjectMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public List updateProject(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to update");
        }
        List projectDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), ProjectDTO.class);
        for (ProjectDTO projectDTO : projectDTOS) {
            LambdaQueryWrapper wapper;
            LambdaQueryWrapper queryWrapper = null;
            queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(projectDTO.getProject_code() != null, Project::getProject_code, (Object)projectDTO.getProject_code())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            if (projectDTO.getProject_code() == null) {
                queryWrapper.eq(Project::getProject_name, (Object)projectDTO.getProject_name());
            }
            Project project = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)queryWrapper);
            if ("2".equals(projectDTO.getProject_type())) {
                wapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wapper.eq(ProjectProductRelation::getProject_id, (Object)project.getProject_code())).eq(ProjectProductRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                this.projectProductRelationDAO.remove((Wrapper)wapper);
                if (projectDTO.getProduct() != null && projectDTO.getProduct().size() != 0) {
                    List<ProductVO> productList = projectDTO.getProduct();
                    for (ProductVO product : productList) {
                        ProjectProductRelation projectProductRelation = new ProjectProductRelation();
                        projectProductRelation.setProject_id(project.getProject_code());
                        projectProductRelation.setProduct_id(product.getProject_code());
                        ((ProjectProductRelationMapper)this.projectProductRelationDAO.getBaseMapper()).insert(projectProductRelation);
                    }
                }
            } else if ("1".equals(projectDTO.getProject_type())) {
                wapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wapper.eq(ProjectProductRelation::getProject_id, (Object)project.getProject_code())).eq(ProjectProductRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                this.projectProductRelationDAO.remove((Wrapper)wapper);
            }
            Project project1 = new Project();
            BeanUtils.copyProperties((Object)projectDTO, (Object)project1);
            project1.setProject_code(project.getProject_code());
            ((ProjectMapper)this.projectDAO.getBaseMapper()).updateById(project1);
            if (projectDTO.getProject_participants() != null) {
                LambdaQueryWrapper relationLambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)relationLambdaQueryWrapper.eq(ProjectEmployeeRelation::getProject_id, (Object)project.getProject_code())).eq(ProjectEmployeeRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                this.projectEmployeeRelationDAO.remove((Wrapper)relationLambdaQueryWrapper);
                List<ProjectEmployeeRelationDTO> projectParticipants = projectDTO.getProject_participants();
                for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectParticipants) {
                    ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                    projectEmployeeRelationDTO.setId(null);
                    BeanUtils.copyProperties((Object)projectEmployeeRelationDTO, (Object)projectEmployeeRelation);
                    projectEmployeeRelation.setProject_id(project.getProject_code());
                    projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                    ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).insert(projectEmployeeRelation);
                }
            }
            ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
            projectEmployeeRelation.setEmployee_no(projectDTO.getProject_leader_id());
            projectEmployeeRelation.setEmployee_role("1");
            projectEmployeeRelation.setProject_id(project.getProject_code());
            projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
            ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).insert(projectEmployeeRelation);
        }
        projectDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), ProjectDTO.class);
        ArrayList projects = new ArrayList();
        for (ProjectDTO projectDTO : projectDTOS) {
            List projectS = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Project::getProject_name, (Object)projectDTO.getProject_code())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            projects.addAll(projectS);
        }
        return projects;
    }

    public List updateProjectStatus(Map map, String status) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        ArrayList<Project> projects = new ArrayList<Project>();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to update");
        }
        List projectDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), ProjectDTO.class);
        for (ProjectDTO projectDTO : projectDTOS) {
            LambdaQueryWrapper queryWrapper = null;
            queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(projectDTO.getProject_code() != null, Project::getProject_code, (Object)projectDTO.getProject_code())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            if (projectDTO.getProject_code() == null) {
                queryWrapper.eq(Project::getProject_name, (Object)projectDTO.getProject_name());
            }
            Project project = new Project();
            project.setManage_status(status);
            queryWrapper.eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            ((ProjectMapper)this.projectDAO.getBaseMapper()).update(project, (Wrapper)queryWrapper);
            Project project1 = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)queryWrapper);
            projects.add(project1);
        }
        return projects;
    }

    @Transactional(rollbackFor={Exception.class})
    public List createProject(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to insert");
        }
        List projectDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), ProjectDTO.class);
        for (ProjectDTO projectDTO : projectDTOs) {
            Project project = new Project();
            BeanUtils.copyProperties((Object)projectDTO, (Object)project);
            project.setManage_status("N");
            ((ProjectMapper)this.projectDAO.getBaseMapper()).insert(project);
            project.setProject_code(project.getId().toString());
            ((ProjectMapper)this.projectDAO.getBaseMapper()).updateById(project);
            if ("1".equals(projectDTO.getProject_type()) && projectDTO.getProject() != null && projectDTO.getProject().getProject_code() != null) {
                Project project1 = projectDTO.getProject();
                ProjectProductRelation projectProductRelation = new ProjectProductRelation();
                projectProductRelation.setProject_id(project1.getProject_code());
                projectProductRelation.setProduct_id(project.getProject_code());
                projectProductRelation.setTenantsid(LoginUserUtils.getTenantSid());
                ((ProjectProductRelationMapper)this.projectProductRelationDAO.getBaseMapper()).insert(projectProductRelation);
            }
            List<ProjectEmployeeRelationDTO> projectParticipants = projectDTO.getProject_participants();
            for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectParticipants) {
                ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                projectEmployeeRelationDTO.setId(null);
                BeanUtils.copyProperties((Object)projectEmployeeRelationDTO, (Object)projectEmployeeRelation);
                projectEmployeeRelation.setProject_id(project.getProject_code());
                projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).insert(projectEmployeeRelation);
            }
            ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
            projectEmployeeRelation.setEmployee_no(projectDTO.getProject_leader_id());
            projectEmployeeRelation.setEmployee_role("1");
            projectEmployeeRelation.setProject_id(project.getProject_code());
            projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
            ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).insert(projectEmployeeRelation);
        }
        List projectDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), ProjectDTO.class);
        ArrayList projects = new ArrayList();
        for (ProjectDTO projectDTO : projectDTOS) {
            List projectS = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Project::getProject_name, (Object)projectDTO.getProject_name())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            projects.addAll(projectS);
        }
        return projects;
    }

    public List<WorkReportDetailVO> queryWorkReportInfo(Map map) throws DWException {
        Employee employee;
        LambdaQueryWrapper employeeLambdaQueryWrapper;
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        List workReportDetailDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetailDTO.class);
        Integer page = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = (Boolean)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page pages = new Page();
        HashMap stringObjectMap = new HashMap();
        ArrayList<String> dateList = new ArrayList<String>();
        List workReportDetailList = null;
        ArrayList<WorkReportDetailVO> workReportDetailVOList = new ArrayList<WorkReportDetailVO>();
        List projectList = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = projectList.stream().collect(Collectors.toMap(a -> a.getProject_code(), b -> b));
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            Object workReportDetail2;
            log.info("id={}", (Object)LoginUserUtils.getTenantSid());
            employeeLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)employeeLambdaQueryWrapper.eq(Employee::getEmail, (Object)workReportDetailDTO.getEmail())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)employeeLambdaQueryWrapper);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            queryWrapper.in(workReportDetailDTO.getReport_date_list() != null, WorkReportDetail::getReport_date, workReportDetailDTO.getReport_date_list());
            queryWrapper.like(StringUtil.isNotEmpty((Object)workReportDetailDTO.getWork_content()), WorkReportDetail::getWork_content, (Object)workReportDetailDTO.getWork_content());
            queryWrapper.eq(StringUtil.isNotEmpty((Object)workReportDetailDTO.getReport_type()), WorkReportDetail::getReport_type, (Object)workReportDetailDTO.getReport_type());
            queryWrapper.eq(StringUtil.isNotEmpty((Object)workReportDetailDTO.getReport_source()), WorkReportDetail::getReport_source, (Object)workReportDetailDTO.getReport_source());
            List workReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
            for (Object workReportDetail2 : workReportDetails) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sf.format(((WorkReportDetail)workReportDetail2).getReport_date());
                dateList.add(format);
            }
            if (StringUtil.isNotEmpty((Object)workReportDetailDTO.getStatus())) {
                queryWrapper.eq(StringUtil.isNotEmpty((Object)workReportDetailDTO.getStatus()), WorkReportDetail::getStatus, (Object)workReportDetailDTO.getStatus());
            } else if (workReportDetailDTO.getSeq() == null) {
                workReportDetailDTO.setStatus("3");
                queryWrapper.eq(WorkReportDetail::getStatus, (Object)"3");
            }
            queryWrapper.eq(workReportDetailDTO.getSeq() != null, WorkReportDetail::getSeq, (Object)workReportDetailDTO.getSeq());
            queryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            workReportDetailList = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
            WorkReportDetailVO workReportDetailVO = null;
            workReportDetail2 = workReportDetailList.iterator();
            while (workReportDetail2.hasNext()) {
                WorkReportDetail reportDetail = (WorkReportDetail)workReportDetail2.next();
                workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties((Object)reportDetail, (Object)workReportDetailVO);
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setFrom_zentao(false);
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)reportDetail.getBelong_project()) && projectMap.containsKey(reportDetail.getBelong_project())) {
                    workReportDetailVO.setBelong_project(reportDetail.getBelong_project());
                    workReportDetailVO.setBelong_project_name(projectMap.get(reportDetail.getBelong_project()).getProject_name());
                } else {
                    workReportDetailVO.setBelong_project_name("");
                    workReportDetailVO.setBelong_project("");
                }
                workReportDetailVOList.add(workReportDetailVO);
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sf.format(reportDetail.getReport_date());
                dateList.add(format);
            }
            if (workReportDetailDTO.getReport_date_list() != null) {
                workReportDetailDTO.getReport_date_list().removeAll(dateList);
            }
            if (!CollectionUtils.isNotEmpty(workReportDetailDTO.getReport_date_list()) || !StringUtils.isNotEmpty(workReportDetailDTO.getStatus()) || !workReportDetailDTO.getStatus().equals("3")) continue;
            ZtUser ztuser = (ZtUser)((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtUser::getEmail, (Object)employee.getEmail())).eq(ZtUser::getDeleted, (Object)"0"));
            if (ztuser == null) {
                log.error("email={}", (Object)employee.getEmail());
                continue;
            }
            LambdaQueryWrapper ztEffortqueryWrapper = new LambdaQueryWrapper();
            ztEffortqueryWrapper.eq(ZtEffort::getAccount, (Object)ztuser.getAccount());
            ztEffortqueryWrapper.in(workReportDetailDTO.getReport_date_list() != null, ZtEffort::getDate, workReportDetailDTO.getReport_date_list());
            ztEffortqueryWrapper.eq(ZtEffort::getDeleted, (Object)"0");
            List ztEfforts = ((ZtEffortMapper)this.ztEffortDAO.getBaseMapper()).selectList((Wrapper)ztEffortqueryWrapper);
            for (ZtEffort ztEffort : ztEfforts) {
                workReportDetailVO = new WorkReportDetailVO();
                if ("task".equals(ztEffort.getObjectType())) {
                    ZtTypeAssociations ztTypeAssociations;
                    ZtTask ztTask = (ZtTask)((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(ZtTask::getId, (Object)ztEffort.getObjectID()));
                    workReportDetailVO.setPlan_hour(new BigDecimal(Float.toString(ztTask.getEstimate().floatValue())).setScale(2, 1));
                    if (ztTask != null && ztTask.getType().length() >= 4 && "spec".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("specification");
                    }
                    if (ztTask != null && ztTask.getType().length() >= 4 && "cult".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("cultivate");
                    }
                    if ((ztTypeAssociations = this.getZtTypeAssociationsByZtTaskType(ztTask.getType())) == null) {
                        log.info("=====not found ztTypeAssociations===>" + ztTask.getType());
                        workReportDetailVO.setReport_type("13");
                    } else {
                        workReportDetailVO.setReport_type(ztTypeAssociations.getType_no());
                    }
                    workReportDetailVO.setReport_source("PROJECT");
                    if (ztTask != null && ztTask.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztTask.getProject());
                        if (projectMap.containsKey("zt_project_" + ztTask.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztTask.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("story".equals(ztEffort.getObjectType())) {
                    ZtStory ztStory = (ZtStory)((ZtStoryMapper)this.ztStoryDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(ZtStory::getId, (Object)ztEffort.getObjectID()));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");
                    if (ztStory != null && ztStory.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztStory.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztStory.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztStory.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("productplan".equals(ztEffort.getObjectType())) {
                    ZtProductplan ztProductplan = (ZtProductplan)((ZtProductplanMapper)this.ztProductplanDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(ZtProductplan::getId, (Object)ztEffort.getObjectID()));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");
                    if (ztProductplan != null && ztProductplan.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztProductplan.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztProductplan.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztProductplan.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("custom".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("OTHER");
                    workReportDetailVO.setReport_type("16");
                } else if ("bug".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("7");
                    if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());
                        if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("feedback".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_type("18");
                    workReportDetailVO.setReport_source("PROJECT");
                    if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());
                        if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                        }
                    } else if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)ztEffort.getProduct()) && !",,".equals(ztEffort.getProduct())) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1]);
                        if (projectMap.containsKey("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1])) {
                            String projectName = projectMap.get("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1]).getProject_name();
                            workReportDetailVO.setBelong_project_name(projectName);
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                }
                workReportDetailVO.setZentao_effort_id(ztEffort.getId().toString());
                workReportDetailVO.setEmployee_no(employee.getEmployee_no());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setReport_date(ztEffort.getDate());
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setFrom_zentao(true);
                workReportDetailVO.setActual_hour(new BigDecimal(Float.toString(ztEffort.getConsumed().floatValue())).setScale(2, 1));
                workReportDetailVO.setUnfinished_hour(new BigDecimal(Float.toString(ztEffort.getLeft().floatValue())).setScale(2, 1));
                workReportDetailVO.setWork_content(ztEffort.getWork());
                workReportDetailVO.setStatus("3");
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sf.format(workReportDetailVO.getReport_date());
                dateList.add(format);
                if (workReportDetailDTO.getReport_date_list() != null) {
                    workReportDetailDTO.getReport_date_list().removeAll(dateList);
                }
                workReportDetailVOList.add(workReportDetailVO);
            }
        }
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            log.info("id={}", (Object)LoginUserUtils.getTenantSid());
            employeeLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)employeeLambdaQueryWrapper.eq(Employee::getEmail, (Object)workReportDetailDTO.getEmail())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)employeeLambdaQueryWrapper);
            List<String> reportDateList = workReportDetailDTO.getReport_date_list();
            for (String date : reportDateList) {
                LambdaQueryWrapper allqw = new LambdaQueryWrapper();
                allqw.eq(workReportDetailDTO.getReport_date_list() != null, WorkReportDetail::getReport_date, (Object)date);
                ((LambdaQueryWrapper)allqw.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                List workReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)allqw);
                if (!"3".equals(workReportDetailDTO.getStatus()) || workReportDetails != null && workReportDetails.size() != 0 || CollectionUtils.isNotEmpty((Collection)workReportDetails)) continue;
                WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties((Object)workReportDetailDTO, (Object)workReportDetailVO);
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date parse = ft.parse(date);
                    workReportDetailVO.setReport_date(parse);
                }
                catch (Exception e) {
                    log.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
                }
                StringUtils.noNullStringAttr(workReportDetailVO);
                workReportDetailVOList.add(workReportDetailVO);
            }
        }
        if (use_has_next == null || !use_has_next.booleanValue() && workReportDetailVOList != null && !workReportDetailVOList.isEmpty()) {
            return workReportDetailVOList;
        }
        int startIndex = (page - 1) * size;
        int endIndex = Math.min(startIndex + size, workReportDetailVOList.size());
        List<WorkReportDetailVO> pagelist = workReportDetailVOList.subList(startIndex, endIndex);
        return pagelist;
    }

    private Employee getEmployeeByEmail(String email) {
        Long tenantSid = LoginUserUtils.getTenantSid();
        log.info("id={}", (Object)tenantSid);
        LambdaQueryWrapper employeeLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)employeeLambdaQueryWrapper.eq(Employee::getEmail, (Object)email)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(Employee::getStatus, (Object)"Y");
        return (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)employeeLambdaQueryWrapper);
    }

    private ZtTypeAssociations getZtTypeAssociationsByZtTaskType(String type) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ZtTypeAssociations::getZt_report_type, (Object)type);
        return (ZtTypeAssociations)((ZtTypeAssociationsMapper)this.ztTypeAssociationsDAO.getBaseMapper()).selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Transactional
    public List CreateOrUpdateWorkReportInfo(Map map, String status) throws DWException, ParseException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        ArrayList<WorkReportDetailVO> workReportDetailS = new ArrayList<WorkReportDetailVO>();
        WorkReportDetail getWorkReportDetail = new WorkReportDetail();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to create or update");
        }
        List workReportDetailDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetailDTO.class);
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));
        for (WorkReportDetailDTO workReportDetail : workReportDetailDTOs) {
            LambdaQueryWrapper employeeQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)employeeQueryWrapper.eq(StringUtil.isNotEmpty((Object)workReportDetail.getEmail()), Employee::getEmail, (Object)workReportDetail.getEmail())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            Employee employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)employeeQueryWrapper);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getSeq, (Object)workReportDetail.getSeq())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            getWorkReportDetail = (WorkReportDetail)((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectOne((Wrapper)queryWrapper);
            workReportDetail.setEmployee_no(employee.getEmployee_no());
            WorkReportDetail workReportDetail1 = new WorkReportDetail();
            workReportDetail1.setZentao_effort_id(workReportDetail.getZentao_effort_id());
            BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetail1);
            workReportDetail1.setTenantsid(LoginUserUtils.getTenantSid());
            if (workReportDetail.getReport_date() == null) {
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date parse = ft.parse(workReportDetail.getReport_date_list().get(0));
                workReportDetail1.setReport_date(parse);
            }
            workReportDetail1.setStatus(status);
            if (getWorkReportDetail == null) {
                ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).insert(workReportDetail1);
                workReportDetail1.setSeq(workReportDetail1.getId().intValue());
                ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).updateById(workReportDetail1);
                getWorkReportDetail = (WorkReportDetail)this.workReportDetailDAO.getById(workReportDetail1.getId());
            } else {
                ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).update(workReportDetail1, (Wrapper)queryWrapper);
                getWorkReportDetail = (WorkReportDetail)((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectOne((Wrapper)queryWrapper);
            }
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties((Object)getWorkReportDetail, (Object)workReportDetailVO);
            if (projectHashMap.containsKey(getWorkReportDetail.getBelong_project())) {
                Project project2 = projectHashMap.get(workReportDetailVO.getBelong_project());
                workReportDetailVO.setBelong_project_name(project2.getProject_name());
                workReportDetailVO.setBelong_project(StringUtils.isNotEmpty(workReportDetail.getBelong_project()) ? workReportDetail.getBelong_project() : "");
            } else {
                workReportDetailVO.setBelong_project_name("");
                workReportDetailVO.setBelong_project("");
            }
            workReportDetailS.add(workReportDetailVO);
        }
        return workReportDetailS;
    }

    public List deleteWorkReportInfo(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("data is empty");
        }
        List workReportDetails = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetail.class);
        workReportDetails.stream().forEach(workReportDetail -> ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).delete((Wrapper)new LambdaQueryWrapper().eq(WorkReportDetail::getSeq, (Object)workReportDetail.getSeq())));
        return null;
    }

    public List<WorkReportDetailVO> auditWorkReportInfo(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_infos");
        ArrayList<WorkReportDetailVO> returnWorkReportDetail = new ArrayList<WorkReportDetailVO>();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("data is empty");
        }
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));
        List auditWorkReportVOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), AuditWorkReportVO.class);
        for (AuditWorkReportVO auditWorkReportVO : auditWorkReportVOS) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ArrayList<WorkReportDetail> updateWorkReportDetails = new ArrayList<WorkReportDetail>();
            for (WorkReportDetailVO workReportDetailVO : auditWorkReportVO.getWork_report_info()) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.eq(WorkReportDetail::getSeq, (Object)workReportDetailVO.getSeq())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                WorkReportDetail updateWorkReport = new WorkReportDetail();
                updateWorkReport.setId(workReportDetailVO.getId());
                ids.add(workReportDetailVO.getId());
                updateWorkReport.setAudit_opinion(workReportDetailVO.getAudit_opinion());
                updateWorkReport.setStatus(workReportDetailVO.getStatus());
                if ("2".equals(workReportDetailVO.getStatus())) {
                    updateWorkReport.setTask_id("");
                }
                updateWorkReportDetails.add(updateWorkReport);
            }
            this.workReportDetailDAO.updateBatchById(updateWorkReportDetails);
            List returnWorkReportDetails = new ArrayList();
            if (!CollectionUtils.isEmpty(ids)) {
                returnWorkReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().in(WorkReportDetail::getId, ids));
            }
            for (WorkReportDetail workReportDetail : returnWorkReportDetails) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)lambdaQueryWrapper.eq(Employee::getEmployee_no, (Object)workReportDetail.getEmployee_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                Employee employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)lambdaQueryWrapper);
                WorkReportDetailVO workReportDetailVO1 = new WorkReportDetailVO();
                BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetailVO1);
                if (projectHashMap.containsKey(workReportDetail.getBelong_project())) {
                    Project project2 = projectHashMap.get(workReportDetailVO1.getBelong_project());
                    workReportDetailVO1.setBelong_project_name(project2.getProject_name());
                    workReportDetailVO1.setBelong_project(!com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)workReportDetail.getBelong_project()) ? workReportDetailVO1.getBelong_project() : "");
                } else {
                    workReportDetailVO1.setBelong_project_name("");
                    workReportDetailVO1.setBelong_project("");
                }
                workReportDetailVO1.setEmail(employee.getEmail());
                returnWorkReportDetail.add(workReportDetailVO1);
            }
        }
        return returnWorkReportDetail;
    }

    public List queryNeedAuditWorkReportInfo(Map map) throws Exception {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_infos");
        List workReportDetailDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetailDTO.class);
        return this.needAuditWorkReportInfo(workReportDetailDTOs);
    }

    private List needAuditWorkReportInfo(List<WorkReportDetailDTO> workReportDetailDTOs) throws DWException, ParseException {
        Employee employee;
        ArrayList<WorkReportDetailVO> returnWorkReportDetailVOs = new ArrayList<WorkReportDetailVO>();
        ArrayList returnWorkReportDetails = new ArrayList();
        ArrayList<AuditWorkReportVO> auditWorkReportVOS = new ArrayList<AuditWorkReportVO>();
        ArrayList<WorkReportDetailVO> workReportDetailVOS = new ArrayList<WorkReportDetailVO>();
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WorkReportDetail::getTask_id, (Object)workReportDetailDTO.getTask_id())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            List taskS = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)taskS)) {
                ArrayList<Object> workReportDetails = new ArrayList<Object>();
                for (Object workReportDetail : taskS) {
                    if ("N".equals(workReportDetailDTO.getReport_status()) && "0".equals(((WorkReportDetail)workReportDetail).getStatus())) {
                        workReportDetails.add(workReportDetail);
                        continue;
                    }
                    if (!"Y".equals(workReportDetailDTO.getReport_status()) || !"1".equals(((WorkReportDetail)workReportDetail).getStatus()) && !"2".equals(((WorkReportDetail)workReportDetail).getStatus())) continue;
                    workReportDetails.add(workReportDetail);
                }
                for (Object workReportDetail : workReportDetails) {
                    WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
                    BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetailVO);
                    if (projectHashMap.containsKey(((WorkReportDetail)workReportDetail).getBelong_project())) {
                        Project project2 = projectHashMap.get(((WorkReportDetail)workReportDetail).getBelong_project());
                        workReportDetailVO.setBelong_project_name(project2.getProject_name());
                        workReportDetailVO.setBelong_project(StringUtil.isNotEmpty((Object)((WorkReportDetail)workReportDetail).getBelong_project()) ? ((WorkReportDetail)workReportDetail).getBelong_project() : "");
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                    employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmployee_no, (Object)((WorkReportDetail)workReportDetail).getEmployee_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                    workReportDetailVO.setEmail(employee.getEmail());
                    workReportDetailVO.setEmployee_name(employee.getEmployee_name());
                    workReportDetailVOS.add(workReportDetailVO);
                }
            } else {
                Object workReportDetail;
                Employee employee1 = this.getEmployeeByEmail(workReportDetailDTO.getEmail());
                List employees1 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getApproval_no, (Object)employee1.getEmployee_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                workReportDetail = employees1.iterator();
                while (workReportDetail.hasNext()) {
                    Employee employee2 = (Employee)workReportDetail.next();
                    this.getWorkReportDetailVO(workReportDetailDTO, employee2, workReportDetailVOS);
                }
                returnWorkReportDetailVOs.addAll(workReportDetailVOS);
                workReportDetailVOS.clear();
                List organizationS = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Organization::getOrg_supervisor_id, (Object)employee1.getEmployee_no())).eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                organizationS.forEach(organization -> {
                    List employees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Employee::getOrg_no, (Object)organization.getOrg_no())).and(wrapper -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(Employee::getApproval_no)).or()).eq(Employee::getApproval_no, (Object)"");
                    })).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                    for (Employee employee : employees) {
                        this.getWorkReportDetailVO(workReportDetailDTO, employee, workReportDetailVOS);
                    }
                });
            }
            returnWorkReportDetailVOs.addAll(workReportDetailVOS);
        }
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        String reportStatus = null;
        HashMap classifiedReport = new HashMap();
        for (WorkReportDetailVO report : returnWorkReportDetailVOs) {
            String employee_no = report.getEmployee_no();
            String date = outputFormat.format(report.getReport_date());
            String status = report.getStatus();
            if (status.equals("0")) {
                reportStatus = "N";
            } else if (status.equals("1") || status.equals("2")) {
                reportStatus = "Y";
            }
            if (!classifiedReport.containsKey(employee_no)) {
                classifiedReport.put(employee_no, new HashMap());
            }
            if (!((Map)classifiedReport.get(employee_no)).containsKey(date)) {
                ((Map)classifiedReport.get(employee_no)).put(date, new ArrayList());
            }
            ((List)((Map)classifiedReport.get(employee_no)).get(date)).add(report);
        }
        for (String employee_no : classifiedReport.keySet()) {
            for (String date : ((Map)classifiedReport.get(employee_no)).keySet()) {
                AuditWorkReportVO entry = new AuditWorkReportVO();
                employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmployee_no, (Object)employee_no)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                entry.setEmployee_name(employee.getEmployee_name());
                entry.setEmployee_no(employee_no);
                entry.setReport_date(date);
                entry.setReport_status(reportStatus);
                entry.setWork_report_info((List)((Map)classifiedReport.get(employee_no)).get(date));
                auditWorkReportVOS.add(entry);
            }
        }
        return auditWorkReportVOS;
    }

    private List<WorkReportDetailVO> getWorkReportDetailVO(WorkReportDetailDTO workReportDetailDTO, Employee employee, List<WorkReportDetailVO> workReportDetailVOS) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WorkReportDetail::getTask_id, (Object)workReportDetailDTO.getTask_id())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List taskS = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(WorkReportDetail::getTask_id)).or()).eq(WorkReportDetail::getTask_id, (Object)"");
        })).eq(WorkReportDetail::getStatus, (Object)"0")).eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List workReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
        for (WorkReportDetail workReportDetail : workReportDetails) {
            workReportDetail.setTask_id(workReportDetailDTO.getTask_id());
            this.workReportDetailDAO.updateById(workReportDetail);
        }
        lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no());
        lambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        if ("Y".equals(workReportDetailDTO.getReport_status())) {
            ArrayList<String> status = new ArrayList<String>();
            status.add("1");
            status.add("2");
            lambdaQueryWrapper.in(WorkReportDetail::getStatus, status);
            lambdaQueryWrapper.eq(StringUtils.isNotEmpty(workReportDetailDTO.getTask_id()), WorkReportDetail::getTask_id, (Object)workReportDetailDTO.getTask_id());
        } else if ("N".equals(workReportDetailDTO.getReport_status())) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WorkReportDetail::getStatus, (Object)"0")).eq(WorkReportDetail::getTask_id, (Object)workReportDetailDTO.getTask_id());
        }
        List workReportDetailS = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)lambdaQueryWrapper);
        for (WorkReportDetail workReportDetail : workReportDetailS) {
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetailVO);
            Project project = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)workReportDetail.getBelong_project())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            if (project != null) {
                workReportDetailVO.setBelong_project_name(project.getProject_name());
                workReportDetailVO.setBelong_project(StringUtil.isNotEmpty((Object)workReportDetail.getBelong_project()) ? workReportDetail.getBelong_project() : "");
            } else {
                workReportDetailVO.setBelong_project_name("");
                workReportDetailVO.setBelong_project("");
            }
            workReportDetailVO.setEmail(employee.getEmail());
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVOS.add(workReportDetailVO);
        }
        return workReportDetailVOS;
    }

    public List<WorkReportDetail> getWarningWorkReportInfo(Map map) {
        return null;
    }

    public List<Employee> getApproverInfo(Map map) throws DWException {
        ArrayList<Employee> employees = new ArrayList<Employee>();
        ArrayList workReportDetails = new ArrayList();
        List emp_nos = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.isNotNull(Employee::getApproval_no)).ne(Employee::getApproval_no, (Object)"");
        })).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map approvalMap = emp_nos.stream().collect(Collectors.groupingBy(Employee::getApproval_no, Collectors.mapping(Employee::getEmployee_no, Collectors.toList())));
        ArrayList<String> approval_nos = new ArrayList<String>(approvalMap.keySet());
        List approvals = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Employee::getEmployee_no, approval_nos)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        List approvals_deport = approvals.stream().filter(employee -> "N".equals(employee.getStatus())).collect(Collectors.toList());
        List approval_nos_deport = approvals_deport.stream().map(employee -> employee.getEmployee_no()).collect(Collectors.toList());
        for (String string : approvalMap.keySet()) {
            LambdaQueryWrapper workReportDetailLambdaQueryWrapper = new LambdaQueryWrapper();
            workReportDetailLambdaQueryWrapper.in(WorkReportDetail::getEmployee_no, (Collection)approvalMap.get(string));
            workReportDetailLambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            workReportDetailLambdaQueryWrapper.eq(WorkReportDetail::getStatus, (Object)"0");
            workReportDetailLambdaQueryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(WorkReportDetail::getTask_id)).or()).eq(WorkReportDetail::getTask_id, (Object)"");
            });
            Long aLong = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectCount((Wrapper)workReportDetailLambdaQueryWrapper);
            if (aLong <= 0L) continue;
            LambdaQueryWrapper employeeLambdaQueryWrapper = new LambdaQueryWrapper();
            Employee employee2 = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)employeeLambdaQueryWrapper.eq(Employee::getEmployee_no, (Object)string)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            employees.add(employee2);
        }
        List organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        for (Organization organization : organizations) {
            List employeeList = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Employee::getOrg_no, (Object)organization.getOrg_no())).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(Employee::getApproval_no)).or()).eq(Employee::getApproval_no, (Object)"")).or()).in(CollectionUtils.isNotEmpty((Collection)approval_nos_deport), Employee::getApproval_no, (Collection)approval_nos_deport);
            })).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            workReportDetails = new ArrayList();
            ArrayList<String> emp_noList = new ArrayList<String>();
            for (Employee allEmployee : employeeList) {
                emp_noList.add(allEmployee.getEmployee_no());
            }
            lambdaQueryWrapper = new LambdaQueryWrapper();
            if (emp_noList == null || emp_noList.size() == 0) continue;
            lambdaQueryWrapper.in(WorkReportDetail::getEmployee_no, emp_noList);
            lambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            lambdaQueryWrapper.eq(WorkReportDetail::getStatus, (Object)"0");
            lambdaQueryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(WorkReportDetail::getTask_id)).or()).eq(WorkReportDetail::getTask_id, (Object)"");
            });
            Long aLong = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectCount((Wrapper)lambdaQueryWrapper);
            if (aLong <= 0L) continue;
            LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmployee_no, (Object)organization.getOrg_supervisor_id())).eq(Employee::getStatus, (Object)"Y")).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            Employee employee3 = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)eq);
            if (employee3 == null) continue;
            employees.add(employee3);
        }
        List<Employee> list = employees.stream().distinct().filter(employee -> "Y".equals(employee.getStatus())).collect(Collectors.toList());
        return list;
    }

    public List getWorkReportByStatus(Map map) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        List workReportDetailDTOs = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetailDTO.class);
        List workReportDetailList = null;
        ArrayList<WorkReportDetailVO> workReportDetailVOList = new ArrayList<WorkReportDetailVO>();
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            Employee employee = this.getEmployeeByEmail(workReportDetailDTO.getEmail());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            queryWrapper.eq(workReportDetailDTO.getReport_date() != null, WorkReportDetail::getReport_date, (Object)workReportDetailDTO.getReport_date());
            queryWrapper.eq(WorkReportDetail::getStatus, (Object)workReportDetailDTO.getStatus());
            queryWrapper.eq(workReportDetailDTO.getSeq() != null, WorkReportDetail::getSeq, (Object)workReportDetailDTO.getSeq());
            queryWrapper.orderByDesc(WorkReportDetail::getUpdate_time);
            queryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            workReportDetailList = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
            WorkReportDetailVO workReportDetailVO = null;
            for (WorkReportDetail reportDetail : workReportDetailList) {
                workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties((Object)reportDetail, (Object)workReportDetailVO);
                if (projectHashMap.containsKey(reportDetail.getBelong_project())) {
                    Project project2 = projectHashMap.get(reportDetail.getBelong_project());
                    workReportDetailVO.setBelong_project_name(project2.getProject_name());
                    workReportDetailVO.setBelong_project(project2.getProject_code());
                } else {
                    workReportDetailVO.setBelong_project_name("");
                    workReportDetailVO.setBelong_project("");
                }
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setFrom_zentao(reportDetail.getFrom_zentao());
                workReportDetailVOList.add(workReportDetailVO);
            }
        }
        return workReportDetailVOList;
    }

    public Map<String, Object> getHistoryWorkReport(Map map) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        Integer page = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = (Integer)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = (Boolean)jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List ztTypeAssociations = ((ZtTypeAssociationsMapper)this.ztTypeAssociationsDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper());
        HashMap<String, String> stringZtTypeAssociationsMap = new HashMap<String, String>();
        for (ZtTypeAssociations ztTypeAssociation : ztTypeAssociations) {
            stringZtTypeAssociationsMap.put(ztTypeAssociation.getType_no(), ztTypeAssociation.getReport_type());
        }
        LambdaQueryWrapper getEmployee = new LambdaQueryWrapper();
        ArrayList workReportDetails = new ArrayList();
        String sql = "";
        queryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        if (jsonArray != null && jsonArray.size() != 0) {
            List searchDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), SearchDTO.class);
            sql = sql + "(";
            block19: for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {
                    case "email": {
                        LambdaQueryWrapper employeeLambdaQueryWrapper = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)employeeLambdaQueryWrapper.like(Employee::getEmail, (Object)searchDTO.getSearch_value().get(0))).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employees2 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)employeeLambdaQueryWrapper);
                        ArrayList<String> listx = new ArrayList<String>();
                        if (CollectionUtils.isNotEmpty((Collection)employees2)) {
                            for (Employee emp : employees2) {
                                listx.add(emp.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(listx);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        listx.add("000000");
                        searchDTO.setSearch_value(listx);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                    case "employee_name": {
                        getEmployee = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Employee::getEmployee_name, (Object)searchDTO.getSearch_value().get(0))).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employee2 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)getEmployee);
                        ArrayList<String> list = new ArrayList<String>();
                        if (CollectionUtils.isNotEmpty((Collection)employee2)) {
                            for (Employee emp : employee2) {
                                list.add(emp.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(list);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        list.add("000000");
                        searchDTO.setSearch_value(list);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                    case "org_no": {
                        getEmployee = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Employee::getOrg_no, (Object)searchDTO.getSearch_value().get(0))).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)getEmployee);
                        if (CollectionUtils.isNotEmpty((Collection)employees)) {
                            ArrayList<String> strings = new ArrayList<String>();
                            for (Employee employee1 : employees) {
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        ArrayList<String> list1 = new ArrayList<String>();
                        list1.add("000000");
                        searchDTO.setSearch_value(list1);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                    case "org_name": {
                        Employee employee1;
                        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Organization::getOrg_name, (Object)searchDTO.getSearch_value().get(0))).eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List organizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)eq);
                        ArrayList<String> strings1 = new ArrayList<String>();
                        if (CollectionUtils.isNotEmpty((Collection)organizations)) {
                            for (Organization organization : organizations) {
                                getEmployee = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getOrg_no, (Object)organization.getOrg_no())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                                List employees1 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)getEmployee);
                                Iterator iterator = employees1.iterator();
                                while (iterator.hasNext()) {
                                    employee1 = (Employee)iterator.next();
                                    strings1.add(employee1.getEmployee_no());
                                }
                            }
                        }
                        if (CollectionUtils.isNotEmpty(strings1)) {
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings1);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        ArrayList<String> list2 = new ArrayList<String>();
                        list2.add("000000");
                        searchDTO.setSearch_value(list2);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                    case "belong_project_name": {
                        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Project::getProject_name, (Object)searchDTO.getSearch_value().get(0))).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                        if (CollectionUtils.isNotEmpty((Collection)projects)) {
                            ArrayList<String> strings = new ArrayList<String>();
                            for (Object project : projects) {
                                strings.add(((Project)project).getProject_code());
                            }
                            searchDTO.setSearch_field("belong_project");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                    }
                    case "approval_no": {
                        Employee employee1;
                        getEmployee = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getApproval_no, (Object)searchDTO.getSearch_value().get(0))).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employees1 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)getEmployee);
                        if (CollectionUtils.isNotEmpty((Collection)employees1)) {
                            Object project;
                            ArrayList<String> strings = new ArrayList<String>();
                            project = employees1.iterator();
                            while (project.hasNext()) {
                                employee1 = (Employee)project.next();
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        ArrayList<String> list1 = new ArrayList<String>();
                        list1.add("000000");
                        searchDTO.setSearch_value(list1);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                    case "approval_name": {
                        List employees11 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Employee::getEmployee_name, (Object)searchDTO.getSearch_value().get(0))).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                        List collect = employees11.stream().map(e -> e.getEmployee_no()).collect(Collectors.toList());
                        getEmployee = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Employee::getApproval_no, collect)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                        List employees3 = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)getEmployee);
                        if (CollectionUtils.isNotEmpty((Collection)employees3)) {
                            ArrayList<String> strings = new ArrayList<String>();
                            for (Employee employee1 : employees3) {
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + StringUtils.builderSQL(searchDTO, sql);
                            continue block19;
                        }
                        searchDTO.setSearch_field("employee_no");
                        ArrayList<String> list1 = new ArrayList<String>();
                        list1.add("000000");
                        searchDTO.setSearch_value(list1);
                        sql = sql + StringUtils.builderSQL(searchDTO, sql);
                        continue block19;
                    }
                }
                sql = sql + StringUtils.builderSQL(searchDTO, sql);
            }
            sql = sql + ")";
            queryWrapper.apply(sql, new Object[0]);
        }
        List workReportDetailS = null;
        if (use_has_next != null && use_has_next.booleanValue()) {
            Page workReportDetailPage = (Page)((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)queryWrapper);
            workReportDetailS = workReportDetailPage.getRecords();
            stringObjectMap.put("total_results", workReportDetailPage.getTotal());
            stringObjectMap.put("has_next", workReportDetailPage.hasNext());
        } else {
            workReportDetailS = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
        }
        List pagelist = workReportDetailS;
        ArrayList<WorkReportDetailVO> workReportDetailVOS = new ArrayList<WorkReportDetailVO>();
        List employeeList = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Employee> employeeMap = employeeList.stream().collect(Collectors.toMap(a -> a.getEmployee_no(), a -> a));
        List organizationList = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Organization> organizationMap = organizationList.stream().collect(Collectors.toMap(a -> a.getOrg_no(), a -> a));
        for (WorkReportDetail workReportDetail : pagelist) {
            Project project;
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetailVO);
            Employee employee = employeeMap.get(workReportDetail.getEmployee_no());
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVO.setEmail(employee.getEmail());
            workReportDetailVO.setTitle(employee.getTitle());
            workReportDetailVO.setReport_type((String)stringZtTypeAssociationsMap.get(workReportDetailVO.getReport_type()));
            workReportDetailVO.setOrg_no(employee.getOrg_no());
            workReportDetailVO.setOrg_name(organizationMap.get(employee.getOrg_no()).getOrg_name());
            workReportDetailVO.setApproval_no(employeeMap.containsKey(employee.getApproval_no()) ? employeeMap.get(employee.getApproval_no()).getEmployee_no() : "");
            workReportDetailVO.setApproval_name(employeeMap.containsKey(employee.getApproval_no()) ? employeeMap.get(employee.getApproval_no()).getEmployee_name() : "");
            Organization organization = (Organization)((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Organization::getOrg_no, (Object)employee.getOrg_no())).eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            workReportDetailVO.setOrg_name(organization.getOrg_name());
            if (StringUtil.isNotEmpty((Object)workReportDetail.getBelong_project()) && (project = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)workReportDetail.getBelong_project())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                workReportDetailVO.setBelong_project_name(project.getProject_name());
            }
            workReportDetailVOS.add(workReportDetailVO);
        }
        stringObjectMap.put("work_report_info", workReportDetailVOS);
        return stringObjectMap;
    }

    @Transactional
    public void updateZtProduct() {
        ArrayList<Project> projectList = new ArrayList<Project>();
        ArrayList<ProjectEmployeeRelation> projectEmployeeRelationList = new ArrayList<ProjectEmployeeRelation>();
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        HashMap<String, Project> projectMap = new HashMap<String, Project>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProjectEmployeeRelation::getEmployee_role, (Object)"1")).eq(ProjectEmployeeRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List projectEmployeeRelations = ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
        HashMap<String, ProjectEmployeeRelation> projectEmployeeRelationMap = new HashMap<String, ProjectEmployeeRelation>();
        for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelations) {
            projectEmployeeRelationMap.put(projectEmployeeRelation.getProject_id(), projectEmployeeRelation);
        }
        List ztProducts = ((ZtProductMapper)this.ztProductDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper());
        for (ZtProduct ztProduct : ztProducts) {
            Employee employee;
            ZtUser ztUser;
            Project project = new Project();
            project.setProject_code("zt_product_" + ztProduct.getId());
            project.setProject_name(ztProduct.getName());
            project.setProject_type("1");
            switch (ztProduct.getStatus()) {
                case "normal": {
                    project.setManage_status("Y");
                    break;
                }
                case "closed": {
                    project.setManage_status("V");
                }
            }
            if (projectMap.containsKey(project.getProject_code())) {
                project.setId(((Project)projectMap.get(project.getProject_code())).getId());
            }
            projectList.add(project);
            projectMap.put(project.getProject_code(), project);
            if (projectList.size() % 1000 == 0) {
                this.projectDAO.saveOrUpdateBatch(projectList);
                projectList.clear();
            }
            if (!StringUtil.isNotEmpty((Object)ztProduct.getPo()) || (ztUser = (ZtUser)((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtUser::getAccount, (Object)ztProduct.getPo())).eq(ZtUser::getDeleted, (Object)"0"))) == null || (employee = this.getEmployeeByEmail(ztUser.getEmail())) == null) continue;
            ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
            projectEmployeeRelation.setProject_id(project.getProject_code());
            projectEmployeeRelation.setEmployee_no(employee.getEmployee_no());
            projectEmployeeRelation.setEmployee_role("1");
            if (projectEmployeeRelationMap.containsKey(project.getProject_code())) {
                projectEmployeeRelation.setId(((ProjectEmployeeRelation)projectEmployeeRelationMap.get(project.getProject_code())).getId());
            }
            projectEmployeeRelationList.add(projectEmployeeRelation);
            if (projectEmployeeRelationList.size() % 500 != 0) continue;
            this.projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();
        }
        if (!projectList.isEmpty()) {
            this.projectDAO.saveOrUpdateBatch(projectList);
            projectList.clear();
        }
        if (!projectEmployeeRelationList.isEmpty()) {
            this.projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();
        }
    }

    @Transactional
    public void updateZtProject() {
        ArrayList<Project> projectList = new ArrayList<Project>();
        ArrayList<ProjectEmployeeRelation> projectEmployeeRelationList = new ArrayList<ProjectEmployeeRelation>();
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        HashMap<String, Project> projectMap = new HashMap<String, Project>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProjectEmployeeRelation::getEmployee_role, (Object)"1")).eq(ProjectEmployeeRelation::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List projectEmployeeRelations = ((ProjectEmployeeRelationMapper)this.projectEmployeeRelationDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
        HashMap<String, ProjectEmployeeRelation> projectEmployeeRelationMap = new HashMap<String, ProjectEmployeeRelation>();
        for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelations) {
            projectEmployeeRelationMap.put(projectEmployeeRelation.getProject_id(), projectEmployeeRelation);
        }
        List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper());
        for (ZtProject ztProject : ztProjects) {
            Employee employee;
            ZtUser ztUser;
            Project project = new Project();
            project.setProject_code("zt_project_" + ztProject.getId());
            project.setProject_name(ztProject.getName());
            project.setProject_type("2");
            switch (ztProject.getStatus()) {
                case "wait": 
                case "pause": 
                case "cancel": {
                    project.setManage_status("N");
                    break;
                }
                case "doing": {
                    project.setManage_status("Y");
                    break;
                }
                case "done": 
                case "closed": {
                    project.setManage_status("V");
                }
            }
            if (projectMap.containsKey(project.getProject_code())) {
                project.setId(((Project)projectMap.get(project.getProject_code())).getId());
            }
            projectList.add(project);
            projectMap.put(project.getProject_code(), project);
            if (projectList.size() % 1000 == 0) {
                this.projectDAO.saveOrUpdateBatch(projectList);
                projectList.clear();
            }
            if (!StringUtil.isNotEmpty((Object)ztProject.getPo()) || (ztUser = (ZtUser)((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtUser::getAccount, (Object)ztProject.getPo())).eq(ZtUser::getDeleted, (Object)"0"))) == null || (employee = this.getEmployeeByEmail(ztUser.getEmail())) == null) continue;
            ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
            projectEmployeeRelation.setProject_id(project.getProject_code());
            projectEmployeeRelation.setEmployee_no(employee.getEmployee_no());
            projectEmployeeRelation.setEmployee_role("1");
            if (projectEmployeeRelationMap.containsKey(project.getProject_code())) {
                projectEmployeeRelation.setId(((ProjectEmployeeRelation)projectEmployeeRelationMap.get(project.getProject_code())).getId());
            }
            projectEmployeeRelationList.add(projectEmployeeRelation);
            if (projectEmployeeRelationList.size() % 500 != 0) continue;
            this.projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();
        }
        if (!projectList.isEmpty()) {
            this.projectDAO.saveOrUpdateBatch(projectList);
            projectList.clear();
        }
        if (!projectEmployeeRelationList.isEmpty()) {
            this.projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();
        }
    }

    @Transactional
    public List getZtWorkReport(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("zentao_work_report");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        WorkReportDetailVO workReportDetailVO = null;
        ArrayList<WorkReportDetailVO> workReportDetailVOList = new ArrayList<WorkReportDetailVO>();
        List workReportDetailDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), WorkReportDetailDTO.class);
        List projectList = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = projectList.stream().collect(Collectors.toMap(a -> a.getProject_code(), b -> b));
        for (WorkReportDetailDTO reportDetailDTO : workReportDetailDTOS) {
            Project project;
            WorkReportDetailVO workVO1;
            Employee employee = this.getEmployeeByEmail(reportDetailDTO.getEmail());
            ZtUser ztuser = (ZtUser)((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtUser::getEmail, (Object)reportDetailDTO.getEmail())).eq(ZtUser::getDeleted, (Object)"0"));
            LambdaQueryWrapper ztEffortqueryWrapper = new LambdaQueryWrapper();
            ztEffortqueryWrapper.eq(ZtEffort::getAccount, (Object)ztuser.getAccount());
            ztEffortqueryWrapper.in(reportDetailDTO.getReport_date_list() != null, ZtEffort::getDate, reportDetailDTO.getReport_date_list());
            ztEffortqueryWrapper.eq(ZtEffort::getDeleted, (Object)"0");
            List ztEfforts = ((ZtEffortMapper)this.ztEffortDAO.getBaseMapper()).selectList((Wrapper)ztEffortqueryWrapper);
            for (ZtEffort ztEffort : ztEfforts) {
                workReportDetailVO = new WorkReportDetailVO();
                if ("task".equals(ztEffort.getObjectType())) {
                    ZtTask ztTask = (ZtTask)((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(ZtTask::getId, (Object)ztEffort.getObjectID()));
                    workReportDetailVO.setPlan_hour(new BigDecimal(Float.toString(ztTask.getEstimate().floatValue())).setScale(2, 1));
                    if (ztTask != null && ztTask.getType().length() >= 4 && "spec".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("specification");
                    }
                    if (ztTask != null && ztTask.getType().length() >= 4 && "cult".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("cultivate");
                    }
                    ZtTypeAssociations ztTypeAssociations = this.getZtTypeAssociationsByZtTaskType(ztTask.getType());
                    workReportDetailVO.setReport_type(ztTypeAssociations.getType_no());
                    workReportDetailVO.setReport_source("PROJECT");
                    if (ztTask != null && ztTask.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztTask.getProject());
                        if (projectMap.containsKey("zt_project_" + ztTask.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztTask.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("story".equals(ztEffort.getObjectType())) {
                    ZtStory ztStory = (ZtStory)((ZtStoryMapper)this.ztStoryDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ZtStory::getId, (Object)ztEffort.getObjectID())).eq(ZtStory::getDeleted, (Object)"0"));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");
                    if (ztStory != null && ztStory.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztStory.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztStory.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztStory.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("productplan".equals(ztEffort.getObjectType())) {
                    ZtProductplan ztProductplan = (ZtProductplan)((ZtProductplanMapper)this.ztProductplanDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ZtProductplan::getId, (Object)ztEffort.getObjectID())).eq(ZtProductplan::getDeleted, (Object)"0"));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");
                    if (ztProductplan != null && ztProductplan.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztProductplan.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztProductplan.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztProductplan.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("custom".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("OTHER");
                    workReportDetailVO.setReport_type("16");
                } else if ("bug".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("7");
                    if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());
                        if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                }
                workReportDetailVO.setZentao_effort_id(ztEffort.getId().toString());
                workReportDetailVO.setEmployee_no(employee.getEmployee_no());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setReport_date(ztEffort.getDate());
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setFrom_zentao(true);
                workReportDetailVO.setActual_hour(new BigDecimal(Float.toString(ztEffort.getConsumed().floatValue())).setScale(2, 1));
                workReportDetailVO.setUnfinished_hour(new BigDecimal(Float.toString(ztEffort.getLeft().floatValue())).setScale(2, 1));
                workReportDetailVO.setWork_content(ztEffort.getWork());
                workReportDetailVO.setStatus("3");
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no());
                queryWrapper.eq(WorkReportDetail::getZentao_effort_id, (Object)ztEffort.getId());
                queryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
                WorkReportDetail workInfo = (WorkReportDetail)((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectOne((Wrapper)queryWrapper);
                if (workInfo != null) {
                    if (!"3".equals(workInfo.getStatus())) continue;
                    workVO1 = new WorkReportDetailVO();
                    BeanUtils.copyProperties((Object)workInfo, (Object)workVO1);
                    workVO1.setReport_frequency(employee.getReport_frequency());
                    workVO1.setEmail(employee.getEmail());
                    workVO1.setFrom_zentao(false);
                    if (StringUtils.isNotEmpty(workInfo.getBelong_project())) {
                        project = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)workInfo.getBelong_project())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                        workVO1.setBelong_project_name(project.getProject_name());
                    } else {
                        workVO1.setBelong_project_name("");
                        workVO1.setBelong_project("");
                    }
                    workReportDetailVOList.add(workVO1);
                    continue;
                }
                workReportDetailVOList.add(workReportDetailVO);
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no());
            queryWrapper.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            queryWrapper.eq(WorkReportDetail::getStatus, (Object)"3");
            queryWrapper.in(WorkReportDetail::getReport_date, reportDetailDTO.getReport_date_list());
            queryWrapper.eq(WorkReportDetail::getFrom_zentao, (Object)false);
            List workReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper);
            for (WorkReportDetail workReportDetail : workReportDetails) {
                workVO1 = new WorkReportDetailVO();
                BeanUtils.copyProperties((Object)workReportDetail, (Object)workVO1);
                workVO1.setReport_frequency(employee.getReport_frequency());
                workVO1.setEmail(employee.getEmail());
                workVO1.setFrom_zentao(false);
                if (StringUtils.isNotEmpty(workReportDetail.getBelong_project())) {
                    project = (Project)((ProjectMapper)this.projectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Project::getProject_code, (Object)workReportDetail.getBelong_project())).eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                    workVO1.setBelong_project_name(project.getProject_name());
                } else {
                    workVO1.setBelong_project_name("");
                    workVO1.setBelong_project("");
                }
                workReportDetailVOList.add(workVO1);
            }
        }
        return workReportDetailVOList;
    }

    public Map<String, Object> getSupplementaryWorkReport(Map map) throws DWException {
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        String email = (String)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("email", String.class);
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        Integer page = (Integer)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = (Integer)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = (Boolean)obj.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        HashMap<String, Object> stringObjectHashMap = new HashMap<String, Object>();
        List workReportDetails = new ArrayList();
        List projects = ((ProjectMapper)this.projectDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(Project::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        HashMap<String, Project> projectMap = new HashMap<String, Project>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        ArrayList<WorkReportDetailVO> workReportDetailVOS = new ArrayList<WorkReportDetailVO>();
        Employee employee = this.getEmployeeByEmail(email);
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper1.eq(WorkReportDetail::getEmployee_no, (Object)employee.getEmployee_no())).eq(WorkReportDetail::getFrom_supplement, (Object)true)).eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        queryWrapper1.orderByDesc(WorkReportDetail::getReport_date);
        if (jsonArray != null && jsonArray.size() != 0) {
            List searchDTOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), SearchDTO.class);
            String sql = "";
            block7: for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {
                    case "email": {
                        searchDTO.setSearch_field("employee_no");
                        ArrayList<String> strings = new ArrayList<String>();
                        strings.add(employee.getEmployee_no());
                        searchDTO.setSearch_value(strings);
                        sql = StringUtils.builderSQL(searchDTO, sql);
                        continue block7;
                    }
                }
                sql = StringUtils.builderSQL(searchDTO, sql);
            }
            queryWrapper1.eq(WorkReportDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            queryWrapper1.apply(sql, new Object[0]);
        }
        queryWrapper1.orderByDesc(WorkReportDetail::getReport_date);
        if (use_has_next != null && use_has_next.booleanValue()) {
            Page pages = new Page((long)page.intValue(), (long)size.intValue());
            Page workReportDetailPage = new Page((long)page.intValue(), (long)size.intValue());
            workReportDetailPage = (Page)((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectPage((IPage)pages, (Wrapper)queryWrapper1);
            workReportDetails = workReportDetailPage.getRecords();
            stringObjectHashMap.put("total_results", workReportDetailPage.getTotal());
            stringObjectHashMap.put("has_next", workReportDetailPage.hasNext());
        } else {
            workReportDetails = ((WorkReportDetailMapper)this.workReportDetailDAO.getBaseMapper()).selectList((Wrapper)queryWrapper1);
        }
        for (WorkReportDetail workReportDetail : workReportDetails) {
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties((Object)workReportDetail, (Object)workReportDetailVO);
            workReportDetailVO.setEmail(email);
            if (StringUtil.isNotEmpty((Object)workReportDetail.getBelong_project())) {
                workReportDetailVO.setBelong_project_name(((Project)projectMap.get(workReportDetailVO.getBelong_project())).getProject_name());
            }
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVOS.add(workReportDetailVO);
        }
        stringObjectHashMap.put("work_report_info", workReportDetailVOS);
        return stringObjectHashMap;
    }
}

