package com.digiwin.athena.dtdapp.pojo.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@TableName("purchase_info")
@Accessors(chain = true)
public class PurchaseInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 采购单号
     */
    private String purchase_no;


    private String purchase_name;
    /**
     * 签核状态(1：待签核;2：签核中;3：签核完成)
     */
    private String easy_flow_status;
    /**
     * 云端营运公司编号
     */
    private String eoc_company_id;
    /**
     * 云端营运据点编号
     */
    private String eoc_site_id;
    /**
     * 云端营运域编号
     */
    private String eoc_region_id;
    /**
     * 营运公司编号
     */
    private String om_company_id;
    /**
     * 营运据点编号
     */
    private String om_site_id;
    /**
     * 营运域编号
     */
    private String om_region_id;
    /**
     * 联络人
     */
    private String contact_name;
    /**
     * 收货地址
     */
    private String receipt_address;
    /**
     * 采购员编号
     */
    private String purchaser_code;
    /**
     * 采购员名称
     */
    private String purchaser_name;
    /**
     * 审核人编号
     */
    private String signer_code;
    /**
     * 审核人名称
     */
    private String signer_name;
    /**
     * 单据备注
     */
    private String doc_remark;
    /**
     * 发起时间
     */
    private Date Initiation_time;
    /**
     * 采购总价
     */
    private BigDecimal purchase_total_price;
    /**
     * 采购状态(1：过程中;2：已完成;3：取消)
     */
    private String purchase_status;
    /**
     * 采购单预存状态(1：预存状态; 2：提交状态)
     */
    private String purchase_temp_status;
    /**
     * 签核预完日
     */
    private Date purchase_approve_date;
}
