package com.digiwin.athena.dtdapp.pojo.entity.zentao;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 法定节假日
 *
 * @author sungqz
 * @since 2025-06-17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("zt_dj_holiday_date")
public class ZtDJHolidayDate {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 年份
     */
    private String year;

    /**
     * 日期类型 0：放假 1：补班
     */
    private Integer dateType;

    /**
     * 日期
     */
    private String date;

    /**
     * 日期描述
     */
    private String dateDesc;
}
