package com.digiwin.athena.dtdapp.pojo.entity.zentao;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.dtdapp.pojo.enums.Status;
import com.google.errorprone.annotations.FormatString;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;


import java.sql.Timestamp;
import java.util.Date;


@Data
@TableName("zt_task")
@Accessors(chain = true)
public class ZtTask {
    private Integer id;

    @TableField("`project`")
    private Integer project;

    @TableField("`parent`")
    private Integer parent;

    @TableField("`execution`")
    private Integer execution;

    @TableField("`module`")
    private Integer module;

    @TableField("`design`")
    private Integer design;

    @TableField("`story`")
    private Integer story;

    @TableField("`storyVersion`")
    private Integer storyVersion;

    @TableField("`designVersion`")
    private Integer designVersion;

    @TableField("`fromBug`")
    private Integer fromBug;

    @TableField("`feedback`")
    private Integer feedback;

    @TableField("`name`")
    private String name;

    @TableField("`type`")
    private String type;

    @TableField("`pri`")
    private Integer pri;

    @TableField("`estimate`")
    private Float estimate;

    @TableField("`consumed`")
    private Float consumed;

    @TableField("`left`")
    private Float left;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`deadline`")
    private Timestamp deadline;

    @TableField("`status`")
    private Status status;

    @TableField("`color`")
    private char color;

    @TableField("`mailto`")
    private String mailto;

    @TableField("`desc`")
    private String desc;

    @TableField("`version`")
    private Integer version;

    @TableField("`openedBy`")
    private String openedBy;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`openedDate`")
    private Timestamp openedDate;

    @TableField("`assignedTO`")
    private String assignedTO;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`assignedDate`")
    private Timestamp assignedDate;

    @TableField("`estStarted`")
    private Timestamp estStarted;

    @TableField("`realStarted`")
    private Timestamp realStarted;

    @TableField("`finishedBy`")
    private String finishedBy;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`finishedDate`")
    private Timestamp finishedDate;

    @TableField("`canceledBy`")
    private String canceledBy;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`canceledDate`")
    private Timestamp canceledDate;

    @TableField("`closedBy`")
    private String closedBy;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`closedDate`")
    private Timestamp closedDate;

    @TableField("`realDuration`")
    private Integer realDuration;

    @TableField("`planDuration`")
    private Integer planDuration;

    @TableField("`closedReason`")
    private String closedReason;

    @TableField("`lastEditedBy`")
    private String lastEditedBy;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`lastEditedDate`")
    private Timestamp lastEditedDate;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("`activatedDate`")
    private Timestamp activatedDate;

    @TableField("`repo`")
    private Integer repo;

    @TableField("`mr`")
    private Integer mr;

    @TableField("`entry`")
    private String entry;

    @TableField("`lines`")
    private String lines;

    @TableField("`v1`")
    private String v1;

    @TableField("`v2`")
    private String v2;

    @TableField("`deleted`")
    private Status deleted;

    @TableField("`subStatus`")
    private String subStatus;

    @TableField("`finishedList`")
    private String finishedList;

    @TableField("`testArea`")
    private String testArea;

    @TableField("`checklistdone`")
    private String checklistdone;

    @TableField("`WorkType`")
    private String WorkType;

    @TableField("`test`")
    private String test;

    @TableField("`DevelopmentWork`")
    private String DevelopmentWork;

    @TableField("`first`")
    private char first;

    @TableField("`SA`")
    private String SA;

    @TableField("`QC`")
    private String QC;

    @TableField("`code`")
    private String code;
}
