package com.digiwin.athena.dtdapp.pojo.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum KanBanStatus {
    Wait("wait", "未开始"),
    Closed("closed","已关闭"),
    Developing("developing","研发中"),
    Extension("extension","已延期"),

    Doing_projectOrSprint("doing","进行中"),
    Done_projectOrSprint("done","已完成"),


    Changing_story("changing","变更中"),
    Active_story("active","激活"),
    Draft_story("draft","草稿"),
    Reviewing_story("reviewing","评审中"),
    Launched_story("launched","已发布"),



    Planned_story_stage("planned","已计划"),
    Projected_story_stage("projected","已立项"),
    Developed_story_stage("developed","研发完毕"),
    Testing_story_stage("testing","测试中"),
    Tested_story_stage("tested","测验完毕"),
    Verified_story_stage("verified","已验收"),
    Released_story_stage("released","已发布"),

    // 任务类型
    design("design","设计"),
    review("review","评审"),
    devel("devel","开发"),
    request("request","需求"),
    test("test","测试"),
    study("study","研究"),
    discuss("discuss","讨论"),
    ui("ui","界面"),
    affair("affair","事务"),
    misc("misc","其他"),
    holiday("holiday","DAP专用请假"),
    leave("leave","请假"),
    demand("demand","规格澄清"),
    specification("specification","会议"),
    cultivate("cultivate","培训(技术类)"),
    internal("internal","内部问题处理"),
    external("external","外部问题处理"),
    learn("learn","学习"),
    cultivatetutors("cultivatetutors","培训（讲师）"),
    cultivatetrainees("cultivatetrainees","培训与学习（学员）"),
    sre("sre","运维"),
    support("support","技术支持"),
    se("se","软件工程"),
    unitTest("unitTest","单元测试"),
    bug("bug","Bug处理"),

    // 角色
    DEV("dev","PR"),
    QC("qa","QC");


    @JsonValue
    @EnumValue
    String value;
    String desc;

    KanBanStatus(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String fromValue(String value) {
        for (KanBanStatus status : KanBanStatus.values()) {
            if (status.getValue().equals(value)) {
                return status.getDesc();
            }
        }
        return null;
    }
}
