package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAIService;

import java.util.Map;

public interface IProcureSercive extends DWService  {
    /**
     * 采购单生成
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.procurement.detail.create")
    DWEAIResult createPurchaseOrder(Map<String, String> headers, String messageBody) throws Exception;

    /**
     * 采购单更新
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.procurement.detail.update")
    DWEAIResult updatePurchaseOrder(Map<String, String> headers, String messageBody) throws Exception;
    /**
     * 采购单获取
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.procurement.detail.get")
    DWEAIResult getPurchaseOrder(Map<String, String> headers, String messageBody) throws Exception;
    /**
     * 商品信息获取
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.supplier.commodity.get")
    DWEAIResult getCommodityInfo(Map<String, String> headers, String messageBody) throws Exception;
    /**
     * 商品信息更新
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.supplier.commodity.update")
    DWEAIResult updateCommodityInfo(Map<String, String> headers, String messageBody) throws Exception;
}