package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAIService;

import java.text.ParseException;
import java.util.Map;

public interface IWorkReportProvider extends DWService {


    @EAIService(id = "dtdapp.employee.get")
    DWEAIResult postQueryEmployeeInfo(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dtdapp.employee.update")
    DWEAIResult updateEmployeeInfo(Map<String, String> headers, String messageBody) throws Exception;


    @EAIService(id = "dtdapp.org.get")
    DWEAIResult queryOrganizationInfo(Map<String, String> headers, String messageBody) throws Exception;

    /**
     * 工作行事历查询
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id = "dtdapp.work.calendar.get")
    DWEAIResult getWorkCalendarInfo(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dtdapp.work.calendar.create.or.update")
    DWEAIResult createOrUpdateWorkCalendar(Map<String, String> headers, String messageBody) throws Exception;

    /**
     * 项目信息查询
     * @param headers
     * @param messageBody
     * @return
     * @throws DWException
     */
    @EAIService(id = "dtdapp.project.get")
    DWEAIResult getProjectInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.project.update")
    DWEAIResult updateProjectInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.project.update.status.y")
    DWEAIResult updateProjectStatusY(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.project.update.status.v")
    DWEAIResult updateProjectStatusV(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.project.create")
    DWEAIResult createProjectInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.detail.get")
    DWEAIResult queryWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.detail.update")
    DWEAIResult CreateOrUpdateWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException, ParseException;
    @EAIService(id = "dtdapp.work.report.detail.save")
    DWEAIResult saveWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException, ParseException;

    @EAIService(id = "dtdapp.work.report.detail.delete")
    DWEAIResult deleteWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.audit")
    DWEAIResult auditWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.need.audit.get")
    DWEAIResult needAuditWorkReportInfo(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dtdapp.work.report.early.warning.get")
    DWEAIResult getWarningWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.early.warning.update")
    DWEAIResult updateWarningWorkReportInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.get.approver")
    DWEAIResult getApproverInfo(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.status.get")
    DWEAIResult getWorkReportByStatus(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.employee.insert")
    DWEAIResult insertOrUpdateEmployee(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.dept.insert")
    DWEAIResult insertOrUpdateDept(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.work.report.detail.history.get")
    DWEAIResult getHistoryWorkReport(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.update.zentao.project")
    DWEAIResult updateZtProject() throws DWException;

    @EAIService(id = "dtdapp.zentao.work.report.get")
    DWEAIResult getZtWorkReport(Map<String, String> headers, String messageBody) throws DWException;

    @EAIService(id = "dtdapp.supplementary.work.report.get")
    DWEAIResult getSupplementaryWorkReport(Map<String, String> headers, String messageBody) throws DWException;
}
