package com.digiwin.athena.dtdapp.provider.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWEAIFasyncResult;
import com.digiwin.app.service.DWEAIFasyncTaskResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.athena.dtdapp.pojo.esp.EspBody;
import com.digiwin.athena.dtdapp.pojo.esp.EspResponse;
import com.digiwin.athena.dtdapp.provider.IServiceChainDemoService;
import com.digiwin.athena.dtdapp.util.ESPInvokeUtil;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceChainDemoServiceImpl implements IServiceChainDemoService {

    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceChainDemoServiceImpl.class);


    @Override
    public DWEAIResult getServiceChainStep1(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStep1========");
        LOGGER.info("header:{}" , headers);
        EspResponse espResponse = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain.two", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, headers.get("pinpoint-traceid"));
        Map<String , Object> result = new HashMap<>();
        List<Object> lists = new ArrayList<>();
        if (espResponse.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            lists.add(parameter);
//            return new DWEAIResult("0", "0", "OK", parameter);
        }

        EspResponse espResponse2 = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain4", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, headers.get("pinpoint-traceid"));

        if (espResponse2.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            lists.add(parameter);
//            return new DWEAIResult("0", "0", "OK", parameter);
        }

        result.put("chain_info_demo", lists);
        LOGGER.info("=======out ServiceChainStep1========");
        return new DWEAIResult("0", "0", "OK", result);
    }

    @Override
    public DWEAIResult getServiceChainStep2(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStep2========");
        LOGGER.info("header:{}" , headers);
//        List<Object> list = new ArrayList<>();
//        Map<String, Object> obj1 = new HashMap<>();
//        obj1.put("chain_step", "2");
//        list.add(obj1);
//
//        Map<String, Object> info = new HashMap<>();
//        info.put("chain_info_demo", list);

        EspResponse espResponse = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain3", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, null);

        if (espResponse.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return new DWEAIResult("0", "0", "OK", parameter);
        }
        LOGGER.info("=======out ServiceChainStep2========");
        return new DWEAIResult("0", "0", "OK", null);
    }

    @Override
    public DWEAIResult getServiceChainStep3(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStep3========");
        LOGGER.info("header:{}" , headers);
        List<Object> list = new ArrayList<>();
        Map<String, Object> obj1 = new HashMap<>();
        obj1.put("chain_step", "3");
        list.add(obj1);

        Map<String, Object> info = new HashMap<>();
        info.put("chain_info_demo", list);
        LOGGER.info("=======out ServiceChainStep3========");
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getServiceChainStep4(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStep4========");
        LOGGER.info("header:{}" , headers);
        List<Object> list = new ArrayList<>();
        Map<String, Object> obj1 = new HashMap<>();
        obj1.put("chain_step", "4");
        list.add(obj1);

        Map<String, Object> info = new HashMap<>();
        info.put("chain_info_demo", list);
        LOGGER.info("=======out ServiceChainStep4========");
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult getServiceChainStepError1(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStepError1========");
        LOGGER.info("header:{}" , headers);
        EspResponse espResponse = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain.error2", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, null);
        Map<String , Object> result = new HashMap<>();
        List<Object> lists = new ArrayList<>();
        if (espResponse.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            lists.add(parameter);
        }

        EspResponse espResponse2 = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain.error4", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, headers.get("pinpoint-traceid"));

        if (espResponse2.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            lists.add(parameter);

        }

        result.put("chain_info_demo", lists);
        LOGGER.info("=======out ServiceChainStepError1========");
        return new DWEAIResult("0", "0", "OK", result);
    }

    @Override
    public DWEAIResult getServiceChainStepError2(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStepError2========");
        LOGGER.info("header:{}" , headers);


        EspResponse espResponse = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain.error3", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, headers.get("pinpoint-traceid"));

        if (espResponse.isOK()) {
            EspBody espBody = (EspBody) espResponse.getData();
            Map<String, Object> parameter = espBody.getStd_data().getParameter();
            return new DWEAIResult("0", "0", "OK", parameter);
        }
        LOGGER.info("=======out ServiceChainStepError2========");
        return new DWEAIResult("0", "0", "OK", null);
    }

    @Override
    public DWEAIResult getServiceChainStepError3(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStepError3========");
        LOGGER.info("header:{}" , headers);
        List<Object> list = new ArrayList<>();
        Map<String, Object> obj1 = new HashMap<>();
        obj1.put("chain_step", "3");
        list.add(obj1);

        Map<String, Object> info = new HashMap<>();
        info.put("chain_info_demo", list);
        LOGGER.info("=======out ServiceChainStepError3========");
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getServiceChainStepError4(Map<String, String> headers, String messageBody) throws DWException {
        LOGGER.info("=======enter ServiceChainStepError4========");
        LOGGER.info("header:{}" , headers);
        throw new DWException("ServiceChainStepError4 throw exception");

//        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getServiceChainCallBack1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("000", "111", "222", new HashMap<>());
    }

    @Override
    public DWEAIResult getServiceChainAsync1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIFasyncResult("000", "111", "222", new HashMap<>(), () -> {
            try {
                LOGGER.info("------DWServiceChainUtils.isServiceChainEnabled：{}", DWServiceChainUtils.isServiceChainEnabled());
                LOGGER.info("------chainInfo：{}",   DWServiceChainContext.getContext().getSessionInfo());
                EspResponse espResponse2 = ESPInvokeUtil.invokeRestSync("dtdapp.test.service.chain.one", "dtdapp",
                        headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, headers.get("pinpoint-traceid"));
            } catch (DWException e) {
                LOGGER.error("getServiceChainAsync1 err", e);
                return new DWEAIFasyncTaskResult("-1", "0", "error", new HashMap<>());
            }
            return new DWEAIFasyncTaskResult("0", "0", "OK", new HashMap<>());
        });
    }

    @Override
    public DWEAIResult callAsync1(Map<String, String> headers, String messageBody) throws Exception {
        EspResponse espResponse2 = ESPInvokeUtil.invokeRestFasync("dtdapp.test.service.async1", "dtdapp",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null,  "dtdapp.test.service.async1.callback");
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs1_1(Map<String, String> headers, String messageBody) throws DWException {
        return callSrvAndBuildResult("tb.v111.product.data.get", headers, messageBody);
    }

    @Override
    public DWEAIResult bs1_2(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs2_1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs2_2(Map<String, String> headers, String messageBody) throws DWException {
        return callSrvAndBuildResult("tb.v221.product.inventory.info.get", headers, messageBody);
    }

    @Override
    public DWEAIResult bs3_1(Map<String, String> headers, String messageBody) throws DWException {
        EspResponse espResponse2 = ESPInvokeUtil.invokeRestFasync("tb.v311.product.inventory.detail", "troubleshoot",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null,  "commom.callback");
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs3_2(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs4_1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIFasyncResult("000", "111", "222", new HashMap<>(), () -> {
            return new DWEAIFasyncTaskResult("0", "0", "OK", new HashMap<>());
        });
    }

    @Override
    public DWEAIResult bs4_1_1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIFasyncResult("000", "111", "222", new HashMap<>(), () -> {
            return new DWEAIFasyncTaskResult("0", "0", "OK", new HashMap<>());
        });
    }

    @Override
    public DWEAIResult bs4_2(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }


    @Override
    public DWEAIResult bs5_1(Map<String, String> headers, String messageBody) throws DWException {
        return callSrvAndBuildResult("tb.v511.product.info.get", headers, messageBody);
    }

    @Override
    public DWEAIResult bs5_2(Map<String, String> headers, String messageBody) throws DWException {
        return callSrvAndBuildResult("tb.v521.product.version.get", headers, messageBody);
    }

    @Override
    public DWEAIResult bs5_3(Map<String, String> headers, String messageBody) throws DWException {
        return callSrvAndBuildResult("tb.v531.product.data.get", headers, messageBody);
    }

    @Override
    public DWEAIResult bs6_1(Map<String, String> headers, String messageBody) throws DWException {
        EspResponse espResponse2 = ESPInvokeUtil.invokeRestFasync("tb.v611.product.inventory.detail", "troubleshoot",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null,  "b.s6.1.callback");
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs6_2(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs6_1_callback(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs6_1_1_1(Map<String, String> headers, String messageBody) throws DWException {
        if (1==1) {
            throw new DWException("模拟异常");
        }
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs7_1(Map<String, String> headers, String messageBody) throws DWException {
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }

    @Override
    public DWEAIResult bs7_2(Map<String, String> headers, String messageBody) throws DWException {
        callSrvAndBuildResult("tb.v721.product.inventory.info.get", headers, messageBody);
        return new DWEAIFasyncResult("000", "111", "222", new HashMap<>(), () -> {
            return new DWEAIFasyncTaskResult("0", "0", "OK", new HashMap<>());
        });
    }


    private DWEAIResult callSrvAndBuildResult(String srvName, Map<String, String> headers, String messageBody) throws DWException {
        EspResponse espResponse = ESPInvokeUtil.invokeRestSync(srvName, "troubleshoot",
                headers.get("token"), LoginUserUtils.getTenantId(), messageBody, null, null, null);
        if (!espResponse.isOK()) {
            throw new DWException(espResponse.getMsg());
        }
        return new DWEAIResult("0", "0", "OK", new HashMap<>());
    }
}
