package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dtdapp.pojo.constants.Constant;
import com.digiwin.athena.dtdapp.pojo.dto.ztkanban.queryTaskReq;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.*;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.*;
import com.digiwin.athena.dtdapp.provider.IZtKanBanService;
import com.digiwin.athena.dtdapp.service.DtdappProjectService;
import com.digiwin.athena.dtdapp.service.ZtKanBanService;
import com.digiwin.athena.dtdapp.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
public class ZtKanBanServiceImpl implements IZtKanBanService {
    @Autowired
    private ZtKanBanService ztKanBanService;

    @Autowired
    private DtdappProjectService projectService;

    public List<ZtProjectLevelVO> getProgram() {
        return ztKanBanService.getProgramLevel();
    }

    @Override
    public List<ZtProject> getProjectByProgram(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String id = jsonObject.getObject("id", String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        return ztKanBanService.getProjectByProgramAndType(id, "project", isShowAll);
    }


    @Override
    public PageVO<ZtProjectVO> getProjectByProgramAndProject(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String projectId = jsonObject.getObject("project_id", String.class);
        Integer page = jsonObject.getObject("page", Integer.class);
        Integer size = jsonObject.getObject("size", Integer.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        String begin_sort = jsonObject.getObject("begin_sort", String.class);
        String end_sort = jsonObject.getObject("end_sort", String.class);
        String total_demand_sort = jsonObject.getObject("total_demand_sort", String.class);
        String completed_demand_sort = jsonObject.getObject("completed_demand_sort", String.class);
        String residue_sort = jsonObject.getObject("residue_sort", String.class);
        return ztKanBanService.getProjectByProgramAndProject(projectId, page, size, isShowAll, begin_sort, end_sort, total_demand_sort, completed_demand_sort, residue_sort);
    }

    @Override
    public List<ZtProject> getSprintByProject(String request) {
        Map map = JSON.parseObject(request, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONArray("id");
        List<String> projectIds = JSON.parseArray(JSON.toJSONString(jsonArray), String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        return ztKanBanService.getSprintByProgramAndType(projectIds, "sprint", isShowAll);
    }

    @Override
    public PageVO<ZtStoryVO> getStoryByProjectOrSprint(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List<Integer> projectIds = JSON.parseArray(JSON.toJSONString(jsonArray), Integer.class);
        String sprintId = jsonObject.getObject("sprint_id", String.class);
        Integer page = jsonObject.getObject("page", Integer.class);
        Integer size = jsonObject.getObject("size", Integer.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);

        String id_sort = jsonObject.getObject("id_sort", String.class);
        String plan_end_sort = jsonObject.getObject("plan_end_sort", String.class);
        String pri_sort = jsonObject.getObject("pri_sort", String.class);
        String estimate_sort = jsonObject.getObject("estimate_sort", String.class);
        String consumed_sort = jsonObject.getObject("consumed_sort", String.class);
        String associated_tasks_sort = jsonObject.getObject("associated_tasks_number_sort", String.class);
        String associated_bugs_sort = jsonObject.getObject("associated_bugs_number_sort", String.class);
        page = (page == null || page == 0) ? 1 : page;
        size = (size == null || size == 0) ? 10 : size;
        String status = jsonObject.getObject("story_status", String.class);
        return ztKanBanService.getStoryByProjectOrSprint(programId, projectIds, sprintId, page, size, isShowAll, status,
                id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort);
    }


    @Override
    public List<ZtProduct> getProductByProgram(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String id = jsonObject.getObject("id", String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        return ztKanBanService.getProductByProgram(id, isShowAll);
    }

    @Override
    public List<ZtModuleLevelVO> getModuleByProduct(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        String productId = jsonObject.getObject("product_id", String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        return ztKanBanService.getModuleByProduct(programId, productId, isShowAll);
    }

    /**
     * 获取需求看板产品维度需求
     *
     * @param requestMap
     * @return
     */
    @Override
    public PageVO<ZtStoryVO> getStoryByProduct(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        String productId = jsonObject.getObject("product_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List<String> moduleId = JSON.parseArray(JSON.toJSONString(jsonArray), String.class);

        String id_sort = jsonObject.getObject("id_sort", String.class);
        String plan_end_sort = jsonObject.getObject("plan_end_sort", String.class);
        String pri_sort = jsonObject.getObject("pri_sort", String.class);
        String estimate_sort = jsonObject.getObject("estimate_sort", String.class);
        String consumed_sort = jsonObject.getObject("consumed_sort", String.class);
        String associated_tasks_sort = jsonObject.getObject("associated_tasks_number_sort", String.class);
        String associated_bugs_sort = jsonObject.getObject("associated_tasks_number_sort", String.class);

        Integer page = jsonObject.getObject("page", Integer.class);
        Integer size = jsonObject.getObject("size", Integer.class);

        page = (page == null || page == 0) ? 1 : page;
        size = (size == null || page == 0) ? 10 : size;
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        String status = jsonObject.getObject("story_status", String.class);
        return ztKanBanService.getStoryByProductOrModule(programId, productId, moduleId, page, size, isShowAll, status, id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort);
    }

    /**
     * 获取需求看板需求达成情况
     *
     * @param requestMap
     * @return
     */
//    @Override
//    public DemandVO getDemandCompleteStatus(String requestMap) {
//        Map map = JSON.parseObject(requestMap, Map.class);
//        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
//        String programId = jsonObject.getObject("program_id", String.class);
//        String date = jsonObject.getObject("date", String.class);
//        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
//        List<Integer> projectIds = JSON.parseArray(JSON.toJSONString(jsonArray), Integer.class);
//        return ztKanBanService.getDemandCompleteStatus(programId,projectIds,date);
//    }

    /**
     * 项目看板内容导出
     *
     * @param
     * @return
     */
    @Override
    public void getProjectToExcel(Map<String, String> requestMap) {
        String projectId = requestMap.get("project_id");
        //String projectId = "393890";
        Boolean isShowAll = Boolean.parseBoolean(requestMap.get("isShowAll"));
        Integer page = 1;
        Integer size = 999999;
        ztKanBanService.getProjectToExcel(projectId, page, size, isShowAll);
    }

    @Override
    public void getStoryByProjectToExcel(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List<Integer> projectIds = JSON.parseArray(JSON.toJSONString(jsonArray), Integer.class);
        String sprintId = jsonObject.getObject("sprint_id", String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        Integer page = 1;
        Integer size = 999999;
        String status = jsonObject.getObject("story_status", String.class);
        ztKanBanService.getStoryByProjectToExcel(programId, projectIds, sprintId, page, size, isShowAll, status);
    }

    /**
     * 需求看板项目维度需求导出
     *
     * @return
     */
    @Override
    public void getStoryByProductToExcel(String requestMap) {
        JSONObject jsonObject = JSONObject.parseObject(requestMap);
        String programId = jsonObject.getObject("program_id", String.class);
        String productId = jsonObject.getObject("product_id", String.class);
        Boolean isShowAll = jsonObject.getObject("isShowAll", Boolean.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List<String> moduleId = JSON.parseArray(JSON.toJSONString(jsonArray), String.class);
        Integer page = 1;
        Integer size = 999999;
        String status = jsonObject.getObject("story_status", String.class);
        ztKanBanService.getStoryByProductToExcel(programId, productId, moduleId, page, size, isShowAll, status);
    }


    @Override
    public DemandVO getProjectDemandCompleteStatus(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List<Integer> projectIds = JSON.parseArray(JSON.toJSONString(jsonArray), Integer.class);
        String sprintId = jsonObject.getObject("sprint_id", String.class);
        Boolean isShow = jsonObject.getObject("is_show", Boolean.class);
        return ztKanBanService.getProjectDemandCompleteStatus(programId, projectIds, sprintId, isShow);
    }


    @Override
    public DemandVO getProductDemandCompleteStatus(String requestMap) {
        Map map = JSON.parseObject(requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
        String programId = jsonObject.getObject("program_id", String.class);
        String productId = jsonObject.getObject("product_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List<String> moduleIds = JSON.parseArray(JSON.toJSONString(jsonArray), String.class);
        Boolean isShow = jsonObject.getObject("is_show", Boolean.class);
        return ztKanBanService.getProductDemandCompleteStatus(programId, productId, moduleIds, isShow);
    }

    /**
     * 根据部门id获取当前部门及子部门列表
     * 不传deptId默认查询"數據自決研發中心"部门
     *
     * @param deptId 部门id
     * @return 返回
     */
    @Override
    public List<ZtDeptVO> queryDeptList(Integer deptId) {
        return ztKanBanService.queryDeptList(deptId);
    }

    /**
     * 根据部门id查询用户(角色为研发和测试)列表
     * 不传deptId默认查询"數據自決研發中心"部门下的用户
     *
     * @param deptId 部门id
     * @return 返回用户信息
     */
    @Override
    public List<ZtUser> queryUserList(Integer deptId) {
        return ztKanBanService.queryUserList(deptId);
    }

    /**
     * 根据项目集id查询当前项目集及子项目集列表
     * 不传programId默认查询"数据自决研发中心"项目集及子项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    @Override
    public List<ZtProjectLevelVO> queryProgramList(Integer programId) {
        return ztKanBanService.queryProgramList(programId);
    }

    /**
     * 根据项目集id查询当前项目集下的项目列表
     * 不传programId默认查询"数据自决研发中心"项目集及子项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    @Override
    public List<ZtProjectLevelVO> queryProjectList(Integer programId) {
        return ztKanBanService.queryProjectList(programId);
    }

    /**
     * 根据项目集id或项目id查询当前所有冲刺
     * 不传id默认查询"数据自决研发中心"项目集下所有冲刺
     *
     * @param id 项目集id或项目id
     * @return 返回
     */
    @Override
    public List<ZtProjectLevelVO> querySprintList(Integer id) {
        return ztKanBanService.querySprintList(id);
    }

    /**
     * 查询部门维度用户任务列表
     *
     * @param queryTaskReq 请求对象
     * @return 返回
     */
    @Override
    public ZtTaskRespVO queryTaskListByDept(queryTaskReq queryTaskReq) {
        // 没传部门，默认查询”數據自決研發中心“
        if (ObjectUtils.isEmpty(queryTaskReq.getDeptId())) {
            queryTaskReq.setDeptId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID);
        }
        // 没传时间，默认为当前时间一个月内
        if (StringUtils.isBlank(queryTaskReq.getStartTime()) || StringUtils.isBlank(queryTaskReq.getEndTime())) {
            LocalDate previousDate = LocalDate.now().minusMonths(1);
            queryTaskReq.setStartTime(DateUtils.parseLocalDateToString(previousDate, DateUtils.DATE_FORMAT_ONE));
            queryTaskReq.setEndTime(DateUtils.parseLocalDateToString(LocalDate.now(), DateUtils.DATE_FORMAT_ONE));
        }

        // 默认查询”数据自决研发中心“项目集下的项目
        List<ZtProjectLevelVO> projectList = ztKanBanService.queryProjectList(null);
        if (CollectionUtils.isEmpty(projectList)) {
            return new ZtTaskRespVO();
        }
        List<Integer> projectIdList = projectList.stream().map(ZtProjectLevelVO::getId).collect(Collectors.toList());
        queryTaskReq.setProjectIdList(projectIdList);
        return projectService.queryTaskListByCondition(queryTaskReq, Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT);
    }

    /**
     * 查询项目维度用户任务列表
     *
     * @param queryTaskReq 请求对象
     * @return 返回
     */
    @Override
    public ZtTaskRespVO queryTaskListByProject(queryTaskReq queryTaskReq) {
        // 没传项目集，默认查询”数据自决研发中心“
        if (ObjectUtils.isEmpty(queryTaskReq.getProgramId())) {
            queryTaskReq.setProgramId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID);
        }
        // 没传项目，默认查询当前项目集下第一个项目
        if (ObjectUtils.isEmpty(queryTaskReq.getProjectId())) {
            List<ZtProjectLevelVO> projectList = ztKanBanService.queryProjectList(queryTaskReq.getProgramId());
            if (CollectionUtils.isEmpty(projectList)) {
                return new ZtTaskRespVO();
            }
            queryTaskReq.setProjectId(projectList.get(0).getId());
        }

        // 部门默认为”數據自決研發中心“
        if (ObjectUtils.isEmpty(queryTaskReq.getDeptId())) {
            queryTaskReq.setDeptId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID);
        }
        // 时间默认为“2024-01-01 -- 2026-12-31”
        if (StringUtils.isBlank(queryTaskReq.getStartTime()) || LocalDate.parse(queryTaskReq.getStartTime()).isBefore(Constant.CAL_AVAILABLE_DURATION_START_DATE)) {
            queryTaskReq.setStartTime(DateUtils.parseLocalDateToString(Constant.CAL_AVAILABLE_DURATION_START_DATE, DateUtils.DATE_FORMAT_ONE));
        }
        if (StringUtils.isBlank(queryTaskReq.getEndTime()) || LocalDate.parse(queryTaskReq.getEndTime()).isAfter(Constant.CAL_AVAILABLE_DURATION_END_DATE)) {
            queryTaskReq.setEndTime(DateUtils.parseLocalDateToString(Constant.CAL_AVAILABLE_DURATION_END_DATE, DateUtils.DATE_FORMAT_ONE));
        }
        return projectService.queryTaskListByCondition(queryTaskReq, Constant.QUERY_TASK_LIST_SCENE_WITH_PROJECT);
    }
}
