/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.config;

import java.util.concurrent.TimeUnit;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

public class DtdappNeo4j1Config {
    public static final String SESSION_FACTORY = "dtdappSessionFactoryForDomain1";
    public static final String TRANSACTION_MANAGER = "dtdappTransactionManagerForDomain1";
    private String uri;
    private String username;
    private String password;
    private Boolean enable;

    public DtdappNeo4j1Config() {
        System.out.println("Neo4j1Config........");
    }

    @Bean(value={"dtdappNeo4jDriverDomain1"})
    public Driver dtdappNeo4jDriverDomain1() {
        System.out.println("neo4jDriverDomain1... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);
        Config config = Config.build().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(20).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).toConfig();
        return GraphDatabase.driver((String)this.uri, (AuthToken)AuthTokens.basic((String)this.username, (String)this.password), (Config)config);
    }

    @Bean(value={"dtdAppOgmDriverDomain1"})
    public org.neo4j.ogm.driver.Driver dtdappOgmDriverDomain1() {
        BoltDriver ogmDriver = new BoltDriver(this.dtdappNeo4jDriverDomain1());
        return ogmDriver;
    }

    @Bean(name={"dtdappSessionFactoryForDomain1"})
    public SessionFactory dtdAppSessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.dtdappOgmDriverDomain1(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        return new String[]{"com.digiwin.athena.dtdapp.pojo.neo4j"};
    }
}

