/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.config;

import java.util.concurrent.TimeUnit;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

public class DtdappNeo4jConfiguration {
    @Autowired
    Neo4jProperties neo4jProperties;

    @Bean(value={"dtdappNeo4jDriver"})
    public Driver dtdAppNeo4jDriver() {
        Config config = Config.build().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).toConfig();
        return GraphDatabase.driver((String)this.neo4jProperties.getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties.getUsername(), (String)this.neo4jProperties.getPassword()), (Config)config);
    }

    @Bean(value={"dtdappOgmDriver"})
    public org.neo4j.ogm.driver.Driver dtdappOgmDriver() {
        BoltDriver ogmDriver = new BoltDriver(this.dtdAppNeo4jDriver());
        return ogmDriver;
    }

    @Bean(value={"dtdappSessionFactory"})
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.dtdappOgmDriver(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        return new String[]{"com.digiwin.athena.dtdapp.pojo.neo4j"};
    }
}

