/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.mapper.AnonymousOpinionsMapper;
import com.digiwin.athena.dtdapp.mapper.DeptEmailMapper;
import com.digiwin.athena.dtdapp.mapper.RecipientMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtDeptMapper;
import com.digiwin.athena.dtdapp.pojo.dto.OpinionsInfoDTO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.DeptEmail;
import com.digiwin.athena.dtdapp.pojo.entity.OpinionsInfo;
import com.digiwin.athena.dtdapp.pojo.entity.RecipientInfo;
import com.digiwin.athena.dtdapp.pojo.vo.OpinionsInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.RecipientInfoVO;
import com.digiwin.athena.dtdapp.util.DateUtils;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnonymousOpinionsDAO {
    private static final Logger log = LoggerFactory.getLogger(AnonymousOpinionsDAO.class);
    @Autowired
    private AnonymousOpinionsMapper anonymousOpinionsMapper;
    @Autowired
    private RecipientMapper recipientMapper;
    @Autowired
    private ZtDeptMapper ztDeptMapper;
    @Autowired
    private DeptEmailMapper deptEmailMapper;
    private String aesKey = DWApplicationConfigUtils.getProperty((String)"aesKey");

    public void insertOpinionsInfo(OpinionsInfoDTO opinionsInfoDTO) {
        log.info("opinionsInfo:{}", (Object)opinionsInfoDTO);
        Map<Long, String> recipientInfo = opinionsInfoDTO.getRecipientInfo();
        String userName = null;
        try {
            DWServiceContext context = DWServiceContext.getContext();
            log.info("\u4e0a\u4e0b\u6587:{}", (Object)context);
            userName = context.getProfile().get("userName").toString();
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        for (Long recipient_id : recipientInfo.keySet()) {
            OpinionsInfo opinionsInfo = new OpinionsInfo();
            BeanUtils.copyProperties((Object)opinionsInfoDTO, (Object)opinionsInfo);
            if (userName == null) {
                opinionsInfo.setCreate_by("\u533f\u540d\u7528\u6237");
            } else {
                opinionsInfo.setCreate_by(userName);
            }
            opinionsInfo.setRecipient_id(recipient_id);
            opinionsInfo.setCreate_date(DateUtils.getDateTimeNow());
            opinionsInfo.setEmail_address(recipientInfo.get(recipient_id));
            this.anonymousOpinionsMapper.insertAEC(opinionsInfo, this.aesKey);
        }
    }

    public List<OpinionsInfoVO> getOpinions() {
        DWServiceContext context = DWServiceContext.getContext();
        log.info("\u4e0a\u4e0b\u6587:{}", (Object)context);
        String userId = context.getProfile().get("userId").toString();
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"recipient_account", (Object)userId);
        RecipientInfo recipientInfo = (RecipientInfo)this.recipientMapper.selectOne((Wrapper)query);
        if (recipientInfo == null) {
            return null;
        }
        List<OpinionsInfoVO> collect = this.anonymousOpinionsMapper.selectListAEC(recipientInfo.getRecipient_id(), this.aesKey).stream().map(opinionsInfo -> {
            OpinionsInfoVO opinionsInfoVO = new OpinionsInfoVO();
            BeanUtils.copyProperties((Object)opinionsInfo, (Object)opinionsInfoVO);
            opinionsInfoVO.setProblem_description(opinionsInfoVO.getApply_name());
            return opinionsInfoVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<RecipientInfoVO> getRecipient() {
        List<RecipientInfoVO> collect = this.recipientMapper.selectList(null).stream().map(recipientInfo -> {
            RecipientInfoVO recipientInfoVO = new RecipientInfoVO();
            BeanUtils.copyProperties((Object)recipientInfo, (Object)recipientInfoVO);
            return recipientInfoVO;
        }).collect(Collectors.toList());
        return collect;
    }

    public List<ZtBugWarningDTO> findAllExternalBugs() {
        LocalDate now = LocalDate.now();
        Map<String, Object> map = AnonymousOpinionsDAO.getPeriod(now);
        String startTime = String.valueOf(map.get("startTime"));
        String endTime = String.valueOf(map.get("endTime"));
        return this.ztDeptMapper.findAllExternalBugs(startTime, endTime);
    }

    public List<ZtBugWarningDTO> findAllSeriousBugs() {
        LocalDate now = LocalDate.now();
        Map<String, Object> map = AnonymousOpinionsDAO.getPeriod(now);
        String startTime = String.valueOf(map.get("startTime"));
        String endTime = String.valueOf(map.get("endTime"));
        return this.ztDeptMapper.findAllSeriousBugs(startTime, endTime);
    }

    public List<ZtBugWarningDTO> findAllNormalBugs() {
        LocalDate now = LocalDate.now();
        Map<String, Object> map = AnonymousOpinionsDAO.getPeriod(now);
        String startTime = String.valueOf(map.get("startTime"));
        String endTime = String.valueOf(map.get("endTime"));
        return this.ztDeptMapper.findAllNormalBugs(startTime, endTime);
    }

    public List<DeptEmail> getEmailInfo() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().ne(DeptEmail::getEmail, (Object)"");
        List deptEmails = this.deptEmailMapper.selectList((Wrapper)queryWrapper);
        return deptEmails;
    }

    private static Map<String, Object> getPeriod(LocalDate openedDate) {
        String startTime = "0000-00-00";
        String endTime = "0000-00-00";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ((openedDate.isEqual(LocalDate.of(2025, 4, 9)) || openedDate.isAfter(LocalDate.of(2025, 4, 9))) && (openedDate.isEqual(LocalDate.of(2025, 5, 22)) || openedDate.isBefore(LocalDate.of(2025, 5, 22)))) {
            startTime = "2025-4-9";
            endTime = "2025-5-22";
        } else if ((openedDate.isEqual(LocalDate.of(2025, 2, 25)) || openedDate.isAfter(LocalDate.of(2025, 2, 25))) && (openedDate.isEqual(LocalDate.of(2025, 4, 8)) || openedDate.isBefore(LocalDate.of(2025, 4, 8)))) {
            startTime = "2025-2-25";
            endTime = "2025-4-8";
        } else if ((openedDate.isEqual(LocalDate.of(2025, 1, 7)) || openedDate.isAfter(LocalDate.of(2025, 1, 7))) && (openedDate.isEqual(LocalDate.of(2025, 2, 24)) || openedDate.isBefore(LocalDate.of(2025, 2, 24)))) {
            startTime = "2025-1-7";
            endTime = "2025-2-24";
        } else if (openedDate.isEqual(LocalDate.of(2024, 11, 25)) || openedDate.isAfter(LocalDate.of(2024, 11, 25)) && openedDate.isBefore(LocalDate.of(2025, 1, 7))) {
            startTime = "2024-11-25";
            endTime = "2025-1-7";
        } else if (openedDate.isEqual(LocalDate.of(2024, 10, 14)) || openedDate.isAfter(LocalDate.of(2024, 10, 14)) && openedDate.isBefore(LocalDate.of(2024, 11, 25))) {
            startTime = "2024-10-14";
            endTime = "2024-11-25";
        } else if (openedDate.isEqual(LocalDate.of(2024, 8, 27)) || openedDate.isAfter(LocalDate.of(2024, 8, 27)) && openedDate.isBefore(LocalDate.of(2024, 10, 14))) {
            startTime = "2024-8-27";
            endTime = "2024-10-14";
        } else if (openedDate.isEqual(LocalDate.of(2024, 7, 16)) || openedDate.isAfter(LocalDate.of(2024, 7, 16)) && openedDate.isBefore(LocalDate.of(2024, 8, 27))) {
            startTime = "2024-7-16";
            endTime = "2024-8-27";
        } else if (openedDate.isEqual(LocalDate.of(2024, 6, 3)) || openedDate.isAfter(LocalDate.of(2024, 6, 3)) && openedDate.isBefore(LocalDate.of(2024, 7, 16))) {
            startTime = "2024-6-3";
            endTime = "2024-7-16";
        } else if (openedDate.isEqual(LocalDate.of(2024, 4, 19)) || openedDate.isAfter(LocalDate.of(2024, 4, 19)) && openedDate.isBefore(LocalDate.of(2024, 6, 3))) {
            startTime = "2024-4-19";
            endTime = "2024-6-3";
        } else if (openedDate.isEqual(LocalDate.of(2024, 3, 28)) || openedDate.isAfter(LocalDate.of(2024, 3, 28)) && openedDate.isBefore(LocalDate.of(2024, 4, 19))) {
            startTime = "2024-3-28";
            endTime = "2024-4-19";
        } else if (openedDate.isEqual(LocalDate.of(2024, 3, 8)) || openedDate.isAfter(LocalDate.of(2024, 3, 8)) && openedDate.isBefore(LocalDate.of(2024, 3, 28))) {
            startTime = "2024-3-8";
            endTime = "2024-3-28";
        } else if (openedDate.isEqual(LocalDate.of(2024, 2, 2)) || openedDate.isAfter(LocalDate.of(2024, 2, 2)) && openedDate.isBefore(LocalDate.of(2024, 3, 8))) {
            startTime = "2024-2-2";
            endTime = "2024-3-8";
        } else if (openedDate.isEqual(LocalDate.of(2024, 1, 16)) || openedDate.isAfter(LocalDate.of(2024, 1, 16)) && openedDate.isBefore(LocalDate.of(2024, 2, 2))) {
            startTime = "2024-1-16";
            endTime = "2024-2-2";
        } else if (openedDate.isEqual(LocalDate.of(2023, 12, 21)) || openedDate.isAfter(LocalDate.of(2023, 12, 21)) && openedDate.isBefore(LocalDate.of(2024, 1, 16))) {
            startTime = "2023-12-21";
            endTime = "2024-1-16";
        }
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return map;
    }
}

