/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.dao.FileInfoDAO;
import com.digiwin.athena.dtdapp.mapper.EmployeeEntryInfoMapper;
import com.digiwin.athena.dtdapp.mapper.FileInfoMapper;
import com.digiwin.athena.dtdapp.pojo.entity.EmployeeEntryInfo;
import com.digiwin.athena.dtdapp.pojo.entity.FileInfo;
import com.digiwin.athena.dtdapp.pojo.vo.EmployeeEntryInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.FileInfoData;
import com.digiwin.athena.dtdapp.util.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class EmployeeEntryInfoDAO2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmployeeEntryInfoDAO2.class);
    public static final String TABLE_NAME = "employee_entry_info";
    @Autowired
    private EmployeeEntryInfoMapper employeeEntryInfoMapper;
    @Autowired
    private FileInfoDAO fileInfoDAO;

    private boolean checkAllEmpNoIsNotNull(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (!StringUtils.isEmpty((CharSequence)empNo)) continue;
            return false;
        }
        return true;
    }

    public List<Map<String, Object>> updateEmployeeEntryInfo(Map<String, String> parameter) throws Exception {
        LOGGER.info("updateEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("update emp_entry_info is empty");
        }
        if (!this.checkAllEmpNoIsNotNull(jsonArray)) {
            throw new DWException("update emp_entry_info has object emp_no is null");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            FileInfoData fileInfoData;
            List<FileInfo> data;
            FileInfoData fileInfoData2;
            List<FileInfo> data2;
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (StringUtils.isEmpty((CharSequence)empNo)) {
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");
            String managerName = jsonObjParam.getString("manager_name");
            String reportSubmitDateString = jsonObjParam.getString("report_submit_date");
            String workReportApprovalDateString = jsonObjParam.getString("work_report_approval_date");
            String probationDateString = jsonObjParam.getString("probation_date");
            String task_status = jsonObjParam.getString("task_status");
            JSONObject report_attachment = jsonObjParam.getJSONObject("report_attachment");
            List rAttachmentIds = null;
            if (!ObjectUtils.isEmpty((Object)report_attachment) && !CollectionUtils.isEmpty(data2 = (fileInfoData2 = (FileInfoData)JSON.parseObject((String)report_attachment.toJSONString(), FileInfoData.class)).getData())) {
                this.fileInfoDAO.saveOrUpdateBatch(data2);
                rAttachmentIds = data2.stream().map(FileInfo::getId).collect(Collectors.toList());
            }
            JSONObject work_report_attachment = jsonObjParam.getJSONObject("work_report_attachment");
            List wrAttachmentIds = null;
            if (!ObjectUtils.isEmpty((Object)work_report_attachment) && !CollectionUtils.isEmpty(data = (fileInfoData = (FileInfoData)JSON.parseObject((String)work_report_attachment.toJSONString(), FileInfoData.class)).getData())) {
                this.fileInfoDAO.saveOrUpdateBatch(data);
                wrAttachmentIds = data.stream().map(FileInfo::getId).collect(Collectors.toList());
            }
            EmployeeEntryInfo employeeEntryInfo = new EmployeeEntryInfo();
            employeeEntryInfo.setUpdate_date(DateUtils.getDateTimeNow());
            if (StringUtil.isNotBlank((CharSequence)entryDateString)) {
                Date entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
                employeeEntryInfo.setEntry_date(entryDate);
            }
            if (StringUtil.isNotBlank((CharSequence)reportSubmitDateString)) {
                Date reportSubmitDate = DateUtils.parseStringToDate(reportSubmitDateString, "yyyy-MM-dd");
                employeeEntryInfo.setReport_submit_date(reportSubmitDate);
            }
            if (StringUtil.isNotBlank((CharSequence)workReportApprovalDateString)) {
                Date workReportApprovalDate = DateUtils.parseStringToDate(workReportApprovalDateString, "yyyy-MM-dd");
                employeeEntryInfo.setWork_report_approval_date(workReportApprovalDate);
            }
            if (StringUtil.isNotBlank((CharSequence)probationDateString)) {
                Date probationDate = DateUtils.parseStringToDate(probationDateString, "yyyy-MM-dd");
                employeeEntryInfo.setProbation_date(probationDate);
            }
            if (StringUtil.isNotBlank((CharSequence)task_status)) {
                employeeEntryInfo.setTask_status(task_status);
            }
            if (!CollectionUtils.isEmpty(rAttachmentIds)) {
                employeeEntryInfo.setReport_attachment_id(StringUtils.join(rAttachmentIds, (String)","));
            }
            if (!CollectionUtils.isEmpty(wrAttachmentIds)) {
                employeeEntryInfo.setWork_report_attachment_id(StringUtils.join(wrAttachmentIds, (String)","));
            }
            this.employeeEntryInfoMapper.update(employeeEntryInfo, (Wrapper)new UpdateWrapper().lambda().eq(EmployeeEntryInfo::getEmp_no, (Object)empNo));
        }
        return this.getEmployeeEntryInfo(parameter);
    }

    public List<Map<String, Object>> insertEmployeeEntryInfo(Map<String, String> parameter) throws Exception {
        LOGGER.info("insertEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("update emp_entry_info is empty");
        }
        if (!this.checkAllEmpNoIsNotNull(jsonArray)) {
            throw new DWException("update emp_entry_info has object emp_no is null");
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if (StringUtils.isEmpty((CharSequence)empNo)) {
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");
            Date entryDate = null;
            if (StringUtils.isNotEmpty((CharSequence)entryDateString)) {
                entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
            }
            String managerName = jsonObjParam.getString("manager_name");
            String managerNo = jsonObjParam.getString("manager_no");
            String emp_email = jsonObjParam.getString("emp_email");
            String manager_email = jsonObjParam.getString("manager_email");
            String task_status = jsonObjParam.getString("task_status");
            EmployeeEntryInfo employeeEntryInfo = new EmployeeEntryInfo();
            employeeEntryInfo.setEmp_no(empNo);
            employeeEntryInfo.setEmp_name(empName);
            employeeEntryInfo.setLogin_name(loginName);
            employeeEntryInfo.setEntry_date(entryDate);
            employeeEntryInfo.setManager_name(managerName);
            employeeEntryInfo.setManager_no(managerNo);
            employeeEntryInfo.setManager_email(manager_email);
            employeeEntryInfo.setEmp_email(emp_email);
            employeeEntryInfo.setTask_status(task_status);
            employeeEntryInfo.setCreate_date(DateUtils.getDateTimeNow());
            this.employeeEntryInfoMapper.insert(employeeEntryInfo);
        }
        return this.getEmployeeEntryInfo(parameter);
    }

    public List getEmployeeEntryInfo(Map<String, String> parameter) throws DWException {
        LOGGER.info("getEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");
        if (ObjectUtils.isEmpty((Object)jsonArray)) {
            throw new DWException("empNo is empty");
        }
        ArrayList<String> empNoList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String emp_no = jsonObject.getString("emp_no");
            empNoList.add(emp_no);
        }
        String task_status = jsonArray.getJSONObject(0).getString("task_status");
        QueryWrapper queryWrapper = new QueryWrapper();
        LambdaQueryWrapper in = (LambdaQueryWrapper)queryWrapper.lambda().in(EmployeeEntryInfo::getEmp_no, empNoList);
        if (StringUtils.isNotEmpty((CharSequence)task_status)) {
            in.eq(EmployeeEntryInfo::getTask_status, (Object)task_status);
        }
        List employeeEntryInfos = this.employeeEntryInfoMapper.selectList((Wrapper)queryWrapper);
        ArrayList<EmployeeEntryInfoVO> result = new ArrayList<EmployeeEntryInfoVO>();
        if (!CollectionUtils.isEmpty((Collection)employeeEntryInfos)) {
            for (EmployeeEntryInfo employeeEntryInfo : employeeEntryInfos) {
                List fileDataList;
                String work_report_attachment;
                List fileDataList2;
                EmployeeEntryInfoVO employeeEntryInfoVO = new EmployeeEntryInfoVO();
                BeanUtils.copyProperties((Object)employeeEntryInfo, (Object)employeeEntryInfoVO);
                String report_attachment = employeeEntryInfo.getReport_attachment_id();
                if (StringUtils.isNotEmpty((CharSequence)report_attachment) && !CollectionUtils.isEmpty((Collection)(fileDataList2 = ((FileInfoMapper)this.fileInfoDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().in((Object)"id", Arrays.asList(report_attachment.split(","))))))) {
                    FileInfoData fileInfoData = new FileInfoData();
                    fileInfoData.setData(fileDataList2);
                    employeeEntryInfoVO.setReport_attachment(fileInfoData);
                }
                if (StringUtils.isNotEmpty((CharSequence)(work_report_attachment = employeeEntryInfo.getWork_report_attachment_id())) && !CollectionUtils.isEmpty((Collection)(fileDataList = ((FileInfoMapper)this.fileInfoDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().in((Object)"id", Arrays.asList(work_report_attachment.split(","))))))) {
                    FileInfoData fileInfoData = new FileInfoData();
                    fileInfoData.setData(fileDataList);
                    employeeEntryInfoVO.setWork_report_attachment(fileInfoData);
                }
                result.add(employeeEntryInfoVO);
            }
        }
        return result;
    }
}

