/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.dtdapp.dao.st.EmployeeDAO;
import com.digiwin.athena.dtdapp.dao.st.OrganizationDAO;
import com.digiwin.athena.dtdapp.dao.st.StConfigDAO;
import com.digiwin.athena.dtdapp.mapper.stmapper.EmployeeMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.OrganizationMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.StConfigMapper;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Attribute;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Dept;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Dept_Employee;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Employee;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_EmployeeDepts;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Stronghold;
import com.digiwin.athena.dtdapp.pojo.dto.api.Api_Type;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.entity.st.Organization;
import com.digiwin.athena.dtdapp.pojo.entity.st.StConfig;
import com.digiwin.athena.dtdapp.service.DtdappIamService;
import com.digiwin.athena.dtdapp.util.HttpUtil;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DtdappEocService {
    private static final Logger log = LoggerFactory.getLogger(DtdappEocService.class);
    private static final String IAM_AP_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";
    private static final String DEPT_INFO = "/api/eoc/v2/dept/list";
    private static final String EMPLOYEE_INFO = "/api/eoc/v2/emp/list";
    private static final String DEPT_EMPLOYEE_INFO = "/api/eoc/v2/dept/cascade";
    private static final String JOB_TYPE = "/api/eoc/v2/emp/type/find";
    private static final String STRONGHOLD = "/api/eoc/v2/corp/company/";
    private static final String Attribute = "/api/eoc/v2/emp/attribute/find";
    private final String TENANT_ID = "99990000";
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${eocUrl}")
    private String eocUrl;
    @Autowired
    private DtdappIamService iamService;
    @Autowired
    private EmployeeDAO employeeDAO;
    @Autowired
    private OrganizationDAO organizationDAO;
    @Autowired
    private StConfigDAO stConfigDAO;

    public JSONArray getEmployeeInfo(List empId) throws Exception {
        String tenantToken = this.iamService.getTenantToken("99990000");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Contect-Type", "application/json");
        headers.add("digi-middleware-auth-user", tenantToken);
        headers.add("digi-middleware-auth-app", IAM_AP_TOKEN);
        ArrayList requestBody = new ArrayList();
        requestBody.addAll(empId);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(this.eocUrl + EMPLOYEE_INFO, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        String s = JSON.toJSONString((Object)body);
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        return jsonArray;
    }

    public JSONArray getDeptEmployee(List<Api_Dept> deptList) throws Exception {
        String tenantToken = this.iamService.getTenantToken("99990000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-data-mask", "false");
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);
        String[] strings = (String[])deptList.stream().map(Api_Dept::getId).toArray(String[]::new);
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("depts", strings);
        HashMap<String, Serializable> requestMap = new HashMap<String, Serializable>();
        requestMap.put("pageNum", Integer.valueOf(1));
        requestMap.put("pageSize", Integer.valueOf(99999));
        requestMap.put("params", params);
        String jsonString = JSON.toJSONString(requestMap);
        String s = HttpUtil.sendGet(this.eocUrl + DEPT_EMPLOYEE_INFO, jsonString, headers);
        JSONObject jsonObject = JSON.parseObject((String)s);
        JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
        return jsonArray;
    }

    public List<Api_Dept> getDeptInfo(String id) throws Exception {
        String[] split;
        String tenantToken = this.iamService.getTenantToken("99990000");
        ArrayList<Api_Dept> apiDepts = new ArrayList<Api_Dept>();
        List apiDept = new ArrayList();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);
        StConfig dept = (StConfig)((StConfigMapper)this.stConfigDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(StConfig::getType, (Object)"dept"));
        for (String s : split = dept.getValue().split(",")) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("deptContent", s);
            paramsMap.put("countEmp", true);
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("pageNum", "1");
            requestMap.put("pageSize", "99999");
            requestMap.put("params", paramsMap);
            String jsonString = JSON.toJSONString(requestMap);
            String forObject = HttpUtil.sendGet(this.eocUrl + DEPT_INFO, jsonString, headers);
            JSONObject jsonObject = JSON.parseObject((String)forObject);
            JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
            apiDept = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Api_Dept.class);
            apiDepts.addAll(apiDept);
        }
        return apiDepts;
    }

    public List<Api_Type> getJobType() throws Exception {
        String tenantToken = this.iamService.getTenantToken("99990000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-data-mask", "false");
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);
        HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
        String s = HttpUtil.postByFormData(this.eocUrl + JOB_TYPE, headers, objectObjectHashMap);
        log.info(s);
        JSONObject jsonObject = JSON.parseObject((String)s);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List apiType = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Api_Type.class);
        return apiType;
    }

    public List<Api_Stronghold> getCompany() throws Exception {
        String tenantToken = this.iamService.getTenantToken("99990000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("pageNum", "1");
        requestMap.put("pageSize", "99999");
        String jsonString = JSON.toJSONString(requestMap);
        String apiUrl1 = this.eocUrl + STRONGHOLD;
        String forObject1 = HttpUtil.sendGet(apiUrl1, jsonString, headers);
        JSONObject jsonObject = JSON.parseObject((String)forObject1);
        JSONArray jsonArray1 = jsonObject.getJSONObject("data").getJSONArray("list");
        List apiStrongholds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray1), Api_Stronghold.class);
        String apiUrl2 = this.eocUrl + STRONGHOLD + ((Api_Stronghold)apiStrongholds.get(0)).getSid() + "/" + 3;
        String forObject2 = HttpUtil.sendGet(apiUrl2, jsonString, headers);
        jsonObject = JSON.parseObject((String)forObject2);
        log.info("jsonObject={}", (Object)jsonObject);
        JSONArray jsonArray = jsonObject.getJSONObject("data").getJSONArray("list");
        List apiStrongholdS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Api_Stronghold.class);
        return apiStrongholdS;
    }

    public List<Api_Attribute> getAttribute() throws Exception {
        StConfig companySid = (StConfig)((StConfigMapper)this.stConfigDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(StConfig::getType, (Object)"companySid"));
        String tenantToken = this.iamService.getTenantToken("99990000");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", tenantToken);
        headers.put("digi-middleware-auth-app", IAM_AP_TOKEN);
        HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
        String forObject = HttpUtil.postByFormData(this.eocUrl + Attribute, headers, objectObjectHashMap);
        JSONObject jsonObject = JSON.parseObject((String)forObject);
        log.info("jsonObject={}", (Object)jsonObject);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List apiAttributes = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Api_Attribute.class);
        return apiAttributes;
    }

    public void insertDeptInfo() throws Exception {
        List<Api_Dept> depts = this.getDeptInfo(null);
        log.info("dept={}", (Object)depts.size());
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        boolean count = false;
        List allOrganizations = ((OrganizationMapper)this.organizationDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(Organization::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        HashMap<String, Long> organizationMap = new HashMap<String, Long>();
        for (Organization organization : allOrganizations) {
            organizationMap.put(organization.getOrg_no(), organization.getId());
        }
        List<Api_Dept> deptList = this.getDeptInfo(null);
        HashMap<String, String> apiDeptMap = new HashMap<String, String>();
        for (Api_Dept apiDept : deptList) {
            apiDeptMap.put(apiDept.getSid(), apiDept.getId());
        }
        for (Api_Dept apiDept : depts) {
            Organization organization = new Organization();
            if (organizationMap.containsKey(apiDept.getId())) {
                organization.setId((Long)organizationMap.get(apiDept.getId()));
            }
            organization.setOrg_no(apiDept.getId());
            organization.setOrg_name(apiDept.getName());
            organization.setOrg_level_id(apiDept.getLevelId());
            organization.setOrg_level(apiDept.getLevelName());
            organization.setSuper_org_no((String)apiDeptMap.get(apiDept.getParentSid()));
            organization.setOrg_supervisor_id(apiDept.getDirectorId());
            organization.setOrg_supervisor(apiDept.getDirectorName());
            organization.setStatus("Y");
            organization.setCorp_id(apiDept.getCorpId());
            organization.setCorp_name(apiDept.getCorpName());
            organization.setType(apiDept.getCompany() != false ? 0 : 1);
            organization.setEmpCount(apiDept.getEmpCount());
            organization.setEmpEnabled(apiDept.getEmpEnabled());
            organization.setTenantsid(LoginUserUtils.getTenantSid());
            organizations.add(organization);
            if (organizations.size() % 10 != 0) continue;
            this.organizationDAO.saveOrUpdateBatch(organizations);
        }
        this.organizationDAO.saveOrUpdateBatch(organizations);
    }

    public void insertEmployeeInfo() throws Exception {
        StConfig dept = (StConfig)((StConfigMapper)this.stConfigDAO.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().lambda().eq(StConfig::getType, (Object)"dept"));
        List<Api_Dept> deptList = this.getDeptInfo(null);
        HashMap<String, String> deptMap = new HashMap<String, String>();
        HashMap<String, String> apiDeptMap = new HashMap<String, String>();
        for (Api_Dept apiDept : deptList) {
            deptMap.put(apiDept.getDirectorUserId(), apiDept.getDirectorUserName());
            apiDeptMap.put(apiDept.getId(), apiDept.getDirectorId());
        }
        List<Api_Type> jobTypeList = this.getJobType();
        HashMap<Long, String> typeMap = new HashMap<Long, String>();
        for (Api_Type apiType : jobTypeList) {
            typeMap.put(apiType.getSid(), apiType.getName());
        }
        List<Api_Stronghold> apiStrongholdList = this.getCompany();
        HashMap<String, Api_Stronghold> strongholdMap = new HashMap<String, Api_Stronghold>();
        for (Api_Stronghold apiStronghold : apiStrongholdList) {
            strongholdMap.put(apiStronghold.getSid(), apiStronghold);
        }
        List<Api_Attribute> apiAttributeList = this.getAttribute();
        HashMap<String, Api_Attribute> attributeMap = new HashMap<String, Api_Attribute>();
        for (Api_Attribute api_attribute : apiAttributeList) {
            attributeMap.put(api_attribute.getSid(), api_attribute);
        }
        List allEmployees = new ArrayList();
        HashSet<String> digiwinCloudEmps = new HashSet<String>();
        JSONArray jsonArray = this.getDeptEmployee(deptList);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject listItem = jsonArray.getJSONObject(i);
            JSONArray empsArray = listItem.getJSONArray("emps");
            List apiEmployees1 = JSON.parseArray((String)JSON.toJSONString((Object)empsArray), Api_Dept_Employee.class);
            ArrayList<Employee> employees = new ArrayList<Employee>();
            ArrayList<String> empIdList = new ArrayList<String>();
            log.info("empsArray.size()={}", (Object)empsArray.size());
            boolean count = false;
            allEmployees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            HashMap<String, Employee> employeeMap = new HashMap<String, Employee>();
            for (Employee employee : allEmployees) {
                employeeMap.put(employee.getEmployee_no(), employee);
            }
            for (Api_Dept_Employee emp : apiEmployees1) {
                empIdList.add(emp.getId());
                digiwinCloudEmps.add(emp.getId());
                if (empIdList.size() % 100 != 0) continue;
                JSONArray employeeInfo = this.getEmployeeInfo(empIdList);
                List apiEmployees = JSON.parseArray((String)JSON.toJSONString((Object)employeeInfo), Api_Employee.class);
                for (Object apiEmployee2 : apiEmployees) {
                    String id;
                    Employee employee = new Employee();
                    block24: for (Api_EmployeeDepts employeeDept : ((Api_Employee)apiEmployee2).getDepts()) {
                        String[] split;
                        for (String s : split = dept.getValue().split(",")) {
                            int length = s.length();
                            String substring = employeeDept.getId().substring(0, length);
                            if (!s.equals(substring)) continue;
                            employee.setOrg_no(employeeDept.getId());
                            break block24;
                        }
                    }
                    if (employeeMap.containsKey(((Api_Employee)apiEmployee2).getId())) {
                        employee.setId(((Employee)employeeMap.get(((Api_Employee)apiEmployee2).getId())).getId());
                        if (StringUtils.isEmpty((CharSequence)((Employee)employeeMap.get(((Api_Employee)apiEmployee2).getId())).getApproval_no())) {
                            employee.setApproval_no((String)apiDeptMap.get(employee.getOrg_no()));
                        } else {
                            employee.setApproval_no(((Employee)employeeMap.get(((Api_Employee)apiEmployee2).getId())).getApproval_no());
                        }
                    } else {
                        employee.setNeed_report_work(!deptMap.containsKey(((Api_Employee)apiEmployee2).getId()));
                        employee.setReport_frequency("D");
                        employee.setApproval_no((String)apiDeptMap.get(employee.getOrg_no()));
                    }
                    employee.setEmployee_no(((Api_Employee)apiEmployee2).getId());
                    employee.setEmployee_name(((Api_Employee)apiEmployee2).getName());
                    employee.setEmail(((Api_Employee)apiEmployee2).getEmail());
                    employee.setTitle(((Api_Employee)apiEmployee2).getDuties().get(0).getName());
                    employee.setQuitDate(((Api_Employee)apiEmployee2).getQuitDate());
                    employee.setType((String)typeMap.get(((Api_Employee)apiEmployee2).getTypeSid()));
                    employee.setStronghold(((Api_Stronghold)strongholdMap.get(((Api_Employee)apiEmployee2).getStrongholdSid())).getName());
                    employee.setEmployee_attributes(((Api_Attribute)attributeMap.get(((Api_Employee)apiEmployee2).getAttributeSid())).getName());
                    switch (id = ((Api_Stronghold)strongholdMap.get(((Api_Employee)apiEmployee2).getStrongholdSid())).getId().substring(0, 2)) {
                        case "C0": {
                            employee.setArea("CN");
                            break;
                        }
                        case "T0": {
                            employee.setArea("TW");
                            break;
                        }
                        default: {
                            employee.setArea("OTHER");
                        }
                    }
                    employee.setStatus(((Api_Employee)apiEmployee2).getStatus() != false ? "Y" : "N");
                    employee.setTenantsid(LoginUserUtils.getTenantSid());
                    employees.add(employee);
                }
                this.employeeDAO.saveOrUpdateBatch(employees);
                employees.clear();
                empIdList.clear();
            }
            allEmployees = ((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            employeeMap = new HashMap();
            for (Employee employee : allEmployees) {
                employeeMap.put(employee.getEmployee_no(), employee);
            }
            JSONArray employeeInfo = this.getEmployeeInfo(empIdList);
            List apiEmployees = JSON.parseArray((String)JSON.toJSONString((Object)employeeInfo), Api_Employee.class);
            for (Api_Employee apiEmployee : apiEmployees) {
                Object apiEmployee2;
                Employee employee = new Employee();
                apiEmployee2 = apiEmployee.getDepts().iterator();
                block28: while (apiEmployee2.hasNext()) {
                    String[] split;
                    Api_EmployeeDepts employeeDept = (Api_EmployeeDepts)apiEmployee2.next();
                    for (String s : split = dept.getValue().split(",")) {
                        int length = s.length();
                        String substring = employeeDept.getId().substring(0, length);
                        if (!s.equals(substring)) continue;
                        employee.setOrg_no(employeeDept.getId());
                        break block28;
                    }
                }
                if (employeeMap.containsKey(apiEmployee.getId())) {
                    employee.setId(((Employee)employeeMap.get(apiEmployee.getId())).getId());
                    if (StringUtils.isEmpty((CharSequence)((Employee)employeeMap.get(apiEmployee.getId())).getApproval_no())) {
                        employee.setApproval_no((String)apiDeptMap.get(employee.getOrg_no()));
                    } else {
                        employee.setApproval_no(((Employee)employeeMap.get(apiEmployee.getId())).getApproval_no());
                    }
                } else {
                    employee.setNeed_report_work(!deptMap.containsKey(apiEmployee.getId()));
                    employee.setReport_frequency("D");
                    employee.setApproval_no((String)apiDeptMap.get(employee.getOrg_no()));
                }
                employee.setEmployee_no(apiEmployee.getId());
                employee.setEmployee_name(apiEmployee.getName());
                employee.setEmail(apiEmployee.getEmail());
                employee.setTitle(apiEmployee.getDuties().get(0).getName());
                employee.setQuitDate(apiEmployee.getQuitDate());
                employee.setType((String)typeMap.get(apiEmployee.getTypeSid()));
                String stronghold = apiEmployee.getStrongholdSid();
                log.info("a={}", (Object)stronghold);
                employee.setStronghold(((Api_Stronghold)strongholdMap.get(apiEmployee.getStrongholdSid())).getName());
                employee.setEmployee_attributes(((Api_Attribute)attributeMap.get(apiEmployee.getAttributeSid())).getName());
                String id = ((Api_Stronghold)strongholdMap.get(apiEmployee.getStrongholdSid())).getId().substring(0, 2);
                switch (id) {
                    case "C0": {
                        employee.setArea("CN");
                        break;
                    }
                    case "T0": {
                        employee.setArea("TW");
                        break;
                    }
                    default: {
                        employee.setArea("OTHER");
                    }
                }
                employee.setStatus(apiEmployee.getStatus() != false ? "Y" : "N");
                employee.setTenantsid(LoginUserUtils.getTenantSid());
                employees.add(employee);
            }
            this.employeeDAO.saveOrUpdateBatch(employees);
        }
        ArrayList<Employee> quitEmployees = new ArrayList<Employee>();
        for (Employee employee : allEmployees) {
            if (digiwinCloudEmps.contains(employee.getEmployee_no())) continue;
            employee.setStatus("N");
            quitEmployees.add(employee);
        }
        this.employeeDAO.updateBatchById(quitEmployees);
    }

    public Map<String, List<Api_Employee>> getApiEmployee(Integer batchSize) throws Exception {
        List<Api_Dept> deptList = this.getDeptInfo(null);
        JSONArray deptJson = this.getDeptEmployee(deptList);
        HashMap<String, List<Api_Employee>> result = new HashMap<String, List<Api_Employee>>();
        if (Objects.nonNull(deptJson) && deptJson.size() > 0) {
            for (int i = 0; i < deptJson.size(); ++i) {
                JSONObject listItem = deptJson.getJSONObject(i);
                if (Objects.isNull(listItem)) continue;
                JSONArray empsArray = listItem.getJSONArray("emps");
                List apiEmployees = JSON.parseArray((String)JSON.toJSONString((Object)empsArray), Api_Dept_Employee.class);
                ArrayList<String> empIdList = new ArrayList<String>();
                log.info("empsArray.size()={}", (Object)empsArray.size());
                for (Api_Dept_Employee emp : apiEmployees) {
                    empIdList.add(emp.getId());
                }
                List batches = this.splitListIntoBatches(empIdList, batchSize);
                ArrayList resultList = new ArrayList();
                for (List batch : batches) {
                    JSONArray employeeInfo = this.getEmployeeInfo(batch);
                    resultList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)employeeInfo), Api_Employee.class));
                }
                result.put(listItem.getString("id"), resultList);
            }
        }
        return result;
    }

    private <T> List<List<T>> splitListIntoBatches(List<T> originalList, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int i = 0; i < originalList.size(); i += batchSize) {
            int end = Math.min(i + batchSize, originalList.size());
            batches.add(originalList.subList(i, end));
        }
        return batches;
    }
}

