/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.digiwin.app.service.DWFile;
import com.digiwin.athena.dtdapp.pojo.neo4j.Action;
import com.digiwin.athena.dtdapp.pojo.vo.publish.PublishRequest;
import com.digiwin.athena.dtdapp.pojo.vo.publish.PublishResult;
import com.digiwin.athena.dtdapp.repoNeo4j.DtdappActionRepository;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DtdappPublishService {
    private static final Logger log = LoggerFactory.getLogger(DtdappPublishService.class);
    @Autowired(required=false)
    @Qualifier(value="dtdappSessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired
    DtdappActionRepository actionRepository;

    public Object publishEspActionByProduct(PublishRequest publishRequest) {
        return null;
    }

    public Object publishEspActionByServiceNameList(List<String> serviceNameList) {
        return "success";
    }

    private void initVirtualTenantForNeo4j() {
        log.info("=================start initVirtualTenantForNeo4j==================");
        ArrayList<String> tenantList = new ArrayList<String>();
        String t1 = "merge (te:TenantEntity{tenantId:'VIRTUAL_V1'}) set te.ifCommon = true, te.version='1.0'";
        String t2 = "merge (te:TenantEntity{tenantId:'VIRTUAL_V2'}) set te.ifCommon = true, te.version='2.0'";
        tenantList.add(t1);
        tenantList.add(t2);
        this.executeNeo4jScript(tenantList, this.sessionFactoryDomain1);
        log.info("=================finish initVirtualTenantForNeo4j==================");
    }

    private List<Object> executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return null;
        }
        if (sessionFactory == null) {
            return null;
        }
        ArrayList<Object> errorResult = new ArrayList<Object>();
        Session session = sessionFactory.openSession();
        for (String str : executeNeo4jScripts) {
            try {
                session.query(str, new HashMap());
            }
            catch (Exception e) {
                errorResult.add(str);
                log.error("=====executeNeo4jScriptError:{}", (Object)str);
            }
        }
        session.clear();
        return errorResult;
    }

    public Object generateActionScriptByProduct(PublishRequest publishRequest) {
        return null;
    }

    public void deleteFolders(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Files.delete(file);
                    log.info("\u5220\u9664\u6587\u4ef6: {}", (Object)file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    log.info("\u6587\u4ef6\u5939\u88ab\u5220\u9664: {}", (Object)dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object generateActionScriptByServiceNameList(List<String> serviceNameList, String createFrom, String version) {
        log.info("=====start clear file directory=========");
        this.deleteFolders("neo4jExport/");
        log.info("serviceNameList:{}", serviceNameList);
        if (StringUtils.isEmpty((CharSequence)createFrom)) {
            createFrom = "batchInitScript" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> exportActionCountErrorList = new ArrayList<String>();
        File file = null;
        int fileIndex = 1;
        int line = 1;
        for (String serviceName : serviceNameList) {
            String actionId = "esp_" + serviceName.trim();
            List<Action> byActionId = this.actionRepository.findByActionId(actionId);
            if (byActionId.size() != 2) {
                log.info("===>action:{}, size:{}", (Object)actionId, (Object)byActionId.size());
                exportActionCountErrorList.add("action:" + actionId + ",size:" + byActionId.size() + ",version:" + (org.apache.commons.collections.CollectionUtils.isNotEmpty(byActionId) ? byActionId.get(0).getVersion() : ""));
            } else {
                Action action = byActionId.get(0);
                Action action1 = byActionId.get(1);
                if (!StringUtils.equals((CharSequence)action.getServiceVersion(), (CharSequence)action1.getServiceVersion())) {
                    exportActionCountErrorList.add("action:" + actionId + ", serviceVersion:" + action.getServiceVersion() + ", " + action1.getServiceVersion());
                }
            }
            for (Action action : byActionId) {
                if (StringUtils.isNotEmpty((CharSequence)version) && version.equals(action.getVersion())) continue;
                set.add(action.getActionId());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Create (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("', url:'");
                stringBuffer.append(action.getUrl());
                stringBuffer.append("', serviceName:'");
                stringBuffer.append(action.getServiceName());
                stringBuffer.append("', serviceVersion:'");
                stringBuffer.append(action.getServiceVersion());
                stringBuffer.append("', actionName:'");
                stringBuffer.append(action.getActionName());
                stringBuffer.append("', actionName_tw:'");
                stringBuffer.append(action.getActionName_tw());
                stringBuffer.append("', desc:'");
                stringBuffer.append(action.getDesc());
                stringBuffer.append("', desc_tw:'");
                stringBuffer.append(action.getDesc_tw());
                stringBuffer.append("', request_parameters:'");
                stringBuffer.append(action.getRequest_parameters());
                stringBuffer.append("', response_object:'");
                stringBuffer.append(action.getResponse_object());
                stringBuffer.append("', invokeType:'");
                stringBuffer.append(action.getInvokeType());
                stringBuffer.append("', lastUpdateTime:'");
                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                stringBuffer.append("', updateTime:'");
                stringBuffer.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                stringBuffer.append("', idempotency:");
                stringBuffer.append(action.getIdempotency());
                stringBuffer.append(", version:'");
                stringBuffer.append(action.getVersion());
                if (StringUtils.isNotEmpty((CharSequence)action.getTenantId())) {
                    stringBuffer.append("', tenantId:'");
                    stringBuffer.append(action.getTenantId());
                }
                stringBuffer.append("', createFrom:'");
                stringBuffer.append(createFrom);
                stringBuffer.append("', nameSpace:'");
                stringBuffer.append("espCommon");
                stringBuffer.append("'});");
                try {
                    if (line == 1) {
                        file = new File("neo4jExport/espActionScript" + fileIndex + ".txt");
                        FileUtils.write((File)file, (CharSequence)"", (String)"UTF-8", (boolean)false);
                    } else if (line == 2800) {
                        line = 0;
                        ++fileIndex;
                    }
                    System.out.println("===>" + ++line);
                    FileUtils.writeLines((File)file, (String)"UTF-8", Arrays.asList(StringEscapeUtils.escapeJava((String)stringBuffer.toString())), (boolean)true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        log.info("====total generate script action:{}", set);
        this.generateFlagAndDeleteScriptFile(set, createFrom, version);
        this.generateErrorSizeActionFile(exportActionCountErrorList);
        log.info("============finish==============");
        return null;
    }

    private void generateErrorSizeActionFile(List<String> exportActionCountErrorList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(exportActionCountErrorList)) {
            return;
        }
        try {
            File file = new File("neo4jExport/exportActionCountError.txt");
            FileUtils.write((File)file, (CharSequence)"", (String)"UTF-8", (boolean)false);
            FileUtils.writeLines((File)file, (String)"UTF-8", exportActionCountErrorList, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateFlagAndDeleteScriptFile(Set<String> set, String createFrom, String version) {
        String leftCodesStr = "['" + StringUtils.join(set, (String)"','") + "']";
        String beforeScript = null;
        String toDeleteScript = null;
        String mergeScript = null;
        String mergeScript2 = null;
        if (StringUtils.isEmpty((CharSequence)version)) {
            beforeScript = "match (a:Action) where a.actionId in " + leftCodesStr + " set a.flagtag = 'old' return count(a);";
            toDeleteScript = "match (a:Action) where a.flagtag = 'old' detach delete a;";
            mergeScript = "match (te:TenantEntity{ifCommon:true,version:'1.0'}) match (espAction:EspAction{createFrom:'" + createFrom + "', version:'1.0'}) merge (te)-[:ACTION]->(espAction);";
            mergeScript2 = "match (te:TenantEntity{ifCommon:true,version:'2.0'}) match (espAction:EspAction{createFrom:'" + createFrom + "', version:'2.0'}) merge (te)-[:ACTION]->(espAction);";
        } else {
            beforeScript = "match (a:Action) where a.actionId in " + leftCodesStr + " and a.version = '" + version + "' set a.flagtag = 'old' return count(a);";
            toDeleteScript = "match (a:Action) where a.flagtag = 'old' detach delete a;";
            if (version.equals("1.0")) {
                mergeScript = "match (te:TenantEntity{ifCommon:true,version:'1.0'}) match (espAction:EspAction{createFrom:'" + createFrom + "', version:'1.0'}) merge (te)-[:ACTION]->(espAction);";
            }
            if (version.equals("2.0")) {
                mergeScript2 = "match (te:TenantEntity{ifCommon:true,version:'2.0'}) match (espAction:EspAction{createFrom:'" + createFrom + "', version:'2.0'}) merge (te)-[:ACTION]->(espAction);";
            }
        }
        String toDeleteScript2 = "match (a:Action) where a.actionId in " + leftCodesStr + " and a.flagtag = 'old' detach delete a;";
        try {
            File file = new File("neo4jExport/beforeInsert.txt");
            FileUtils.write((File)file, (CharSequence)"", (String)"UTF-8", (boolean)false);
            FileUtils.writeLines((File)file, (String)"UTF-8", Arrays.asList(beforeScript), (boolean)true);
            File file2 = new File("neo4jExport/afterInsert.txt");
            FileUtils.write((File)file2, (CharSequence)"", (String)"UTF-8", (boolean)false);
            FileUtils.writeLines((File)file2, (String)"UTF-8", Arrays.asList(toDeleteScript, mergeScript, mergeScript2), (boolean)true);
            File file3 = new File("neo4jExport/afterInsert2.txt");
            FileUtils.write((File)file3, (CharSequence)"", (String)"UTF-8", (boolean)false);
            FileUtils.writeLines((File)file3, (String)"UTF-8", Arrays.asList(toDeleteScript2), (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublishResult executeScript(DWFile dwFile) {
        InputStream inputStream = dwFile.getInputStream();
        File tempFile = new File("tempFile.txt");
        log.info("============start==============");
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            List list = FileUtils.readLines((File)tempFile, (String)"UTF-8");
            List partitions = Lists.partition((List)list, (int)200);
            int i = 0;
            for (List par : partitions) {
                log.info("execute partitions\uff1a{}", (Object)(++i));
                List<Object> objectList = this.executeNeo4jScript(par, this.sessionFactoryDomain1);
                result.addAll(objectList);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            log.info("===delete temp file=====");
            tempFile.delete();
        }
        log.info("============finish==============");
        PublishResult publishResult = new PublishResult();
        publishResult.setErrorScripts(result);
        return publishResult;
    }
}

