/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.dao.newemployeereview.NewEmployeeReviewProportionDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.NewEmployeesReviewDetailDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.NewEmployeesReviewMentorDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.ProbationaryPeriodGoalsDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.ProbationaryPeriodPlansDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.SummaryOneMonthDetailsDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.SummaryOneWeekDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.SummaryThreeMonthDetailsDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.SummaryTwoMonthDetailsDAO;
import com.digiwin.athena.dtdapp.dao.newemployeereview.SummaryTwoWeekDetailsDAO;
import com.digiwin.athena.dtdapp.dao.st.EmployeeDAO;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.NewEmployeeReviewProportionMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.NewEmployeesReviewDetailMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.NewEmployeesReviewMentorMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.ProbationaryPeriodGoalsMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.ProbationaryPeriodPlansMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.SummaryOneMonthDetailsMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.SummaryOneWeekMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.SummaryThreeMonthDetailsMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.SummaryTwoMonthDetailsMapper;
import com.digiwin.athena.dtdapp.mapper.newemployeereviewmapper.SummaryTwoWeekDetailsMapper;
import com.digiwin.athena.dtdapp.mapper.stmapper.EmployeeMapper;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.NewEmployeeReviewProportion;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.NewEmployeesReviewDetail;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.NewEmployeesReviewMentor;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.ProbationaryPeriodGoals;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.ProbationaryPeriodPlans;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.SummaryOneMonthDetails;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.SummaryOneWeekDetails;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.SummaryThreeMonthDetails;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.SummaryTwoMonthDetails;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.SummaryTwoWeekDetails;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.enums.Status;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.NewEmployeeReviewInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.NewEmployeeReviewInfoVO2;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.ProbationaryPeriodGoalsVO;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.ProbationaryPeriodPlanVO;
import com.digiwin.athena.dtdapp.util.AttachmentUtils;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewEmployeeReviewService {
    private static final Logger log = LoggerFactory.getLogger(NewEmployeeReviewService.class);
    @Autowired
    private EmployeeDAO employeeDAO;
    @Autowired
    private NewEmployeesReviewDetailDAO newEmployeesReviewDetailDAO;
    @Autowired
    private ProbationaryPeriodGoalsDAO probationaryPeriodGoalsDAO;
    @Autowired
    private SummaryOneWeekDAO summaryOneWeekDAO;
    @Autowired
    private ProbationaryPeriodPlansDAO probationaryPeriodPlansDAO;
    @Autowired
    private SummaryTwoWeekDetailsDAO summaryTwoWeekDetailsDAO;
    @Autowired
    private SummaryOneMonthDetailsDAO summaryOneMonthDetailsDAO;
    @Autowired
    private SummaryTwoMonthDetailsDAO summaryTwoMonthDetailsDAO;
    @Autowired
    private SummaryThreeMonthDetailsDAO summaryThreeMonthDetailsDAO;
    @Autowired
    private NewEmployeesReviewMentorDAO newEmployeesReviewMentorDAO;
    @Autowired
    private NewEmployeeReviewProportionDAO newEmployeeReviewProportionDAO;

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewInfo(Map map) throws DWException {
        Employee getEmployee;
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        String email = LoginUserUtils.getLoginUserId();
        if (email == null) {
            throw new DWException("no date");
        }
        int loop = -1;
        List<Object> newEmployeeReviewInfoVOS = new ArrayList();
        List<NewEmployeesReviewDetail> tutorDetails = new ArrayList();
        List<NewEmployeesReviewDetail> PMDetails = new ArrayList();
        NewEmployeesReviewDetail ownerDetail = null;
        List PMODetails = null;
        HashMap<String, NewEmployeesReviewDetail> newEmployeesReviewDetailMap = new HashMap<String, NewEmployeesReviewDetail>();
        ownerDetail = (NewEmployeesReviewDetail)((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getOwner_emp_email, (Object)email));
        if (ownerDetail != null) {
            loop = 1;
            newEmployeesReviewDetailMap.put(ownerDetail.getOwner_emp_email(), ownerDetail);
        }
        if (CollectionUtils.isNotEmpty(tutorDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getTutor_email, (Object)email)))) {
            loop = 2;
            for (NewEmployeesReviewDetail newEmployeesReviewDetail : tutorDetails) {
                if (newEmployeesReviewDetailMap.containsKey(newEmployeesReviewDetail.getOwner_emp_email())) continue;
                newEmployeesReviewDetailMap.put(newEmployeesReviewDetail.getOwner_emp_email(), newEmployeesReviewDetail);
            }
        }
        if (CollectionUtils.isNotEmpty(PMDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getManager_email, (Object)email)))) {
            loop = 3;
            for (NewEmployeesReviewDetail newEmployeesReviewDetail : PMDetails) {
                if (newEmployeesReviewDetailMap.containsKey(newEmployeesReviewDetail.getOwner_emp_email())) continue;
                newEmployeesReviewDetailMap.put(newEmployeesReviewDetail.getOwner_emp_email(), newEmployeesReviewDetail);
            }
        }
        if ((getEmployee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmail, (Object)email)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null && ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position()))) {
            loop = 4;
            PMODetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            for (NewEmployeesReviewDetail PMODetail : PMODetails) {
                if (newEmployeesReviewDetailMap.containsKey(PMODetail.getOwner_emp_email())) continue;
                newEmployeesReviewDetailMap.put(PMODetail.getOwner_emp_email(), PMODetail);
            }
        }
        if (loop == 1) {
            ArrayList<NewEmployeesReviewDetail> arrayList = new ArrayList<NewEmployeesReviewDetail>();
            arrayList.add(ownerDetail);
            newEmployeeReviewInfoVOS = this.getInfo(arrayList, loop, true, false);
        } else if (loop == 2) {
            newEmployeeReviewInfoVOS = this.getInfo(tutorDetails, loop, true, false);
        } else if (loop == 3) {
            newEmployeeReviewInfoVOS = this.getInfo(PMDetails, loop, true, false);
        } else if (loop == 4) {
            newEmployeeReviewInfoVOS = this.getInfo(PMODetails, loop, true, false);
        }
        if (loop == -1) {
            return new ArrayList<NewEmployeeReviewInfoVO>();
        }
        return newEmployeeReviewInfoVOS;
    }

    private List<NewEmployeeReviewInfoVO> getInfo(List<NewEmployeesReviewDetail> newEmployeesReviewDetails, int loop, Boolean isNeedArray, Boolean isNeedDesc) {
        ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            SummaryThreeMonthDetails summaryThreeMonthDetails;
            SummaryTwoMonthDetails summaryTwoMonthDetails;
            SummaryOneMonthDetails summaryOneMonthDetails;
            SummaryTwoWeekDetails summaryTwoWeekDetails;
            SummaryOneWeekDetails summaryOneWeekDetails;
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            BeanUtils.copyProperties((Object)newEmployeesReviewDetail, (Object)newEmployeeReviewInfoVO);
            if (isNeedDesc.booleanValue()) {
                newEmployeeReviewInfoVO.setJob_title(Status.fromValue(newEmployeesReviewDetail.getJob_title()));
                newEmployeeReviewInfoVO.setJob_level(Status.fromValue(newEmployeesReviewDetail.getJob_level()));
                if ("3".equals(newEmployeeReviewInfoVO.getProbationary_period_term())) {
                    newEmployeeReviewInfoVO.setProbationary_period_term("\u4e09\u4e2a\u6708");
                } else if ("6".equals(newEmployeeReviewInfoVO.getProbationary_period_term())) {
                    newEmployeeReviewInfoVO.setProbationary_period_term("\u516d\u4e2a\u6708");
                }
                newEmployeeReviewInfoVO.setEmployee_attribute(Status.fromValue(newEmployeesReviewDetail.getEmployee_attribute()));
                newEmployeeReviewInfoVO.setEmployee_status(Status.fromValue(newEmployeesReviewDetail.getEmployee_status()));
            }
            if (isNeedArray.booleanValue()) {
                List probationaryPeriodGoals = ((ProbationaryPeriodGoalsMapper)this.probationaryPeriodGoalsDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProbationaryPeriodGoals::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(ProbationaryPeriodGoals::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                ArrayList<ProbationaryPeriodGoalsVO> probationaryPeriodGoalsVOS = new ArrayList<ProbationaryPeriodGoalsVO>();
                if (CollectionUtils.isNotEmpty((Collection)probationaryPeriodGoals)) {
                    for (Object probationaryPeriodGoal : probationaryPeriodGoals) {
                        ProbationaryPeriodGoalsVO probationaryPeriodGoalsVO = new ProbationaryPeriodGoalsVO();
                        probationaryPeriodGoalsVO.setGoal_id(((ProbationaryPeriodGoals)probationaryPeriodGoal).getGoal_id());
                        probationaryPeriodGoalsVO.setGoal_category(((ProbationaryPeriodGoals)probationaryPeriodGoal).getGoal_category());
                        probationaryPeriodGoalsVO.setGoal_project_no(((ProbationaryPeriodGoals)probationaryPeriodGoal).getProject_no());
                        probationaryPeriodGoalsVO.setGoal_project_name(((ProbationaryPeriodGoals)probationaryPeriodGoal).getProject_name());
                        probationaryPeriodGoalsVO.setGoal_weight(((ProbationaryPeriodGoals)probationaryPeriodGoal).getWeight());
                        probationaryPeriodGoalsVO.setGoal_achieved_details(((ProbationaryPeriodGoals)probationaryPeriodGoal).getAchieved_details());
                        probationaryPeriodGoalsVO.setGoal_measurement_standard(((ProbationaryPeriodGoals)probationaryPeriodGoal).getMeasurement_standard());
                        probationaryPeriodGoalsVO.setOwner_emp_email(((ProbationaryPeriodGoals)probationaryPeriodGoal).getOwner_emp_email());
                        probationaryPeriodGoalsVOS.add(probationaryPeriodGoalsVO);
                    }
                }
                newEmployeeReviewInfoVO.setProbationary_period_goals(probationaryPeriodGoalsVOS);
            }
            if ((summaryOneWeekDetails = (SummaryOneWeekDetails)((SummaryOneWeekMapper)this.summaryOneWeekDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SummaryOneWeekDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryOneWeekDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                newEmployeeReviewInfoVO.setOne_week_new_employees_review_detail_id(summaryOneWeekDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setOne_week_trial_period_goal(summaryOneWeekDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setOne_week_monthly_summary_plan(summaryOneWeekDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setOne_week_deviation_current_cycle(summaryOneWeekDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_reason_current_cycle(summaryOneWeekDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_next_cycle(summaryOneWeekDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_reason_next_cycle(summaryOneWeekDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setOne_week_help_needed(summaryOneWeekDetails.getHelp_needed());
                newEmployeeReviewInfoVO.setOne_week_is_familiar_with_process(summaryOneWeekDetails.getIs_familiar_with_process());
                newEmployeeReviewInfoVO.setOne_week_is_weekly_report_completed(summaryOneWeekDetails.getIs_weekly_report_completed());
                newEmployeeReviewInfoVO.setOne_week_is_communicated_with_academy(summaryOneWeekDetails.getIs_communicated_with_academy());
                newEmployeeReviewInfoVO.setOne_week_is_daily_progress_synced(summaryOneWeekDetails.getIs_daily_progress_synced());
            }
            ArrayList<ProbationaryPeriodPlanVO> probationaryPeriodPlanVOS = new ArrayList<ProbationaryPeriodPlanVO>();
            if (isNeedArray.booleanValue()) {
                List probationaryPeriodPlans;
                if (summaryOneWeekDetails != null && CollectionUtils.isNotEmpty((Collection)(probationaryPeriodPlans = ((ProbationaryPeriodPlansMapper)this.probationaryPeriodPlansDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProbationaryPeriodPlans::getSummary_one_week_details_id, (Object)summaryOneWeekDetails.getSummary_one_week_details_id())).eq(ProbationaryPeriodPlans::getTenantsid, (Object)LoginUserUtils.getTenantSid()))))) {
                    Object probationaryPeriodGoal;
                    probationaryPeriodGoal = probationaryPeriodPlans.iterator();
                    while (probationaryPeriodGoal.hasNext()) {
                        ProbationaryPeriodPlans probationaryPeriodPlan = (ProbationaryPeriodPlans)probationaryPeriodGoal.next();
                        ProbationaryPeriodPlanVO probationaryPeriodPlanVO = new ProbationaryPeriodPlanVO();
                        probationaryPeriodPlanVO.setPlan_category(probationaryPeriodPlan.getPlan_category());
                        probationaryPeriodPlanVO.setPlan_project_name(probationaryPeriodPlan.getProject_name());
                        probationaryPeriodPlanVO.setPlan_project_no(probationaryPeriodPlan.getProject_no());
                        probationaryPeriodPlanVO.setPlan_achieved_plan_details(probationaryPeriodPlan.getAchieved_plan_details());
                        probationaryPeriodPlanVO.setPlan_measurement_standard(probationaryPeriodPlan.getMeasurement_standard());
                        probationaryPeriodPlanVO.setPlan_weight(probationaryPeriodPlan.getWeight());
                        probationaryPeriodPlanVO.setOwner_emp_email(probationaryPeriodPlan.getOwner_emp_email());
                        probationaryPeriodPlanVOS.add(probationaryPeriodPlanVO);
                    }
                }
                newEmployeeReviewInfoVO.setProbationary_period_plan(probationaryPeriodPlanVOS);
            }
            if ((summaryTwoWeekDetails = (SummaryTwoWeekDetails)((SummaryTwoWeekDetailsMapper)this.summaryTwoWeekDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SummaryTwoWeekDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryTwoWeekDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                newEmployeeReviewInfoVO.setTwo_week_new_employees_review_detail_id(summaryTwoWeekDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setTwo_week_trial_period_goal(summaryTwoWeekDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setTwo_week_monthly_summary_plan(summaryTwoWeekDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setTwo_week_deviation_current_cycle(summaryTwoWeekDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_reason_current_cycle(summaryTwoWeekDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_next_cycle(summaryTwoWeekDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_reason_next_cycle(summaryTwoWeekDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setTwo_week_help_needed(summaryTwoWeekDetails.getHelp_needed());
            }
            if ((summaryOneMonthDetails = (SummaryOneMonthDetails)((SummaryOneMonthDetailsMapper)this.summaryOneMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SummaryOneMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryOneMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                newEmployeeReviewInfoVO.setOne_month_new_employees_review_detail_id(summaryOneMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setOne_month_trial_period_goal(summaryOneMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setOne_month_monthly_summary_plan(summaryOneMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setOne_month_deviation_current_cycle(summaryOneMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_reason_current_cycle(summaryOneMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_next_cycle(summaryOneMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_reason_next_cycle(summaryOneMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setOne_month_help_needed(summaryOneMonthDetails.getHelp_needed());
            }
            if ((summaryTwoMonthDetails = (SummaryTwoMonthDetails)((SummaryTwoMonthDetailsMapper)this.summaryTwoMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SummaryTwoMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryTwoMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                newEmployeeReviewInfoVO.setTwo_month_new_employees_review_detail_id(summaryTwoMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setTwo_month_trial_period_goal(summaryTwoMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setTwo_month_monthly_summary_plan(summaryTwoMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setTwo_month_deviation_current_cycle(summaryTwoMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_reason_current_cycle(summaryTwoMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_next_cycle(summaryTwoMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_reason_next_cycle(summaryTwoMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setTwo_month_help_needed(summaryTwoMonthDetails.getHelp_needed());
            }
            if ((summaryThreeMonthDetails = (SummaryThreeMonthDetails)((SummaryThreeMonthDetailsMapper)this.summaryThreeMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SummaryThreeMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryThreeMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null) {
                newEmployeeReviewInfoVO.setThree_month_new_employees_review_detail_id(summaryThreeMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setThree_month_trial_period_goal(summaryThreeMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setThree_month_monthly_summary_plan(summaryThreeMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setThree_month_deviation_current_cycle(summaryThreeMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_reason_current_cycle(summaryThreeMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_next_cycle(summaryThreeMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_reason_next_cycle(summaryThreeMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setThree_month_help_needed(summaryThreeMonthDetails.getHelp_needed());
            }
            if (loop > 1) {
                NewEmployeesReviewMentor newEmployeesReviewMentor = (NewEmployeesReviewMentor)((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
                newEmployeeReviewInfoVO.setIs_edit(true);
                if (newEmployeesReviewMentor != null) {
                    BeanUtils.copyProperties((Object)newEmployeesReviewMentor, (Object)newEmployeeReviewInfoVO);
                    newEmployeeReviewInfoVO.setIs_retainable(Status.fromValue(newEmployeesReviewMentor.getIs_retainable()));
                    newEmployeeReviewInfoVO.setAttachment_one_week(null);
                    newEmployeeReviewInfoVO.setAttachment_two_week(null);
                    newEmployeeReviewInfoVO.setAttachment_one_month(null);
                    newEmployeeReviewInfoVO.setAttachment_two_month(null);
                    newEmployeeReviewInfoVO.setAttachment_three_month(null);
                    String attachment = newEmployeesReviewMentor.getAttachment();
                    newEmployeeReviewInfoVO.setAttachment(AttachmentUtils.getAttachment(attachment));
                }
            }
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
        }
        return newEmployeeReviewInfoVOS;
    }

    public NewEmployeeReviewInfoVO getNewEmployeeReviewInfoOne(Map map) throws DWException {
        NewEmployeeReviewInfoVO newEmployeeReviewInfoVO;
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        String email = LoginUserUtils.getLoginUserId();
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("new_employees_review_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        List<Object> newEmployeeReviewInfoVOS = new ArrayList();
        Long tutorDetails = 0L;
        Long PMDetails = 0L;
        List employees = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), NewEmployeesReviewDetail.class);
        for (NewEmployeesReviewDetail employee : employees) {
            Employee getEmployee;
            int loop = -1;
            NewEmployeesReviewDetail ownerDetail = null;
            ownerDetail = (NewEmployeesReviewDetail)((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getOwner_emp_email, (Object)employee.getOwner_emp_email()));
            if (email != null && email.equals(employee.getOwner_emp_email())) {
                loop = 1;
            } else {
                tutorDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getTutor_email, (Object)email)).eq(NewEmployeesReviewDetail::getOwner_emp_email, (Object)employee.getOwner_emp_email()));
                if (tutorDetails != 0L) {
                    loop = 2;
                } else {
                    PMDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getManager_email, (Object)email)).eq(NewEmployeesReviewDetail::getOwner_emp_email, (Object)employee.getOwner_emp_email()));
                    if (PMDetails != 0L) {
                        loop = 3;
                    }
                }
            }
            if (loop == -1 && (getEmployee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmail, (Object)email)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()))) != null && ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position()))) {
                loop = 4;
            }
            ArrayList<NewEmployeesReviewDetail> arrayList = new ArrayList<NewEmployeesReviewDetail>();
            if (loop != -1) {
                arrayList.add(ownerDetail);
            }
            newEmployeeReviewInfoVOS = this.getInfo(arrayList, loop, true, false);
        }
        if (CollectionUtils.isEmpty(newEmployeeReviewInfoVOS)) {
            newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            newEmployeeReviewInfoVO.setIs_edit(null);
            return newEmployeeReviewInfoVO;
        }
        newEmployeeReviewInfoVO = (NewEmployeeReviewInfoVO)newEmployeeReviewInfoVOS.get(0);
        return newEmployeeReviewInfoVO;
    }

    public List<NewEmployeeReviewInfoVO2> getNewEmployeeReviewMonthlyReportDetail(Map map) throws DWException {
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        String email = LoginUserUtils.getLoginUserId();
        if (!"integration".equals(email)) {
            return new ArrayList<NewEmployeeReviewInfoVO2>();
        }
        Employee employee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmail, (Object)email)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        if (!(employee == null || "PMO".equals(employee.getJob_position()) && "VP".equals(employee.getJob_position()))) {
            return new ArrayList<NewEmployeeReviewInfoVO2>();
        }
        List<Object> newEmployeeReviewInfoVOS = new ArrayList();
        ArrayList<NewEmployeesReviewDetail> allDetail = new ArrayList();
        allDetail = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        newEmployeeReviewInfoVOS = this.getInfo(allDetail, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            newEmployeeReviewInfoVO.setAttachment(null);
        }
        ArrayList<NewEmployeeReviewInfoVO2> newEmployeeReviewInfoVO2s = new ArrayList<NewEmployeeReviewInfoVO2>();
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            NewEmployeeReviewInfoVO2 newEmployeeReviewInfoVO2 = new NewEmployeeReviewInfoVO2();
            BeanUtils.copyProperties((Object)newEmployeeReviewInfoVO, (Object)newEmployeeReviewInfoVO2);
            com.digiwin.athena.dtdapp.util.StringUtils.copyObjectIsBoolean(newEmployeeReviewInfoVO, newEmployeeReviewInfoVO2);
            newEmployeeReviewInfoVO2s.add(newEmployeeReviewInfoVO2);
        }
        return newEmployeeReviewInfoVO2s;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportDate(Map map) {
        LocalDate month = LocalDate.now().minusMonths(1L);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"probation")).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"quit")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            });
        })).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List newEmployeesReviewDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)qw);
        if (CollectionUtils.isEmpty((Collection)newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(newEmployeesReviewDetails, 4, false, true);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now().minusMonths(1L);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            LocalDate parse = LocalDate.parse(newEmployeeReviewInfoVO.getEmployment_date(), dateTimeFormatter);
            LocalDate one_week = parse.plusWeeks(1L);
            LocalDate two_week = parse.plusWeeks(2L);
            LocalDate one_month = parse.plusMonths(1L);
            LocalDate oneToTwo_month = parse.plusMonths(2L);
            if (Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status()) || Status.DEPART.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                if (now.isBefore(one_week)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1\u5468\u5185\u8bd5\u7528\u671f\u5458\u5de5\uff080-7\uff09");
                } else if (now.isBefore(two_week)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1-2\u5468\u8bd5\u7528\u671f\u65b0\u5458\u5de5\uff088-14\u5929\uff09");
                } else if (now.isBefore(one_month)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1\u4e2a\u6708\u8bd5\u7528\u671f\u65b0\u5458\u5de5\uff0815-1\u4e2a\u6708\uff09");
                } else if (now.isBefore(oneToTwo_month)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("2\u4e2a\u6708\u8bd5\u7528\u671f\u5458\u5de5\uff081\u4e2a\u6708-2\u4e2a\u6708\uff09");
                }
            }
            long until = parse.until(now, ChronoUnit.DAYS);
            if (!Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status()) || until < 60L) continue;
            newEmployeeReviewInfoVO.setNew_employee_status("\u5373\u5c06\u8f6c\u6b63\u8bd5\u7528\u671f\u5458\u5de5\uff082\u4e2a\u6708\u4ee5\u4e0a\uff09");
        }
        return info;
    }

    private List<NewEmployeesReviewDetail> getNewEmployeesReviewDetails() {
        LocalDate month = LocalDate.now().minusMonths(1L);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        qw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"probation")).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"quit")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"beformal")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(c -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)c.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"return")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            });
        });
        return ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)qw);
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportTaskCardCompletionStatus(Map map) throws URISyntaxException, IOException {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails1 = this.getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails1)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(newEmployeesReviewDetails1, 4, false, true);
        Map<String, NewEmployeeReviewInfoVO> collect = info.stream().collect(Collectors.toMap(s -> s.getOwner_emp_email(), s -> {
            NewEmployeeReviewInfoVO vo = s;
            vo.setNew_employee_status("\u6309\u65f6\u5b8c\u6210\u4efb\u52a1\u5361\u5458\u5de5");
            return vo;
        }));
        LocalDate month = LocalDate.now().minusMonths(1L);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        NewEmployeeReviewProportion newEmployeeReviewProportion = (NewEmployeeReviewProportion)((NewEmployeeReviewProportionMapper)this.newEmployeeReviewProportionDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(NewEmployeeReviewProportion::getDate, (Object)firstDay)).le(NewEmployeeReviewProportion::getDate, (Object)localDate)).eq(NewEmployeeReviewProportion::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        List<String> list = Arrays.asList(newEmployeeReviewProportion.getOverdue_employees().split(","));
        for (String s2 : list) {
            if (!collect.containsKey(s2)) continue;
            collect.get(s2).setNew_employee_status("\u8d85\u671f\u672a\u5b8c\u6210\u4efb\u52a1\u5361\u5458\u5de5");
        }
        List<NewEmployeeReviewInfoVO> collect1 = collect.values().stream().collect(Collectors.toList());
        return collect1;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportOnDutySituation(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = this.getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(newEmployeesReviewDetails, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            if (Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status()) || Status.BEFORMAL.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status()) || Status.NOUSED.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("\u5728\u804c\u65b0\u5458\u5de5");
            }
            if (!Status.DEPART.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) continue;
            newEmployeeReviewInfoVO.setNew_employee_status("\u79bb\u804c\u65b0\u5458\u5de5");
        }
        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportRetentionSituation(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = this.getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        ArrayList<NewEmployeesReviewDetail> details = new ArrayList<NewEmployeesReviewDetail>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            NewEmployeesReviewMentor newEmployeesReviewMentor = (NewEmployeesReviewMentor)((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewMentor::getOwner_emp_email, (Object)newEmployeesReviewDetail.getOwner_emp_email()));
            if (newEmployeesReviewMentor == null || newEmployeesReviewMentor == null || newEmployeesReviewMentor.getAcceptance_score() == null || newEmployeesReviewMentor.getAcceptance_score() == 0) continue;
            details.add(newEmployeesReviewDetail);
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(details, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            if (Status.BEFORMAL.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("\u8f6c\u6b63\u5458\u5de5");
            }
            if (!Status.NOUSED.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) continue;
            newEmployeeReviewInfoVO.setNew_employee_status("\u4e0d\u4e88\u7559\u7528\u5458\u5de5");
        }
        if (CollectionUtils.isEmpty(info)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportScore(Map map) {
        LocalDate month = LocalDate.now().minusMonths(1L);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        NewEmployeeReviewProportion newEmployeeReviewProportion = (NewEmployeeReviewProportion)((NewEmployeeReviewProportionMapper)this.newEmployeeReviewProportionDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(NewEmployeeReviewProportion::getDate, (Object)firstDay)).le(NewEmployeeReviewProportion::getDate, (Object)localDate)).eq(NewEmployeeReviewProportion::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        List<String> teachingRating6Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_6_employees().split(","));
        List<String> teachingRating78Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_7_8_employees().split(","));
        List<String> teachingRating910Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_9_10_employees().split(","));
        List<String> teachingMoreThan10Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_more_than_10_employees().split(","));
        ArrayList<String> allEmail = new ArrayList<String>();
        allEmail.addAll(teachingRating6Employees);
        allEmail.addAll(teachingRating78Employees);
        allEmail.addAll(teachingRating910Employees);
        allEmail.addAll(teachingMoreThan10Employees);
        List allNewEmployeesReviewDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(NewEmployeesReviewDetail::getOwner_emp_email, allEmail)).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        if (CollectionUtils.isEmpty((Collection)allNewEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List<NewEmployeeReviewInfoVO> info = this.getInfo(allNewEmployeesReviewDetails, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            LocalDate date = LocalDate.parse(newEmployeeReviewInfoVO.getEmployment_date(), dateTimeFormatter);
            long until = date.until(localDate, ChronoUnit.DAYS);
            if (until >= 7L && until < 14L) {
                newEmployeeReviewInfoVO.setCurrent_score_status("\u5165\u804c\u4e00\u5468");
                if (newEmployeeReviewInfoVO.getRating_one_week_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52066\u5206\u4ee5\u4e0b");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() >= 7 && newEmployeeReviewInfoVO.getRating_one_week_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52067-8\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() >= 9 && newEmployeeReviewInfoVO.getRating_one_week_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52069-10\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u520610\u5206\u4ee5\u4e0a");
                }
            } else if (until >= 14L && until < 30L) {
                newEmployeeReviewInfoVO.setCurrent_score_status("\u5165\u804c\u4e8c\u5468");
                if (newEmployeeReviewInfoVO.getRating_two_week_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52066\u5206\u4ee5\u4e0b");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() >= 7 && newEmployeeReviewInfoVO.getRating_two_week_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52067-8\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() >= 9 && newEmployeeReviewInfoVO.getRating_two_week_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52069-10\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u520610\u5206\u4ee5\u4e0a");
                }
            } else if (until >= 30L && until < 60L) {
                newEmployeeReviewInfoVO.setCurrent_score_status("\u5165\u804c\u4e00\u4e2a\u6708");
                if (newEmployeeReviewInfoVO.getRating_one_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52066\u5206\u4ee5\u4e0b");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_one_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52067-8\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_one_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52069-10\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u520610\u5206\u4ee5\u4e0a");
                }
            } else if (until >= 60L && until < 90L) {
                newEmployeeReviewInfoVO.setCurrent_score_status("\u5165\u804c\u4fe9\u4e2a\u6708");
                if (newEmployeeReviewInfoVO.getRating_two_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52066\u5206\u4ee5\u4e0b");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_two_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52067-8\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_two_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52069-10\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u520610\u5206\u4ee5\u4e0a");
                }
            } else if (until >= 90L) {
                newEmployeeReviewInfoVO.setCurrent_score_status("\u5373\u5c06\u8f6c\u6b63");
                if (newEmployeeReviewInfoVO.getRating_three_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52066\u5206\u4ee5\u4e0b");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_three_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52067-8\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_three_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u52069-10\u5206");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("\u4ee3\u6559\u8bc4\u520610\u5206\u4ee5\u4e0a");
                }
            }
            newEmployeeReviewInfoVO.setAttachment(null);
        }
        if (CollectionUtils.isEmpty(info)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportCheckAndAccept(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = this.getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(newEmployeesReviewDetails, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            NewEmployeesReviewMentor newEmployeesReviewMentor = (NewEmployeesReviewMentor)((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewMentor::getOwner_emp_email, (Object)newEmployeeReviewInfoVO.getOwner_emp_email()));
            if (newEmployeesReviewMentor == null) continue;
            if (newEmployeesReviewMentor != null && newEmployeesReviewMentor.getAcceptance_score() != null && newEmployeesReviewMentor.getAcceptance_score() != 0) {
                newEmployeeReviewInfoVO.setNew_employee_status("\u9a8c\u6536\u4eba\u6570");
                continue;
            }
            newEmployeeReviewInfoVO.setNew_employee_status("\u672a\u9a8c\u6536\u4eba\u6570");
        }
        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportAcceptanceRating(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = this.getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = this.getInfo(newEmployeesReviewDetails, 4, false, true);
        ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<NewEmployeeReviewInfoVO>();
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            NewEmployeesReviewMentor newEmployeesReviewMentor = (NewEmployeesReviewMentor)((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewMentor::getOwner_emp_email, (Object)newEmployeeReviewInfoVO.getOwner_emp_email()));
            if (newEmployeesReviewMentor == null || newEmployeesReviewMentor == null || newEmployeesReviewMentor.getAcceptance_score() == null || newEmployeesReviewMentor.getAcceptance_score() == 0) continue;
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
        }
        for (NewEmployeeReviewInfoVO employeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            if (employeeReviewInfoVO.getAcceptance_score() < 7) {
                employeeReviewInfoVO.setNew_employee_status("\u65b0\u4eba\u603b\u9a8c\u6536\u8bc4\u52065\u5206\u4ee5\u4e0b");
            }
            if (employeeReviewInfoVO.getAcceptance_score() >= 7 && employeeReviewInfoVO.getAcceptance_score() <= 8) {
                employeeReviewInfoVO.setNew_employee_status("\u65b0\u4eba\u603b\u9a8c\u6536\u8bc4\u52067-8\u5206");
            }
            if (employeeReviewInfoVO.getAcceptance_score() < 9 || employeeReviewInfoVO.getAcceptance_score() > 10) continue;
            employeeReviewInfoVO.setNew_employee_status("\u65b0\u4eba\u603b\u9a8c\u6536\u8bc4\u52069-10\u5206");
        }
        if (CollectionUtils.isEmpty(newEmployeeReviewInfoVOS)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            com.digiwin.athena.dtdapp.util.StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            newEmployeeReviewInfoVOS = new ArrayList();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        return newEmployeeReviewInfoVOS;
    }

    @Transactional
    public List<NewEmployeesReviewDetail> getNewEmployeeReviewStatusUpdate(Map map) throws DWException {
        if (!this.isPMOVP(LoginUserUtils.getLoginUserId()).booleanValue() && !this.isPM(LoginUserUtils.getLoginUserId()).booleanValue()) {
            throw new DWException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539");
        }
        log.info("queryEmployeeInfo:{}", (Object)map);
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("new_employees_review_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        ArrayList<String> strings = new ArrayList<String>();
        List employees = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), NewEmployeesReviewDetail.class);
        for (NewEmployeesReviewDetail employee : employees) {
            NewEmployeesReviewDetail newEmployeesReviewDetail = new NewEmployeesReviewDetail();
            newEmployeesReviewDetail.setOwner_emp_email(employee.getOwner_emp_email());
            newEmployeesReviewDetail.setEmployee_status(employee.getEmployee_status());
            LambdaQueryWrapper w = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)w.eq(NewEmployeesReviewDetail::getOwner_emp_email, (Object)employee.getOwner_emp_email())).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).update(newEmployeesReviewDetail, (Wrapper)w);
            Employee updateEmp = new Employee();
            if ("quit".equals(employee.getEmployee_status())) {
                updateEmp.setStatus("N");
            }
            ((EmployeeMapper)this.employeeDAO.getBaseMapper()).update(updateEmp, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmail, (Object)employee.getOwner_emp_email())).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            strings.add(employee.getOwner_emp_email());
        }
        List newEmployeesReviewDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(NewEmployeesReviewDetail::getOwner_emp_email, strings)).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        return newEmployeesReviewDetails;
    }

    @Scheduled(cron="00 00 23 * * ?")
    public List<NewEmployeeReviewProportion> updateNewcomerStatistics() throws URISyntaxException, IOException {
        List newEmployeeReviewProportions = ((NewEmployeeReviewProportionMapper)this.newEmployeeReviewProportionDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeeReviewProportion::getTenantsid, (Object)LoginUserUtils.getTenantSid())).orderByAsc(NewEmployeeReviewProportion::getDate));
        LocalDate now = LocalDate.now();
        int currentMonth = now.getMonth().getValue();
        int currentYear = now.getYear();
        Map<java.util.Date, NewEmployeeReviewProportion> newEmployeeReviewProportionMap = newEmployeeReviewProportions.stream().collect(Collectors.toMap(s -> s.getDate(), s -> s));
        List closestData = newEmployeeReviewProportions.stream().filter(proportion -> new java.util.Date(proportion.getDate().getTime()).getYear() + 1900 == currentYear).filter(proportion -> new java.util.Date(proportion.getDate().getTime()).getMonth() + 1 == currentMonth).collect(Collectors.toList());
        NewEmployeeReviewProportion currentMonthNewEmployeeReviewProportion = null;
        if (CollectionUtils.isEmpty(closestData)) {
            currentMonthNewEmployeeReviewProportion = this.getCurrentMonthNewEmployeeReviewProportion(null);
        } else {
            currentMonthNewEmployeeReviewProportion = this.getCurrentMonthNewEmployeeReviewProportion((NewEmployeeReviewProportion)closestData.get(0));
            currentMonthNewEmployeeReviewProportion.setId(((NewEmployeeReviewProportion)closestData.get(0)).getId());
        }
        currentMonthNewEmployeeReviewProportion.setTenantsid(LoginUserUtils.getTenantSid());
        this.newEmployeeReviewProportionDAO.saveOrUpdate(currentMonthNewEmployeeReviewProportion);
        if (CollectionUtils.isNotEmpty(closestData)) {
            newEmployeeReviewProportionMap.remove(((NewEmployeeReviewProportion)closestData.get(0)).getDate());
        }
        ArrayList<Map.Entry<java.util.Date, NewEmployeeReviewProportion>> list = new ArrayList<Map.Entry<java.util.Date, NewEmployeeReviewProportion>>(newEmployeeReviewProportionMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<java.util.Date, NewEmployeeReviewProportion>>(){

            @Override
            public int compare(Map.Entry<java.util.Date, NewEmployeeReviewProportion> o1, Map.Entry<java.util.Date, NewEmployeeReviewProportion> o2) {
                LocalDate date2;
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate date1 = LocalDate.parse(o1.getKey().toString(), formatter);
                if (date1.isBefore(date2 = LocalDate.parse(o2.getKey().toString(), formatter))) {
                    return -1;
                }
                if (date1.isEqual(date2)) {
                    return 0;
                }
                return 1;
            }
        });
        List<NewEmployeeReviewProportion> collect = list.stream().map(a -> (NewEmployeeReviewProportion)a.getValue()).collect(Collectors.toList());
        return collect;
    }

    private NewEmployeeReviewProportion getCurrentMonthNewEmployeeReviewProportion(NewEmployeeReviewProportion closestData) throws URISyntaxException, IOException {
        LocalDate month = LocalDate.now();
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"probation")).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"quit")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"beformal")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(c -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)c.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"return")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            });
        })).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List newEmployeesReviewDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)qw);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.isNull(NewEmployeesReviewMentor::getAcceptance_score)).eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        List newEmployeesReviewMentors = ((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectList((Wrapper)wrapper);
        List emails = newEmployeesReviewMentors.stream().map(i -> i.getOwner_emp_email()).collect(Collectors.toList());
        List score_employees = new ArrayList();
        Map<Object, Object> score_employeesMap = new HashMap();
        if (CollectionUtils.isNotEmpty(emails)) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"probation");
            })).in(NewEmployeesReviewDetail::getOwner_emp_email, emails)).eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
            score_employees = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)wrapper1);
            score_employeesMap = score_employees.stream().collect(Collectors.toMap(NewEmployeesReviewDetail::getOwner_emp_no, score_employee -> score_employee));
        }
        int total = newEmployeesReviewDetails.size();
        int probation_new_employee_sum = 0;
        String probation_new_employeeS = "";
        int one_week_sum = 0;
        String one_week_employeeS = "";
        int two_week_sum = 0;
        String two_week_employeeS = "";
        int two_week_to_one_month_sum = 0;
        String two_week_to_one_month_employeeS = "";
        int one_to_two_month_sum = 0;
        String one_to_two_month_employeeS = "";
        int will_entry_sum = 0;
        String will_entry_employeeS = "";
        int depart_sum = 0;
        String depart_employeeS = "";
        int acceptance_sum = 0;
        String acceptance_employeeS = "";
        int formal_sum = 0;
        String formal_employeeS = "";
        int no_number_of_permanent_employees_sum = 0;
        String no_number_of_permanent_employeeS = "";
        int total_score_6 = 0;
        String total_score_6_employeeS = "";
        int total_score_7_8 = 0;
        String total_score_7_8_employeeS = "";
        int total_score_9_10 = 0;
        String total_score_9_10_employeeS = "";
        int current_score_6 = 0;
        String current_score_6_employeeS = "";
        int current_score_7_8 = 0;
        String current_score_7_8_employeeS = "";
        int current_score_9_10 = 0;
        String current_score_9_10_employeeS = "";
        int current_score_10 = 0;
        String current_score_10_employeeS = "";
        int overdue_sum = 0;
        String overdue_task_employeeS = "";
        int score_employeesSum = 0;
        String score_employees_employeeS = "";
        NewEmployeeReviewProportion newEmployeeReviewProportion = new NewEmployeeReviewProportion();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            LocalDate parse = LocalDate.parse(newEmployeesReviewDetail.getEmployment_date(), dateTimeFormatter);
            LocalDate localDate2 = parse.plusWeeks(1L);
            LocalDate two_week = parse.plusWeeks(2L);
            LocalDate one_month = parse.plusMonths(1L);
            LocalDate oneToTwo_month = parse.plusMonths(2L);
            if ("probation".equals(newEmployeesReviewDetail.getEmployee_status())) {
                ++probation_new_employee_sum;
                probation_new_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(probation_new_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                if (now.isBefore(localDate2)) {
                    ++one_week_sum;
                    one_week_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(one_week_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(two_week)) {
                    ++two_week_sum;
                    two_week_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(two_week_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(one_month)) {
                    ++two_week_to_one_month_sum;
                    two_week_to_one_month_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(two_week_to_one_month_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(oneToTwo_month)) {
                    ++one_to_two_month_sum;
                    one_to_two_month_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(one_to_two_month_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                }
            }
            NewEmployeesReviewMentor newEmployeesReviewMentor = (NewEmployeesReviewMentor)((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid())).in(NewEmployeesReviewMentor::getOwner_emp_email, new Object[]{newEmployeesReviewDetail.getOwner_emp_email()}));
            long until = parse.until(now, ChronoUnit.DAYS);
            if ("probation".equals(newEmployeesReviewDetail.getEmployee_status()) && until >= 60L) {
                ++will_entry_sum;
                will_entry_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(will_entry_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if (newEmployeesReviewMentor != null && !score_employeesMap.isEmpty() && score_employeesMap.containsKey(newEmployeesReviewDetail.getOwner_emp_no())) {
                String employmentDateString = ((NewEmployeesReviewDetail)score_employeesMap.get(newEmployeesReviewDetail.getOwner_emp_no())).getEmployment_date();
                LocalDate employmentDate = LocalDate.parse(employmentDateString, dateTimeFormatter).plusDays(7L);
                LocalDate finalScoringTime = LocalDate.parse(employmentDateString, dateTimeFormatter).plusDays(90L);
                if (until >= 7L && until < 14L) {
                    ++score_employeesSum;
                    score_employees_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getRating_one_week_all() != null) {
                        if (newEmployeesReviewMentor.getRating_one_week_all() <= 6) {
                            ++current_score_6;
                            current_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_week_all() >= 7 && newEmployeesReviewMentor.getRating_one_week_all() <= 8) {
                            ++current_score_7_8;
                            current_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_week_all() >= 9 && newEmployeesReviewMentor.getRating_one_week_all() <= 10) {
                            ++current_score_9_10;
                            current_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_week_all() > 10) {
                            ++current_score_10;
                            current_score_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        }
                    }
                } else if (until >= 14L && until < 30L) {
                    ++score_employeesSum;
                    score_employees_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getRating_two_week_all() != null) {
                        if (newEmployeesReviewMentor.getRating_two_week_all() <= 6) {
                            ++current_score_6;
                            current_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_week_all() >= 7 && newEmployeesReviewMentor.getRating_two_week_all() <= 8) {
                            ++current_score_7_8;
                            current_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_week_all() >= 9 && newEmployeesReviewMentor.getRating_two_week_all() <= 10) {
                            ++current_score_9_10;
                            current_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_week_all() > 10) {
                            ++current_score_10;
                            current_score_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        }
                    }
                } else if (until >= 30L && until < 60L) {
                    ++score_employeesSum;
                    score_employees_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getRating_one_month_all() != null) {
                        if (newEmployeesReviewMentor.getRating_one_month_all() <= 6) {
                            ++current_score_6;
                            current_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_month_all() >= 7 && newEmployeesReviewMentor.getRating_one_month_all() <= 8) {
                            ++current_score_7_8;
                            current_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_month_all() >= 9 && newEmployeesReviewMentor.getRating_one_month_all() <= 10) {
                            ++current_score_9_10;
                            current_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_one_month_all() > 10) {
                            ++current_score_10;
                            current_score_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        }
                    }
                } else if (until >= 60L && until < 90L) {
                    ++score_employeesSum;
                    score_employees_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getRating_two_month_all() != null) {
                        if (newEmployeesReviewMentor.getRating_two_month_all() <= 6) {
                            ++current_score_6;
                            current_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_month_all() >= 7 && newEmployeesReviewMentor.getRating_two_month_all() <= 8) {
                            ++current_score_7_8;
                            current_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_month_all() >= 9 && newEmployeesReviewMentor.getRating_two_month_all() <= 10) {
                            ++current_score_9_10;
                            current_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_two_month_all() > 10) {
                            ++current_score_10;
                            current_score_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        }
                    }
                } else if (until >= 90L && finalScoringTime.getYear() == now.getYear() && finalScoringTime.getMonth().equals(now.getMonth())) {
                    ++score_employeesSum;
                    score_employees_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getRating_three_month_all() != null) {
                        if (newEmployeesReviewMentor.getRating_three_month_all() <= 6) {
                            ++current_score_6;
                            current_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_three_month_all() >= 7 && newEmployeesReviewMentor.getRating_three_month_all() <= 8) {
                            ++current_score_7_8;
                            current_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_three_month_all() >= 9 && newEmployeesReviewMentor.getRating_three_month_all() <= 10) {
                            ++current_score_9_10;
                            current_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        } else if (newEmployeesReviewMentor.getRating_three_month_all() > 10) {
                            ++current_score_10;
                            current_score_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        }
                    }
                }
            }
            if ("beformal".equals(newEmployeesReviewDetail.getEmployee_status())) {
                ++formal_sum;
                formal_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(formal_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if ("quit".equals(newEmployeesReviewDetail.getEmployee_status())) {
                ++depart_sum;
                depart_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(depart_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if ("return".equals(newEmployeesReviewDetail.getEmployee_status())) {
                ++no_number_of_permanent_employees_sum;
                no_number_of_permanent_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(no_number_of_permanent_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if (newEmployeesReviewMentor == null || newEmployeesReviewMentor.getAcceptance_score() == null || newEmployeesReviewMentor.getAcceptance_score() == null || newEmployeesReviewMentor.getAcceptance_score() == 0) continue;
            ++acceptance_sum;
            acceptance_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(acceptance_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            if (newEmployeesReviewMentor.getAcceptance_score() < 7) {
                ++total_score_6;
                total_score_6_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(total_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if (newEmployeesReviewMentor.getAcceptance_score() == 7 || newEmployeesReviewMentor.getAcceptance_score() == 8) {
                ++total_score_7_8;
                total_score_7_8_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(total_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if (newEmployeesReviewMentor.getAcceptance_score() != 9 && newEmployeesReviewMentor.getAcceptance_score() != 10) continue;
            ++total_score_9_10;
            total_score_9_10_employeeS = com.digiwin.athena.dtdapp.util.StringUtils.splice(total_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
        }
        List<Object> overdueTask = new ArrayList();
        overdueTask = closestData == null ? this.getOverdueTask("") : this.getOverdueTask(closestData.getOverdue_employees());
        overdue_sum = overdueTask.size();
        String a = "";
        for (String string : overdueTask) {
            a = com.digiwin.athena.dtdapp.util.StringUtils.splice(a, string);
        }
        overdue_task_employeeS = a;
        newEmployeeReviewProportion.setYear(month.getYear());
        newEmployeeReviewProportion.setDate(Date.valueOf(LocalDate.now()));
        newEmployeeReviewProportion.setTotal(total);
        newEmployeeReviewProportion.setProbation_new_employee_sum(probation_new_employee_sum);
        newEmployeeReviewProportion.setOne_week_sum(one_week_sum);
        newEmployeeReviewProportion.setOne_week_proportion(probation_new_employee_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)one_week_sum / ((double)probation_new_employee_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTwo_week_sum(two_week_sum);
        newEmployeeReviewProportion.setTwo_week_proportion(probation_new_employee_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)two_week_sum / ((double)probation_new_employee_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTwo_week_to_one_month(two_week_to_one_month_sum);
        newEmployeeReviewProportion.setTwo_week_to_one_month_proportion(probation_new_employee_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)two_week_to_one_month_sum / ((double)probation_new_employee_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setOne_month_sum(one_to_two_month_sum);
        newEmployeeReviewProportion.setOne_month_proportion(probation_new_employee_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)one_to_two_month_sum / ((double)probation_new_employee_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setWill_entry_sum(will_entry_sum);
        newEmployeeReviewProportion.setWill_entry_proportion(probation_new_employee_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)will_entry_sum / ((double)probation_new_employee_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setDepart(depart_sum);
        newEmployeeReviewProportion.setDepart_proportion(total == 0 ? new BigDecimal(0) : new BigDecimal((double)depart_sum / ((double)total * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setFormal_employees(formal_sum);
        newEmployeeReviewProportion.setFormal_employees_proportion(acceptance_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)formal_sum / ((double)acceptance_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_rating_6(current_score_6);
        newEmployeeReviewProportion.setTeaching_rating_6_proportion(score_employees.size() == 0 ? new BigDecimal(0) : new BigDecimal((double)current_score_6 / ((double)score_employeesSum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_rating_7_8(current_score_7_8);
        newEmployeeReviewProportion.setTeaching_rating_7_8_proportion(score_employees.size() == 0 ? new BigDecimal(0) : new BigDecimal((double)current_score_7_8 / ((double)score_employeesSum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_ration_9_10(current_score_9_10);
        newEmployeeReviewProportion.setTeaching_ration_9_10_proportion(score_employees.size() == 0 ? new BigDecimal(0) : new BigDecimal((double)current_score_9_10 / ((double)score_employeesSum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_more_than_10(current_score_10);
        newEmployeeReviewProportion.setTeaching_more_than_10_proportion(score_employees.size() == 0 ? new BigDecimal(0) : new BigDecimal((double)current_score_10 / ((double)score_employeesSum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setAcceptance_report(acceptance_sum);
        newEmployeeReviewProportion.setAcceptance_report_proportion(total == 0 ? new BigDecimal(0) : new BigDecimal((double)acceptance_sum / ((double)total * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setNo_number_of_permanent_employees(no_number_of_permanent_employees_sum);
        newEmployeeReviewProportion.setNo_number_of_permanent_employees_proportion(acceptance_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)no_number_of_permanent_employees_sum / ((double)acceptance_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTotal_teaching_rating_6(total_score_6);
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8(total_score_7_8);
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10(total_score_9_10);
        newEmployeeReviewProportion.setTotal_teaching_rating_6_proportion(acceptance_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)total_score_6 / ((double)acceptance_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8_proportion(acceptance_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)total_score_7_8 / ((double)acceptance_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10_proportion(acceptance_sum == 0 ? new BigDecimal(0) : new BigDecimal((double)total_score_9_10 / ((double)acceptance_sum * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setOverdue_task(overdue_sum);
        newEmployeeReviewProportion.setOverdue_proportion(total == 0 ? new BigDecimal(0) : new BigDecimal((double)overdue_sum / ((double)total * 1.0)).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setOverdue_employees(overdue_task_employeeS);
        newEmployeeReviewProportion.setProbation_new_employees(probation_new_employeeS);
        newEmployeeReviewProportion.setOne_week_employees(one_week_employeeS);
        newEmployeeReviewProportion.setTwo_week_employees(two_week_employeeS);
        newEmployeeReviewProportion.setTwo_week_to_one_month_employees(two_week_to_one_month_employeeS);
        newEmployeeReviewProportion.setOne_month_employees(one_to_two_month_employeeS);
        newEmployeeReviewProportion.setWill_entry_employees(will_entry_employeeS);
        newEmployeeReviewProportion.setOverdue_employees(overdue_task_employeeS);
        newEmployeeReviewProportion.setDepart_employees(depart_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_6_employees(current_score_6_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_7_8_employees(current_score_7_8_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_9_10_employees(current_score_9_10_employeeS);
        newEmployeeReviewProportion.setTeaching_more_than_10_employees(current_score_10_employeeS);
        newEmployeeReviewProportion.setAcceptance_report_employees(acceptance_employeeS);
        newEmployeeReviewProportion.setFormal_employees_employees(formal_employeeS);
        newEmployeeReviewProportion.setNo_number_of_permanent_employees_employees(no_number_of_permanent_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_6_employees(total_score_6_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8_employees(total_score_7_8_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10_employees(total_score_9_10_employeeS);
        return newEmployeeReviewProportion;
    }

    private Boolean isPMOVP(String email) {
        ArrayList PMODetails = new ArrayList();
        Employee getEmployee = (Employee)((EmployeeMapper)this.employeeDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Employee::getEmail, (Object)email)).eq(Employee::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
        if (getEmployee != null && ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position()))) {
            return true;
        }
        return false;
    }

    private Boolean isPM(String email) {
        Long PMDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid())).eq(NewEmployeesReviewDetail::getManager_email, (Object)email));
        if (PMDetails != 0L) {
            return true;
        }
        return false;
    }

    private List<String> getOverdueTask(String existEmail) {
        List<String> list = Arrays.asList(existEmail.split(","));
        LocalDate month = LocalDate.now();
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(NewEmployeesReviewDetail::getTenantsid, (Object)LoginUserUtils.getTenantSid());
        qw.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"probation")).or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"quit")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"beformal")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            })).or(c -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)c.eq(NewEmployeesReviewDetail::getEmployee_status, (Object)"return")).ge(NewEmployeesReviewDetail::getConfirmation_date, (Object)firstDay)).le(NewEmployeesReviewDetail::getConfirmation_date, (Object)localDate);
            });
        });
        List newEmployeesReviewDetails = ((NewEmployeesReviewDetailMapper)this.newEmployeesReviewDetailDAO.getBaseMapper()).selectList((Wrapper)qw);
        ArrayList<String> overTaskEmail = new ArrayList<String>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            String employmentDate = newEmployeesReviewDetail.getEmployment_date();
            LocalDate date = LocalDate.parse(employmentDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            long until = date.until(month, ChronoUnit.DAYS);
            Long aLong = -1L;
            String goal = null;
            if (newEmployeesReviewDetail.getEmployee_status().equals("quit")) continue;
            if (until > 1L && until < 7L) {
                aLong = ((ProbationaryPeriodGoalsMapper)this.probationaryPeriodGoalsDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProbationaryPeriodGoals::getOwner_emp_email, (Object)newEmployeesReviewDetail.getOwner_emp_email())).eq(ProbationaryPeriodGoals::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            } else if (until >= 10L && until < 14L) {
                goal = ((SummaryOneWeekDetails)((SummaryOneWeekMapper)this.summaryOneWeekDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SummaryOneWeekDetails::getTrial_period_goal}).eq(SummaryOneWeekDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryOneWeekDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))).getTrial_period_goal();
            } else if (until > 17L && until < 30L) {
                goal = ((SummaryTwoWeekDetails)((SummaryTwoWeekDetailsMapper)this.summaryTwoWeekDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SummaryTwoWeekDetails::getTrial_period_goal}).eq(SummaryTwoWeekDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryTwoWeekDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))).getTrial_period_goal();
            } else if (until > 33L && until < 60L) {
                goal = ((SummaryOneMonthDetails)((SummaryOneMonthDetailsMapper)this.summaryOneMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SummaryOneMonthDetails::getTrial_period_goal}).eq(SummaryOneMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryOneMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))).getTrial_period_goal();
            } else if (until > 63L && until < 90L) {
                goal = ((SummaryTwoMonthDetails)((SummaryTwoMonthDetailsMapper)this.summaryTwoMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SummaryTwoMonthDetails::getTrial_period_goal}).eq(SummaryTwoMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryTwoMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))).getTrial_period_goal();
            } else if (until >= 93L && until < 97L) {
                goal = ((SummaryThreeMonthDetails)((SummaryThreeMonthDetailsMapper)this.summaryThreeMonthDetailsDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SummaryThreeMonthDetails::getTrial_period_goal}).eq(SummaryThreeMonthDetails::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).eq(SummaryThreeMonthDetails::getTenantsid, (Object)LoginUserUtils.getTenantSid()))).getTrial_period_goal();
            }
            if ("3".equals(newEmployeesReviewDetail.getProbationary_period_term() + "") && until >= 97L) {
                aLong = ((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).isNotNull(NewEmployeesReviewMentor::getAcceptance_score)).eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            }
            if ("6".equals(Character.valueOf(newEmployeesReviewDetail.getProbationary_period_term())) && until >= 187L) {
                aLong = ((NewEmployeesReviewMentorMapper)this.newEmployeesReviewMentorDAO.getBaseMapper()).selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, (Object)newEmployeesReviewDetail.getNew_employees_review_detail_id())).isNotNull(NewEmployeesReviewMentor::getAcceptance_score)).eq(NewEmployeesReviewMentor::getTenantsid, (Object)LoginUserUtils.getTenantSid()));
            }
            if (!StringUtils.isEmpty((CharSequence)goal)) {
                aLong = 1L;
            }
            if (aLong != 0L) continue;
            overTaskEmail.add(newEmployeesReviewDetail.getOwner_emp_email());
        }
        List<String> collect = Stream.of(list, overTaskEmail).flatMap(Collection::stream).filter(s -> !s.isEmpty()).distinct().collect(Collectors.toList());
        return collect;
    }
}

