/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.digiwin.athena.dtdapp.dao.zentao.ZtBugDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtDeptDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtModuleDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProductDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProductplanDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProjectDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProjectStoryDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtStoryDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtTaskDAO;
import com.digiwin.athena.dtdapp.dao.zentao.ZtUserDAO;
import com.digiwin.athena.dtdapp.mapperzentao.ZtBugMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtModuleMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProductMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProductplanMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProjectMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProjectStoryMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtStoryMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtTaskMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtUserMapper;
import com.digiwin.athena.dtdapp.pojo.constants.Constant;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtBug;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtDept;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtModule;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProduct;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProductplan;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProjectStory;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtStory;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.enums.KanBanStatus;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.DemandVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.PageVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtDeptVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtModuleLevelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectExcelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectLevelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtStoryExcelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtStoryVO;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class ZtKanBanService {
    private static final Logger log = LoggerFactory.getLogger(ZtKanBanService.class);
    @Autowired
    private ZtProjectDAO ztProjectDAO;
    @Autowired
    private ZtProjectStoryDAO ztProjectStoryDAO;
    @Autowired
    private ZtTaskDAO ztTaskDAO;
    @Autowired
    private ZtBugDAO ztBugDAO;
    @Autowired
    private ZtStoryDAO ztStoryDAO;
    @Autowired
    private ZtProductDAO ztProductDAO;
    @Autowired
    private ZtModuleDAO ztModuleDAO;
    @Autowired
    private ZtProductplanDAO ztProductplanDAO;
    @Autowired
    private ZtUserDAO ztUserDAO;
    @Autowired
    private ZtDeptDAO ztDeptDAO;

    private static int compareValuesDate(LocalDate value1, LocalDate value2, String sortOrder) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return 1;
        }
        if (value2 == null) {
            return -1;
        }
        if (StringUtils.isEmpty((CharSequence)sortOrder)) {
            return 0;
        }
        if ("ascend".equals(sortOrder)) {
            return value1.compareTo(value2);
        }
        if ("descend".equals(sortOrder)) {
            return value2.compareTo(value1);
        }
        return 0;
    }

    private static int compareValuesInt(int value1, int value2, String sortOrder) {
        if (StringUtils.isEmpty((CharSequence)sortOrder)) {
            return 0;
        }
        if ("ascend".equals(sortOrder)) {
            return Integer.compare(value1, value2);
        }
        if ("descend".equals(sortOrder)) {
            return Integer.compare(value2, value1);
        }
        return 0;
    }

    private static int compareValuesFloat(Float value1, Float value2, String sortOrder) {
        if (StringUtils.isEmpty((CharSequence)sortOrder)) {
            return 0;
        }
        if ("ascend".equals(sortOrder)) {
            return Float.compare(value1.floatValue(), value2.floatValue());
        }
        if ("descend".equals(sortOrder)) {
            return Float.compare(value2.floatValue(), value1.floatValue());
        }
        return 0;
    }

    public List<ZtProjectLevelVO> getProgramLevel() {
        ArrayList<String> programIds = new ArrayList<String>();
        programIds.add("394900");
        return this.getProgramsWithLevels(programIds);
    }

    private List<ZtProjectLevelVO> getProgramsWithLevels(List<String> programIds) {
        ArrayList<ZtProjectLevelVO> programs = new ArrayList<ZtProjectLevelVO>();
        List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getParent, programIds)).eq(ZtProject::getDeleted, (Object)"0"));
        for (ZtProject project : ztProjects) {
            if (!"program".equals(project.getType())) continue;
            List childProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtProject::getParent, (Object)project.getId().toString())).eq(ZtProject::getType, (Object)"program")).eq(ZtProject::getDeleted, (Object)"0"));
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            projectLevelVO.setId(project.getId());
            projectLevelVO.setName(project.getName());
            projectLevelVO.setChildren(this.convertToProjectLevelVOs(childProjects));
            programs.add(projectLevelVO);
            if (childProjects.isEmpty() || !this.hasProgramChild(childProjects)) continue;
            for (ZtProjectLevelVO ztProjectLevelVO : projectLevelVO.getChildren()) {
                ArrayList<String> collect = new ArrayList<String>();
                collect.add(ztProjectLevelVO.getId().toString());
                ztProjectLevelVO.setChildren(this.getProgramsWithLevels(collect));
            }
        }
        return programs;
    }

    private List<ZtProjectLevelVO> convertToProjectLevelVOs(List<ZtProject> projects) {
        ArrayList<ZtProjectLevelVO> projectLevelVOs = new ArrayList<ZtProjectLevelVO>();
        for (ZtProject project : projects) {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            projectLevelVO.setId(project.getId());
            projectLevelVO.setName(project.getName());
            projectLevelVOs.add(projectLevelVO);
        }
        return projectLevelVOs;
    }

    private List<ZtProject> getProgram1(List<String> programIds) {
        ArrayList<String> programIds2 = new ArrayList<String>();
        ArrayList<ZtProject> programs = new ArrayList<ZtProject>();
        for (String programId : programIds) {
            ZtProject program = (ZtProject)((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getId, new Object[]{programId})).eq(ZtProject::getDeleted, (Object)"0"));
            List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtProject::getParent, (Object)program.getId())).eq(ZtProject::getDeleted, (Object)"0"));
            for (ZtProject project : ztProjects) {
                if ("program".equals(project.getType())) {
                    List childProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtProject::getParent, (Object)project.getId().toString())).eq(ZtProject::getDeleted, (Object)"0"));
                    if (childProjects.isEmpty() || !this.hasProgramChild(childProjects)) {
                        programs.add(project);
                        continue;
                    }
                    programIds2.add(project.getId().toString());
                    continue;
                }
                if (!"project".equals(project.getType())) continue;
                programs.add(program);
                break;
            }
            if (programIds2.isEmpty()) continue;
            programs.addAll(this.getProgram1(programIds2));
        }
        return programs;
    }

    private boolean hasProgramChild(List<ZtProject> projects) {
        for (ZtProject project : projects) {
            if (!"program".equals(project.getType())) continue;
            return true;
        }
        return false;
    }

    public List<ZtProject> getProjectByProgramAndType(String id, String type, Boolean isShowAll) {
        List<Object> ids = new ArrayList();
        List<ZtProject> program = this.getProgram(id);
        ids = program.stream().map(a -> a.getId()).collect(Collectors.toList());
        List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getParent, ids)).eq(ZtProject::getType, (Object)type)).eq(ZtProject::getDeleted, (Object)"0")).ne(isShowAll == false, ZtProject::getStatus, (Object)"closed"));
        return ztProjects;
    }

    private List<ZtProject> getProgram(String id) {
        ArrayList<String> programIds = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = "4004";
        }
        programIds.add(id);
        return this.getProgram1(programIds);
    }

    private Comparator<ZtProjectVO> createComparator1(String begin_sort, String end_sort, String total_demand_sort, String completed_demand_sort, String residue_sort) {
        return (p1, p2) -> {
            int endComparison;
            int beginComparison;
            LocalDate date1 = null;
            LocalDate date2 = null;
            if (StringUtils.isNotEmpty((CharSequence)p1.getBegin())) {
                date1 = LocalDate.parse(p1.getBegin());
            }
            if (StringUtils.isNotEmpty((CharSequence)p2.getBegin())) {
                date2 = LocalDate.parse(p2.getBegin());
            }
            if ((beginComparison = ZtKanBanService.compareValuesDate(date1, date2, begin_sort)) != 0) {
                return beginComparison;
            }
            LocalDate endDate1 = null;
            LocalDate endDate2 = null;
            if (StringUtils.isNotEmpty((CharSequence)p1.getEnd())) {
                endDate1 = LocalDate.parse(p1.getEnd());
            }
            if (StringUtils.isNotEmpty((CharSequence)p2.getEnd())) {
                endDate2 = LocalDate.parse(p2.getEnd());
            }
            if ((endComparison = ZtKanBanService.compareValuesDate(endDate1, endDate2, end_sort)) != 0) {
                return endComparison;
            }
            int totalDemandComparison = ZtKanBanService.compareValuesInt(p1.getTotal_demand(), p2.getTotal_demand(), total_demand_sort);
            if (totalDemandComparison != 0) {
                return totalDemandComparison;
            }
            int completedDemandComparison = ZtKanBanService.compareValuesInt(p1.getCompleted_demand(), p2.getCompleted_demand(), completed_demand_sort);
            if (completedDemandComparison != 0) {
                return completedDemandComparison;
            }
            int residueSortComparison = ZtKanBanService.compareValuesInt(p1.getResidue(), p2.getResidue(), residue_sort);
            if (residueSortComparison != 0) {
                return residueSortComparison;
            }
            return 0;
        };
    }

    public PageVO<ZtProjectVO> getProjectByProgramAndProject(String projectId, Integer page, Integer size, Boolean isShowAll, String begin_sort, String end_sort, String total_demand_sort, String completed_demand_sort, String residue_sort) {
        List<ZtProject> grade4Project = this.getGrade4Project(projectId);
        if (!isShowAll.booleanValue()) {
            grade4Project = grade4Project.stream().filter(project -> !"closed".equals(project.getStatus())).collect(Collectors.toList());
        }
        PageVO<ZtProjectVO> pageVO = new PageVO<ZtProjectVO>();
        pageVO.setPage(page.longValue());
        pageVO.setSize(size.longValue());
        pageVO.setTotal(new Integer(grade4Project.size()).longValue());
        pageVO.setHasNext((long)((int)Math.ceil((double)pageVO.getTotal().longValue() / (double)pageVO.getSize().longValue())) > pageVO.getPage());
        ArrayList<ZtProjectVO> ztProjectVOS = new ArrayList<ZtProjectVO>();
        for (ZtProject ztProject : grade4Project) {
            LocalDate end;
            boolean before;
            ZtProjectVO ztProjectVO = new ZtProjectVO();
            BeanUtils.copyProperties((Object)ztProject, (Object)ztProjectVO);
            LocalDate now = LocalDate.now();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            if (("wait".equals(ztProjectVO.getStatus()) || "doing".equals(ztProjectVO.getStatus())) && (before = now.isAfter(end = LocalDate.parse(ztProjectVO.getEnd(), dateTimeFormatter)))) {
                ztProjectVO.setStatus("extension");
            }
            List<ZtProject> sprints = this.ztProjectDAO.getProjectByProgramAndType(ztProjectVO.getId().toString(), "sprint");
            for (ZtProject sprint : sprints) {
                LocalDate end2;
                boolean before2;
                if (!"wait".equals(sprint.getStatus()) && !"doing".equals(sprint.getStatus()) || !(before2 = now.isAfter(end2 = LocalDate.parse(sprint.getEnd(), dateTimeFormatter)))) continue;
                sprint.setStatus("extension");
            }
            List<ZtStory> ztStories = this.ztStoryDAO.getProjectDemandByProjectId(ztProject.getId());
            Long closedCount = ztStories.stream().filter(ztStory -> "closed".equals(ztStory.getStatus())).count();
            Long activeCount = ztStories.stream().filter(ztStory -> "active".equals(ztStory.getStatus())).count();
            ztProjectVO.setTotal_demand(ztStories.size());
            ztProjectVO.setCompleted_demand(closedCount.intValue());
            ztProjectVO.setResidue(activeCount.intValue());
            ztProjectVO.setSprint_list(sprints);
            ztProjectVOS.add(ztProjectVO);
        }
        ztProjectVOS.sort(this.createComparator1(begin_sort, end_sort, total_demand_sort, completed_demand_sort, residue_sort));
        List subList = ztProjectVOS.stream().skip((page - 1) * size).limit(size.intValue()).collect(Collectors.toList());
        pageVO.setProject(subList);
        return pageVO;
    }

    private List<ZtProject> getGrade4Project(String id) {
        ArrayList<ZtProject> resultProjectIds = new ArrayList<ZtProject>();
        ZtProject project = (ZtProject)((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtProject::getId, (Object)id)).eq(ZtProject::getDeleted, (Object)"0"));
        if (project != null && "project".equals(project.getType())) {
            resultProjectIds.add(project);
            return resultProjectIds;
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = "4004";
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(id);
        List<ZtProject> program1 = this.getProgram1(parentIds);
        List collect = program1.stream().map(a -> a.getId()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(program1)) {
            List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getParent, collect)).eq(ZtProject::getDeleted, (Object)"0"));
            resultProjectIds.addAll(ztProjects);
        } else {
            List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtProject::getParent, (Object)id)).eq(ZtProject::getDeleted, (Object)"0"));
            if (!CollectionUtils.isEmpty((Collection)ztProjects)) {
                resultProjectIds.addAll(ztProjects);
            }
        }
        return resultProjectIds;
    }

    public List<ZtProject> getSprintByProgramAndType(List<String> ids, String sprint, Boolean isShowAll) {
        ArrayList<ZtProject> returnZtProjects = new ArrayList<ZtProject>();
        if (CollectionUtils.isEmpty(ids)) {
            ids.add("4004");
        }
        for (String id : ids) {
            List<ZtProject> grade4Project = this.getGrade4Project(id);
            if (!isShowAll.booleanValue()) {
                grade4Project = grade4Project.stream().filter(project -> !"closed".equals(project.getStatus())).collect(Collectors.toList());
            }
            List projectIds = grade4Project.stream().map(a -> a.getId().toString()).collect(Collectors.toList());
            List ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProject::getId, ZtProject::getName}).in(ZtProject::getParent, projectIds)).eq(ZtProject::getDeleted, (Object)"0")).eq(ZtProject::getType, (Object)sprint));
            returnZtProjects.addAll(ztProjects);
        }
        return returnZtProjects;
    }

    private Comparator<ZtStoryVO> createComparator2(String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort, String associated_tasks_number_sort, String associated_bugs_number_sort) {
        return (p1, p2) -> {
            int associatedBugsNumberSortComparison;
            int associatedTasksNumberSortComparison;
            int consumedSortComparison;
            int estimateComparison;
            int priComparison;
            int idSortComparison;
            if (!StringUtils.isEmpty((CharSequence)id_sort) && (idSortComparison = ZtKanBanService.compareValuesInt(Integer.parseInt(p1.getId()), Integer.parseInt(p2.getId()), id_sort)) != 0) {
                return idSortComparison;
            }
            if (!StringUtils.isEmpty((CharSequence)plan_end_sort)) {
                int planEndComparison;
                LocalDate date1 = null;
                LocalDate date2 = null;
                if (StringUtils.isNotEmpty((CharSequence)p1.getPlan_end())) {
                    date1 = LocalDate.parse(p1.getPlan_end());
                }
                if (StringUtils.isNotEmpty((CharSequence)p2.getPlan_end())) {
                    date2 = LocalDate.parse(p2.getPlan_end());
                }
                if ((planEndComparison = ZtKanBanService.compareValuesDate(date1, date2, plan_end_sort)) != 0) {
                    return planEndComparison;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)pri_sort) && (priComparison = ZtKanBanService.compareValuesInt(Integer.parseInt(p1.getPri()), Integer.parseInt(p2.getPri()), pri_sort)) != 0) {
                return priComparison;
            }
            if (!StringUtils.isEmpty((CharSequence)estimate_sort) && (estimateComparison = ZtKanBanService.compareValuesInt(p1.getEstimate(), p2.getEstimate(), estimate_sort)) != 0) {
                return estimateComparison;
            }
            if (!StringUtils.isEmpty((CharSequence)consumed_sort) && (consumedSortComparison = ZtKanBanService.compareValuesFloat(p1.getConsumed(), p2.getConsumed(), consumed_sort)) != 0) {
                return consumedSortComparison;
            }
            if (!StringUtils.isEmpty((CharSequence)associated_bugs_number_sort) && (associatedTasksNumberSortComparison = ZtKanBanService.compareValuesInt(p1.getAssociated_tasks_number(), p2.getAssociated_tasks_number(), associated_tasks_number_sort)) != 0) {
                return associatedTasksNumberSortComparison;
            }
            if (!StringUtils.isEmpty((CharSequence)associated_bugs_number_sort) && (associatedBugsNumberSortComparison = ZtKanBanService.compareValuesInt(p1.getAssociated_bugs_number(), p2.getAssociated_bugs_number(), associated_bugs_number_sort)) != 0) {
                return associatedBugsNumberSortComparison;
            }
            return 0;
        };
    }

    public PageVO<ZtStoryVO> getStoryByProjectOrSprint(String programId, List<Integer> projectIds, String sprintId, Integer page, Integer size, Boolean isShowAll, String status, String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort, String associated_tasks_sort, String associated_bugs_sort) {
        List<ZtStoryVO> ztStoryVOS = this.getStoryByProjectOrSprint(programId, projectIds, sprintId, isShowAll);
        switch (status) {
            case "total": {
                break;
            }
            case "completed": {
                ztStoryVOS = ztStoryVOS.stream().filter(ztStoryVO -> "closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
                break;
            }
            case "unfinished": {
                ztStoryVOS = ztStoryVOS.stream().filter(ztStoryVO -> !"closed".equals(ztStoryVO.getStage()) && !"released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
            }
        }
        Integer storyCountByProjectId = ztStoryVOS.size();
        ztStoryVOS.sort(this.createComparator2(id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort));
        List subList = ztStoryVOS.stream().skip((page - 1) * size).limit(size.intValue()).collect(Collectors.toList());
        PageVO<ZtStoryVO> ztProjectVOPageVO = new PageVO<ZtStoryVO>();
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setProject(subList);
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setTotal(storyCountByProjectId.longValue());
        ztProjectVOPageVO.setHasNext((long)((int)Math.ceil((double)ztProjectVOPageVO.getTotal().longValue() / (double)ztProjectVOPageVO.getSize().longValue())) > ztProjectVOPageVO.getPage());
        return ztProjectVOPageVO;
    }

    private List<ZtStoryVO> getStoryByProjectOrSprint(String programId, List<Integer> projectIds, String sprintId, Boolean isShowAll) {
        List allZtBugs;
        List allZtTasks;
        List ztProjects;
        ArrayList ztStoryVOS = new ArrayList();
        List<Object> sprintIds = new ArrayList<Object>();
        List<Object> storys = new ArrayList();
        Date sprintStart = null;
        Date sprintEnd = null;
        if (StringUtils.isEmpty((CharSequence)sprintId)) {
            if (CollectionUtils.isEmpty(projectIds)) {
                List<ZtProject> grade4Project = this.getGrade4Project(programId);
                if (!isShowAll.booleanValue()) {
                    grade4Project = grade4Project.stream().filter(project -> !"closed".equals(project.getStatus())).collect(Collectors.toList());
                }
                List getProjectIds = grade4Project.stream().map(t -> t.getId()).collect(Collectors.toList());
                ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getParent, getProjectIds)).eq(ZtProject::getDeleted, (Object)"0"));
                sprintIds.addAll(getProjectIds);
                sprintIds.addAll(ztProjects.stream().map(a -> a.getId()).collect(Collectors.toList()));
            } else {
                sprintIds.addAll(projectIds);
            }
        } else {
            ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProject::getId, ZtProject::getRealBegan, ZtProject::getRealEnd}).in(ZtProject::getId, new Object[]{sprintId})).eq(ZtProject::getDeleted, (Object)"0")).eq(ZtProject::getType, (Object)"sprint"));
            sprintIds = ztProjects.stream().map(t -> t.getId()).collect(Collectors.toList());
            sprintStart = ((ZtProject)ztProjects.get(0)).getRealBegan();
            sprintEnd = ((ZtProject)ztProjects.get(0)).getRealEnd();
        }
        List ztProjectStories = ((ZtProjectStoryMapper)this.ztProjectStoryDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProjectStory::getProject, ZtProjectStory::getStory}).in(ZtProjectStory::getProject, sprintIds));
        List<Integer> storyIds = ztProjectStories.stream().map(a -> a.getStory()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(storyIds)) {
            storys = this.ztProjectStoryDAO.getStoryByProjectId(storyIds);
        }
        if (!CollectionUtils.isEmpty(storys)) {
            if (!StringUtils.isEmpty((CharSequence)sprintId)) {
                allZtTasks = ((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory}).in(ZtTask::getStory, storyIds)).eq(ZtTask::getDeleted, (Object)"0")).eq(ZtTask::getExecution, (Object)sprintId));
                allZtBugs = ((ZtBugMapper)this.ztBugDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtBug::getId, ZtBug::getStory, ZtBug::getStatus}).in(ZtBug::getStory, storyIds)).ge(ZtBug::getExecution, (Object)sprintId));
            } else {
                allZtTasks = ((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory}).in(ZtTask::getStory, storyIds)).eq(ZtTask::getDeleted, (Object)"0"));
                allZtBugs = ((ZtBugMapper)this.ztBugDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtBug::getId, ZtBug::getStory, ZtBug::getStatus}).in(ZtBug::getStory, storyIds)).ge(ZtBug::getExecution, (Object)sprintId));
            }
        } else {
            allZtTasks = new ArrayList();
            allZtBugs = new ArrayList();
        }
        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream().filter(task -> task.getStory() != null).collect(Collectors.groupingBy(task -> task.getStory().toString()));
        Map<String, List<ZtBug>> ztBugMap = allZtBugs.stream().filter(ztBug -> ztBug.getStory() != null).collect(Collectors.groupingBy(bug -> bug.getStory().toString()));
        List allZtProducts = ((ZtProductMapper)this.ztProductDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProduct::getId, ZtProduct::getName}));
        Map<Integer, ZtProduct> ztProductMap = allZtProducts.stream().collect(Collectors.toMap(product -> product.getId(), product -> product));
        List allZtModules = ((ZtModuleMapper)this.ztModuleDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtModule::getId, ZtModule::getName}));
        Map<Integer, ZtModule> ztModuleMap = allZtModules.stream().collect(Collectors.toMap(ztModule -> ztModule.getId(), ztModule -> ztModule));
        List allZtProductplans = ((ZtProductplanMapper)this.ztProductplanDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProductplan::getId, ZtProductplan::getEnd}));
        Map<String, ZtProductplan> ztProductplanMap = allZtProductplans.stream().collect(Collectors.toMap(ztProductplan -> ztProductplan.getId(), ztProductplan -> ztProductplan));
        List allZtUsers = ((ZtUserMapper)this.ztUserDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtUser::getId, ZtUser::getAccount, ZtUser::getRealname}));
        Map<String, ZtUser> ztUserMap = allZtUsers.stream().collect(Collectors.toMap(ztUser -> ztUser.getAccount(), ztUser -> ztUser));
        return storys.stream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties((Object)story, (Object)ztStoryVO);
            List getZtTasks = ztTaskMap.getOrDefault(story.getId(), new ArrayList());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            double leftSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getLeft));
            ztStoryVO.setConsumed(Float.valueOf((float)consumedSum));
            ztStoryVO.setLeft(Float.valueOf((float)leftSum));
            ztStoryVO.setAssociated_tasks_number(getZtTasks.size());
            Long completed_tasks_number = getZtTasks.stream().filter(task -> "done".equals(task.getStatus().getValue()) || "closed".equals(task.getStatus().getValue())).count();
            ztStoryVO.setCompleted_tasks_number(completed_tasks_number.intValue());
            List getZtBugs = ztBugMap.getOrDefault(story.getId(), new ArrayList());
            ztStoryVO.setAssociated_bugs_number(getZtBugs.size());
            Long completed_bugs_number = getZtBugs.stream().filter(bug -> "resolved".equals(bug.getStatus()) || "closed".equals(bug.getStatus())).count();
            ztStoryVO.setCompleted_bugs_number(completed_bugs_number.intValue());
            ZtProduct ztProduct = (ZtProduct)ztProductMap.get(ztStoryVO.getProduct());
            ztStoryVO.setProduct_name(ztProduct == null ? "" : ztProduct.getName());
            ZtModule ztModule = (ZtModule)ztModuleMap.get(ztStoryVO.getModule());
            ztStoryVO.setModule_name(ztModule == null ? "" : ztModule.getName());
            ZtProductplan ztProductplan = (ZtProductplan)ztProductplanMap.get(story.getPlan());
            ztStoryVO.setPlan_end(ztProductplan == null ? null : ztProductplan.getEnd());
            ZtUser ztUser = (ZtUser)ztUserMap.get(story.getAssignedTo());
            ztStoryVO.setAssignedTo(ztUser == null ? null : ztUser.getRealname());
            return ztStoryVO;
        }).collect(Collectors.toList());
    }

    public List<ZtProduct> getProductByProgram(String programId, Boolean isShowAll) {
        if (StringUtils.isEmpty((CharSequence)programId)) {
            programId = "4004";
        }
        List<ZtProject> projectList = this.getProjectByProgramAndType(programId, "project", isShowAll);
        List<Integer> projectIds = projectList.stream().map(project -> project.getId()).collect(Collectors.toList());
        List<ZtProduct> ztProducts = this.ztProductDAO.getProductByProject(projectIds);
        if (!isShowAll.booleanValue()) {
            ztProducts = ztProducts.stream().filter(ztProduct -> !"closed".equals(ztProduct.getStatus())).collect(Collectors.toList());
        }
        return ztProducts;
    }

    public List<ZtModuleLevelVO> getModuleByProduct(String programId, String productId, Boolean isShowAll) {
        List<Integer> productIds = new ArrayList<Integer>();
        if (StringUtils.isEmpty((CharSequence)productId)) {
            List<ZtProduct> productByProgram = this.getProductByProgram(programId, isShowAll);
            productIds = productByProgram.stream().map(a -> a.getId()).collect(Collectors.toList());
        } else {
            productIds.add(Integer.parseInt(productId));
        }
        List ztModules = ((ZtModuleMapper)this.ztModuleDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtModule::getId, ZtModule::getName, ZtModule::getParent}).in(ZtModule::getRoot, productIds)).eq(ZtModule::getType, (Object)"story")).eq(ZtModule::getDeleted, (Object)"0"));
        List<ZtModuleLevelVO> ztModuleLevelVOS = this.buildHierarchy(ztModules);
        return ztModuleLevelVOS;
    }

    private List<ZtModuleLevelVO> buildHierarchy(List<ZtModule> ztModules) {
        Map<Integer, ZtModuleLevelVO> voMap = ztModules.stream().map(module -> new ZtModuleLevelVO(module.getId(), module.getName(), module.getParent(), new ArrayList<ZtModuleLevelVO>())).collect(Collectors.toMap(ZtModuleLevelVO::getId, vo -> vo));
        ArrayList<ZtModuleLevelVO> rootModules = new ArrayList<ZtModuleLevelVO>();
        for (ZtModuleLevelVO vo2 : voMap.values()) {
            if (vo2.getParent() == null || vo2.getParent() == 0) {
                rootModules.add(vo2);
                continue;
            }
            ZtModuleLevelVO parentVO = voMap.get(vo2.getParent());
            if (parentVO == null) continue;
            if (CollectionUtils.isEmpty(parentVO.getChildren())) {
                parentVO.setChildren(new ArrayList<ZtModuleLevelVO>());
            }
            parentVO.getChildren().add(vo2);
        }
        return rootModules;
    }

    public PageVO<ZtStoryVO> getStoryByProductOrModule(String programId, String productId, List<String> moduleIds, Integer page, Integer size, Boolean isShowAll, String status, String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort, String associated_tasks_sort, String associated_bugs_sort) {
        List<String> storyIds;
        if (CollectionUtils.isEmpty(moduleIds)) {
            List<Integer> productIds;
            if (StringUtils.isEmpty((CharSequence)productId)) {
                List<ZtProduct> productByProgram = this.getProductByProgram(programId, isShowAll);
                productIds = productByProgram.stream().map(ZtProduct::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productIds)) {
                    return null;
                }
                storyIds = this.ztStoryDAO.getStoryIdByProductIds(productIds);
            } else {
                int productIdInt = Integer.parseInt(productId);
                productIds = new ArrayList<Integer>();
                productIds.add(productIdInt);
                storyIds = this.ztStoryDAO.getStoryIdByProductIds(productIds);
            }
        } else {
            List ztModules = ((ZtModuleMapper)this.ztModuleDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtModule::getId}).in(ZtModule::getParent, moduleIds)).eq(ZtModule::getDeleted, (Object)"0"));
            moduleIds.addAll(ztModules.stream().map(a -> a.getId().toString()).collect(Collectors.toList()));
            storyIds = this.ztStoryDAO.getStoryIdByModuleIds(moduleIds);
        }
        if (storyIds == null || storyIds.isEmpty()) {
            return null;
        }
        Integer page1 = (page - 1) * size;
        Integer size1 = page * size;
        Long total = this.ztStoryDAO.getStoryByProductIdOrModuleIdSum(storyIds, status);
        List<ZtStoryVO> ztStoryVOS = this.ztStoryDAO.getStoryByProductIdOrModuleId(storyIds, id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort, page1, size1, status);
        PageVO<ZtStoryVO> ztProjectVOPageVO = new PageVO<ZtStoryVO>();
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setProject(ztStoryVOS);
        ztProjectVOPageVO.setTotal(total);
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(ztProjectVOPageVO.getTotal() > size.longValue() ? size.longValue() : ztProjectVOPageVO.getTotal().longValue());
        ztProjectVOPageVO.setHasNext((long)((int)Math.ceil((double)ztProjectVOPageVO.getTotal().longValue() / (double)ztProjectVOPageVO.getSize().longValue())) > ztProjectVOPageVO.getPage());
        return ztProjectVOPageVO;
    }

    private HttpServletResponse getHttpServletResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u9879\u76ee\u8be6\u60c5\u8868".concat(".xlsx"), "UTF-8");
        response.setHeader("content-type", "application/octet-stream");
        response.setHeader("content-disposition", "attachment;filename=" + fileName);
        return response;
    }

    public void getProjectToExcel(String programId, Integer page, Integer size, Boolean isShowAll) {
        HttpServletResponse response = this.getHttpServletResponse();
        PageVO<ZtProjectVO> projectByProgramAndProject = this.getProjectByProgramAndProject(programId, page, size, isShowAll, null, null, null, null, null);
        ArrayList<ZtProjectExcelVO> ztProjectExcelVOS = new ArrayList<ZtProjectExcelVO>();
        for (ZtProjectVO ztProjectVO : projectByProgramAndProject.getProject()) {
            ZtProjectExcelVO ztProjectExcelVO = new ZtProjectExcelVO();
            BeanUtils.copyProperties((Object)ztProjectVO, (Object)ztProjectExcelVO);
            ztProjectExcelVO.setStatus(KanBanStatus.fromValue(ztProjectVO.getStatus()));
            if (!CollectionUtils.isEmpty(ztProjectVO.getSprint_list())) {
                for (ZtProject ztProject : ztProjectVO.getSprint_list()) {
                    ztProjectExcelVO.setSprint_name(ztProject.getName());
                    ztProjectExcelVO.setSprint_begin(ztProject.getBegin());
                    ztProjectExcelVO.setSprint_end(ztProject.getEnd());
                }
            }
            ztProjectExcelVOS.add(ztProjectExcelVO);
        }
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ZtProjectExcelVO.class).sheet("\u9879\u76ee\u8be6\u60c5\u8868").doWrite(ztProjectExcelVOS);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void getStoryByProjectToExcel(String programId, List<Integer> projectId, String sprintId, Integer page, Integer size, Boolean isShowAll, String status) {
        HttpServletResponse response = this.getHttpServletResponse();
        PageVO<ZtStoryVO> ztStoryVOPageVO = this.getStoryByProjectOrSprint(programId, projectId, sprintId, page, size, isShowAll, status, null, null, null, null, null, null, null);
        ArrayList<ZtStoryExcelVO> ztStoryExcelVOS = new ArrayList<ZtStoryExcelVO>();
        for (ZtStoryVO ztStoryVO : ztStoryVOPageVO.getProject()) {
            ZtStoryExcelVO ztStoryExcelVO = new ZtStoryExcelVO();
            BeanUtils.copyProperties((Object)ztStoryVO, (Object)ztStoryExcelVO);
            ztStoryExcelVO.setStatus(KanBanStatus.fromValue(ztStoryVO.getStatus()));
            ztStoryExcelVO.setStage(KanBanStatus.fromValue(ztStoryVO.getStage()));
            ztStoryExcelVOS.add(ztStoryExcelVO);
        }
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ZtStoryExcelVO.class).sheet("\u9879\u76ee\u9700\u6c42\u8868").doWrite(ztStoryExcelVOS);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void getStoryByProductToExcel(String programId, String productId, List<String> moduleId, Integer page, Integer size, Boolean isShowAll, String status) {
        HttpServletResponse response = this.getHttpServletResponse();
        PageVO<ZtStoryVO> storyByProduct = this.getStoryByProductOrModule(programId, productId, moduleId, page, size, isShowAll, status, null, null, null, null, null, null, null);
        ArrayList<ZtStoryExcelVO> ztStoryExcelVOS = new ArrayList<ZtStoryExcelVO>();
        for (ZtStoryVO ztStoryVO : storyByProduct.getProject()) {
            ZtStoryExcelVO ztStoryExcelVO = new ZtStoryExcelVO();
            BeanUtils.copyProperties((Object)ztStoryVO, (Object)ztStoryExcelVO);
            ztStoryExcelVO.setStatus(KanBanStatus.fromValue(ztStoryVO.getStatus()));
            ztStoryExcelVO.setStage(KanBanStatus.fromValue(ztStoryVO.getStage()));
            ztStoryExcelVOS.add(ztStoryExcelVO);
        }
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ZtStoryExcelVO.class).sheet("\u4ea7\u54c1\u9700\u6c42\u8868").doWrite(ztStoryExcelVOS);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public DemandVO getProjectDemandCompleteStatus(String programId, List<Integer> projectIds, String sprintId, Boolean isShow) {
        List ztProjects;
        List<Object> ztStoryVOS = new ArrayList();
        List<Object> sprintIds = new ArrayList<Object>();
        List<Object> storys = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)sprintId)) {
            if (CollectionUtils.isEmpty(projectIds)) {
                List<ZtProject> grade4Project = this.getGrade4Project(programId);
                if (!isShow.booleanValue()) {
                    grade4Project = grade4Project.stream().filter(project -> !"closed".equals(project.getStatus())).collect(Collectors.toList());
                }
                List getProjectIds = grade4Project.stream().map(t -> t.getId()).collect(Collectors.toList());
                ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtProject::getParent, getProjectIds)).eq(ZtProject::getDeleted, (Object)"0"));
                sprintIds.addAll(getProjectIds);
                sprintIds.addAll(ztProjects.stream().map(a -> a.getId()).collect(Collectors.toList()));
            } else {
                sprintIds.addAll(projectIds);
            }
        } else {
            ztProjects = ((ZtProjectMapper)this.ztProjectDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProject::getId, ZtProject::getRealBegan, ZtProject::getRealEnd}).in(ZtProject::getId, new Object[]{sprintId})).eq(ZtProject::getDeleted, (Object)"0")).eq(ZtProject::getType, (Object)"sprint"));
            sprintIds = ztProjects.stream().map(t -> t.getId()).collect(Collectors.toList());
        }
        List ztProjectStories = ((ZtProjectStoryMapper)this.ztProjectStoryDAO.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtProjectStory::getProject, ZtProjectStory::getStory}).in(ZtProjectStory::getProject, sprintIds));
        List<Integer> storyIds = ztProjectStories.stream().map(a -> a.getStory()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(storyIds)) {
            storys = this.ztProjectStoryDAO.getStoryByProjectId(storyIds);
        }
        List allZtTasks = !CollectionUtils.isEmpty(storys) ? (!StringUtils.isEmpty((CharSequence)sprintId) ? ((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory}).in(ZtTask::getStory, storyIds)).eq(ZtTask::getDeleted, (Object)"0")).eq(ZtTask::getExecution, (Object)sprintId)) : ((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory}).in(ZtTask::getStory, storyIds)).eq(ZtTask::getDeleted, (Object)"0"))) : new ArrayList();
        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream().filter(task -> task.getStory() != null).collect(Collectors.groupingBy(task -> task.getStory().toString()));
        ztStoryVOS = storys.stream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties((Object)story, (Object)ztStoryVO);
            List getZtTasks = ztTaskMap.getOrDefault(story.getId(), new ArrayList());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            double leftSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getLeft));
            ztStoryVO.setConsumed(Float.valueOf((float)consumedSum));
            ztStoryVO.setLeft(Float.valueOf((float)leftSum));
            ztStoryVO.setAssociated_tasks_number(getZtTasks.size());
            Long completed_tasks_number = getZtTasks.stream().filter(task -> "done".equals(task.getStatus().getValue()) || "closed".equals(task.getStatus().getValue())).count();
            ztStoryVO.setCompleted_tasks_number(completed_tasks_number.intValue());
            return ztStoryVO;
        }).collect(Collectors.toList());
        int estimateSum = ztStoryVOS.stream().mapToInt(ZtStory::getEstimate).sum();
        List collect = ztStoryVOS.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float consumedSum = 0.0f;
        for (Float a2 : collect) {
            consumedSum = ZtKanBanService.add(consumedSum, a2.floatValue()).floatValue();
        }
        List completedStorys = ztStoryVOS.stream().filter(ztStoryVO -> "closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
        int completedEstimate = completedStorys.stream().mapToInt(ZtStory::getEstimate).sum();
        List completedStorysConsumed = completedStorys.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float completedStorysConsumedSum = 0.0f;
        for (Float a3 : completedStorysConsumed) {
            completedStorysConsumedSum = ZtKanBanService.add(completedStorysConsumedSum, a3.floatValue()).floatValue();
        }
        List unfinishedStorys = ztStoryVOS.stream().filter(ztStoryVO -> !"closed".equals(ztStoryVO.getStage()) && !"released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
        int unfinishedEstimate = unfinishedStorys.stream().mapToInt(ZtStory::getEstimate).sum();
        List unfinishedStorysConsumed = unfinishedStorys.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float unfinishedStorysConsumedSum = 0.0f;
        for (Float a4 : unfinishedStorysConsumed) {
            unfinishedStorysConsumedSum = ZtKanBanService.add(unfinishedStorysConsumedSum, a4.floatValue()).floatValue();
        }
        DemandVO demandVO = new DemandVO();
        demandVO.setStory_sum(ztStoryVOS.size());
        demandVO.setCompleted_story_sum(completedStorys.size());
        demandVO.setUnfinished_story_sum(unfinishedStorys.size());
        demandVO.setTotal_story_points_sum(estimateSum);
        demandVO.setTotal_consume(Float.valueOf(consumedSum));
        demandVO.setCompleted_story_points_sum(completedEstimate);
        demandVO.setCompleted_consume(Float.valueOf(completedStorysConsumedSum));
        demandVO.setUnfinished_story_points_sum(unfinishedEstimate);
        demandVO.setUnfinished_consume(Float.valueOf(unfinishedStorysConsumedSum));
        return demandVO;
    }

    public DemandVO getProductDemandCompleteStatus(String programId, String productId, List<String> moduleIds, Boolean isShow) {
        List storys;
        if (CollectionUtils.isEmpty(moduleIds)) {
            if (StringUtils.isEmpty((CharSequence)productId)) {
                List<ZtProduct> productByProgram = this.getProductByProgram(programId, isShow);
                List productIds = productByProgram.stream().map(ZtProduct::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productIds)) {
                    return null;
                }
                storys = ((ZtStoryMapper)this.ztStoryDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtStory::getProduct, productIds)).eq(ZtStory::getDeleted, (Object)"0"));
            } else {
                int productIdInt = Integer.parseInt(productId);
                storys = ((ZtStoryMapper)this.ztStoryDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ZtStory::getProduct, (Object)productIdInt)).eq(ZtStory::getDeleted, (Object)"0"));
            }
        } else {
            List ztModules = ((ZtModuleMapper)this.ztModuleDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtModule::getId}).in(ZtModule::getParent, moduleIds)).eq(ZtModule::getDeleted, (Object)"0"));
            moduleIds.addAll(ztModules.stream().map(a -> a.getId().toString()).collect(Collectors.toList()));
            storys = ((ZtStoryMapper)this.ztStoryDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ZtStory::getModule, moduleIds)).eq(ZtStory::getDeleted, (Object)"0"));
        }
        if (storys == null || storys.isEmpty()) {
            return null;
        }
        List storyIds = storys.stream().map(s -> s.getId()).collect(Collectors.toList());
        List allZtTasks = !CollectionUtils.isEmpty((Collection)storys) ? ((ZtTaskMapper)this.ztTaskDAO.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory}).in(ZtTask::getStory, storyIds)).eq(ZtTask::getDeleted, (Object)"0")) : new ArrayList();
        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream().filter(task -> task.getStory() != null).collect(Collectors.groupingBy(task -> task.getStory().toString()));
        allZtTasks.clear();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        ztTaskMap.forEach((key, value) -> concurrentHashMap.put(key, value));
        List ztStoryVOS = storys.parallelStream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties((Object)story, (Object)ztStoryVO);
            List getZtTasks = concurrentHashMap.getOrDefault(story.getId(), new ArrayList());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            ztStoryVO.setConsumed(Float.valueOf((float)consumedSum));
            return ztStoryVO;
        }).collect(Collectors.toList());
        int estimateSum = ztStoryVOS.stream().mapToInt(ZtStory::getEstimate).sum();
        List collect = ztStoryVOS.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float consumedSum = 0.0f;
        for (Float a2 : collect) {
            consumedSum = ZtKanBanService.add(consumedSum, a2.floatValue()).floatValue();
        }
        List completedStorys = ztStoryVOS.stream().filter(ztStoryVO -> "closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
        int completedEstimate = completedStorys.stream().mapToInt(ZtStory::getEstimate).sum();
        float completedStorysConsumedSum = (float)completedStorys.stream().mapToDouble(ZtStoryVO::getConsumed).sum();
        List unfinishedStorys = ztStoryVOS.stream().filter(ztStoryVO -> !"closed".equals(ztStoryVO.getStage()) && !"released".equals(ztStoryVO.getStage())).collect(Collectors.toList());
        int unfinishedEstimate = unfinishedStorys.stream().mapToInt(ZtStory::getEstimate).sum();
        float unfinishedStorysConsumedSum = (float)unfinishedStorys.stream().mapToDouble(ZtStoryVO::getConsumed).sum();
        DemandVO demandVO = new DemandVO();
        demandVO.setStory_sum(ztStoryVOS.size());
        demandVO.setCompleted_story_sum(completedStorys.size());
        demandVO.setUnfinished_story_sum(unfinishedStorys.size());
        demandVO.setTotal_story_points_sum(estimateSum);
        demandVO.setTotal_consume(Float.valueOf(consumedSum));
        demandVO.setCompleted_story_points_sum(completedEstimate);
        demandVO.setCompleted_consume(Float.valueOf(completedStorysConsumedSum));
        demandVO.setUnfinished_story_points_sum(unfinishedEstimate);
        demandVO.setUnfinished_consume(Float.valueOf(unfinishedStorysConsumedSum));
        return demandVO;
    }

    private static Float add(float v1, float v2) {
        BigDecimal b1 = new BigDecimal(Float.toString(v1));
        BigDecimal b2 = new BigDecimal(Float.toString(v2));
        return Float.valueOf(b1.add(b2).floatValue());
    }

    public List<ZtDeptVO> queryDeptList(@RequestParam Integer deptId) {
        List<ZtDept> deptList = this.ztDeptDAO.queryDeptList(deptId = ObjectUtils.isEmpty((Object)deptId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID : deptId);
        if (CollectionUtils.isEmpty(deptList)) {
            return Lists.newArrayList();
        }
        List<ZtDeptVO> deptRespList = deptList.stream().map(x -> {
            ZtDeptVO ztDeptVO = new ZtDeptVO();
            BeanUtils.copyProperties((Object)x, (Object)ztDeptVO);
            return ztDeptVO;
        }).collect(Collectors.toList());
        Integer parentGrade = deptList.stream().map(ZtDept::getGrade).min(Integer::compareTo).get();
        for (ZtDeptVO dept : deptRespList) {
            deptRespList.forEach(t -> {
                if (dept.getId().equals(t.getParent())) {
                    if (dept.getChildren() == null) {
                        dept.setChildren(Lists.newArrayList());
                    }
                    dept.getChildren().add((ZtDeptVO)t);
                }
            });
        }
        return deptRespList.stream().filter(v -> parentGrade.equals(v.getGrade())).collect(Collectors.toList());
    }

    public List<ZtUser> queryUserList(Integer deptId) {
        return this.ztUserDAO.queryUserList(deptId);
    }

    public List<ZtProjectLevelVO> queryProgramList(Integer programId) {
        List<ZtProject> programList = this.ztProjectDAO.queryProgramList(programId = ObjectUtils.isEmpty((Object)programId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : programId);
        if (CollectionUtils.isEmpty(programList)) {
            return Lists.newArrayList();
        }
        List<ZtProjectLevelVO> programVOList = programList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties((Object)x, (Object)projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());
        Integer parentGrade = programList.stream().map(ZtProject::getGrade).min(Integer::compareTo).get();
        for (ZtProjectLevelVO projectLevelVO : programVOList) {
            programVOList.forEach(t -> {
                if (projectLevelVO.getId().equals(t.getParent())) {
                    if (projectLevelVO.getChildren() == null) {
                        projectLevelVO.setChildren(Lists.newArrayList());
                    }
                    projectLevelVO.getChildren().add((ZtProjectLevelVO)t);
                }
            });
        }
        return programVOList.stream().filter(v -> parentGrade.equals(v.getGrade())).collect(Collectors.toList());
    }

    public List<ZtProjectLevelVO> queryProjectList(Integer programId) {
        List<ZtProject> projectList = this.ztProjectDAO.queryProjectList(programId = ObjectUtils.isEmpty((Object)programId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : programId);
        if (CollectionUtils.isEmpty(projectList)) {
            return Lists.newArrayList();
        }
        return projectList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties((Object)x, (Object)projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());
    }

    public List<ZtProjectLevelVO> querySprintList(Integer id) {
        List<ZtProject> sprintList = this.ztProjectDAO.querySprintList(id = ObjectUtils.isEmpty((Object)id) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : id);
        if (CollectionUtils.isEmpty(sprintList)) {
            return Lists.newArrayList();
        }
        return sprintList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties((Object)x, (Object)projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());
    }
}

