/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.util;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class AESUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtil.class);
    private static final String ENCODING = "UTF-8";
    private static final String AES_ALGORITHM = "AES";
    private static final String CIPHER_PADDING = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_CBC_PADDING = "AES/CBC/PKCS5Padding";
    private static final String IV_SEED = "1234567812345678";

    public static String encrypt(String content, String aesKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.info("AES encrypt: the content is null!");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey) && aesKey.length() == 16) {
            try {
                byte[] bytes = aesKey.getBytes(ENCODING);
                SecretKeySpec skeySpec = new SecretKeySpec(bytes, AES_ALGORITHM);
                Cipher cipher = Cipher.getInstance(CIPHER_PADDING);
                cipher.init(1, skeySpec);
                byte[] encrypted = cipher.doFinal(content.getBytes(ENCODING));
                return Base64Utils.encodeToString((byte[])encrypted);
            }
            catch (Exception e) {
                LOGGER.info("AES encrypt exception:" + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("AES encrypt: the aesKey is null or error!");
        return null;
    }

    public static String decrypt(String content, String aesKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.info("AES decrypt: the content is null!");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey) && aesKey.length() == 16) {
            try {
                byte[] bytes = aesKey.getBytes(ENCODING);
                SecretKeySpec skeySpec = new SecretKeySpec(bytes, AES_ALGORITHM);
                Cipher cipher = Cipher.getInstance(CIPHER_PADDING);
                cipher.init(2, skeySpec);
                byte[] decodeBase64 = Base64Utils.decodeFromString((String)content);
                byte[] decrypted = cipher.doFinal(decodeBase64);
                return new String(decrypted, ENCODING);
            }
            catch (Exception e) {
                LOGGER.info("AES decrypt exception:" + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("AES decrypt: the aesKey is null or error!");
        return null;
    }

    public static String encryptCBC(String content, String aesKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.info("AES_CBC encrypt: the content is null!");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey) && aesKey.length() == 16) {
            try {
                byte[] bytes = aesKey.getBytes(ENCODING);
                SecretKeySpec skeySpec = new SecretKeySpec(bytes, AES_ALGORITHM);
                Cipher cipher = Cipher.getInstance(CIPHER_CBC_PADDING);
                IvParameterSpec iv = new IvParameterSpec(IV_SEED.getBytes(ENCODING));
                cipher.init(1, (Key)skeySpec, iv);
                byte[] encrypted = cipher.doFinal(content.getBytes(ENCODING));
                return Base64Utils.encodeToString((byte[])encrypted);
            }
            catch (Exception e) {
                LOGGER.info("AES_CBC encrypt exception:" + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("AES_CBC encrypt: the aesKey is null or error!");
        return null;
    }

    public static String decryptCBC(String content, String aesKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.info("AES_CBC decrypt: the content is null!");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey) && aesKey.length() == 16) {
            try {
                byte[] bytes = aesKey.getBytes(ENCODING);
                SecretKeySpec skeySpec = new SecretKeySpec(bytes, AES_ALGORITHM);
                IvParameterSpec iv = new IvParameterSpec(IV_SEED.getBytes(ENCODING));
                Cipher cipher = Cipher.getInstance(CIPHER_CBC_PADDING);
                cipher.init(2, (Key)skeySpec, iv);
                byte[] decodeBase64 = Base64Utils.decodeFromString((String)content);
                byte[] decrypted = cipher.doFinal(decodeBase64);
                return new String(decrypted, ENCODING);
            }
            catch (Exception e) {
                LOGGER.info("AES_CBC decrypt exception:" + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("AES_CBC decrypt: the aesKey is null or error!");
        return null;
    }
}

