/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String sendGet(String url, String reqJson, Map<String, String> header) throws URISyntaxException, IOException {
        String responseContent = "";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse httpResponse;
            HttpEntity entity;
            URIBuilder uriBuilder = new URIBuilder(url);
            if (StringUtils.isNotEmpty((CharSequence)reqJson)) {
                List<NameValuePair> nameValuePairList = HttpUtil.json2NameValuePairList(JSON.parseObject((String)reqJson));
                uriBuilder.setParameters(nameValuePairList);
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader("Content-Type", "application/json");
            if (null != header && !header.isEmpty()) {
                for (Map.Entry<String, String> i : header.entrySet()) {
                    httpGet.setHeader(i.getKey(), i.getValue());
                }
            }
            if (null != (entity = (httpResponse = httpClient.execute((HttpUriRequest)httpGet)).getEntity())) {
                responseContent = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
            return responseContent;
        }
        catch (URISyntaxException e) {
            log.error(e.toString());
            throw e;
        }
        catch (IOException e) {
            log.error(e.toString());
            throw e;
        }
    }

    private static List<NameValuePair> json2NameValuePairList(JSONObject params) {
        if (params != null && !params.isEmpty()) {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                String value = String.valueOf(entry.getValue());
                list.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), value));
            }
            return list;
        }
        return null;
    }

    public static String postByFormData(String url, Map<String, String> header, Map<String, String> requestParams) {
        String result = "";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity resEntity;
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(550000).setConnectTimeout(550000).setConnectionRequestTimeout(550000).build();
            client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            for (Map.Entry<String, String> next : header.entrySet()) {
                httpPost.setHeader(next.getKey(), next.getValue());
            }
            Iterator<Map.Entry<String, String>> it = requestParams.entrySet().iterator();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                params.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            response = client.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            String reasonPhrase = statusLine.getReasonPhrase();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new RuntimeException("HTTP request failed with status code: " + statusCode);
            }
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (ClientProtocolException e) {
            throw null;
        }
        catch (Exception e) {
            throw null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postByJsonBody(String url, Map<String, String> headers, String requestBody) {
        String result = "";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(550000).setConnectTimeout(550000).setConnectionRequestTimeout(550000).build();
            client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            URIBuilder uriBuilder = new URIBuilder(url);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpPost.setHeader(header.getKey(), header.getValue());
            }
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody, "UTF-8"));
            response = client.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new RuntimeException("HTTP request failed with status code: " + statusCode);
            }
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

