package com.digiwin.athena.dtdapp.config;

import javax.sql.DataSource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWDaoImpl;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;


@Configuration
@MapperScan(basePackages = {"com.digiwin.athena.dtdapp.mapper"}, sqlSessionTemplateRef = "dtdappSqlSessionTemplate")
public class DtdappDataSourceConfig {

//    @Value("${jdbcDriverClassName}")
//    private String driverClassName;
//    @Value("${dbUrl}")
//    private String url;
//    @Value("${dbUsername}")
//    private String username;
//    @Value("${dbPassword}")
//    private String password;
//
//    static final String PACKAGE = "com.digiwin.athena.dtdapp.mapper";
//    static final String MAPPER_LOCATION = "classpath:mapper/mysql/*.xml";
//    static final String NULL = "configuration.setCallSettersOnNulls=true";

//    @Autowired
//    private MybatisInterceptor mybatisInterceptor;

    @Bean(name = "dtdappDataSource")
    @ConfigurationProperties(prefix = "dtdapp.spring.datasource")
    public DataSource setDataSource() {
//        DruidDataSource build = DataSourceBuilder.create().driverClassName(driverClassName).url(url).username(username).password(password).type(DruidDataSource.class).build();
//        return build;
        DruidDataSource druidDataSource= new DruidDataSource();
        return druidDataSource;
    }

    @Bean(name = "dtdappTransactionManager")
    public DataSourceTransactionManager setTransactionManager(@Qualifier("dtdappDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name = "dtdappSqlSessionFactory")
    public SqlSessionFactory setSqlSessionFactory(@Qualifier("dtdappDataSource") DataSource dataSource)
            throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(
                new PathMatchingResourcePatternResolver().getResources("classpath*:mappers/dtdapp/*.xml"));

        MybatisConfiguration mybatisConfiguration = new MybatisConfiguration();
        mybatisConfiguration.setMapUnderscoreToCamelCase(false);
        mybatisConfiguration.setCallSettersOnNulls(true);
        mybatisConfiguration.setLogImpl(StdOutImpl.class);

        bean.setConfiguration(mybatisConfiguration);
        //分页插件
        //bean.setPlugins(mybatisPlusInterceptor());
        bean.setPlugins(mybatisInterceptor(),mybatisPlusInterceptor());

        return bean.getObject();
    }

    @Bean(name = "dtdappSqlSessionTemplate")
    public SqlSessionTemplate setSqlSessionTemplate(
            @Qualifier("dtdappSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }


    public DtdAppMybatisInterceptor mybatisInterceptor(){

        return new DtdAppMybatisInterceptor();
    }

    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean("dtdappDwdao")
    public DWDao dtdappDwdao(@Qualifier("dtdappDataSource") DataSource dataSource){
        DWDaoImpl dao = new DWDaoImpl(new QueryRunner(dataSource));
        return dao;
    }

}
